/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.commons.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.fileupload.FileItem;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.commons.api.SakaiProxy;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.memory.api.MemoryService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.FormattedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SakaiProxyImpl
implements SakaiProxy {
    private static final Logger log = LoggerFactory.getLogger(SakaiProxyImpl.class);
    private AuthzGroupService authzGroupService;
    private ContentHostingService contentHostingService;
    private EntityManager entityManager;
    private EventTrackingService eventTrackingService;
    private FunctionManager functionManager;
    private MemoryService memoryService;
    private SecurityService securityService;
    private SessionManager sessionManager;
    private ServerConfigurationService serverConfigurationService;
    private SiteService siteService;
    private ToolManager toolManager;
    private UserDirectoryService userDirectoryService;
    private ProjectLogic projectLogic;

    public void init() {
    }

    public Session getCurrentSession() {
        return this.sessionManager.getCurrentSession();
    }

    public String getCurrentSiteId() {
        return this.toolManager.getCurrentPlacement().getContext();
    }

    public Site getSiteOrNull(String siteId) {
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException idue) {
            log.warn("No site with id '" + siteId + "'");
        }
        return site;
    }

    public String getCurrentSiteLocale() {
        String locale;
        String siteId = this.toolManager.getCurrentPlacement().getContext();
        Site currentSite = this.getSiteOrNull(siteId);
        if (currentSite != null && (locale = currentSite.getProperties().getProperty("locale_string")) != null) {
            return locale;
        }
        return null;
    }

    public Tool getCurrentTool() {
        return this.toolManager.getCurrentTool();
    }

    public String getCurrentToolId() {
        return this.toolManager.getCurrentPlacement().getId();
    }

    public String getCurrentUserId() {
        Session session = this.sessionManager.getCurrentSession();
        String userId = session.getUserId();
        return userId;
    }

    public ToolSession getCurrentToolSession() {
        return this.sessionManager.getCurrentToolSession();
    }

    public void setCurrentToolSession(ToolSession toolSession) {
        this.sessionManager.setCurrentToolSession(toolSession);
    }

    public String getDisplayNameForTheUser(String userId) {
        try {
            User sakaiUser = this.userDirectoryService.getUser(userId);
            return FormattedText.escapeHtmlFormattedText((String)sakaiUser.getDisplayName());
        }
        catch (Exception e) {
            return userId;
        }
    }

    public boolean isCurrentUserAdmin() {
        return this.securityService.isSuperUser();
    }

    public String getPortalUrl() {
        String serverUrl = this.serverConfigurationService.getServerUrl();
        return serverUrl + this.serverConfigurationService.getString("portalPath");
    }

    public void registerEntityProducer(EntityProducer entityProducer) {
        this.entityManager.registerEntityProducer(entityProducer, "/commons");
    }

    public void registerFunction(String function) {
        List functions = this.functionManager.getRegisteredFunctions("commons.");
        if (!functions.contains(function)) {
            this.functionManager.registerFunction(function);
        }
    }

    public boolean isAllowedFunction(String function, String siteId) {
        try {
            Site site = this.siteService.getSite(siteId);
            Role role = this.getCurrentUserRoleForSite(site);
            return this.isAllowedFunction(function, role);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAllowedFunction(String function, Role role) {
        try {
            if (this.isCurrentUserAdmin()) {
                return true;
            }
            if (role == null) {
                return false;
            }
            return role.isAllowed(function);
        }
        catch (Exception e) {
            log.error("Caught exception while performing function test", (Throwable)e);
            return false;
        }
    }

    public void postEvent(String event, String reference, String siteId) {
        this.eventTrackingService.post(this.eventTrackingService.newEvent(event, reference, siteId, true, 2));
    }

    public Set<String> getSiteUsers(String siteId) {
        try {
            Site site = this.siteService.getSite(siteId);
            return site.getUsers();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getCommonsToolId(String siteId) {
        try {
            Site site = this.siteService.getSite(siteId);
            ToolConfiguration tc = site.getToolForCommonId("sakai.commons");
            return tc.getId();
        }
        catch (Exception e) {
            return "";
        }
    }

    public Set<String> getSitePermissionsForCurrentUser(String siteId, String embedder) {
        Role siteHelperRole;
        TreeSet<String> filteredFunctions = new TreeSet<String>();
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException e) {
            log.error("Trying to get commons permissions for unknown site " + siteId, (Throwable)e);
        }
        String userId = this.getCurrentUserId();
        if (userId == null) {
            throw new SecurityException("This action (userPerms) is not accessible to anon and there is no current user.");
        }
        if (this.securityService.isSuperUser(userId)) {
            filteredFunctions.addAll(this.functionManager.getRegisteredFunctions("commons"));
            return filteredFunctions;
        }
        Role siteRole = this.getCurrentUserRoleForSite(site);
        if (this.siteService.getUserSiteId(userId).equals(siteId)) {
            AuthzGroup siteRealm = null;
            try {
                siteRealm = this.authzGroupService.getAuthzGroup("/site/" + siteId);
                if (!(siteRole.isAllowed("commons.post.create") && siteRole.isAllowed("commons.post.read.any") && siteRole.isAllowed("commons.post.update.own") && siteRole.isAllowed("commons.post.delete.own") && siteRole.isAllowed("commons.comment.create") && siteRole.isAllowed("commons.comment.read.any") && siteRole.isAllowed("commons.comment.update.own") && siteRole.isAllowed("commons.comment.delete.own"))) {
                    siteRole.allowFunction("commons.post.create");
                    siteRole.allowFunction("commons.post.read.any");
                    siteRole.allowFunction("commons.post.update.own");
                    siteRole.allowFunction("commons.post.delete.own");
                    siteRole.allowFunction("commons.comment.create");
                    siteRole.allowFunction("commons.comment.read.any");
                    siteRole.allowFunction("commons.comment.update.own");
                    siteRole.allowFunction("commons.comment.delete.own");
                    this.authzGroupService.save(siteRealm);
                }
            }
            catch (Exception e) {
                log.error("Exception while looking up or modifying user workspace role " + siteRole.getId() + " in site " + siteId, (Throwable)e);
            }
        }
        if (embedder.equals("ASSIGNMENT")) {
            if (siteRole.isAllowed("asn.submit")) {
                filteredFunctions.add("commons.post.create");
                filteredFunctions.add("commons.post.read.any");
                filteredFunctions.add("commons.post.update.own");
                filteredFunctions.add("commons.post.delete.own");
                filteredFunctions.add("commons.comment.create");
                filteredFunctions.add("commons.comment.read.any");
                filteredFunctions.add("commons.comment.update.own");
                filteredFunctions.add("commons.comment.delete.own");
            }
            if (siteRole.isAllowed("asn.new")) {
                filteredFunctions.add("commons.post.create");
                filteredFunctions.add("commons.post.read.any");
                filteredFunctions.add("commons.post.delete.any");
                filteredFunctions.add("commons.post.update.own");
                filteredFunctions.add("commons.post.delete.own");
                filteredFunctions.add("commons.comment.create");
                filteredFunctions.add("commons.comment.read.any");
                filteredFunctions.add("commons.comment.update.own");
                filteredFunctions.add("commons.comment.delete.own");
                filteredFunctions.add("commons.comment.delete.any");
            }
            return filteredFunctions;
        }
        Set functions = siteRole.getAllowedFunctions();
        AuthzGroup siteHelperRealm = null;
        try {
            siteHelperRealm = this.authzGroupService.getAuthzGroup("!site.helper");
        }
        catch (Exception e) {
            log.error("Error calling authzGroupService.getAuthzGroup(\"!site.helper\")", (Throwable)e);
        }
        if (siteHelperRealm != null && (siteHelperRole = siteHelperRealm.getRole(siteRole.getId())) != null) {
            functions.addAll(siteHelperRole.getAllowedFunctions());
        }
        filteredFunctions.addAll(functions.stream().filter(f -> f.startsWith("commons") || f.equals("site.upd")).collect(Collectors.toSet()));
        return filteredFunctions;
    }

    public Role getCurrentUserRoleForSite(Site site) {
        String[] delegatedAccess = this.projectLogic.getCurrentUsersAccessToSite("/site/" + site.getId());
        if (delegatedAccess != null && delegatedAccess.length >= 2) {
            Role role = null;
            try {
                role = site.getRole(delegatedAccess[1]);
            }
            catch (Exception e) {
                log.error("Exception getting role for delegatedAccess role " + delegatedAccess[1] + " in site " + site.getId(), (Throwable)e);
            }
            if (role == null) {
                role = site.getRole("Student");
            }
            if (role == null) {
                role = site.getRole("access");
            }
            if (role == null) {
                log.error("Unable to find a role for user with delegatedAccess role " + delegatedAccess[1] + " in site " + site.getId());
            }
            return role;
        }
        return site.getUserRole(this.getCurrentUserId());
    }

    public Map<String, Set<String>> getSitePermissions(String siteId) {
        HashMap<String, Set<String>> perms = new HashMap<String, Set<String>>();
        String userId = this.getCurrentUserId();
        if (userId == null) {
            throw new SecurityException("This action (perms) is not accessible to anon and there is no current user.");
        }
        try {
            Site site = this.siteService.getSite(siteId);
            for (Role role : site.getRoles()) {
                Set functions = role.getAllowedFunctions();
                perms.put(role.getId(), functions.stream().filter(f -> f.startsWith("commons")).collect(Collectors.toSet()));
            }
        }
        catch (Exception e) {
            log.error("Failed to get current site permissions.", (Throwable)e);
        }
        return perms;
    }

    public boolean setPermissionsForSite(String siteId, Map<String, Object> params) {
        String userId = this.getCurrentUserId();
        if (userId == null) {
            throw new SecurityException("This action (setPerms) is not accessible to anon and there is no current user.");
        }
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException ide) {
            log.warn(userId + " attempted to update COMMONS permissions for unknown site " + siteId);
            return false;
        }
        boolean admin = this.securityService.isSuperUser(userId);
        try {
            AuthzGroup authzGroup = this.authzGroupService.getAuthzGroup(site.getReference());
            if (!this.securityService.isSuperUser()) {
                Role siteRole = this.getCurrentUserRoleForSite(site);
                AuthzGroup siteHelperAuthzGroup = this.authzGroupService.getAuthzGroup("!site.helper");
                Role siteHelperRole = siteHelperAuthzGroup.getRole(siteRole.getId());
                if (!siteRole.isAllowed("site.upd")) {
                    log.warn(userId + " attempted to update COMMONS permissions for site " + site.getTitle());
                    return false;
                }
            }
            boolean changed = false;
            for (String name : params.keySet()) {
                if (!name.contains(":")) continue;
                String value = (String)params.get(name);
                String roleId = name.substring(0, name.indexOf(":"));
                Role role = authzGroup.getRole(roleId);
                if (role == null) {
                    throw new IllegalArgumentException("Invalid role id '" + roleId + "' provided in POST parameters.");
                }
                String function = name.substring(name.indexOf(":") + 1);
                if ("true".equals(value)) {
                    role.allowFunction(function);
                } else {
                    role.disallowFunction(function);
                }
                changed = true;
            }
            if (changed) {
                try {
                    this.authzGroupService.save(authzGroup);
                }
                catch (AuthzPermissionException ape) {
                    throw new SecurityException("The permissions for this site (" + siteId + ") cannot be updated by the current user.");
                }
            }
            return true;
        }
        catch (GroupNotDefinedException gnde) {
            log.error("No realm defined for site (" + siteId + ").", (Throwable)gnde);
            return false;
        }
    }

    public Cache getCache(String cache) {
        try {
            return this.memoryService.getCache(cache);
        }
        catch (Exception e) {
            log.error("Exception whilst retrieving '" + cache + "' cache. Returning null ...", (Throwable)e);
            return null;
        }
    }

    public boolean isUserSite(String siteId) {
        return this.siteService.isUserSite(siteId);
    }

    public void addObserver(Observer observer) {
        this.eventTrackingService.addObserver(observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String storeFile(FileItem fileItem, String siteId) {
        SecurityAdvisor advisor = new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                return SecurityAdvisor.SecurityAdvice.ALLOWED;
            }
        };
        this.securityService.pushAdvisor(advisor);
        try {
            String fileName = fileItem.getName();
            int lastIndexOf = fileName.lastIndexOf("/");
            if (lastIndexOf != -1 && fileName.length() > lastIndexOf + 1) {
                fileName = fileName.substring(lastIndexOf + 1);
            }
            String suffix = "";
            lastIndexOf = fileName.lastIndexOf(".");
            if (lastIndexOf != -1 && fileName.length() > lastIndexOf + 1) {
                suffix = fileName.substring(lastIndexOf + 1);
                fileName = fileName.substring(0, lastIndexOf);
            }
            String toolCollection = "/group/" + siteId + "/" + "commons" + "/";
            try {
                this.contentHostingService.checkCollection(toolCollection);
            }
            catch (Exception e) {
                ContentCollectionEdit toolEdit = this.contentHostingService.addCollection(toolCollection);
                toolEdit.getPropertiesEdit().addProperty("DAV:displayname", "commons");
                this.contentHostingService.commitCollection(toolEdit);
            }
            ContentResourceEdit edit = this.contentHostingService.addResource(toolCollection, fileName, suffix, 2);
            edit.setContent(fileItem.getInputStream());
            this.contentHostingService.commitResource(edit, 0);
            String string = edit.getUrl();
            return string;
        }
        catch (Exception e) {
            log.error("Failed to store file.", (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            this.securityService.popAdvisor(advisor);
        }
    }

    public void setAuthzGroupService(AuthzGroupService authzGroupService) {
        this.authzGroupService = authzGroupService;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public void setMemoryService(MemoryService memoryService) {
        this.memoryService = memoryService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setProjectLogic(ProjectLogic projectLogic) {
        this.projectLogic = projectLogic;
    }
}

