/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.commons.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.Stack;
import org.sakaiproject.commons.api.CommonsManager;
import org.sakaiproject.commons.api.CommonsSecurityManager;
import org.sakaiproject.commons.api.PersistenceManager;
import org.sakaiproject.commons.api.QueryBean;
import org.sakaiproject.commons.api.SakaiProxy;
import org.sakaiproject.commons.api.datamodel.Comment;
import org.sakaiproject.commons.api.datamodel.Post;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.memory.api.Cache;
import org.sakaiproject.profile2.logic.ProfileConnectionsLogic;
import org.sakaiproject.util.FormattedText;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommonsManagerImpl
implements CommonsManager,
Observer {
    private static final Logger log = LoggerFactory.getLogger(CommonsManagerImpl.class);
    private CommonsSecurityManager commonsSecurityManager;
    private PersistenceManager persistenceManager;
    private ProfileConnectionsLogic profileConnectionsLogic;
    private SakaiProxy sakaiProxy;

    public void init() {
        log.info("Registering Commons functions ...");
        this.sakaiProxy.registerFunction("commons.post.create");
        this.sakaiProxy.registerFunction("commons.post.read.any");
        this.sakaiProxy.registerFunction("commons.post.update.any");
        this.sakaiProxy.registerFunction("commons.post.update.own");
        this.sakaiProxy.registerFunction("commons.post.delete.any");
        this.sakaiProxy.registerFunction("commons.post.delete.own");
        this.sakaiProxy.registerFunction("commons.comment.create");
        this.sakaiProxy.registerFunction("commons.comment.read.any");
        this.sakaiProxy.registerFunction("commons.comment.update.any");
        this.sakaiProxy.registerFunction("commons.comment.update.own");
        this.sakaiProxy.registerFunction("commons.comment.delete.any");
        this.sakaiProxy.registerFunction("commons.comment.delete.own");
        log.info("Registered Commons functions.");
        this.sakaiProxy.registerEntityProducer((EntityProducer)this);
        this.sakaiProxy.addObserver((Observer)this);
    }

    private List<Post> getPosts(String siteId) throws Exception {
        QueryBean query = new QueryBean();
        query.siteId = siteId;
        return this.commonsSecurityManager.filter(this.persistenceManager.getAllPost(query), siteId, "SITE");
    }

    public Post getPost(String postId, boolean loadComments) {
        return this.persistenceManager.getPost(postId, loadComments);
    }

    public List<Post> getPosts(QueryBean query) throws Exception {
        String key;
        Cache cache = this.sakaiProxy.getCache("org.sakaiproject.commons.sortedPostCache");
        List posts = (List)cache.get((Object)(key = query.isUserSite ? query.callerId : query.commonsId));
        if (posts == null) {
            log.debug("Cache miss or expired on id: {}", (Object)key);
            if (query.isUserSite) {
                log.debug("Getting posts for a user site ...");
                query.fromIds.add(query.callerId);
                query.fromIds.addAll(this.getConnectionUserIds(this.sakaiProxy.getCurrentUserId()));
            }
            List unfilteredPosts = this.persistenceManager.getAllPost(query, true);
            cache.put((Object)key, (Object)unfilteredPosts);
            return this.commonsSecurityManager.filter(unfilteredPosts, query.siteId, query.embedder);
        }
        log.debug("Cache hit on id: {}", (Object)key);
        return this.commonsSecurityManager.filter(posts, query.siteId, query.embedder);
    }

    public Post savePost(Post post) {
        if (this.commonsSecurityManager.canCurrentUserEditPost(post)) {
            try {
                post.setContent(FormattedText.processFormattedText((String)post.getContent(), (StringBuilder)new StringBuilder(), (boolean)true, (boolean)false));
                Post newOrUpdatedPost = this.persistenceManager.savePost(post);
                if (newOrUpdatedPost != null) {
                    String commonsId = post.getCommonsId();
                    ArrayList<String> contextIds = new ArrayList<String>();
                    if (this.persistenceManager.getCommons(commonsId).isSocial()) {
                        contextIds = this.getConnectionUserIds(this.sakaiProxy.getCurrentUserId());
                    } else {
                        contextIds.add(post.getCommonsId());
                    }
                    this.removeContextIdsFromCache(contextIds);
                    return newOrUpdatedPost;
                }
                log.error("Failed to save post");
            }
            catch (Exception e) {
                log.error("Caught exception whilst saving post", (Throwable)e);
            }
        } else {
            log.warn("Current user cannot save post with id '{}'. Null will be returned.", (Object)post.getId());
        }
        return null;
    }

    public boolean deletePost(String postId) {
        try {
            Post post = this.persistenceManager.getPost(postId, false);
            if (this.commonsSecurityManager.canCurrentUserDeletePost(post)) {
                if (this.persistenceManager.deletePost(post)) {
                    ArrayList<String> contextIds = new ArrayList<String>();
                    String commonsId = post.getCommonsId();
                    if (this.persistenceManager.getCommons(commonsId).isSocial()) {
                        String userId = post.getCreatorId();
                        contextIds = this.getConnectionUserIds(userId);
                    } else {
                        contextIds.add(post.getCommonsId());
                    }
                    this.removeContextIdsFromCache(contextIds);
                    return true;
                }
            } else {
                log.warn("Can't delete post '" + postId + "'");
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public Comment saveComment(String commonsId, Comment comment) {
        try {
            Comment savedComment;
            Post post = this.persistenceManager.getPost(comment.getPostId(), false);
            if (this.commonsSecurityManager.canCurrentUserCommentOnPost(post) && (savedComment = this.persistenceManager.saveComment(comment)) != null) {
                ArrayList<String> contextIds = new ArrayList<String>();
                if (this.persistenceManager.getCommons(commonsId).isSocial()) {
                    contextIds = this.getConnectionUserIds(post.getCreatorId());
                } else {
                    contextIds.add(commonsId);
                }
                this.removeContextIdsFromCache(contextIds);
                return savedComment;
            }
        }
        catch (Exception e) {
            log.error("Caught exception whilst saving comment", (Throwable)e);
        }
        return null;
    }

    public boolean deleteComment(String siteId, String commonsId, String embedder, String commentId, String commentCreatorId, String postCreatorId) {
        try {
            if (this.commonsSecurityManager.canCurrentUserDeleteComment(siteId, embedder, commentCreatorId, postCreatorId) && this.persistenceManager.deleteComment(commentId)) {
                ArrayList<String> contextIds = new ArrayList<String>();
                if (embedder.equals("SOCIAL")) {
                    contextIds = this.getConnectionUserIds(postCreatorId);
                } else {
                    contextIds.add(commonsId);
                }
                this.removeContextIdsFromCache(contextIds);
                return true;
            }
        }
        catch (Exception e) {
            log.error("Caught exception whilst deleting comment.", (Throwable)e);
        }
        return false;
    }

    private String serviceName() {
        return CommonsManager.class.getName();
    }

    public String archive(String siteId, Document doc, Stack stack, String archivePath, List attachments) {
        log.debug("archive(siteId:{}, archivePath:{})", (Object)siteId, (Object)archivePath);
        StringBuilder results = new StringBuilder();
        results.append(this.getLabel() + ": Started.\n");
        int postCount = 0;
        try {
            Element element = doc.createElement(this.serviceName());
            element.setAttribute("version", "11.x");
            ((Element)stack.peek()).appendChild(element);
            stack.push(element);
            Element commons = doc.createElement("commons");
            List<Post> posts = this.getPosts(siteId);
            if (posts != null && posts.size() > 0) {
                for (Post post : posts) {
                    Element postElement = post.toXml(doc, stack);
                    commons.appendChild(postElement);
                    ++postCount;
                }
            }
            ((Element)stack.peek()).appendChild(commons);
            stack.push(commons);
            stack.pop();
            results.append(this.getLabel() + ": Finished. " + postCount + " post(s) archived.\n");
        }
        catch (Exception any) {
            results.append(this.getLabel() + ": exception caught. Message: " + any.getMessage());
            log.warn(this.getLabel() + " exception caught. Message: " + any.getMessage());
        }
        stack.pop();
        return results.toString();
    }

    public String merge(String siteId, Element root, String archivePath, String fromSiteId, Map attachmentNames, Map userIdTrans, Set userListAllowImport) {
        log.debug("merge(siteId:{},root tagName:{},archivePath:{},fromSiteId:{})", new Object[]{siteId, root.getTagName(), archivePath, fromSiteId});
        StringBuilder results = new StringBuilder();
        int postCount = 0;
        NodeList postNodes = root.getElementsByTagName("post");
        int numberPosts = postNodes.getLength();
        for (int i = 0; i < numberPosts; ++i) {
            Node child = postNodes.item(i);
            if (child.getNodeType() != 1) {
                log.error("Post nodes should be elements. Skipping ...");
                continue;
            }
            Element postElement = (Element)child;
            Post post = new Post();
            post.fromXml(postElement);
            post.setSiteId(siteId);
            this.savePost(post);
            for (Comment comment : post.getComments()) {
                comment.setPostId(post.getId());
                this.saveComment(siteId, comment);
            }
            ++postCount;
        }
        results.append("Stored " + postCount + " posts.");
        return results.toString();
    }

    public Entity getEntity(Reference ref) {
        log.debug("getEntity(Ref ID:{})", (Object)ref.getId());
        Post rv = null;
        try {
            String reference = ref.getReference();
            String[] parts = reference.split("/");
            if (parts.length == 5) {
                String postId = parts[4];
                rv = this.persistenceManager.getPost(postId, true);
            }
        }
        catch (Exception e) {
            log.warn("getEntity(): " + e);
        }
        return rv;
    }

    public Collection getEntityAuthzGroups(Reference ref, String userId) {
        log.debug("getEntityAuthzGroups(Ref ID:{},{})", (Object)ref.getId(), (Object)userId);
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("/site/" + ref.getContext());
        return ids;
    }

    public String getEntityDescription(Reference arg0) {
        return null;
    }

    public ResourceProperties getEntityResourceProperties(Reference ref) {
        try {
            String reference = ref.getReference();
            int lastIndex = reference.lastIndexOf("/");
            String postId = reference.substring(lastIndex, reference.length() - lastIndex);
            Post entity = this.persistenceManager.getPost(postId, false);
            return entity.getProperties();
        }
        catch (Exception e) {
            log.warn("getEntity(): " + e);
            return null;
        }
    }

    public String getEntityUrl(Reference ref) {
        return this.getEntity(ref).getUrl();
    }

    public HttpAccess getHttpAccess() {
        return null;
    }

    public String getLabel() {
        return "commons";
    }

    public boolean parseEntityReference(String referenceString, Reference reference) {
        String[] parts = referenceString.split("/");
        if (parts.length < 2 || !parts[1].equals("commons")) {
            return false;
        }
        if (parts.length == 2) {
            reference.set("sakai:commons", "", "", null, "");
            return true;
        }
        String siteId = parts[2];
        String subType = parts[3];
        return false;
    }

    public boolean willArchiveMerge() {
        return true;
    }

    public String getEntityPrefix() {
        return "commons";
    }

    public boolean entityExists(String id) {
        String postId = id.substring(id.lastIndexOf("/"));
        try {
            if (this.persistenceManager.postExists(postId)) {
                return true;
            }
        }
        catch (Exception e) {
            log.error("entityExists threw an exception", (Throwable)e);
        }
        return false;
    }

    private void removeContextIdsFromCache(List<String> contextIds) {
        Cache cache = this.sakaiProxy.getCache("org.sakaiproject.commons.sortedPostCache");
        contextIds.forEach(contextId -> cache.remove(contextId));
    }

    private List<String> getConnectionUserIds(String userId) {
        ArrayList<String> userIds = new ArrayList<String>();
        List conns = this.profileConnectionsLogic.getBasicConnectionsForUser(userId);
        conns.forEach(conn -> userIds.add(conn.getUuid()));
        userIds.add(userId);
        return userIds;
    }

    @Override
    public void update(Observable o, Object arg) {
        Event e;
        String event;
        if (arg instanceof Event && ("profile.friend.confirm".equals(event = (e = (Event)arg).getEvent()) || "profile.friend.remove".equals(event))) {
            String ref = e.getResource();
            String[] pathParts = ref.split("/");
            String from = e.getUserId();
            String to = pathParts[2];
            ArrayList<String> contextIds = new ArrayList<String>();
            contextIds.add(from);
            contextIds.add(to);
            this.removeContextIdsFromCache(contextIds);
        }
    }

    public void setCommonsSecurityManager(CommonsSecurityManager commonsSecurityManager) {
        this.commonsSecurityManager = commonsSecurityManager;
    }

    public void setPersistenceManager(PersistenceManager persistenceManager) {
        this.persistenceManager = persistenceManager;
    }

    public void setProfileConnectionsLogic(ProfileConnectionsLogic profileConnectionsLogic) {
        this.profileConnectionsLogic = profileConnectionsLogic;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }
}

