/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.commons.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.sakaiproject.commons.api.PersistenceManager;
import org.sakaiproject.commons.api.QueryBean;
import org.sakaiproject.commons.api.SakaiProxy;
import org.sakaiproject.commons.api.datamodel.Comment;
import org.sakaiproject.commons.api.datamodel.Commons;
import org.sakaiproject.commons.api.datamodel.Post;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.db.api.SqlReader;
import org.sakaiproject.db.api.SqlService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManagerImpl
implements PersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(PersistenceManagerImpl.class);
    private static final String POST_SELECT = "SELECT cp.*,cw.ID as COMMONS_ID,cw.SITE_ID,cw.EMBEDDER FROM COMMONS_POST as cp, COMMONS_COMMONS as cw, COMMONS_COMMONS_POST as cwp WHERE cp.ID = ? AND cp.ID = cwp.POST_ID and cwp.COMMONS_ID = cw.ID";
    private static final String COMMONS_SELECT = "SELECT * FROM COMMONS_COMMONS WHERE ID = ?";
    private static final String COMMONS_POSTS_SELECT = "SELECT cw.ID as COMMONS_ID,cw.SITE_ID,cw.EMBEDDER,cp.* FROM COMMONS_COMMONS as cw,COMMONS_COMMONS_POST as cwp,COMMONS_POST as cp WHERE cw.ID = ? AND cwp.COMMONS_ID = cw.ID AND cp.ID = cwp.POST_ID ORDER BY CREATED_DATE DESC";
    private static final String SOCIAL_COMMONS_POSTS_SELECT = "SELECT cw.ID as COMMONS_ID,cw.SITE_ID,cw.EMBEDDER,cp.* FROM COMMONS_COMMONS as cw,COMMONS_COMMONS_POST as cwp,COMMONS_POST as cp WHERE cw.ID = ? AND cwp.COMMONS_ID = cw.ID AND cp.ID = cwp.POST_ID AND CREATOR_ID IN (";
    private static final String COMMONS_POST_INSERT = "INSERT INTO COMMONS_COMMONS_POST VALUES(?,?)";
    private static final String COMMONS_INSERT = "INSERT INTO COMMONS_COMMONS VALUES(?,?,?)";
    private static final String COMMENT_SELECT = "SELECT * FROM COMMONS_COMMENT WHERE ID = ?";
    private static final String COMMENTS_SELECT = "SELECT * FROM COMMONS_COMMENT WHERE POST_ID = ? ORDER BY CREATED_DATE ASC";
    private static final String COMMENT_INSERT = "INSERT INTO COMMONS_COMMENT VALUES(?,?,?,?,?,?)";
    private static final String COMMENT_UPDATE = "UPDATE COMMONS_COMMENT SET CONTENT = ?, MODIFIED_DATE = ? WHERE ID = ?";
    private static final String COMMENT_DELETE = "DELETE FROM COMMONS_COMMENT WHERE ID = ?";
    private static final String POST_UPDATE = "UPDATE COMMONS_POST SET CONTENT = ?, MODIFIED_DATE = ?, RELEASE_DATE = ? WHERE ID = ?";
    private static final String POST_INSERT = "INSERT INTO COMMONS_POST VALUES (?,?,?,?,?,?)";
    private static final String POST_DELETE = "DELETE FROM COMMONS_POST WHERE ID = ?";
    private static final String COMMONS_POST_DELETE = "DELETE FROM COMMONS_COMMONS_POST WHERE POST_ID = ?";
    private static final String COMMENTS_DELETE = "DELETE FROM COMMONS_COMMENT WHERE POST_ID = ?";
    private SakaiProxy sakaiProxy;
    private ServerConfigurationService serverConfigurationService;
    private SqlService sqlService;

    public void init() {
        if (this.serverConfigurationService.getBoolean("auto.ddl", true)) {
            this.sqlService.ddl(this.getClass().getClassLoader(), "commons_tables");
        }
    }

    public boolean postExists(String postId) {
        log.debug("postExists({})", (Object)postId);
        List posts = this.sqlService.dbRead(POST_SELECT, new Object[]{postId}, (SqlReader)new SqlReader<Post>(){

            public Post readSqlResultRecord(ResultSet result) {
                return new Post();
            }
        });
        return posts.size() > 0;
    }

    public List<Post> getAllPost(QueryBean query) throws Exception {
        return this.getAllPost(query, false);
    }

    public List<Post> getAllPost(QueryBean query, final boolean populate) throws Exception {
        log.debug("getAllPost({})", (Object)query);
        if (query.embedder.equals("SOCIAL")) {
            int numFromIds = query.fromIds.size();
            if (numFromIds > 0) {
                String sql = SOCIAL_COMMONS_POSTS_SELECT;
                for (int i = 0; i < numFromIds; ++i) {
                    sql = sql + "?,";
                }
                sql = sql.substring(0, sql.length() - 1);
                sql = sql + ") ORDER BY CREATED_DATE DESC";
                ArrayList<String> params = new ArrayList<String>();
                params.add(query.commonsId);
                params.addAll(query.fromIds);
                return this.sqlService.dbRead(sql, params.toArray(), (SqlReader)new SqlReader<Post>(){

                    public Post readSqlResultRecord(ResultSet result) {
                        return PersistenceManagerImpl.this.loadPostFromResult(result, populate);
                    }
                });
            }
            log.warn("SOCIAL posts requested, but no connection ids supplies. Returning an empty list ...");
            return new ArrayList<Post>();
        }
        return this.sqlService.dbRead(COMMONS_POSTS_SELECT, new Object[]{query.commonsId}, (SqlReader)new SqlReader<Post>(){

            public Post readSqlResultRecord(ResultSet result) {
                return PersistenceManagerImpl.this.loadPostFromResult(result, populate);
            }
        });
    }

    public Comment getComment(String commentId) {
        List comments = this.sqlService.dbRead(COMMENT_SELECT, new Object[]{commentId}, (SqlReader)new SqlReader<Comment>(){

            public Comment readSqlResultRecord(ResultSet result) {
                try {
                    return new Comment(result);
                }
                catch (SQLException sqle) {
                    log.error("Failed to get comment", (Throwable)sqle);
                    return null;
                }
            }
        });
        Comment comment = (Comment)comments.get(0);
        comment.setCreatorDisplayName(this.sakaiProxy.getDisplayNameForTheUser(comment.getCreatorId()));
        return comment;
    }

    public Comment saveComment(Comment comment) {
        if ("".equals(comment.getId())) {
            comment.setId(UUID.randomUUID().toString());
            this.sqlService.dbWrite(COMMENT_INSERT, new Object[]{comment.getId(), comment.getPostId(), comment.getContent(), comment.getCreatorId(), new Timestamp(comment.getCreatedDate()), new Timestamp(comment.getModifiedDate())});
        } else {
            this.sqlService.dbWrite(COMMENT_UPDATE, new Object[]{comment.getContent(), new Timestamp(comment.getModifiedDate()), comment.getId()});
        }
        return this.getComment(comment.getId());
    }

    public boolean deleteComment(String commentId) {
        this.sqlService.dbWrite(COMMENT_DELETE, new Object[]{commentId});
        return true;
    }

    public Post savePost(final Post post) {
        log.debug("savePost()");
        if (this.postExists(post.getId())) {
            this.sqlService.dbWrite(POST_UPDATE, new Object[]{post.getContent(), new Timestamp(new Date().getTime()), new Timestamp(post.getReleaseDate()), post.getId()});
        } else {
            Runnable transaction = new Runnable(){

                @Override
                public void run() {
                    if (PersistenceManagerImpl.this.getCommons(post.getCommonsId()) == null) {
                        String embedder = post.getEmbedder();
                        String siteId = embedder.equals("SOCIAL") ? "SOCIAL" : post.getSiteId();
                        PersistenceManagerImpl.this.sqlService.dbWrite(PersistenceManagerImpl.COMMONS_INSERT, new Object[]{post.getCommonsId(), siteId, embedder});
                    }
                    post.setId(UUID.randomUUID().toString());
                    PersistenceManagerImpl.this.sqlService.dbWrite(PersistenceManagerImpl.POST_INSERT, new Object[]{post.getId(), post.getContent(), post.getCreatorId(), new Timestamp(post.getCreatedDate()), new Timestamp(post.getModifiedDate()), new Timestamp(post.getReleaseDate())});
                    PersistenceManagerImpl.this.sqlService.dbWrite(PersistenceManagerImpl.COMMONS_POST_INSERT, new Object[]{post.getCommonsId(), post.getId()});
                }
            };
            this.sqlService.transact(transaction, "COMMONS_POST_CREATION_TRANSACTION");
        }
        return this.getPost(post.getId(), false);
    }

    public boolean deletePost(final Post post) {
        log.debug("deletePost({})", (Object)post.getId());
        Runnable transaction = new Runnable(){

            @Override
            public void run() {
                Object[] params = new Object[]{post.getId()};
                PersistenceManagerImpl.this.sqlService.dbWrite(PersistenceManagerImpl.COMMENTS_DELETE, params);
                PersistenceManagerImpl.this.sqlService.dbWrite(PersistenceManagerImpl.COMMONS_POST_DELETE, params);
                PersistenceManagerImpl.this.sqlService.dbWrite(PersistenceManagerImpl.POST_DELETE, params);
            }
        };
        return this.sqlService.transact(transaction, "COMMONS_POST_DELETION_TRANSACTION");
    }

    public Post getPost(String postId, final boolean loadComments) {
        List posts = this.sqlService.dbRead(POST_SELECT, new Object[]{postId}, (SqlReader)new SqlReader<Post>(){

            public Post readSqlResultRecord(ResultSet result) {
                return PersistenceManagerImpl.this.loadPostFromResult(result, loadComments);
            }
        });
        if (posts.size() < 1) {
            return null;
        }
        return (Post)posts.get(0);
    }

    public Commons getCommons(String commonsId) {
        List commons = this.sqlService.dbRead(COMMONS_SELECT, new Object[]{commonsId}, (SqlReader)new SqlReader<Commons>(){

            public Commons readSqlResultRecord(ResultSet result) {
                try {
                    return new Commons(result);
                }
                catch (SQLException sqle) {
                    return null;
                }
            }
        });
        if (commons.size() > 0) {
            return (Commons)commons.get(0);
        }
        log.warn("No commons for id '" + commonsId + "'. Returning null ...");
        return null;
    }

    private Post loadPostFromResult(ResultSet result, boolean loadComments) {
        try {
            final Post post = new Post(result);
            post.setCreatorDisplayName(this.sakaiProxy.getDisplayNameForTheUser(post.getCreatorId()));
            if (loadComments) {
                List comments = this.sqlService.dbRead(COMMENTS_SELECT, new Object[]{post.getId()}, (SqlReader)new SqlReader<Comment>(){

                    public Comment readSqlResultRecord(ResultSet commentResult) {
                        try {
                            Comment comment = new Comment(commentResult);
                            comment.setCreatorDisplayName(PersistenceManagerImpl.this.sakaiProxy.getDisplayNameForTheUser(comment.getCreatorId()));
                            String toolId = PersistenceManagerImpl.this.sakaiProxy.getCommonsToolId(post.getSiteId());
                            String url = PersistenceManagerImpl.this.sakaiProxy.getPortalUrl() + "/directtool/" + toolId + "?state=post&postId=" + post.getId();
                            comment.setUrl(url);
                            return comment;
                        }
                        catch (SQLException sqle) {
                            log.error("Failed to read comment from DB.", (Throwable)sqle);
                            return null;
                        }
                    }
                });
                post.setComments(comments);
            }
            return post;
        }
        catch (SQLException sqle) {
            log.error("Failed to read post from DB.", (Throwable)sqle);
            return null;
        }
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public SqlService getSqlService() {
        return this.sqlService;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setSqlService(SqlService sqlService) {
        this.sqlService = sqlService;
    }
}

