/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.commons.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.commons.api.CommonsSecurityManager;
import org.sakaiproject.commons.api.SakaiProxy;
import org.sakaiproject.commons.api.datamodel.Post;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.tool.api.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonsSecurityManagerImpl
implements CommonsSecurityManager {
    private static final Logger log = LoggerFactory.getLogger(CommonsSecurityManagerImpl.class);
    private SakaiProxy sakaiProxy;
    private SecurityService securityService;
    private SiteService siteService;
    private ToolManager toolManager;

    public boolean canCurrentUserCommentOnPost(Post post) {
        log.debug("canCurrentUserCommentOnPost()");
        if (this.sakaiProxy.isAllowedFunction("commons.comment.update.any", post.getSiteId())) {
            return true;
        }
        if (post.getCreatorId().equals(this.sakaiProxy.getCurrentUserId())) {
            return true;
        }
        return this.sakaiProxy.isAllowedFunction("commons.comment.create", post.getSiteId());
    }

    public boolean canCurrentUserDeletePost(Post post) throws SecurityException {
        String siteId = post.getSiteId();
        if (this.sakaiProxy.isAllowedFunction("commons.post.delete.any", siteId)) {
            return true;
        }
        String currentUser = this.sakaiProxy.getCurrentUserId();
        return currentUser != null && currentUser.equals(post.getCreatorId()) && (siteId.equals("SOCIAL") || this.sakaiProxy.isAllowedFunction("commons.post.delete.own", siteId));
    }

    public boolean canCurrentUserEditPost(Post post) {
        if (this.sakaiProxy.isAllowedFunction("commons.post.update.any", post.getSiteId())) {
            return true;
        }
        String currentUser = this.sakaiProxy.getCurrentUserId();
        if (currentUser != null && currentUser.equals(post.getCreatorId())) {
            if (StringUtils.isBlank((String)post.getId())) {
                return this.sakaiProxy.isAllowedFunction("commons.post.create", post.getSiteId());
            }
            return this.sakaiProxy.isAllowedFunction("commons.post.update.own", post.getSiteId());
        }
        return false;
    }

    public boolean canCurrentUserDeleteComment(String siteId, String embedder, String commentCreatorId, String postCreatorId) throws SecurityException {
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        if (this.sakaiProxy.isAllowedFunction("commons.comment.delete.any", siteId)) {
            return true;
        }
        if (this.sakaiProxy.isAllowedFunction("commons.comment.delete.own", siteId) && commentCreatorId.equals(currentUserId)) {
            return true;
        }
        return embedder.equals("SOCIAL") && postCreatorId.equals(currentUserId);
    }

    public List<Post> filter(List<Post> posts, String siteId, String embedder) {
        if (posts != null && posts.size() > 0) {
            long now = Instant.now().toEpochMilli();
            posts = posts.stream().filter(p -> p.getReleaseDate() <= now).collect(Collectors.toList());
            if (embedder.equals("SITE")) {
                boolean readAny = this.securityService.unlock("commons.post.read.any", "/site/" + siteId);
                return readAny ? posts : new ArrayList();
            }
            if (embedder.equals("ASSIGNMENT")) {
                boolean readAny = this.securityService.unlock("asn.submit", "/site/" + siteId);
                return readAny ? posts : new ArrayList();
            }
            if (embedder.equals("SOCIAL")) {
                return posts;
            }
            return new ArrayList<Post>();
        }
        return posts;
    }

    public boolean canCurrentUserReadPost(Post post) {
        Site site = this.sakaiProxy.getSiteOrNull(post.getSiteId());
        if (site != null) {
            return this.securityService.unlock("commons.post.read.any", "/site/" + post.getSiteId());
        }
        return false;
    }

    public Site getSiteIfCurrentUserCanAccessTool(String siteId) {
        Site site;
        try {
            site = this.siteService.getSiteVisit(siteId);
        }
        catch (Exception e) {
            return null;
        }
        ToolConfiguration toolConfig = site.getToolForCommonId("sakai.commons");
        if (!this.toolManager.isVisible(site, toolConfig)) {
            return null;
        }
        return site;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }
}

