/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.compilatio;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.service.ContentReviewService;
import org.sakaiproject.entity.api.ResourceProperties;

public class CompilatioContentValidator {
    private static final Log log = LogFactory.getLog(CompilatioContentValidator.class);
    ContentReviewService contentReviewService = null;

    public void setContentReviewService(ContentReviewService contentReviewService) {
        this.contentReviewService = contentReviewService;
    }

    public void init() {
    }

    public boolean isAcceptableContent(ContentResource resource) {
        if (resource == null) {
            return false;
        }
        String mime = resource.getContentType();
        log.debug((Object)("Got a content type of " + mime));
        Map acceptableExtensionsToMimeTypes = this.contentReviewService.getAcceptableExtensionsToMimeTypes();
        HashSet acceptableMimeTypes = new HashSet();
        for (SortedSet mimeTypes : acceptableExtensionsToMimeTypes.values()) {
            acceptableMimeTypes.addAll(mimeTypes);
        }
        Boolean fileTypeOk = false;
        if (acceptableMimeTypes.contains(mime)) {
            fileTypeOk = true;
            log.debug((Object)"FileType matches a known mime");
        } else {
            log.debug((Object)"FileType doesn't match a known mime");
        }
        if (!fileTypeOk.booleanValue()) {
            ResourceProperties resourceProperties = resource.getProperties();
            String fileName = resourceProperties.getProperty(resourceProperties.getNamePropDisplayName());
            if (fileName.indexOf(".") > 0) {
                String extension = fileName.substring(fileName.lastIndexOf("."));
                log.debug((Object)("file has an extension of " + extension));
                Set extensions = acceptableExtensionsToMimeTypes.keySet();
                fileTypeOk = extensions.contains(extension) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else {
                fileTypeOk = false;
            }
        }
        return fileTypeOk;
    }
}

