/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.compilatio;

import java.util.Map;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.contentreview.compilatio.util.CompilatioAPIUtil;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.exception.TransientSubmissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CompilatioAccountConnection {
    private static final Logger log = LoggerFactory.getLogger(CompilatioAccountConnection.class);
    private static final String DEFAULT_API_URL = "http://service.compilatio.net/webservices/CompilatioUserClient.php?";
    private static final int DEFAULT_TIMEOUT = 180000;
    private String secretKey = null;
    private String apiURL = "";
    private int compilatioConnTimeout = 0;
    private ServerConfigurationService serverConfigurationService;

    public void init() {
        log.info("init()");
        this.secretKey = this.serverConfigurationService.getString("compilatio.secretKey");
        this.apiURL = this.serverConfigurationService.getString("compilatio.apiURL", DEFAULT_API_URL);
        this.compilatioConnTimeout = this.serverConfigurationService.getInt("compilatio.networkTimeout", 180000);
    }

    public Document callCompilatioReturnDocument(Map params) throws TransientSubmissionException, SubmissionException {
        return CompilatioAPIUtil.callCompilatioReturnDocument(this.apiURL, params, this.secretKey, this.compilatioConnTimeout);
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }
}

