/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.compilatio;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.advisors.ContentReviewSiteAdvisor;
import org.sakaiproject.contentreview.compilatio.CompilatioAccountConnection;
import org.sakaiproject.contentreview.compilatio.CompilatioContentValidator;
import org.sakaiproject.contentreview.compilatio.util.CompilatioAPIUtil;
import org.sakaiproject.contentreview.dao.ContentReviewConstants;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.exception.QueueException;
import org.sakaiproject.contentreview.exception.ReportException;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.exception.TransientSubmissionException;
import org.sakaiproject.contentreview.service.BaseContentReviewService;
import org.sakaiproject.contentreview.service.ContentReviewQueueService;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CompilatioReviewServiceImpl
extends BaseContentReviewService {
    private static final Logger log = LoggerFactory.getLogger(CompilatioReviewServiceImpl.class);
    public static final String COMPILATIO_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String SERVICE_NAME = "Compilatio";
    private static final String COMPILATIO_SITE_PROPERTY = "compilatio";
    private final String[] DEFAULT_ACCEPTABLE_FILE_EXTENSIONS = new String[]{".doc", ".docx", ".xls", ".xls", ".xls", ".xls", ".xlsx", ".ppt", ".ppt", ".ppt", ".ppt", ".pptx", ".pps", ".pps", ".ppsx", ".pdf", ".ps", ".eps", ".txt", ".html", ".htm", ".wpd", ".wpd", ".odt", ".rtf", ".rtf", ".rtf", ".rtf"};
    private final String[] DEFAULT_ACCEPTABLE_MIME_TYPES = new String[]{"application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/excel", "application/vnd.ms-excel", "application/x-excel", "application/x-msexcel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/mspowerpoint", "application/powerpoint", "application/vnd.ms-powerpoint", "application/x-mspowerpoint", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/mspowerpoint", "application/vnd.ms-powerpoint", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/pdf", "application/postscript", "application/postscript", "text/plain", "text/html", "text/html", "application/wordperfect", "application/x-wpwin", "application/vnd.oasis.opendocument.text", "text/rtf", "application/rtf", "application/x-rtf", "text/richtext"};
    private final String PROP_ACCEPT_ALL_FILES = "compilatio.accept.all.files";
    private final String PROP_ACCEPTABLE_FILE_EXTENSIONS = "compilatio.acceptable.file.extensions";
    private final String PROP_ACCEPTABLE_MIME_TYPES = "compilatio.acceptable.mime.types";
    private final String PROP_ACCEPTABLE_FILE_TYPES = "compilatio.acceptable.file.types";
    private final String PROP_MAX_FILENAME_LENGTH = "compilatio.filename.max.length";
    private final int DEFAULT_MAX_FILENAME_LENGTH = -1;
    private final String KEY_FILE_TYPE_PREFIX = "file.type";
    private static final String NEW_ASSIGNMENT_REVIEW_SERVICE_REPORT_RADIO = "report_gen_speed";
    private static final String NEW_ASSIGNMENT_REVIEW_SERVICE_REPORT_IMMEDIATELY = "0";
    private static final String NEW_ASSIGNMENT_REVIEW_SERVICE_REPORT_DUE = "2";
    static final long LOCK_PERIOD = 12000000L;
    private Long maxRetry = 20L;
    private String defaultAssignmentName = null;
    protected ToolManager toolManager;
    protected UserDirectoryService userDirectoryService;
    protected ContentHostingService contentHostingService;
    protected CompilatioAccountConnection compilatioConn;
    protected CompilatioContentValidator compilatioContentValidator;
    protected ContentReviewSiteAdvisor siteAdvisor;
    ContentReviewQueueService crqs;

    public void init() {
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public void queueContent(String userId, String siteId, String taskId, List<ContentResource> content) throws QueueException {
        log.debug("Method called queueContent(" + userId + "," + siteId + "," + taskId + ")");
        if (content == null || content.isEmpty()) {
            return;
        }
        if (userId == null) {
            log.debug("Using current user");
            userId = this.userDirectoryService.getCurrentUser().getId();
        }
        if (siteId == null) {
            log.debug("Using current site");
            siteId = this.toolManager.getCurrentPlacement().getContext();
        }
        if (taskId == null) {
            log.debug("Generating default taskId");
            taskId = siteId + " defaultAssignment";
        }
        log.debug("Adding content from site " + siteId + " and user: " + userId + " for task: " + taskId + " to submission queue");
        this.crqs.queueContent(this.getProviderId(), userId, siteId, taskId, content);
    }

    public Long getReviewStatus(String contentId) throws QueueException {
        return this.crqs.getReviewStatus(this.getProviderId(), contentId);
    }

    public Date getDateQueued(String contextId) throws QueueException {
        return this.crqs.getDateQueued(this.getProviderId(), contextId);
    }

    public Date getDateSubmitted(String contextId) throws QueueException, SubmissionException {
        return this.crqs.getDateSubmitted(this.getProviderId(), contextId);
    }

    public List<ContentReviewItem> getReportList(String siteId, String taskId) throws QueueException, SubmissionException, ReportException {
        return this.crqs.getContentReviewItems(this.getProviderId(), siteId, taskId);
    }

    public List<ContentReviewItem> getReportList(String siteId) throws QueueException, SubmissionException, ReportException {
        return this.getReportList(siteId, null);
    }

    public List<ContentReviewItem> getAllContentReviewItems(String siteId, String taskId) throws QueueException, SubmissionException, ReportException {
        return this.crqs.getContentReviewItems(this.getProviderId(), siteId, taskId);
    }

    public void resetUserDetailsLockedItems(String userId) {
        this.crqs.resetUserDetailsLockedItems(this.getProviderId(), userId);
    }

    public void removeFromQueue(String contentId) {
        this.crqs.removeFromQueue(this.getProviderId(), contentId);
    }

    private Optional<ContentReviewItem> getItemByContentId(String contentId) {
        return this.crqs.getQueuedItem(this.getProviderId(), contentId);
    }

    private Optional<ContentReviewItem> getNextItemInSubmissionQueue() {
        return this.crqs.getNextItemInQueueToSubmit(this.getProviderId());
    }

    public boolean allowResubmission() {
        return true;
    }

    public int getReviewScore(String contentId, String assignmentRef, String userId) throws QueueException, ReportException, Exception {
        ContentReviewItem item = null;
        try {
            Optional<ContentReviewItem> matchingItem = this.getItemByContentId(contentId);
            if (!matchingItem.isPresent()) {
                log.debug("Content " + contentId + " has not been queued previously");
            }
            if ((item = matchingItem.get()).getStatus().compareTo(ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_REPORT_AVAILABLE_CODE) != 0) {
                log.debug("Report not available: " + item.getStatus());
            }
        }
        catch (Exception e) {
            log.error("(getReviewScore)" + e);
        }
        return item.getReviewScore();
    }

    public String getReviewReport(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        Optional<ContentReviewItem> matchingItem = this.getItemByContentId(contentId);
        if (!matchingItem.isPresent()) {
            log.debug("Content " + contentId + " has not been queued previously");
            throw new QueueException("Content " + contentId + " has not been queued previously");
        }
        ContentReviewItem item = matchingItem.get();
        if (item.getStatus().compareTo(ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_REPORT_AVAILABLE_CODE) != 0) {
            log.debug("Report not available: " + item.getStatus());
            throw new ReportException("Report not available: " + item.getStatus());
        }
        Map<String, String> params = CompilatioAPIUtil.packMap("action", "getDocumentReportURL", "idDocument", item.getExternalId());
        String reportURL = null;
        try {
            boolean successQuery;
            Document reportURLDoc = this.compilatioConn.callCompilatioReturnDocument(params);
            boolean bl = successQuery = reportURLDoc.getElementsByTagName("sucess") != null;
            if (successQuery) {
                reportURL = this.getNodeValue("success", reportURLDoc);
            }
        }
        catch (SubmissionException | TransientSubmissionException e) {
            log.error("Error retrieving Compilatio report URL", e);
        }
        return reportURL;
    }

    public String getReviewReportInstructor(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getReviewReport(contentId, assignmentRef, userId);
    }

    public String getReviewReportStudent(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getReviewReport(contentId, assignmentRef, userId);
    }

    public void processQueue() {
        log.info("Processing submission queue");
        int errors = 0;
        int success = 0;
        Optional<ContentReviewItem> nextItem = null;
        while ((nextItem = this.getNextItemInSubmissionQueue()).isPresent()) {
            boolean successQuery;
            ContentReviewItem currentItem;
            block14: {
                currentItem = nextItem.get();
                if (StringUtils.isBlank((CharSequence)currentItem.getExternalId())) {
                    if (!this.processItem(currentItem)) {
                        ++errors;
                        continue;
                    }
                    if (!this.addDocumentToCompilatio(currentItem)) {
                        ++errors;
                        continue;
                    }
                }
                try {
                    Instant dueDate;
                    String assignmentId = this.assignmentService.getEntity(this.entityManager.newReference(currentItem.getTaskId())).getId();
                    Assignment a = this.assignmentService.getAssignment(assignmentId);
                    if (NEW_ASSIGNMENT_REVIEW_SERVICE_REPORT_DUE.equals(a.getProperties().get(NEW_ASSIGNMENT_REVIEW_SERVICE_REPORT_RADIO)) && (dueDate = a.getDueDate()).isAfter(Instant.now())) {
                        log.debug("assignment due time not yet reached for item: " + currentItem.getId());
                        currentItem.setNextRetryTime(this.getNextRetryTime(0L));
                        this.crqs.update(currentItem);
                    }
                    break block14;
                }
                catch (IdUnusedException | PermissionException e) {
                    log.error("Error getting assignment for item " + currentItem.getId(), e);
                    this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_NO_RETRY_CODE, null, null);
                    ++errors;
                }
                continue;
            }
            log.debug("Attempting to submit content (status:" + currentItem.getStatus() + "): " + currentItem.getContentId() + " for user: " + currentItem.getUserId() + " and site: " + currentItem.getSiteId());
            if (!this.processItem(currentItem)) {
                ++errors;
                continue;
            }
            Document document = null;
            try {
                Map<String, String> params = CompilatioAPIUtil.packMap("action", "startDocumentAnalyse", "idDocument", currentItem.getExternalId());
                document = this.compilatioConn.callCompilatioReturnDocument(params);
            }
            catch (SubmissionException | TransientSubmissionException e) {
                String errorMsg = this.createLastError(arg_0 -> this.lambda$processQueue$0((Exception)e, arg_0));
                this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE, errorMsg, null);
                ++errors;
                continue;
            }
            Element root = document.getDocumentElement();
            boolean bl = successQuery = root.getElementsByTagName("sucess") != null;
            if (successQuery) {
                log.debug("Submission successful");
                currentItem.setStatus(ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_AWAITING_REPORT_CODE);
                currentItem.setRetryCount(Long.valueOf(0L));
                currentItem.setNextRetryTime(new Date());
                currentItem.setLastError(null);
                currentItem.setErrorCode(null);
                currentItem.setDateSubmitted(new Date());
                ++success;
                this.crqs.update(currentItem);
                continue;
            }
            String rMessage = this.getNodeValue("faultstring", root);
            String rCode = this.getNodeValue("faultcode", root);
            log.debug("Submission not successful: " + rMessage + "(" + rCode + ")");
            if (CompilatioError.ANALYSE_ALREADY_STARTED.equals((Object)CompilatioError.valueOf(rCode))) {
                log.debug("ContentReview id " + currentItem.getId() + ", externalId : " + currentItem.getExternalId() + " has new status : " + "Content submitted for review and awaiting report");
                currentItem.setStatus(ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_AWAITING_REPORT_CODE);
                currentItem.setRetryCount(Long.valueOf(0L));
                currentItem.setLastError(null);
                currentItem.setErrorCode(null);
                currentItem.setDateSubmitted(new Date());
            } else {
                log.warn("Submission not successful. It will be retried.");
                int errorCodeInt = -1;
                if (CompilatioError.valueOf(rCode) != null) {
                    errorCodeInt = CompilatioError.valueOf(rCode).getErrorCode();
                }
                String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.with.code", new Object[]{rMessage, rCode}));
                this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE, errorMsg, errorCodeInt);
                ++errors;
            }
            this.crqs.update(currentItem);
        }
        log.info("Submission queue run completed: " + success + " items submitted, " + errors + " errors.");
    }

    public void checkForReports() {
        SimpleDateFormat dform = (SimpleDateFormat)DateFormat.getDateInstance();
        dform.applyPattern(COMPILATIO_DATETIME_FORMAT);
        log.info("Fetching reports from Compilatio");
        List awaitingReport = this.crqs.getAwaitingReports(this.getProviderId());
        Iterator listIterator = awaitingReport.iterator();
        log.debug("There are " + awaitingReport.size() + " submissions awaiting reports");
        int errors = 0;
        int success = 0;
        int inprogress = 0;
        while (listIterator.hasNext()) {
            ContentReviewItem currentItem = (ContentReviewItem)listIterator.next();
            if (currentItem.getNextRetryTime() == null) {
                currentItem.setNextRetryTime(new Date());
            }
            if (currentItem.getNextRetryTime().after(new Date())) {
                log.info("checkForReports :: next retry time not yet reached for item: " + currentItem.getId());
                this.crqs.update(currentItem);
                continue;
            }
            if (!this.processItem(currentItem)) {
                ++errors;
                continue;
            }
            if (StringUtils.isBlank((CharSequence)currentItem.getExternalId())) {
                currentItem.setStatus(Long.valueOf(ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE));
                this.crqs.update(currentItem);
                ++errors;
                continue;
            }
            log.debug("Attempting to update hashtable with reports for site " + currentItem.getSiteId());
            Map<String, String> params = CompilatioAPIUtil.packMap("action", "getDocument", "idDocument", currentItem.getExternalId());
            Document document = null;
            try {
                document = this.compilatioConn.callCompilatioReturnDocument(params);
            }
            catch (SubmissionException | TransientSubmissionException e) {
                log.warn("Update failed : " + e.toString(), e);
                this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_REPORT_ERROR_RETRY_CODE, e.getLocalizedMessage(), null);
                ++errors;
                continue;
            }
            Element root = document.getDocumentElement();
            if (root.getElementsByTagName("documentStatus").item(0) != null) {
                log.debug("Report list returned successfully");
                NodeList objects = root.getElementsByTagName("documentStatus");
                log.debug(objects.getLength() + " objects in the returned list");
                String status = this.getNodeValue("status", root);
                if ("ANALYSE_NOT_STARTED".equals(status)) {
                    String msg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "report.error.analyse.not.started", new Object[0]));
                    this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE, msg, null);
                    ++errors;
                    continue;
                }
                if ("ANALYSE_COMPLETE".equals(status)) {
                    String reportVal = this.getNodeValue("indice", root);
                    currentItem.setReviewScore(Integer.valueOf((int)Math.round(Double.parseDouble(reportVal))));
                    currentItem.setStatus(ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_REPORT_AVAILABLE_CODE);
                    ++success;
                } else {
                    String progression = this.getNodeValue("progression", root);
                    if (StringUtils.isNotBlank((CharSequence)progression)) {
                        currentItem.setReviewScore(Integer.valueOf((int)Double.parseDouble(progression)));
                        ++inprogress;
                    }
                }
                currentItem.setDateReportReceived(new Date());
                this.crqs.update(currentItem);
                log.debug("new report received: " + currentItem.getExternalId() + " -> " + currentItem.getReviewScore());
                continue;
            }
            log.debug("Report list request not successful");
            log.debug(document.getTextContent());
            ++errors;
        }
        log.info("Finished fetching reports from Compilatio : " + success + " success items, " + inprogress + " in progress, " + errors + " errors");
    }

    public void syncRosters() {
    }

    public boolean allowAllContent() {
        return this.serverConfigurationService.getBoolean("compilatio.accept.all.files", false);
    }

    public boolean isAcceptableContent(ContentResource resource) {
        return this.compilatioContentValidator.isAcceptableContent(resource);
    }

    public Map<String, SortedSet<String>> getAcceptableExtensionsToMimeTypes() {
        HashMap<String, SortedSet<String>> acceptableExtensionsToMimeTypes = new HashMap<String, SortedSet<String>>();
        String[] acceptableFileExtensions = this.getAcceptableFileExtensions();
        String[] acceptableMimeTypes = this.getAcceptableMimeTypes();
        int min = Math.min(acceptableFileExtensions.length, acceptableMimeTypes.length);
        for (int i = 0; i < min; ++i) {
            this.appendToMap(acceptableExtensionsToMimeTypes, acceptableFileExtensions[i], acceptableMimeTypes[i]);
        }
        return acceptableExtensionsToMimeTypes;
    }

    public Map<String, SortedSet<String>> getAcceptableFileTypesToExtensions() {
        LinkedHashMap<String, SortedSet<String>> acceptableFileTypesToExtensions = new LinkedHashMap<String, SortedSet<String>>();
        String[] acceptableFileTypes = this.getAcceptableFileTypes();
        String[] acceptableFileExtensions = this.getAcceptableFileExtensions();
        if (acceptableFileTypes != null && acceptableFileTypes.length > 0) {
            int min = Math.min(acceptableFileTypes.length, acceptableFileExtensions.length);
            for (int i = 0; i < min; ++i) {
                this.appendToMap(acceptableFileTypesToExtensions, acceptableFileTypes[i], acceptableFileExtensions[i]);
            }
        } else {
            ResourceLoader resourceLoader = this.getResourceLoader();
            for (String fileExtension : acceptableFileExtensions) {
                String key = "file.type" + fileExtension;
                if (!resourceLoader.getIsValid(key)) {
                    log.warn("While resolving acceptable file types for Compilatio, the sakai.property compilatio.acceptable.file.types is not set, and the message bundle " + key + " could not be resolved. Displaying [missing key ...] to the user");
                }
                String fileType = resourceLoader.getString(key);
                this.appendToMap(acceptableFileTypesToExtensions, fileType, fileExtension);
            }
        }
        return acceptableFileTypesToExtensions;
    }

    public boolean isSiteAcceptable(Site site) {
        if (site == null) {
            return false;
        }
        log.debug("isSiteAcceptable (" + this.siteAdvisor + "): " + site.getId() + " / " + site.getTitle());
        if (this.siteAdvisor != null) {
            return this.siteAdvisor.siteCanUseReviewService(site);
        }
        ResourceProperties properties = site.getProperties();
        String prop = (String)properties.get(COMPILATIO_SITE_PROPERTY);
        if (StringUtils.isNotBlank((CharSequence)prop)) {
            log.debug("Using site property: " + prop);
            return Boolean.parseBoolean(prop);
        }
        return true;
    }

    public String getIconCssClassforScore(int score, String contentId) {
        if (score == 0) {
            return "contentReviewIconThreshold-5";
        }
        if (score < 25) {
            return "contentReviewIconThreshold-4";
        }
        if (score < 50) {
            return "contentReviewIconThreshold-3";
        }
        if (score < 75) {
            return "contentReviewIconThreshold-2";
        }
        return "contentReviewIconThreshold-1";
    }

    public String getLocalizedStatusMessage(String messageCode, String userRef) {
        return this.getResourceLoader().getString(messageCode);
    }

    public String getLocalizedStatusMessage(String messageCode) {
        return this.getLocalizedStatusMessage(messageCode, this.userDirectoryService.getCurrentUser().getReference());
    }

    public String getLocalizedStatusMessage(String messageCode, Locale locale) {
        return null;
    }

    public String getReviewError(String contentId) {
        return this.getLocalizedReviewErrorMessage(contentId);
    }

    public Map getAssignment(String siteId, String taskId) throws SubmissionException, TransientSubmissionException {
        return null;
    }

    public void createAssignment(String siteId, String taskId, Map extraAsnnOpts) throws SubmissionException, TransientSubmissionException {
    }

    private String getLocalizedReviewErrorMessage(String contentId) {
        log.debug("Returning review error for content: " + contentId);
        Optional item = this.crqs.getQueuedItem(this.getProviderId(), contentId);
        if (item.isPresent()) {
            Integer errorCode = ((ContentReviewItem)item.get()).getErrorCode();
            if (errorCode != null) {
                return this.getLocalizedStatusMessage(errorCode.toString());
            }
            return ((ContentReviewItem)item.get()).getLastError();
        }
        log.debug("Content " + contentId + " has not been queued previously");
        return null;
    }

    private Date getNextRetryTime(long retryCount) {
        int offset = 5;
        if (retryCount > 9L && retryCount < 20L) {
            offset = 10;
        } else if (retryCount > 19L && retryCount < 30L) {
            offset = 20;
        } else if (retryCount > 29L && retryCount < 40L) {
            offset = 40;
        } else if (retryCount > 39L && retryCount < 50L) {
            offset = 80;
        } else if (retryCount > 49L && retryCount < 60L) {
            offset = 160;
        } else if (retryCount > 59L) {
            offset = 220;
        }
        Calendar cal = Calendar.getInstance();
        cal.add(12, offset);
        return cal.getTime();
    }

    private boolean addDocumentToCompilatio(ContentReviewItem currentItem) {
        ContentResource resource = null;
        String fileName = null;
        try {
            try {
                resource = this.contentHostingService.getResource(currentItem.getContentId());
                if (!this.compilatioContentValidator.isAcceptableContent(resource)) {
                    log.error("Not valid extension: resource with id " + currentItem.getContentId());
                    String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.invalid.extension", new Object[0]));
                    this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_NO_RETRY_CODE, errorMsg, null);
                    return false;
                }
            }
            catch (TypeException e4) {
                log.warn("TypeException: resource with id " + currentItem.getContentId());
                String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.type.exception", new Object[]{e4.getLocalizedMessage()}));
                this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_NO_RETRY_CODE, errorMsg, null);
                return false;
            }
            catch (IdUnusedException e) {
                log.warn("IdUnusedException: no resource with id " + currentItem.getContentId());
                String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.id.unused.exception", new Object[0]));
                this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_NO_RETRY_CODE, errorMsg, null);
                return false;
            }
            ResourceProperties resourceProperties = resource.getProperties();
            fileName = resourceProperties.getProperty(resourceProperties.getNamePropDisplayName());
            fileName = this.escapeFileName(fileName, resource.getId());
        }
        catch (PermissionException e2) {
            log.error("Submission failed due to permission error.", (Throwable)e2);
            String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.permission.exception", new Object[0]));
            this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE, errorMsg, null);
            return false;
        }
        fileName = this.truncateFileName(fileName);
        Document document = null;
        try {
            Map<String, String> params = CompilatioAPIUtil.packMap("action", "addDocumentBase64", "filename", URLEncoder.encode(fileName, "UTF-8"), "mimetype", resource.getContentType(), "content", Base64.encodeBase64String((byte[])resource.getContent()));
            document = this.compilatioConn.callCompilatioReturnDocument(params);
            if (document == null) {
                return false;
            }
            Element root = document.getDocumentElement();
            String externalId = null;
            if (root.getElementsByTagName("idDocument").item(0) != null) {
                externalId = this.getNodeValue("idDocument", root);
            }
            if (externalId != null) {
                if (externalId.length() <= 0) {
                    log.warn("invalid external id");
                    String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.no.external.id.received", new Object[0]));
                    this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE, errorMsg, null);
                    return false;
                }
            } else {
                String rMessage = this.getNodeValue("faultstring", root);
                String rCode = this.getNodeValue("faultcode", root);
                log.debug("Add Document To compilatio not successful: " + rMessage + "(" + rCode + ")");
                int errorCodeInt = -1;
                CompilatioError errorCode = CompilatioError.valueOf(rCode);
                if (errorCode != null) {
                    errorCodeInt = errorCode.getErrorCode();
                }
                String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.compilatio.with.code", new Object[]{rMessage, rCode}));
                this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE, errorMsg, errorCodeInt);
                return false;
            }
            log.debug("Submission successful");
            currentItem.setExternalId(externalId);
            currentItem.setStatus(ContentReviewConstants.CONTENT_REVIEW_NOT_SUBMITTED_CODE);
            currentItem.setRetryCount(Long.valueOf(0L));
            currentItem.setLastError(null);
            currentItem.setErrorCode(null);
            currentItem.setDateSubmitted(new Date());
            this.crqs.update(currentItem);
        }
        catch (Exception e) {
            String errorMsg = this.createLastError(doc -> this.createFormattedMessageXML(doc, "submission.error.generic", new Object[]{e.getLocalizedMessage()}));
            this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE, errorMsg, null);
            return false;
        }
        return true;
    }

    public String escapeFileName(String fileName, String contentId) {
        log.debug("original filename is: " + fileName);
        if (fileName == null) {
            fileName = contentId;
        }
        log.debug("fileName is :" + fileName);
        try {
            fileName = URLDecoder.decode(fileName, "UTF-8");
            while (fileName.indexOf("%20") > 0 || fileName.contains("%2520")) {
                fileName = URLDecoder.decode(fileName, "UTF-8");
            }
        }
        catch (UnsupportedEncodingException | IllegalArgumentException eae) {
            log.warn("Unable to decode fileName: " + fileName, (Throwable)eae);
            return contentId;
        }
        fileName = fileName.replace(' ', '_');
        fileName = StringUtils.replace((String)fileName, (String)"__", (String)"_");
        log.debug("fileName is :" + fileName);
        return fileName;
    }

    private String truncateFileName(String fileName) {
        int i = this.serverConfigurationService.getInt("compilatio.filename.max.length", -1);
        if (StringUtils.isBlank((CharSequence)fileName)) {
            return "noname";
        }
        if (i < 0) {
            return fileName;
        }
        if (fileName.length() < i) {
            return fileName;
        }
        String extension = "";
        if (fileName.contains(".")) {
            extension = fileName.substring(fileName.lastIndexOf("."));
        }
        fileName = fileName.substring(0, i - extension.length());
        fileName = fileName + extension;
        return fileName;
    }

    private String[] getAcceptableMimeTypes() {
        String[] mimeTypes = this.serverConfigurationService.getStrings("compilatio.acceptable.mime.types");
        if (mimeTypes != null && mimeTypes.length > 0) {
            return mimeTypes;
        }
        return this.DEFAULT_ACCEPTABLE_MIME_TYPES;
    }

    private String[] getAcceptableFileExtensions() {
        String[] extensions = this.serverConfigurationService.getStrings("compilatio.acceptable.file.extensions");
        if (extensions != null && extensions.length > 0) {
            return extensions;
        }
        return this.DEFAULT_ACCEPTABLE_FILE_EXTENSIONS;
    }

    private String[] getAcceptableFileTypes() {
        return this.serverConfigurationService.getStrings("compilatio.acceptable.file.types");
    }

    private void appendToMap(Map<String, SortedSet<String>> map, String key, String value) {
        SortedSet<String> valueList = map.get(key);
        if (valueList == null) {
            valueList = new TreeSet<String>();
            map.put(key, valueList);
        }
        valueList.add(value);
    }

    private String getNodeValue(String key, Document document) {
        NodeList nodeList = document.getElementsByTagName(key);
        return this.getNodeValue(key, nodeList);
    }

    private String getNodeValue(String key, Element root) {
        NodeList nodeList = root.getElementsByTagName(key);
        return this.getNodeValue(key, nodeList);
    }

    private String getNodeValue(String key, NodeList nodeList) {
        String ret = "";
        if (nodeList != null && nodeList.item(0) != null && nodeList.item(0).getFirstChild() != null) {
            ret = nodeList.item(0).getFirstChild().getNodeValue();
        }
        if (ret == null) {
            ret = "";
        }
        return ret.trim();
    }

    private void processError(ContentReviewItem item, Long status, String error, Integer errorCode) {
        if (status == null) {
            IllegalArgumentException ex = new IllegalArgumentException("Status is null; you must supply a valid status to update when calling processError()");
            throw ex;
        }
        item.setStatus(status);
        if (error != null) {
            item.setLastError(error);
        }
        if (errorCode != null) {
            item.setErrorCode(errorCode);
        }
        this.crqs.update(item);
    }

    private boolean processItem(ContentReviewItem currentItem) {
        if (currentItem.getRetryCount() == null) {
            currentItem.setRetryCount(Long.valueOf(0L));
            currentItem.setNextRetryTime(this.getNextRetryTime(0L));
        } else {
            if ((long)currentItem.getRetryCount().intValue() > this.maxRetry) {
                this.processError(currentItem, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_EXCEEDED_CODE, null, null);
                return false;
            }
            long l = currentItem.getRetryCount();
            currentItem.setRetryCount(Long.valueOf(++l));
            currentItem.setNextRetryTime(this.getNextRetryTime(l));
        }
        this.crqs.update(currentItem);
        return true;
    }

    public ContentReviewItem getContentReviewItemByContentId(String contentId) {
        Optional cri = this.crqs.getQueuedItem(this.getProviderId(), contentId);
        if (cri.isPresent()) {
            ContentReviewItem item = (ContentReviewItem)cri.get();
            return item;
        }
        return null;
    }

    public String getEndUserLicenseAgreementLink(String userId) {
        return null;
    }

    public Instant getEndUserLicenseAgreementTimestamp() {
        return null;
    }

    public String getEndUserLicenseAgreementVersion() {
        return null;
    }

    public void webhookEvent(HttpServletRequest request, int providerId, Optional<String> customParam) {
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setContentHostingService(ContentHostingService contentHostingService) {
        this.contentHostingService = contentHostingService;
    }

    public void setCompilatioConn(CompilatioAccountConnection compilatioConn) {
        this.compilatioConn = compilatioConn;
    }

    public void setCompilatioContentValidator(CompilatioContentValidator compilatioContentValidator) {
        this.compilatioContentValidator = compilatioContentValidator;
    }

    public void setSiteAdvisor(ContentReviewSiteAdvisor siteAdvisor) {
        this.siteAdvisor = siteAdvisor;
    }

    public void setCrqs(ContentReviewQueueService crqs) {
        this.crqs = crqs;
    }

    private /* synthetic */ Object lambda$processQueue$0(Exception e, Document doc) {
        return this.createFormattedMessageXML(doc, "submission.error.generic", new Object[]{e.getLocalizedMessage()});
    }

    public static enum CompilatioError {
        INVALID_ID_FOLDER(1),
        NOT_ENOUGH_SPACE(2),
        TEMPORARY_UNAVAILABLE(3),
        INVALID_KEY(4),
        NOT_ENOUGH_CREDITS(5),
        ANALYSE_ALREADY_STARTED(6),
        INVALID_FILE_TYPE(10),
        NO_CONTENT_FOUND(11),
        TEXT_EXTRACTION_FAILED(12),
        NO_TEXT_FOUND(13),
        UNANALYSABLE_TEXT(14);

        private int errorCode;

        public int getErrorCode() {
            return this.errorCode;
        }

        private CompilatioError(int errorCode) {
            this.errorCode = errorCode;
        }

        public static CompilatioError find(int faultCodeInt) {
            CompilatioError errorReturn = null;
            for (CompilatioError error : CompilatioError.values()) {
                if (error.getErrorCode() != faultCodeInt) continue;
                errorReturn = error;
            }
            return errorReturn;
        }
    }
}

