/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.compilatio.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.exception.TransientSubmissionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CompilatioAPIUtil {
    private static final Logger log = LoggerFactory.getLogger(CompilatioAPIUtil.class);

    public static Document callCompilatioReturnDocument(String apiURL, Map<String, String> parameters, String secretKey, final int timeout) throws TransientSubmissionException, SubmissionException {
        Document xmlDocument = null;
        try {
            SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
            SOAPConnection soapConnection = soapConnectionFactory.createConnection();
            MessageFactory messageFactory = MessageFactory.newInstance();
            SOAPMessage soapMessage = messageFactory.createMessage();
            SOAPPart soapPart = soapMessage.getSOAPPart();
            SOAPEnvelope envelope = soapPart.getEnvelope();
            SOAPBody soapBody = envelope.getBody();
            SOAPElement soapBodyAction = soapBody.addChildElement(parameters.get("action"));
            parameters.remove("action");
            SOAPElement soapBodyKey = soapBodyAction.addChildElement("key");
            soapBodyKey.addTextNode(secretKey);
            Set<Map.Entry<String, String>> ets = parameters.entrySet();
            for (Map.Entry<String, String> param : ets) {
                SOAPElement soapBodyElement = soapBodyAction.addChildElement(param.getKey());
                soapBodyElement.addTextNode(param.getValue());
            }
            URL endpoint = new URL(null, apiURL, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL url) throws IOException {
                    URL target = new URL(url.toString());
                    URLConnection connection = target.openConnection();
                    connection.setConnectTimeout(timeout);
                    connection.setReadTimeout(timeout);
                    return connection;
                }
            });
            SOAPMessage soapResponse = soapConnection.call(soapMessage, (Object)endpoint);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            soapResponse.writeTo((OutputStream)out);
            DocumentBuilderFactory builderfactory = DocumentBuilderFactory.newInstance();
            builderfactory.setNamespaceAware(true);
            DocumentBuilder builder = builderfactory.newDocumentBuilder();
            xmlDocument = builder.parse(new InputSource(new StringReader(out.toString())));
            soapConnection.close();
        }
        catch (IOException | UnsupportedOperationException | ParserConfigurationException | SOAPException | SAXException e) {
            log.error(e.getLocalizedMessage(), e);
        }
        return xmlDocument;
    }

    public static Map<String, String> packMap(String ... vargs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (vargs.length % 2 != 0) {
            throw new IllegalArgumentException("You need to supply an even number of vargs for the key-val pairs.");
        }
        for (int i = 0; i < vargs.length; i += 2) {
            map.put(vargs[i], vargs[i + 1]);
        }
        return map;
    }
}

