/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.compilatio;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.service.ContentReviewService;
import org.sakaiproject.entity.api.ResourceProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompilatioContentValidator {
    private static final Logger log = LoggerFactory.getLogger(CompilatioContentValidator.class);
    ContentReviewService contentReviewService = null;

    public void setContentReviewService(ContentReviewService contentReviewService) {
        this.contentReviewService = contentReviewService;
    }

    public void init() {
    }

    public boolean isAcceptableContent(ContentResource resource) {
        if (resource == null) {
            return false;
        }
        String mime = resource.getContentType();
        log.debug("Got a content type of " + mime);
        Map acceptableExtensionsToMimeTypes = this.contentReviewService.getAcceptableExtensionsToMimeTypes();
        HashSet acceptableMimeTypes = new HashSet();
        for (SortedSet mimeTypes : acceptableExtensionsToMimeTypes.values()) {
            acceptableMimeTypes.addAll(mimeTypes);
        }
        Boolean fileTypeOk = false;
        if (acceptableMimeTypes.contains(mime)) {
            fileTypeOk = true;
            log.debug("FileType matches a known mime");
        } else {
            log.debug("FileType doesn't match a known mime");
        }
        if (!fileTypeOk.booleanValue()) {
            ResourceProperties resourceProperties = resource.getProperties();
            String fileName = resourceProperties.getProperty(resourceProperties.getNamePropDisplayName());
            if (fileName.indexOf(".") > 0) {
                String extension = fileName.substring(fileName.lastIndexOf("."));
                log.debug("file has an extension of " + extension);
                Set extensions = acceptableExtensionsToMimeTypes.keySet();
                fileTypeOk = extensions.contains(extension) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            } else {
                fileTypeOk = false;
            }
        }
        return fileTypeOk;
    }
}

