/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.tool;

import java.security.InvalidParameterException;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.assignment.api.AssignmentReferenceReckoner;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.model.AssignmentSubmission;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.service.ContentReviewService;
import org.sakaiproject.tool.api.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class MainController {
    private static final Logger log = LoggerFactory.getLogger(MainController.class);
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    @Qualifier(value="org.sakaiproject.contentreview.service.ContentReviewService")
    private ContentReviewService contentReviewService;
    @Autowired
    private AssignmentService assignmentService;

    @RequestMapping(value={"/webhooks"}, method={RequestMethod.POST})
    public void webhooks(HttpServletRequest request, HttpServletResponse response, Model model, @RequestParam Integer providerId, @RequestParam(required=false) String custom) {
        if (providerId == null) {
            throw new InvalidParameterException("Missing providerName");
        }
        log.info("webhook provider and custom: " + custom);
        this.contentReviewService.webhookEvent(request, providerId.intValue(), Optional.ofNullable(custom));
    }

    @RequestMapping(value={"/viewreport"}, method={RequestMethod.GET})
    public String viewReport(Model model, @RequestParam String contentId, @RequestParam String assignmentRef, @RequestParam String contextId) {
        log.info("viewReport(): contentId: " + contentId + ", assignmentRef: " + assignmentRef);
        if (this.sessionManager != null && this.sessionManager.getCurrentSession() != null && StringUtils.isNotEmpty((String)this.sessionManager.getCurrentSessionUserId())) {
            boolean isInstructor = this.hasInstructorPermissions(assignmentRef);
            if (!isInstructor && !this.hasStudentPermission(assignmentRef, contentId)) {
                throw new SecurityException("A valid session ID with access to the content item is required");
            }
            return "redirect:" + this.contentReviewService.getReviewReportRedirectUrl(contentId, assignmentRef, this.sessionManager.getCurrentSessionUserId(), contextId, isInstructor);
        }
        throw new SecurityException("A valid session ID with access to the content item is required");
    }

    private boolean hasInstructorPermissions(String assignmentRef) {
        AssignmentReferenceReckoner.AssignmentReference refReckoner;
        if (StringUtils.isNotEmpty((String)assignmentRef) && assignmentRef.startsWith("/assignment") && "a".equals((refReckoner = AssignmentReferenceReckoner.reckoner().reference(assignmentRef).reckon()).getSubtype())) {
            return this.assignmentService.allowGradeSubmission(assignmentRef);
        }
        return false;
    }

    private boolean hasStudentPermission(String assignmentRef, String contentId) {
        ContentReviewItem item = this.contentReviewService.getContentReviewItemByContentId(contentId);
        if (item != null && this.sessionManager.getCurrentSessionUserId().equals(item.getUserId())) {
            return true;
        }
        if (assignmentRef.startsWith("/assignment")) {
            try {
                AssignmentReferenceReckoner.AssignmentReference refReckoner = AssignmentReferenceReckoner.reckoner().reference(assignmentRef).reckon();
                if ("a".equals(refReckoner.getSubtype())) {
                    AssignmentSubmission submission = this.assignmentService.getSubmission(refReckoner.getId(), this.sessionManager.getCurrentSessionUserId());
                    return submission != null && submission.getAttachments().contains("/content" + contentId);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }
}

