/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.dao;

import java.util.Calendar;
import java.util.List;
import java.util.Optional;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.sakaiproject.contentreview.dao.ContentReviewConstants;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.dao.HibernateCommonDao;

public class ContentReviewItemDao
extends HibernateCommonDao<ContentReviewItem> {
    public List<ContentReviewItem> findByProviderAnyMatching(Integer providerId, String contentId, String userId, String siteId, String taskId, String externalId, Long status, Integer errorCode) {
        Criteria c = this.sessionFactory.getCurrentSession().createCriteria(ContentReviewItem.class).add((Criterion)Restrictions.eq((String)"providerId", (Object)providerId));
        if (contentId != null) {
            c.add((Criterion)Restrictions.eq((String)"contentId", (Object)contentId));
        }
        if (userId != null) {
            c.add((Criterion)Restrictions.eq((String)"userId", (Object)userId));
        }
        if (siteId != null) {
            c.add((Criterion)Restrictions.eq((String)"siteId", (Object)siteId));
        }
        if (taskId != null) {
            c.add((Criterion)Restrictions.eq((String)"taskId", (Object)taskId));
        }
        if (externalId != null) {
            c.add((Criterion)Restrictions.eq((String)"externalId", (Object)externalId));
        }
        if (status != null) {
            c.add((Criterion)Restrictions.eq((String)"status", (Object)status));
        }
        if (errorCode != null) {
            c.add((Criterion)Restrictions.eq((String)"errorCode", (Object)errorCode));
        }
        return c.list();
    }

    public List<ContentReviewItem> findByProviderGroupedBySiteAndTask(Integer providerId) {
        Criteria c = this.sessionFactory.getCurrentSession().createCriteria(ContentReviewItem.class).add((Criterion)Restrictions.eq((String)"providerId", (Object)providerId)).setProjection((Projection)Projections.projectionList().add((Projection)Projections.groupProperty((String)"siteId")).add((Projection)Projections.groupProperty((String)"taskId")));
        return c.list();
    }

    public List<ContentReviewItem> findByProviderAwaitingReports(Integer providerId) {
        Criteria c = this.sessionFactory.getCurrentSession().createCriteria(ContentReviewItem.class).add((Criterion)Restrictions.eq((String)"providerId", (Object)providerId)).add(Restrictions.in((String)"status", (Object[])new Long[]{ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_AWAITING_REPORT_CODE, ContentReviewConstants.CONTENT_REVIEW_REPORT_ERROR_RETRY_CODE}));
        return c.list();
    }

    public Optional<ContentReviewItem> findByProviderAndContentId(Integer providerId, String contentId) {
        Criteria c = this.sessionFactory.getCurrentSession().createCriteria(ContentReviewItem.class).add((Criterion)Restrictions.eq((String)"providerId", (Object)providerId)).add((Criterion)Restrictions.eq((String)"contentId", (Object)contentId));
        return Optional.ofNullable((ContentReviewItem)c.uniqueResult());
    }

    public Optional<ContentReviewItem> findByProviderSingleItemToSubmit(Integer providerId) {
        Calendar calendar = Calendar.getInstance();
        Criteria c = this.sessionFactory.getCurrentSession().createCriteria(ContentReviewItem.class).add((Criterion)Restrictions.eq((String)"providerId", (Object)providerId)).add(Restrictions.in((String)"status", (Object[])new Long[]{ContentReviewConstants.CONTENT_REVIEW_NOT_SUBMITTED_CODE, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE})).add((Criterion)Restrictions.lt((String)"nextRetryTime", (Object)calendar.getTime())).setMaxResults(1);
        return Optional.ofNullable((ContentReviewItem)c.uniqueResult());
    }
}

