/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.dao;

import java.io.Serializable;
import java.util.Optional;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public abstract class HibernateCommonDao<T> {
    protected Class<T> persistentClass;
    protected SessionFactory sessionFactory;

    public void create(T t) {
        this.sessionFactory.getCurrentSession().persist(t);
    }

    public void save(T t) {
        this.sessionFactory.getCurrentSession().saveOrUpdate(t);
    }

    public Optional<T> get(long id) {
        return Optional.ofNullable(this.sessionFactory.getCurrentSession().get(this.persistentClass, (Serializable)Long.valueOf(id)));
    }

    public void delete(T t) {
        Session session = this.sessionFactory.getCurrentSession();
        session.delete(t);
    }

    public void delete(long id) {
        Optional<T> t = this.get(id);
        if (t.isPresent()) {
            this.sessionFactory.getCurrentSession().delete(t.get());
        }
    }

    public void setPersistentClass(Class<T> persistentClass) {
        this.persistentClass = persistentClass;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }
}

