/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.exception.ContentReviewProviderException;
import org.sakaiproject.contentreview.exception.QueueException;
import org.sakaiproject.contentreview.exception.ReportException;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.exception.TransientSubmissionException;
import org.sakaiproject.contentreview.service.ContentReviewService;
import org.sakaiproject.contentreview.service.NoOpContentReviewService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentReviewFederatedServiceImpl
implements ContentReviewService {
    private static final Logger log = LoggerFactory.getLogger(ContentReviewFederatedServiceImpl.class);
    private ServerConfigurationService serverConfigurationService;
    private ToolManager toolManager;
    private SiteService siteService;
    private List<ContentReviewService> providers;
    private String defaultProvider;
    private List<String> enabledProviders;

    public void init() {
        String cdp;
        this.enabledProviders = this.configureEnabledProviders();
        if (this.enabledProviders.isEmpty()) {
            NoOpContentReviewService noop = new NoOpContentReviewService();
            this.providers.add(noop);
            this.enabledProviders.add(noop.getServiceName());
        }
        this.providers.stream().forEach(p -> log.debug("Found Content Review Provider: " + p.getServiceName() + " with providerId of " + p.getProviderId()));
        this.enabledProviders.stream().forEach(p -> log.info("Enabled Content Review Provider: " + p + " with providerId of " + Math.abs(p.hashCode())));
        Optional<String> configuredDefaultProvider = Optional.ofNullable(this.serverConfigurationService.getString("contentreview.defaultProvider"));
        if (configuredDefaultProvider.isPresent() && this.enabledProviders.contains(cdp = configuredDefaultProvider.get())) {
            this.defaultProvider = cdp;
            log.info("Default Content Review Provider: " + this.defaultProvider + " with providerId of " + Math.abs(this.defaultProvider.hashCode()));
        }
        if (StringUtils.isBlank((String)this.defaultProvider)) {
            this.defaultProvider = this.enabledProviders.get(0);
            log.info("Default Content Review Provider: " + this.defaultProvider + " with providerId of " + Math.abs(this.defaultProvider.hashCode()));
        }
    }

    private Optional<Site> getCurrentSite() {
        Optional<Site> site = null;
        try {
            String context = this.toolManager.getCurrentPlacement().getContext();
            site = Optional.of(this.siteService.getSite(context));
        }
        catch (Exception e) {
            site = Optional.empty();
        }
        return site;
    }

    private List<String> configureEnabledProviders() {
        List<String> enabledProviders = new ArrayList<String>();
        Optional<String[]> configuredProviders = Optional.ofNullable(this.serverConfigurationService.getStrings("contentreview.enabledProviders"));
        if (configuredProviders.isPresent()) {
            List<Object> configProviders = Arrays.asList((Object[])configuredProviders.get());
            enabledProviders = this.providers.stream().filter(crs -> configProviders.contains(crs.getServiceName())).map(crs -> crs.getServiceName()).collect(Collectors.toList());
        }
        return enabledProviders;
    }

    private ContentReviewService getSelectedProvider() {
        if (StringUtils.isBlank((String)this.defaultProvider)) {
            throw new ContentReviewProviderException("No Default Content Review Provider");
        }
        Optional<Site> currentSite = this.getCurrentSite();
        if (currentSite.isPresent()) {
            String overrideProvider;
            if (log.isDebugEnabled()) {
                log.debug("In Location:" + currentSite.get().getReference());
            }
            if (this.enabledProviders.contains(overrideProvider = currentSite.get().getProperties().getProperty("contentreview.provider"))) {
                return (ContentReviewService)this.providers.stream().filter(crs -> crs.getServiceName().equals(overrideProvider)).collect(Collectors.toList()).get(0);
            }
        }
        return (ContentReviewService)this.providers.stream().filter(crs -> crs.getServiceName().equals(this.defaultProvider)).collect(Collectors.toList()).get(0);
    }

    public boolean allowResubmission() {
        return this.getSelectedProvider().allowResubmission();
    }

    public void checkForReports() {
        this.providers.stream().filter(provider -> this.enabledProviders.contains(provider.getServiceName())).forEach(ContentReviewService::checkForReports);
    }

    public void createAssignment(String arg0, String arg1, Map arg2) throws SubmissionException, TransientSubmissionException {
        this.getSelectedProvider().createAssignment(arg0, arg1, arg2);
    }

    public List<ContentReviewItem> getAllContentReviewItems(String arg0, String arg1) throws QueueException, SubmissionException, ReportException {
        return this.getSelectedProvider().getAllContentReviewItems(arg0, arg1);
    }

    public Map getAssignment(String arg0, String arg1) throws SubmissionException, TransientSubmissionException {
        return this.getSelectedProvider().getAssignment(arg0, arg1);
    }

    public Date getDateQueued(String arg0) throws QueueException {
        return this.getSelectedProvider().getDateQueued(arg0);
    }

    public Date getDateSubmitted(String arg0) throws QueueException, SubmissionException {
        return this.getSelectedProvider().getDateSubmitted(arg0);
    }

    public String getIconCssClassforScore(int score, String contentId) {
        return this.getSelectedProvider().getIconCssClassforScore(score, contentId);
    }

    public String getLocalizedStatusMessage(String arg0) {
        return this.getSelectedProvider().getLocalizedStatusMessage(arg0);
    }

    public String getLocalizedStatusMessage(String arg0, String arg1) {
        return this.getSelectedProvider().getLocalizedStatusMessage(arg0, arg1);
    }

    public String getLocalizedStatusMessage(String arg0, Locale arg1) {
        return this.getSelectedProvider().getLocalizedStatusMessage(arg0, arg1);
    }

    public List<ContentReviewItem> getReportList(String siteId) throws QueueException, SubmissionException, ReportException {
        return this.getSelectedProvider().getReportList(siteId);
    }

    public List<ContentReviewItem> getReportList(String siteId, String taskId) throws QueueException, SubmissionException, ReportException {
        return this.getSelectedProvider().getReportList(siteId, taskId);
    }

    public String getReviewReport(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getSelectedProvider().getReviewReport(contentId, assignmentRef, userId);
    }

    public String getReviewReportInstructor(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getSelectedProvider().getReviewReportInstructor(contentId, assignmentRef, userId);
    }

    public String getReviewReportStudent(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getSelectedProvider().getReviewReportStudent(contentId, assignmentRef, userId);
    }

    public Long getReviewStatus(String contentId) throws QueueException {
        return this.getSelectedProvider().getReviewStatus(contentId);
    }

    public String getServiceName() {
        return this.getSelectedProvider().getServiceName();
    }

    public boolean allowAllContent() {
        return this.getSelectedProvider().allowAllContent();
    }

    public boolean isAcceptableContent(ContentResource arg0) {
        return this.getSelectedProvider().isAcceptableContent(arg0);
    }

    public Map<String, SortedSet<String>> getAcceptableExtensionsToMimeTypes() {
        return this.getSelectedProvider().getAcceptableExtensionsToMimeTypes();
    }

    public Map<String, SortedSet<String>> getAcceptableFileTypesToExtensions() {
        return this.getSelectedProvider().getAcceptableFileTypesToExtensions();
    }

    public boolean isSiteAcceptable(Site arg0) {
        return this.getSelectedProvider().isSiteAcceptable(arg0);
    }

    public void processQueue() {
        this.providers.stream().filter(provider -> this.enabledProviders.contains(provider.getServiceName())).forEach(ContentReviewService::processQueue);
    }

    public void queueContent(String userId, String siteId, String assignmentReference, List<ContentResource> content) throws QueueException {
        this.getSelectedProvider().queueContent(userId, siteId, assignmentReference, content);
    }

    public void removeFromQueue(String arg0) {
        this.getSelectedProvider().removeFromQueue(arg0);
    }

    public void resetUserDetailsLockedItems(String arg0) {
        this.getSelectedProvider().resetUserDetailsLockedItems(arg0);
    }

    public String getReviewError(String contentId) {
        return this.getSelectedProvider().getReviewError(contentId);
    }

    public int getReviewScore(String contentId, String assignmentRef, String userId) throws QueueException, ReportException, Exception {
        return this.getSelectedProvider().getReviewScore(contentId, assignmentRef, userId);
    }

    public ContentReviewItem getContentReviewItemByContentId(String arg0) {
        return this.getSelectedProvider().getContentReviewItemByContentId(arg0);
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setProviders(List<ContentReviewService> providers) {
        this.providers = providers;
    }
}

