/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.service;

import java.time.Instant;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.contentreview.dao.ContentReviewConstants;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.exception.QueueException;
import org.sakaiproject.contentreview.exception.ReportException;
import org.sakaiproject.contentreview.service.ContentReviewService;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.user.api.PreferencesEdit;
import org.sakaiproject.user.api.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseContentReviewService
implements ContentReviewService {
    private static final Logger log = LoggerFactory.getLogger(BaseContentReviewService.class);
    protected PreferencesService preferencesService;
    protected ServerConfigurationService serverConfigurationService;
    private static final String PROP_KEY_EULA = "contentReviewEULA";
    private static final String PROP_KEY_EULA_TIMESTAMP = "contentReviewEULATimestamp";
    private static final String PROP_KEY_EULA_VERSION = "contentReviewEULAVersion";
    private static final String REDIRECT_URL_TEMPLATE = "/content-review-tool/viewreport?contentId=%s&assignmentRef=%s&contextId=%s";
    private static final String WEBHOOK_URL_TEMPLATE = "%scontent-review-tool/webhooks?providerId=%s";

    public Instant getUserEULATimestamp(String userId) {
        Instant timestamp = null;
        try {
            ResourceProperties pref = this.preferencesService.getPreferences(userId).getProperties(PROP_KEY_EULA + this.getProviderId());
            if (pref != null) {
                timestamp = Instant.ofEpochMilli(pref.getLongProperty(PROP_KEY_EULA_TIMESTAMP));
            }
        }
        catch (EntityPropertyNotDefinedException pref) {
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return timestamp;
    }

    public String getUserEULAVersion(String userId) {
        String version = null;
        try {
            ResourceProperties pref = this.preferencesService.getPreferences(userId).getProperties(PROP_KEY_EULA + this.getProviderId());
            if (pref != null) {
                version = pref.getProperty(PROP_KEY_EULA_VERSION);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return version;
    }

    public void updateUserEULATimestamp(String userId) {
        block6: {
            try {
                PreferencesEdit pref = this.preferencesService.edit(userId);
                try {
                    if (pref == null) break block6;
                    ResourcePropertiesEdit resourcePropEdit = pref.getPropertiesEdit(PROP_KEY_EULA + this.getProviderId());
                    if (resourcePropEdit != null) {
                        resourcePropEdit.addProperty(PROP_KEY_EULA_TIMESTAMP, "" + Instant.now().toEpochMilli());
                        String EULAVersion = this.getEndUserLicenseAgreementVersion();
                        if (StringUtils.isNotEmpty((CharSequence)EULAVersion)) {
                            resourcePropEdit.addProperty(PROP_KEY_EULA_VERSION, EULAVersion);
                        }
                        this.preferencesService.commit(pref);
                        break block6;
                    }
                    this.preferencesService.cancel(pref);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.preferencesService.cancel(pref);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public String getReviewReport(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        ContentReviewItem item = this.checkContentItemStatus(contentId);
        return String.format(REDIRECT_URL_TEMPLATE, contentId, assignmentRef, item.getSiteId());
    }

    public String getReviewReportInstructor(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        ContentReviewItem item = this.checkContentItemStatus(contentId);
        return String.format(REDIRECT_URL_TEMPLATE, contentId, assignmentRef, item.getSiteId());
    }

    public String getReviewReportStudent(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        ContentReviewItem item = this.checkContentItemStatus(contentId);
        return String.format(REDIRECT_URL_TEMPLATE, contentId, assignmentRef, item.getSiteId());
    }

    private ContentReviewItem checkContentItemStatus(String contentId) throws ReportException {
        ContentReviewItem item = this.getContentReviewItemByContentId(contentId);
        if (item == null || !ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_REPORT_AVAILABLE_CODE.equals(item.getStatus())) {
            throw new ReportException("Report status: " + (item != null ? item.getStatus() : ""));
        }
        return item;
    }

    public String getReviewReportRedirectUrl(String contentId, String assignmentRef, String userId, String contextId, boolean isInstructor) {
        return null;
    }

    public String getWebhookUrl(Optional<String> customParam) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serverConfigurationService.getServerUrl());
        if (!StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)"/")) {
            sb.append("/");
        }
        return String.format(WEBHOOK_URL_TEMPLATE, sb.toString(), this.getProviderId()) + (customParam.isPresent() ? "&custom=" + customParam.get() : "");
    }

    public boolean allowSubmissionsOnBehalf() {
        return false;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }
}

