/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.service;

import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.dao.ContentReviewConstants;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.dao.ContentReviewItemDao;
import org.sakaiproject.contentreview.exception.QueueException;
import org.sakaiproject.contentreview.exception.ReportException;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.service.ContentReviewQueueService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class ContentReviewQueueServiceImpl
implements ContentReviewQueueService {
    private static final Logger log = LoggerFactory.getLogger(ContentReviewQueueServiceImpl.class);
    private ContentReviewItemDao itemDao;

    @Transactional
    public void queueContent(Integer providerId, String userId, String siteId, String taskId, List<ContentResource> content) throws QueueException {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        Objects.requireNonNull(userId, "userId cannot be null");
        Objects.requireNonNull(siteId, "siteId cannot be null");
        Objects.requireNonNull(taskId, "taskId cannot be null");
        Objects.requireNonNull(content, "content cannot be null");
        for (ContentResource resource : content) {
            String contentId = resource.getId();
            Optional existingItem = this.itemDao.findByProviderAndContentId(providerId, contentId);
            if (existingItem.isPresent()) {
                throw new QueueException("Content " + contentId + " is already queued");
            }
            ContentReviewItem item = new ContentReviewItem(contentId, userId, siteId, taskId, new Date(), ContentReviewConstants.CONTENT_REVIEW_NOT_SUBMITTED_CODE, providerId);
            log.debug("Adding content: " + contentId + " from site " + siteId + " and user: " + userId + " for task: " + taskId + " to submission queue");
            this.itemDao.create((Object)item);
        }
    }

    @Transactional(readOnly=true)
    @Deprecated
    public int getReviewScore(Integer providerId, String contentId) throws QueueException, ReportException, Exception {
        Optional<ContentReviewItem> item = this.getQueuedItem(providerId, contentId);
        return item.isPresent() ? item.get().getReviewScore() : null;
    }

    @Transactional(readOnly=true)
    @Deprecated
    public Long getReviewStatus(Integer providerId, String contentId) throws QueueException {
        Optional<ContentReviewItem> item = this.getQueuedItem(providerId, contentId);
        return item.isPresent() ? item.get().getStatus() : null;
    }

    @Transactional(readOnly=true)
    @Deprecated
    public Date getDateQueued(Integer providerId, String contentId) throws QueueException {
        Optional<ContentReviewItem> item = this.getQueuedItem(providerId, contentId);
        return item.isPresent() ? item.get().getDateQueued() : null;
    }

    @Transactional(readOnly=true)
    @Deprecated
    public Date getDateSubmitted(Integer providerId, String contentId) throws QueueException, SubmissionException {
        Optional<ContentReviewItem> item = this.getQueuedItem(providerId, contentId);
        return item.isPresent() ? item.get().getDateSubmitted() : null;
    }

    @Transactional(readOnly=true)
    public List<ContentReviewItem> getContentReviewItems(Integer providerId, String siteId, String taskId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        return this.itemDao.findByProviderAnyMatching(providerId, null, null, siteId, taskId, null, null, null);
    }

    @Transactional(readOnly=true)
    public List<ContentReviewItem> getAllContentReviewItemsGroupedBySiteAndTask(Integer providerId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        log.debug("Returning list of items grouped by site and task");
        return this.itemDao.findByProviderGroupedBySiteAndTask(providerId);
    }

    @Transactional
    public void resetUserDetailsLockedItems(Integer providerId, String userId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        Objects.requireNonNull(userId, "userId cannot be null");
        List lockedItems = this.itemDao.findByProviderAnyMatching(providerId, null, userId, null, null, null, ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_USER_DETAILS_CODE, null);
        for (ContentReviewItem item : lockedItems) {
            item.setStatus(ContentReviewConstants.CONTENT_REVIEW_SUBMISSION_ERROR_RETRY_CODE);
            this.itemDao.save((Object)item);
        }
    }

    @Transactional
    public void removeFromQueue(Integer providerId, String contentId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        Objects.requireNonNull(contentId, "contentId cannot be null");
        Optional item = this.itemDao.findByProviderAndContentId(providerId, contentId);
        if (item.isPresent()) {
            this.itemDao.delete(item.get());
        }
    }

    @Transactional(readOnly=true)
    public Optional<ContentReviewItem> getQueuedItem(Integer providerId, String contentId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        Objects.requireNonNull(contentId, "contentId cannot be null");
        return this.itemDao.findByProviderAndContentId(providerId, contentId);
    }

    @Transactional(readOnly=true)
    public Optional<ContentReviewItem> getQueuedItemByExternalId(Integer providerId, String externalId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        Objects.requireNonNull(externalId, "externalId cannot be null");
        return this.itemDao.findByProviderAndExternalId(providerId, externalId);
    }

    @Transactional(readOnly=true)
    public List<ContentReviewItem> getQueuedNotSubmittedItems(Integer providerId) {
        return this.itemDao.findByProviderAnyMatching(providerId, null, null, null, null, null, ContentReviewConstants.CONTENT_REVIEW_NOT_SUBMITTED_CODE, null);
    }

    @Transactional(readOnly=true)
    public Optional<ContentReviewItem> getNextItemInQueueToSubmit(Integer providerId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        return this.itemDao.findByProviderSingleItemToSubmit(providerId);
    }

    @Transactional(readOnly=true)
    public List<ContentReviewItem> getAwaitingReports(Integer providerId) {
        Objects.requireNonNull(providerId, "providerId cannot be null");
        return this.itemDao.findByProviderAwaitingReports(providerId);
    }

    @Transactional
    public void update(ContentReviewItem item) {
        Objects.requireNonNull(item, "item cannot be null");
        Objects.requireNonNull(item.getProviderId(), "providerId cannot be null");
        this.itemDao.save((Object)item);
    }

    @Transactional
    public void delete(ContentReviewItem item) {
        Objects.requireNonNull(item, "item cannot be null");
        Objects.requireNonNull(item.getId(), "Id cannot be null");
        Objects.requireNonNull(item.getProviderId(), "providerId cannot be null");
        this.itemDao.delete((Object)item);
    }

    public void setItemDao(ContentReviewItemDao itemDao) {
        this.itemDao = itemDao;
    }
}

