/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.service;

import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;
import javax.servlet.http.HttpServletRequest;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.exception.QueueException;
import org.sakaiproject.contentreview.exception.ReportException;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.exception.TransientSubmissionException;
import org.sakaiproject.contentreview.service.BaseContentReviewService;
import org.sakaiproject.site.api.Site;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NoOpContentReviewService
extends BaseContentReviewService {
    private static final Logger log = LoggerFactory.getLogger(NoOpContentReviewService.class);
    private static final String SERVICE_NAME = "No Operation";

    public void queueContent(String userId, String siteId, String taskId, List<ContentResource> content) throws QueueException {
        log.debug("void queueContent {} {} {} {}", new Object[]{userId, siteId, taskId, content});
    }

    public int getReviewScore(String contentId, String taskId, String userId) throws QueueException, ReportException, Exception {
        log.debug("{} getReviewScore {} {} {}", new Object[]{0, contentId, taskId, userId});
        return 0;
    }

    @Override
    public String getReviewReport(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        log.debug("{} getReviewReport {} {} {}", new Object[]{null, contentId, assignmentRef, userId});
        return null;
    }

    @Override
    public String getReviewReportStudent(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        log.debug("{} getReviewReportStudent {} {} {}", new Object[]{null, contentId, assignmentRef, userId});
        return null;
    }

    @Override
    public String getReviewReportInstructor(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        log.debug("{} getReviewReportInstructor {} {} {}", new Object[]{null, contentId, assignmentRef, userId});
        return null;
    }

    public Long getReviewStatus(String contentId) throws QueueException {
        log.debug("{} getReviewStatus {}", null, (Object)contentId);
        return null;
    }

    public Date getDateQueued(String contextId) throws QueueException {
        log.debug("{} getDateQueued {}", null, (Object)contextId);
        return null;
    }

    public Date getDateSubmitted(String contextId) throws QueueException, SubmissionException {
        log.debug("{} getDateSubmitted {}", null, (Object)contextId);
        return null;
    }

    public void processQueue() {
        log.debug("void processqueue");
    }

    public void checkForReports() {
        log.debug("void checkForReports");
    }

    public List<ContentReviewItem> getReportList(String siteId, String taskId) throws QueueException, SubmissionException, ReportException {
        log.debug("{} getReportList {} {}", new Object[]{null, siteId, taskId});
        return null;
    }

    public List<ContentReviewItem> getReportList(String siteId) throws QueueException, SubmissionException, ReportException {
        log.debug("{} getReportList {}", null, (Object)siteId);
        return null;
    }

    public List<ContentReviewItem> getAllContentReviewItems(String siteId, String taskId) throws QueueException, SubmissionException, ReportException {
        log.debug("{} getAllContentReviewItems {} {}", new Object[]{null, siteId, taskId});
        return null;
    }

    public String getServiceName() {
        log.debug("{} getServiceName", (Object)SERVICE_NAME);
        return SERVICE_NAME;
    }

    public void resetUserDetailsLockedItems(String userId) {
        log.debug("void resetUserDetailsLockedItems {}", (Object)userId);
    }

    public boolean allowAllContent() {
        boolean ret = false;
        if ("true".equalsIgnoreCase(System.getProperty("sakai.demo"))) {
            ret = true;
        }
        log.debug("{} allowAllContent", (Object)ret);
        return ret;
    }

    public boolean isAcceptableContent(ContentResource resource) {
        boolean ret = false;
        if ("true".equalsIgnoreCase(System.getProperty("sakai.demo"))) {
            ret = true;
        }
        log.debug("{} isAcceptableContent {}", (Object)ret, (Object)resource);
        return ret;
    }

    public Map<String, SortedSet<String>> getAcceptableExtensionsToMimeTypes() {
        HashMap<String, SortedSet<String>> ret = new HashMap<String, SortedSet<String>>();
        log.debug("{} getAcceptableExtensionsToMimeTypes", ret);
        return ret;
    }

    public Map<String, SortedSet<String>> getAcceptableFileTypesToExtensions() {
        HashMap<String, SortedSet<String>> ret = new HashMap<String, SortedSet<String>>();
        log.debug("{} getAcceptableFileTypesToExtensions", ret);
        return ret;
    }

    public boolean isSiteAcceptable(Site site) {
        boolean ret = false;
        if ("true".equalsIgnoreCase(System.getProperty("sakai.demo"))) {
            ret = true;
        }
        log.debug("{} isSiteAcceptable {}", (Object)ret, (Object)site);
        return ret;
    }

    public String getIconCssClassforScore(int score, String contentId) {
        String ret = "contentReviewIconNoService";
        log.debug("{} getIconCssClassforScore {} {}", new Object[]{ret, score, contentId});
        return ret;
    }

    public boolean allowResubmission() {
        log.debug("{} allowResubmission", (Object)false);
        return false;
    }

    public void removeFromQueue(String contentId) {
        log.debug("void removeFromQueue {}", (Object)contentId);
    }

    public String getLocalizedStatusMessage(String messageCode, String userRef) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getLocalizedStatusMessage {} {}", new Object[]{ret, messageCode, userRef});
        return ret;
    }

    public String getLocalizedStatusMessage(String messageCode) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getLocalizedStatusMessage {}", (Object)ret, (Object)messageCode);
        return ret;
    }

    public String getReviewError(String contentId) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getReviewError {}", (Object)ret, (Object)contentId);
        return ret;
    }

    public String getLocalizedStatusMessage(String messageCode, Locale locale) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getLocalizedStatusMessage {} {}", new Object[]{ret, messageCode, locale});
        return ret;
    }

    public Map getAssignment(String siteId, String taskId) throws SubmissionException, TransientSubmissionException {
        log.debug("{} getAssignment {} {}", new Object[]{null, siteId, taskId});
        return null;
    }

    public void createAssignment(String siteId, String taskId, Map extraAsnnOpts) throws SubmissionException, TransientSubmissionException {
        log.debug("void createAssignment {} {} {}", new Object[]{siteId, taskId, extraAsnnOpts});
    }

    public ContentReviewItem getContentReviewItemByContentId(String contentId) {
        ContentReviewItem ret = null;
        log.debug("{} getContentReviewItemByContentId {}", ret, (Object)contentId);
        return ret;
    }

    public String getEndUserLicenseAgreementLink(String userId) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getEndUserLicenseAgreementLink {}", (Object)ret, (Object)userId);
        return null;
    }

    public Instant getEndUserLicenseAgreementTimestamp() {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getEndUserLicenseAgreementTimestamp", (Object)ret);
        return null;
    }

    @Override
    public Instant getUserEULATimestamp(String userId) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getUserEULATimestamp {}", (Object)ret, (Object)userId);
        return null;
    }

    @Override
    public void updateUserEULATimestamp(String userId) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} updateUserEULATimestamp {}", (Object)ret, (Object)userId);
    }

    public String getEndUserLicenseAgreementVersion() {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} getEndUserLicenseAgreementVersion", (Object)ret);
        return null;
    }

    public void webhookEvent(HttpServletRequest request, int providerId, Optional<String> customParam) {
        String ret = "There is no content review service configured, please see your administrator";
        log.debug("{} webhookEvent", (Object)ret);
    }
}

