/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.service;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.exception.ContentReviewProviderException;
import org.sakaiproject.contentreview.exception.QueueException;
import org.sakaiproject.contentreview.exception.ReportException;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.exception.TransientSubmissionException;
import org.sakaiproject.contentreview.service.BaseContentReviewService;
import org.sakaiproject.contentreview.service.ContentReviewService;
import org.sakaiproject.contentreview.service.NoOpContentReviewService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentReviewFederatedServiceImpl
extends BaseContentReviewService {
    private static final Logger log = LoggerFactory.getLogger(ContentReviewFederatedServiceImpl.class);
    private ToolManager toolManager;
    private SiteService siteService;
    private List<ContentReviewService> providers;
    private int defaultProvider = -1;
    private Set<Integer> enabledProviders;

    public void init() {
        this.enabledProviders = this.configureEnabledProviders();
        if (this.enabledProviders.isEmpty()) {
            NoOpContentReviewService noop = new NoOpContentReviewService();
            this.providers.add(noop);
            this.enabledProviders.add((int)noop.getProviderId());
        }
        this.providers.stream().forEach(p -> log.info("Found Content Review Provider: " + p.getServiceName() + " with providerId of " + p.getProviderId()));
        this.enabledProviders.stream().forEach(p -> log.info("Enabled Content Review Provider: " + p));
        Optional<String> configuredDefaultProvider = Optional.ofNullable(this.serverConfigurationService.getString("contentreview.defaultProvider"));
        if (configuredDefaultProvider.isPresent()) {
            Integer cdp = Math.abs(configuredDefaultProvider.get().hashCode());
            if (this.enabledProviders.stream().anyMatch(p -> p.intValue() == cdp.intValue())) {
                this.defaultProvider = cdp;
                log.info("Default Content Review Provider: " + this.defaultProvider);
            }
        }
        if (this.defaultProvider < 0) {
            this.defaultProvider = new ArrayList<Integer>(this.enabledProviders).get(0);
            log.info("Default Content Review Provider: " + this.defaultProvider);
        }
    }

    private Optional<Site> getCurrentSite(String contextId) {
        Optional<Site> site = null;
        try {
            String context = StringUtils.isNotEmpty((String)contextId) ? contextId : this.toolManager.getCurrentPlacement().getContext();
            site = Optional.of(this.siteService.getSite(context));
        }
        catch (Exception e) {
            site = Optional.empty();
        }
        return site;
    }

    private Set<Integer> configureEnabledProviders() {
        HashSet<Integer> enabledProviders = new HashSet<Integer>();
        Optional<String[]> configuredProviders = Optional.ofNullable(this.serverConfigurationService.getStrings("contentreview.enabledProviders"));
        if (configuredProviders.isPresent()) {
            List<Object> configProviders = Arrays.asList((Object[])configuredProviders.get());
            for (ContentReviewService provider : this.providers) {
                for (String string : configProviders) {
                    if (Math.abs(string.hashCode()) != provider.getProviderId()) continue;
                    enabledProviders.add((int)provider.getProviderId());
                }
            }
        }
        return enabledProviders;
    }

    private ContentReviewService getSelectedProvider() {
        return this.getSelectedProvider(null);
    }

    private ContentReviewService getSelectedProvider(String contextId) {
        if (this.defaultProvider < 0) {
            throw new ContentReviewProviderException("No Default Content Review Provider");
        }
        Optional<Site> currentSite = this.getCurrentSite(contextId);
        if (currentSite.isPresent()) {
            String overrideProvider;
            if (log.isDebugEnabled()) {
                log.debug("In Location:" + currentSite.get().getReference());
            }
            if (StringUtils.isNotEmpty((String)(overrideProvider = currentSite.get().getProperties().getProperty("contentreview.provider"))) && this.enabledProviders.stream().anyMatch(p -> p == Math.abs(overrideProvider.hashCode()))) {
                return (ContentReviewService)this.providers.stream().filter(crs -> crs.getProviderId() == Math.abs(overrideProvider.hashCode())).collect(Collectors.toList()).get(0);
            }
        }
        return (ContentReviewService)this.providers.stream().filter(crs -> crs.getProviderId() == this.defaultProvider).collect(Collectors.toList()).get(0);
    }

    public boolean allowResubmission() {
        return this.getSelectedProvider().allowResubmission();
    }

    public void checkForReports() {
        this.providers.stream().filter(provider -> this.enabledProviders.stream().anyMatch(ep -> ep.intValue() == provider.getProviderId().intValue())).forEach(ContentReviewService::checkForReports);
    }

    public void syncRosters() {
        this.providers.stream().filter(provider -> this.enabledProviders.stream().anyMatch(ep -> ep.intValue() == provider.getProviderId().intValue())).forEach(ContentReviewService::syncRosters);
    }

    public Integer getProviderId() {
        return this.getSelectedProvider().getProviderId();
    }

    public void createAssignment(String arg0, String arg1, Map arg2) throws SubmissionException, TransientSubmissionException {
        this.getSelectedProvider().createAssignment(arg0, arg1, arg2);
    }

    public List<ContentReviewItem> getAllContentReviewItems(String arg0, String arg1) throws QueueException, SubmissionException, ReportException {
        return this.getSelectedProvider().getAllContentReviewItems(arg0, arg1);
    }

    public Map getAssignment(String arg0, String arg1) throws SubmissionException, TransientSubmissionException {
        return this.getSelectedProvider().getAssignment(arg0, arg1);
    }

    public Date getDateQueued(String arg0) throws QueueException {
        return this.getSelectedProvider().getDateQueued(arg0);
    }

    public Date getDateSubmitted(String arg0) throws QueueException, SubmissionException {
        return this.getSelectedProvider().getDateSubmitted(arg0);
    }

    public String getIconCssClassforScore(int score, String contentId) {
        return this.getSelectedProvider().getIconCssClassforScore(score, contentId);
    }

    public String getLocalizedStatusMessage(String arg0) {
        return this.getSelectedProvider().getLocalizedStatusMessage(arg0);
    }

    public String getLocalizedStatusMessage(String arg0, String arg1) {
        return this.getSelectedProvider().getLocalizedStatusMessage(arg0, arg1);
    }

    public String getLocalizedStatusMessage(String arg0, Locale arg1) {
        return this.getSelectedProvider().getLocalizedStatusMessage(arg0, arg1);
    }

    public List<ContentReviewItem> getReportList(String siteId) throws QueueException, SubmissionException, ReportException {
        return this.getSelectedProvider().getReportList(siteId);
    }

    public List<ContentReviewItem> getReportList(String siteId, String taskId) throws QueueException, SubmissionException, ReportException {
        return this.getSelectedProvider().getReportList(siteId, taskId);
    }

    @Override
    public String getReviewReport(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getSelectedProvider().getReviewReport(contentId, assignmentRef, userId);
    }

    @Override
    public String getReviewReportInstructor(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getSelectedProvider().getReviewReportInstructor(contentId, assignmentRef, userId);
    }

    @Override
    public String getReviewReportStudent(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.getSelectedProvider().getReviewReportStudent(contentId, assignmentRef, userId);
    }

    public Long getReviewStatus(String contentId) throws QueueException {
        return this.getSelectedProvider().getReviewStatus(contentId);
    }

    public String getServiceName() {
        return this.getSelectedProvider().getServiceName();
    }

    public boolean allowAllContent() {
        return this.getSelectedProvider().allowAllContent();
    }

    public boolean isAcceptableContent(ContentResource arg0) {
        return this.getSelectedProvider().isAcceptableContent(arg0);
    }

    public Map<String, SortedSet<String>> getAcceptableExtensionsToMimeTypes() {
        return this.getSelectedProvider().getAcceptableExtensionsToMimeTypes();
    }

    public Map<String, SortedSet<String>> getAcceptableFileTypesToExtensions() {
        return this.getSelectedProvider().getAcceptableFileTypesToExtensions();
    }

    public boolean isSiteAcceptable(Site arg0) {
        return this.getSelectedProvider().isSiteAcceptable(arg0);
    }

    public void processQueue() {
        this.providers.stream().filter(provider -> this.enabledProviders.stream().anyMatch(ep -> ep.intValue() == provider.getProviderId().intValue())).forEach(ContentReviewService::processQueue);
    }

    public void queueContent(String userId, String siteId, String assignmentReference, List<ContentResource> content) throws QueueException {
        this.getSelectedProvider().queueContent(userId, siteId, assignmentReference, content);
    }

    public void removeFromQueue(String arg0) {
        this.getSelectedProvider().removeFromQueue(arg0);
    }

    public void resetUserDetailsLockedItems(String arg0) {
        this.getSelectedProvider().resetUserDetailsLockedItems(arg0);
    }

    public String getReviewError(String contentId) {
        return this.getSelectedProvider().getReviewError(contentId);
    }

    public int getReviewScore(String contentId, String assignmentRef, String userId) throws QueueException, ReportException, Exception {
        return this.getSelectedProvider().getReviewScore(contentId, assignmentRef, userId);
    }

    public ContentReviewItem getContentReviewItemByContentId(String arg0) {
        return this.getSelectedProvider().getContentReviewItemByContentId(arg0);
    }

    public String getEndUserLicenseAgreementLink(String userId) {
        return this.getSelectedProvider().getEndUserLicenseAgreementLink(userId);
    }

    public Instant getEndUserLicenseAgreementTimestamp() {
        return this.getSelectedProvider().getEndUserLicenseAgreementTimestamp();
    }

    @Override
    public Instant getUserEULATimestamp(String userId) {
        return this.getSelectedProvider().getUserEULATimestamp(userId);
    }

    @Override
    public void updateUserEULATimestamp(String userId) {
        this.getSelectedProvider().updateUserEULATimestamp(userId);
    }

    public String getEndUserLicenseAgreementVersion() {
        return this.getSelectedProvider().getEndUserLicenseAgreementVersion();
    }

    @Override
    public String getReviewReportRedirectUrl(String contentId, String assignmentRef, String userId, String contextId, boolean isInstructor) {
        return this.getSelectedProvider(contextId).getReviewReportRedirectUrl(contentId, assignmentRef, userId, contextId, isInstructor);
    }

    public void webhookEvent(HttpServletRequest request, int providerId, Optional<String> customParam) {
        ((ContentReviewService)this.providers.stream().filter(crs -> crs.getProviderId() == providerId).collect(Collectors.toList()).get(0)).webhookEvent(request, providerId, customParam);
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setProviders(List<ContentReviewService> providers) {
        this.providers = providers;
    }
}

