/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.service;

import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.sakaiproject.contentreview.exception.ContentReviewProviderException;
import org.sakaiproject.util.ResourceLoader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class I18nXmlUtility {
    private static final String TAG_NAME_MESSAGE = "message";
    private static final String TAG_NAME_KEY = "key";
    private static final String TAG_NAME_ARG = "arg";
    private static DocumentBuilderFactory documentBuilderFactory = null;
    private static DocumentBuilder documentBuilder = null;

    public static DocumentBuilder getDocumentBuilder() {
        try {
            if (documentBuilderFactory == null) {
                documentBuilderFactory = DocumentBuilderFactory.newInstance();
            }
            if (documentBuilder == null) {
                documentBuilder = documentBuilderFactory.newDocumentBuilder();
            }
            return documentBuilder;
        }
        catch (Exception e) {
            throw new ContentReviewProviderException("Failed to produce an XML Document Builder", (Throwable)e);
        }
    }

    public static Document createXmlDocument() {
        return I18nXmlUtility.getDocumentBuilder().newDocument();
    }

    public static String addElementAndGetDocumentAsString(Document doc, Element el) {
        doc.appendChild(el);
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer aTransformer = tranFactory.newTransformer();
            DOMSource src = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            StreamResult dest = new StreamResult(writer);
            aTransformer.transform(src, dest);
            String result = writer.getBuffer().toString();
            return result;
        }
        catch (Exception e) {
            throw new ContentReviewProviderException("Failed to transform the XML Document into a String");
        }
    }

    protected static Object createFormattedMessageXML(Document document, String key, Object ... args) {
        if (document == null) {
            throw new ContentReviewProviderException("createFormattedMessageXML invoked with null document");
        }
        Element message = document.createElement(TAG_NAME_MESSAGE);
        Element eKey = document.createElement(TAG_NAME_KEY);
        eKey.setTextContent(key);
        message.appendChild(eKey);
        for (Object arg : args) {
            if (arg == null) {
                arg = "";
            }
            if (arg instanceof Element) {
                message.appendChild((Element)arg);
                continue;
            }
            Element eArg = document.createElement(TAG_NAME_ARG);
            eArg.setTextContent(String.valueOf(arg));
            message.appendChild(eArg);
        }
        return message;
    }

    public static String getLocalizedMessage(ResourceLoader rb, Node node) {
        String nodeName;
        switch (nodeName = node.getNodeName()) {
            case "message": {
                Node keyNode = node.getFirstChild();
                if (!TAG_NAME_KEY.equals(keyNode.getNodeName())) {
                    throw new ContentReviewProviderException("XML is malformed; first child of \"message\" tag expected \"key\", but got: " + keyNode.getNodeName());
                }
                String key = keyNode.getTextContent();
                ArrayList<String> args = new ArrayList<String>();
                for (Node arg = keyNode.getNextSibling(); arg != null; arg = arg.getNextSibling()) {
                    args.add(I18nXmlUtility.getLocalizedMessage(rb, arg));
                }
                Object[] argsArray = args.toArray(new String[args.size()]);
                return rb.getFormattedMessage(key, argsArray);
            }
            case "arg": {
                return node.getTextContent();
            }
        }
        throw new ContentReviewProviderException("XML is malformed; got unexpected tag: " + nodeName);
    }
}

