/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.contentreview.service;

import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.assignment.api.AssignmentService;
import org.sakaiproject.assignment.api.model.Assignment;
import org.sakaiproject.assignment.api.model.AssignmentSubmission;
import org.sakaiproject.assignment.api.model.AssignmentSubmissionSubmitter;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.contentreview.dao.ContentReviewConstants;
import org.sakaiproject.contentreview.dao.ContentReviewItem;
import org.sakaiproject.contentreview.exception.ContentReviewProviderException;
import org.sakaiproject.contentreview.exception.QueueException;
import org.sakaiproject.contentreview.exception.ReportException;
import org.sakaiproject.contentreview.exception.SubmissionException;
import org.sakaiproject.contentreview.exception.TransientSubmissionException;
import org.sakaiproject.contentreview.service.ContentReviewQueueService;
import org.sakaiproject.contentreview.service.ContentReviewService;
import org.sakaiproject.contentreview.service.I18nXmlUtility;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.user.api.PreferencesEdit;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.util.ResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class BaseContentReviewService
implements ContentReviewService {
    private static final Logger log = LoggerFactory.getLogger(BaseContentReviewService.class);
    protected AssignmentService assignmentService;
    protected ContentReviewQueueService crqs;
    protected EntityManager entityManager;
    protected PreferencesService preferencesService;
    protected ServerConfigurationService serverConfigurationService;
    private static final String PROP_KEY_EULA = "contentReviewEULA";
    private static final String PROP_KEY_EULA_TIMESTAMP = "contentReviewEULATimestamp";
    private static final String PROP_KEY_EULA_VERSION = "contentReviewEULAVersion";
    private static final String REDIRECT_URL_TEMPLATE = "/content-review-tool/viewreport?contentId=%s&assignmentRef=%s&contextId=%s";
    private static final String WEBHOOK_URL_TEMPLATE = "%scontent-review-tool/webhooks?providerId=%s";
    private ResourceLoader rb;

    public Instant getUserEULATimestamp(String userId) {
        Instant timestamp = null;
        try {
            ResourceProperties pref = this.preferencesService.getPreferences(userId).getProperties(PROP_KEY_EULA + this.getProviderId());
            if (pref != null) {
                timestamp = Instant.ofEpochMilli(pref.getLongProperty(PROP_KEY_EULA_TIMESTAMP));
            }
        }
        catch (EntityPropertyNotDefinedException pref) {
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return timestamp;
    }

    public String getUserEULAVersion(String userId) {
        String version = null;
        try {
            ResourceProperties pref = this.preferencesService.getPreferences(userId).getProperties(PROP_KEY_EULA + this.getProviderId());
            if (pref != null) {
                version = pref.getProperty(PROP_KEY_EULA_VERSION);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return version;
    }

    public void updateUserEULATimestamp(String userId) {
        block6: {
            try {
                PreferencesEdit pref = this.preferencesService.edit(userId);
                try {
                    if (pref == null) break block6;
                    ResourcePropertiesEdit resourcePropEdit = pref.getPropertiesEdit(PROP_KEY_EULA + this.getProviderId());
                    if (resourcePropEdit != null) {
                        resourcePropEdit.addProperty(PROP_KEY_EULA_TIMESTAMP, "" + Instant.now().toEpochMilli());
                        String EULAVersion = this.getEndUserLicenseAgreementVersion();
                        if (StringUtils.isNotEmpty((CharSequence)EULAVersion)) {
                            resourcePropEdit.addProperty(PROP_KEY_EULA_VERSION, EULAVersion);
                        }
                        this.preferencesService.commit(pref);
                        break block6;
                    }
                    this.preferencesService.cancel(pref);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    this.preferencesService.cancel(pref);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void createAssignment(String contextId, String taskId, Map opts) throws SubmissionException, TransientSubmissionException {
        this.queueAllSubmissionsForAssignment(taskId);
    }

    protected void queueAllSubmissionsForAssignment(String taskId) {
        try {
            Assignment assignment;
            try {
                assignment = this.assignmentService.getAssignment(this.entityManager.newReference(taskId));
            }
            catch (IdUnusedException | PermissionException e) {
                return;
            }
            Set submissions = this.assignmentService.getSubmissions(assignment);
            if (submissions != null) {
                submissions.stream().filter(AssignmentSubmission::getSubmitted).forEach(sub -> {
                    List attachments = this.assignmentService.getAllAcceptableAttachments(sub);
                    if (!attachments.isEmpty()) {
                        Optional submitter = this.assignmentService.getSubmissionSubmittee(sub);
                        if (!submitter.isPresent() && this.allowSubmissionsOnBehalf()) {
                            submitter = sub.getSubmitters().stream().findAny();
                        }
                        if (submitter.isPresent()) {
                            try {
                                this.queueContent(((AssignmentSubmissionSubmitter)submitter.get()).getSubmitter(), assignment.getContext(), taskId, attachments);
                            }
                            catch (QueueException queueException) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            log.error("Unknown excpetion queueing submissions for assessment " + taskId, (Throwable)e);
        }
    }

    public void deleteAssignment(String siteId, String taskId) {
        this.deleteAllSubmissionsForAssignment(siteId, taskId);
    }

    protected void deleteAllSubmissionsForAssignment(String siteId, String taskId) {
        Integer providerId = this.getProviderId();
        List items = this.crqs.getContentReviewItems(providerId, siteId, taskId);
        items.forEach(item -> this.crqs.removeFromQueue(providerId, item.getContentId()));
    }

    public String getReviewReport(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.formatRedirectUrl(contentId, assignmentRef, userId);
    }

    public String getReviewReportInstructor(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.formatRedirectUrl(contentId, assignmentRef, userId);
    }

    public String getReviewReportStudent(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        return this.formatRedirectUrl(contentId, assignmentRef, userId);
    }

    private String formatRedirectUrl(String contentId, String assignmentRef, String userId) throws QueueException, ReportException {
        ContentReviewItem item = this.checkContentItemStatus(contentId);
        try {
            return String.format(REDIRECT_URL_TEMPLATE, URLEncoder.encode(contentId, "UTF-8"), URLEncoder.encode(assignmentRef, "UTF-8"), URLEncoder.encode(item.getSiteId(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ReportException("Error encoding contentId: " + contentId + ", assignmentRef: " + assignmentRef + ", siteId: " + item.getSiteId());
        }
    }

    private ContentReviewItem checkContentItemStatus(String contentId) throws ReportException {
        ContentReviewItem item = this.getContentReviewItemByContentId(contentId);
        if (item == null || !ContentReviewConstants.CONTENT_REVIEW_SUBMITTED_REPORT_AVAILABLE_CODE.equals(item.getStatus())) {
            throw new ReportException("Report status: " + (Serializable)(item != null ? item.getStatus() : ""));
        }
        return item;
    }

    public String getReviewReportRedirectUrl(String contentId, String assignmentRef, String userId, String contextId, boolean isInstructor) {
        return null;
    }

    public String getWebhookUrl(Optional<String> customParam) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serverConfigurationService.getServerUrl());
        if (!StringUtils.endsWith((CharSequence)sb.toString(), (CharSequence)"/")) {
            sb.append("/");
        }
        return String.format(WEBHOOK_URL_TEMPLATE, sb.toString(), this.getProviderId()) + (String)(customParam.isPresent() ? "&custom=" + customParam.get() : "");
    }

    protected Object createFormattedMessageXML(Document document, String key, Object ... args) {
        try {
            return I18nXmlUtility.createFormattedMessageXML(document, key, args);
        }
        catch (Exception e) {
            log.warn("Could not create last error xml, returning the raw message localized to the current session", (Throwable)e);
            return this.getResourceLoader().getFormattedMessage(key, args);
        }
    }

    protected void setLastError(ContentReviewItem item, LastErrorUpdater leu) {
        item.setLastError(this.createLastError(leu));
    }

    protected void setLastError(ContentReviewItem item, Exception e) {
        this.setLastError(item, e, null);
    }

    protected void setLastError(ContentReviewItem item, Exception e, LastErrorUpdater leu) {
        if (e instanceof ContentReviewProviderException) {
            item.setLastError(((ContentReviewProviderException)e).getI18nXml());
        } else {
            String message = leu == null ? e.getLocalizedMessage() : this.createLastError(leu);
            item.setLastError(message);
        }
    }

    protected String createLastError(LastErrorUpdater leu) {
        Document document = null;
        try {
            document = I18nXmlUtility.createXmlDocument();
        }
        catch (ContentReviewProviderException e) {
            log.warn("Failed to create an XML document", (Throwable)e);
        }
        Object lastErrorXML = leu.createLastErrorXML(document);
        String lastError = null;
        if (lastErrorXML instanceof Element) {
            lastError = I18nXmlUtility.addElementAndGetDocumentAsString(document, (Element)lastErrorXML);
        } else if (lastErrorXML instanceof String) {
            lastError = (String)lastErrorXML;
        } else {
            throw new ContentReviewProviderException("Unexpected behavior while generating the last_error value");
        }
        return lastError;
    }

    public String getLocalizedLastError(ContentReviewItem item) {
        String xmlString = item.getLastError();
        if (StringUtils.isBlank((CharSequence)xmlString)) {
            return "";
        }
        try {
            Document doc = I18nXmlUtility.getDocumentBuilder().parse(new InputSource(new StringReader(xmlString)));
            Node root = doc.getFirstChild();
            return I18nXmlUtility.getLocalizedMessage(this.getResourceLoader(), root);
        }
        catch (Exception e) {
            log.warn("Could not internationalize last_error value:\n{}\nReturning the raw data", (Object)xmlString);
            log.debug("Cause:", (Throwable)e);
            return xmlString;
        }
    }

    protected ResourceLoader getResourceLoader() {
        if (this.rb == null) {
            this.rb = new ResourceLoader(this.getResourceLoaderName());
        }
        return this.rb;
    }

    protected String getResourceLoaderName() {
        return this.getServiceName().toLowerCase();
    }

    public boolean allowSubmissionsOnBehalf() {
        return false;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }

    public void setCrqs(ContentReviewQueueService crqs) {
        this.crqs = crqs;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setPreferencesService(PreferencesService preferencesService) {
        this.preferencesService = preferencesService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public static interface LastErrorUpdater {
        public Object createLastErrorXML(Document var1);
    }
}

