/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.beans;

import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sakaiproject.conversations.api.Reaction;
import org.sakaiproject.conversations.api.beans.CommentTransferBean;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.conversations.api.model.Post;
import org.sakaiproject.entity.api.Entity;

public class PostTransferBean
implements Entity {
    public String id;
    public String message;
    public int numberOfComments;
    public List<CommentTransferBean> comments;
    public String creator;
    public Instant created;
    public String formattedCreatedDate;
    public String siteId;
    public String modifier;
    public Instant modified;
    public String formattedModifiedDate;
    public Map<Reaction, Boolean> myReactions = new HashMap<Reaction, Boolean>();
    public Map<Reaction, Integer> reactionTotals = new HashMap<Reaction, Integer>();
    public boolean viewed;
    public boolean locked;
    public boolean hidden;
    public boolean draft;
    public boolean anonymous;
    public boolean isMine;
    public boolean privatePost;
    public int upvotes;
    public String topic;
    public String creatorDisplayName;
    public String verifierDisplayName;
    public boolean upvoted;
    public boolean canView;
    public boolean canEdit;
    public boolean canDelete;
    public boolean canComment;
    public boolean canUpvote;
    public boolean canReact;
    public boolean canModerate;
    public boolean isInstructor;
    public String url;
    public String reference;

    public static PostTransferBean of(Post post) {
        PostTransferBean postBean = new PostTransferBean();
        postBean.id = post.getId();
        postBean.message = post.getMessage();
        postBean.numberOfComments = post.getNumberOfComments();
        Metadata metadata = post.getMetadata();
        postBean.creator = metadata.getCreator();
        postBean.created = metadata.getCreated();
        postBean.modifier = metadata.getModifier();
        postBean.modified = metadata.getModified();
        postBean.hidden = post.getHidden();
        postBean.locked = post.getLocked();
        postBean.draft = post.getDraft();
        postBean.siteId = post.getSiteId();
        postBean.privatePost = post.getPrivatePost();
        postBean.upvotes = post.getUpvotes();
        postBean.topic = post.getTopic().getId();
        postBean.anonymous = post.getAnonymous();
        return postBean;
    }

    public Post asPost() {
        Post post = new Post();
        post.setId(this.id);
        post.setMessage(this.message);
        post.setNumberOfComments(this.numberOfComments);
        Metadata metadata = new Metadata();
        metadata.setCreator(this.creator);
        metadata.setCreated(this.created);
        metadata.setModifier(this.modifier);
        metadata.setModified(this.modified);
        post.setMetadata(metadata);
        post.setSiteId(this.siteId);
        post.setHidden(this.hidden);
        post.setLocked(this.locked);
        post.setDraft(this.draft);
        post.setUpvotes(this.upvotes);
        post.setPrivatePost(this.privatePost);
        post.setAnonymous(this.anonymous);
        return post;
    }

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }

    public List<CommentTransferBean> getComments() {
        return this.comments;
    }

    public String getCreator() {
        return this.creator;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getFormattedCreatedDate() {
        return this.formattedCreatedDate;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Instant getModified() {
        return this.modified;
    }

    public String getFormattedModifiedDate() {
        return this.formattedModifiedDate;
    }

    public Map<Reaction, Boolean> getMyReactions() {
        return this.myReactions;
    }

    public Map<Reaction, Integer> getReactionTotals() {
        return this.reactionTotals;
    }

    public boolean isViewed() {
        return this.viewed;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isMine() {
        return this.isMine;
    }

    public boolean isPrivatePost() {
        return this.privatePost;
    }

    public int getUpvotes() {
        return this.upvotes;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getCreatorDisplayName() {
        return this.creatorDisplayName;
    }

    public String getVerifierDisplayName() {
        return this.verifierDisplayName;
    }

    public boolean isUpvoted() {
        return this.upvoted;
    }

    public boolean isCanView() {
        return this.canView;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public boolean isCanDelete() {
        return this.canDelete;
    }

    public boolean isCanComment() {
        return this.canComment;
    }

    public boolean isCanUpvote() {
        return this.canUpvote;
    }

    public boolean isCanReact() {
        return this.canReact;
    }

    public boolean isCanModerate() {
        return this.canModerate;
    }

    public boolean isInstructor() {
        return this.isInstructor;
    }

    public String getUrl() {
        return this.url;
    }

    public String getReference() {
        return this.reference;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNumberOfComments(int numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    public void setComments(List<CommentTransferBean> comments) {
        this.comments = comments;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setFormattedCreatedDate(String formattedCreatedDate) {
        this.formattedCreatedDate = formattedCreatedDate;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    public void setFormattedModifiedDate(String formattedModifiedDate) {
        this.formattedModifiedDate = formattedModifiedDate;
    }

    public void setMyReactions(Map<Reaction, Boolean> myReactions) {
        this.myReactions = myReactions;
    }

    public void setReactionTotals(Map<Reaction, Integer> reactionTotals) {
        this.reactionTotals = reactionTotals;
    }

    public void setViewed(boolean viewed) {
        this.viewed = viewed;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setMine(boolean isMine) {
        this.isMine = isMine;
    }

    public void setPrivatePost(boolean privatePost) {
        this.privatePost = privatePost;
    }

    public void setUpvotes(int upvotes) {
        this.upvotes = upvotes;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setCreatorDisplayName(String creatorDisplayName) {
        this.creatorDisplayName = creatorDisplayName;
    }

    public void setVerifierDisplayName(String verifierDisplayName) {
        this.verifierDisplayName = verifierDisplayName;
    }

    public void setUpvoted(boolean upvoted) {
        this.upvoted = upvoted;
    }

    public void setCanView(boolean canView) {
        this.canView = canView;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public void setCanComment(boolean canComment) {
        this.canComment = canComment;
    }

    public void setCanUpvote(boolean canUpvote) {
        this.canUpvote = canUpvote;
    }

    public void setCanReact(boolean canReact) {
        this.canReact = canReact;
    }

    public void setCanModerate(boolean canModerate) {
        this.canModerate = canModerate;
    }

    public void setInstructor(boolean isInstructor) {
        this.isInstructor = isInstructor;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
}

