/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.beans;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sakaiproject.conversations.api.Reaction;
import org.sakaiproject.conversations.api.TopicType;
import org.sakaiproject.conversations.api.TopicVisibility;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.conversations.api.model.Tag;
import org.sakaiproject.conversations.api.model.Topic;
import org.sakaiproject.entity.api.Entity;

public class TopicTransferBean
implements Entity {
    public String id;
    public String title;
    public String siteId;
    public String aboutReference;
    public String message;
    public long numberOfPosts;
    public long numberOfUnreadPosts;
    public String creator;
    public Instant created;
    public String formattedCreatedDate;
    public String modifier;
    public Instant modified;
    public String formattedModifiedDate;
    public boolean pinned;
    public boolean locked;
    public boolean hidden;
    public boolean resolved;
    public List<Tag> tags = new ArrayList<Tag>();
    public Map<Reaction, Boolean> myReactions = new HashMap<Reaction, Boolean>();
    public Map<Reaction, Integer> reactionTotals = new HashMap<Reaction, Integer>();
    public Set<String> groups = new HashSet<String>();
    public String type;
    public String visibility;
    public int unread;
    public boolean bookmarked;
    public boolean draft;
    public boolean anonymous;
    public boolean allowAnonymousPosts;
    public String creatorDisplayName;
    public boolean canEdit;
    public boolean canDelete;
    public boolean canPost;
    public boolean canPin;
    public boolean canBookmark;
    public boolean canTag;
    public boolean canReact;
    public boolean canModerate;
    public boolean isMine;
    public String url;
    public String reference;

    public static TopicTransferBean of(Topic topic) {
        TopicTransferBean topicBean = new TopicTransferBean();
        topicBean.id = topic.getId();
        topicBean.title = topic.getTitle();
        topicBean.siteId = topic.getSiteId();
        topicBean.aboutReference = topic.getAboutReference();
        topicBean.message = topic.getMessage();
        Metadata metadata = topic.getMetadata();
        topicBean.creator = metadata.getCreator();
        topicBean.created = metadata.getCreated();
        topicBean.modifier = metadata.getModifier();
        topicBean.modified = metadata.getModified();
        topicBean.pinned = topic.getPinned();
        topicBean.locked = topic.getLocked();
        topicBean.hidden = topic.getHidden();
        topicBean.resolved = topic.getResolved();
        topicBean.type = topic.getType().name();
        topicBean.visibility = topic.getVisibility().name();
        topicBean.draft = topic.getDraft();
        topicBean.anonymous = topic.getAnonymous();
        topicBean.allowAnonymousPosts = topic.getAllowAnonymousPosts();
        topicBean.groups = topic.getGroups();
        return topicBean;
    }

    public Topic asTopic() {
        Topic topic = new Topic();
        topic.setId(this.id);
        topic.setSiteId(this.siteId);
        topic.setTitle(this.title);
        topic.setAboutReference(this.aboutReference);
        topic.setMessage(this.message);
        Metadata metadata = new Metadata();
        metadata.setCreator(this.creator);
        metadata.setCreated(this.created);
        metadata.setModifier(this.modifier);
        metadata.setModified(this.modified);
        topic.setMetadata(metadata);
        topic.setTagIds(this.tags.stream().map(t -> t.getId()).collect(Collectors.toSet()));
        topic.setGroups(this.groups);
        topic.setPinned(this.pinned);
        topic.setLocked(this.locked);
        topic.setHidden(this.hidden);
        topic.setType(Enum.valueOf(TopicType.class, this.type));
        topic.setVisibility(Enum.valueOf(TopicVisibility.class, this.visibility));
        topic.setDraft(this.draft);
        topic.setAnonymous(this.anonymous);
        topic.setAllowAnonymousPosts(this.allowAnonymousPosts);
        return topic;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getAboutReference() {
        return this.aboutReference;
    }

    public String getMessage() {
        return this.message;
    }

    public long getNumberOfPosts() {
        return this.numberOfPosts;
    }

    public long getNumberOfUnreadPosts() {
        return this.numberOfUnreadPosts;
    }

    public String getCreator() {
        return this.creator;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getFormattedCreatedDate() {
        return this.formattedCreatedDate;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Instant getModified() {
        return this.modified;
    }

    public String getFormattedModifiedDate() {
        return this.formattedModifiedDate;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Map<Reaction, Boolean> getMyReactions() {
        return this.myReactions;
    }

    public Map<Reaction, Integer> getReactionTotals() {
        return this.reactionTotals;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getType() {
        return this.type;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public int getUnread() {
        return this.unread;
    }

    public boolean isBookmarked() {
        return this.bookmarked;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isAllowAnonymousPosts() {
        return this.allowAnonymousPosts;
    }

    public String getCreatorDisplayName() {
        return this.creatorDisplayName;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public boolean isCanDelete() {
        return this.canDelete;
    }

    public boolean isCanPost() {
        return this.canPost;
    }

    public boolean isCanPin() {
        return this.canPin;
    }

    public boolean isCanBookmark() {
        return this.canBookmark;
    }

    public boolean isCanTag() {
        return this.canTag;
    }

    public boolean isCanReact() {
        return this.canReact;
    }

    public boolean isCanModerate() {
        return this.canModerate;
    }

    public boolean isMine() {
        return this.isMine;
    }

    public String getUrl() {
        return this.url;
    }

    public String getReference() {
        return this.reference;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setAboutReference(String aboutReference) {
        this.aboutReference = aboutReference;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNumberOfPosts(long numberOfPosts) {
        this.numberOfPosts = numberOfPosts;
    }

    public void setNumberOfUnreadPosts(long numberOfUnreadPosts) {
        this.numberOfUnreadPosts = numberOfUnreadPosts;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setFormattedCreatedDate(String formattedCreatedDate) {
        this.formattedCreatedDate = formattedCreatedDate;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    public void setFormattedModifiedDate(String formattedModifiedDate) {
        this.formattedModifiedDate = formattedModifiedDate;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public void setMyReactions(Map<Reaction, Boolean> myReactions) {
        this.myReactions = myReactions;
    }

    public void setReactionTotals(Map<Reaction, Integer> reactionTotals) {
        this.reactionTotals = reactionTotals;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public void setUnread(int unread) {
        this.unread = unread;
    }

    public void setBookmarked(boolean bookmarked) {
        this.bookmarked = bookmarked;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setAllowAnonymousPosts(boolean allowAnonymousPosts) {
        this.allowAnonymousPosts = allowAnonymousPosts;
    }

    public void setCreatorDisplayName(String creatorDisplayName) {
        this.creatorDisplayName = creatorDisplayName;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public void setCanPost(boolean canPost) {
        this.canPost = canPost;
    }

    public void setCanPin(boolean canPin) {
        this.canPin = canPin;
    }

    public void setCanBookmark(boolean canBookmark) {
        this.canBookmark = canBookmark;
    }

    public void setCanTag(boolean canTag) {
        this.canTag = canTag;
    }

    public void setCanReact(boolean canReact) {
        this.canReact = canReact;
    }

    public void setCanModerate(boolean canModerate) {
        this.canModerate = canModerate;
    }

    public void setMine(boolean isMine) {
        this.isMine = isMine;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
}

