/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.conversations.api.model.Post;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_COMMENTS", indexes={@Index(columnList="POST_ID"), @Index(columnList="SITE_ID")})
public class Comment
implements PersistableEntity<String> {
    @Id
    @Column(name="COMMENT_ID", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private String id;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="POST_ID", nullable=false)
    private Post post;
    @Column(name="MESSAGE", length=255, nullable=false)
    private String message;
    @Column(name="LOCKED")
    private Boolean locked = Boolean.FALSE;
    @Embedded
    private Metadata metadata;

    public String getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public Post getPost() {
        return this.post;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setPost(Post post) {
        this.post = post;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

