/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.conversations.api.model.Topic;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_POSTS", indexes={@Index(columnList="TOPIC_ID"), @Index(columnList="SITE_ID")})
public class Post
implements PersistableEntity<String> {
    @Id
    @Column(name="POST_ID", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private String id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TOPIC_ID", nullable=false)
    private Topic topic;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="PARENT_POST_ID")
    private Post parentPost;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @Lob
    @Column(name="MESSAGE", nullable=false)
    private String message;
    @Column(name="NUMBER_OF_COMMENTS")
    private Integer numberOfComments = 0;
    @Column(name="DRAFT")
    private Boolean draft = Boolean.FALSE;
    @Column(name="HIDDEN")
    private Boolean hidden = Boolean.FALSE;
    @Column(name="LOCKED")
    private Boolean locked = Boolean.FALSE;
    @Column(name="UPVOTES")
    private Integer upvotes = 0;
    @Column(name="PRIVATE_POST")
    private Boolean privatePost = Boolean.FALSE;
    @Column(name="ANONYMOUS")
    private Boolean anonymous = Boolean.FALSE;
    @Embedded
    private Metadata metadata;

    public String getId() {
        return this.id;
    }

    public Topic getTopic() {
        return this.topic;
    }

    public Post getParentPost() {
        return this.parentPost;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getNumberOfComments() {
        return this.numberOfComments;
    }

    public Boolean getDraft() {
        return this.draft;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Integer getUpvotes() {
        return this.upvotes;
    }

    public Boolean getPrivatePost() {
        return this.privatePost;
    }

    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public void setParentPost(Post parentPost) {
        this.parentPost = parentPost;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNumberOfComments(Integer numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setUpvotes(Integer upvotes) {
        this.upvotes = upvotes;
    }

    public void setPrivatePost(Boolean privatePost) {
        this.privatePost = privatePost;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

