/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.sakaiproject.conversations.api.TopicType;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_SETTINGS", indexes={@Index(columnList="SITE_ID", unique=true)})
public class Settings
implements PersistableEntity<Long> {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @Column(name="ALLOW_BOOKMARKING")
    private Boolean allowBookmarking = Boolean.TRUE;
    @Column(name="ALLOW_REACTIONS")
    private Boolean allowReactions = Boolean.TRUE;
    @Column(name="ALLOW_UPVOTING")
    private Boolean allowUpvoting = Boolean.FALSE;
    @Column(name="ALLOW_ANON_POSTING")
    private Boolean allowAnonPosting = Boolean.TRUE;
    @Column(name="ALLOW_PINNING")
    private Boolean allowPinning = Boolean.TRUE;
    @Column(name="SITE_LOCKED")
    private Boolean siteLocked = Boolean.FALSE;
    @Column(name="REQUIRE_GUIDELINES_AGREEMENT")
    private Boolean requireGuidelinesAgreement = Boolean.FALSE;
    @Lob
    @Column(name="GUIDELINES")
    private String guidelines = "";
    @Column(name="DEFAULT_TOPIC_TYPE", length=32)
    @Enumerated(value=EnumType.STRING)
    private TopicType defaultTopicType = TopicType.QUESTION;

    public Settings() {
    }

    public Settings(String siteId) {
        this.siteId = siteId;
    }

    public Long getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public Boolean getAllowBookmarking() {
        return this.allowBookmarking;
    }

    public Boolean getAllowReactions() {
        return this.allowReactions;
    }

    public Boolean getAllowUpvoting() {
        return this.allowUpvoting;
    }

    public Boolean getAllowAnonPosting() {
        return this.allowAnonPosting;
    }

    public Boolean getAllowPinning() {
        return this.allowPinning;
    }

    public Boolean getSiteLocked() {
        return this.siteLocked;
    }

    public Boolean getRequireGuidelinesAgreement() {
        return this.requireGuidelinesAgreement;
    }

    public String getGuidelines() {
        return this.guidelines;
    }

    public TopicType getDefaultTopicType() {
        return this.defaultTopicType;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setAllowBookmarking(Boolean allowBookmarking) {
        this.allowBookmarking = allowBookmarking;
    }

    public void setAllowReactions(Boolean allowReactions) {
        this.allowReactions = allowReactions;
    }

    public void setAllowUpvoting(Boolean allowUpvoting) {
        this.allowUpvoting = allowUpvoting;
    }

    public void setAllowAnonPosting(Boolean allowAnonPosting) {
        this.allowAnonPosting = allowAnonPosting;
    }

    public void setAllowPinning(Boolean allowPinning) {
        this.allowPinning = allowPinning;
    }

    public void setSiteLocked(Boolean siteLocked) {
        this.siteLocked = siteLocked;
    }

    public void setRequireGuidelinesAgreement(Boolean requireGuidelinesAgreement) {
        this.requireGuidelinesAgreement = requireGuidelinesAgreement;
    }

    public void setGuidelines(String guidelines) {
        this.guidelines = guidelines;
    }

    public void setDefaultTopicType(TopicType defaultTopicType) {
        this.defaultTopicType = defaultTopicType;
    }
}

