/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.sakaiproject.conversations.api.TopicType;
import org.sakaiproject.conversations.api.TopicVisibility;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_TOPICS", indexes={@Index(columnList="SITE_ID")})
public class Topic
implements PersistableEntity<String> {
    @Id
    @Column(name="TOPIC_ID", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private String id;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @Column(name="ABOUT_REFERENCE", length=255)
    private String aboutReference = "";
    @Column(name="TITLE", length=255, nullable=false)
    private String title;
    @Lob
    @Column(name="MESSAGE")
    private String message = "";
    @ElementCollection
    @CollectionTable(name="CONV_TOPIC_TAGS", joinColumns={@JoinColumn(name="TOPIC_ID")})
    @Column(name="TAG")
    private Set<Long> tagIds = new HashSet<Long>();
    @Column(name="TOPIC_TYPE", length=32)
    @Enumerated(value=EnumType.STRING)
    private TopicType type = TopicType.QUESTION;
    @Column(name="RESOLVED")
    private Boolean resolved = Boolean.FALSE;
    @Column(name="HOW_ACTIVE")
    private Integer howActive = 0;
    @Column(name="LAST_ACTIVITY")
    private Instant lastActivity;
    @Column(name="PINNED")
    private Boolean pinned = Boolean.FALSE;
    @Column(name="DRAFT")
    private Boolean draft = Boolean.FALSE;
    @Column(name="HIDDEN")
    private Boolean hidden = Boolean.FALSE;
    @Column(name="LOCKED")
    private Boolean locked = Boolean.FALSE;
    @Column(name="ANONYMOUS")
    private Boolean anonymous = Boolean.FALSE;
    @Column(name="ALLOW_ANONYMOUS_POSTS")
    private Boolean allowAnonymousPosts = Boolean.FALSE;
    @ElementCollection
    @CollectionTable(name="CONV_TOPIC_GROUPS", joinColumns={@JoinColumn(name="TOPIC_ID")})
    @Column(name="GROUP_ID")
    private Set<String> groups = new HashSet<String>();
    @Column(name="VISIBILITY", length=32)
    @Enumerated(value=EnumType.STRING)
    private TopicVisibility visibility = TopicVisibility.SITE;
    @Embedded
    private Metadata metadata;

    public String getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getAboutReference() {
        return this.aboutReference;
    }

    public String getTitle() {
        return this.title;
    }

    public String getMessage() {
        return this.message;
    }

    public Set<Long> getTagIds() {
        return this.tagIds;
    }

    public TopicType getType() {
        return this.type;
    }

    public Boolean getResolved() {
        return this.resolved;
    }

    public Integer getHowActive() {
        return this.howActive;
    }

    public Instant getLastActivity() {
        return this.lastActivity;
    }

    public Boolean getPinned() {
        return this.pinned;
    }

    public Boolean getDraft() {
        return this.draft;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public Boolean getAllowAnonymousPosts() {
        return this.allowAnonymousPosts;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public TopicVisibility getVisibility() {
        return this.visibility;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setAboutReference(String aboutReference) {
        this.aboutReference = aboutReference;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTagIds(Set<Long> tagIds) {
        this.tagIds = tagIds;
    }

    public void setType(TopicType type) {
        this.type = type;
    }

    public void setResolved(Boolean resolved) {
        this.resolved = resolved;
    }

    public void setHowActive(Integer howActive) {
        this.howActive = howActive;
    }

    public void setLastActivity(Instant lastActivity) {
        this.lastActivity = lastActivity;
    }

    public void setPinned(Boolean pinned) {
        this.pinned = pinned;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setAllowAnonymousPosts(Boolean allowAnonymousPosts) {
        this.allowAnonymousPosts = allowAnonymousPosts;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setVisibility(TopicVisibility visibility) {
        this.visibility = visibility;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

