/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sakaiproject.conversations.api.ConversationsPermissionsException;
import org.sakaiproject.conversations.api.PostSort;
import org.sakaiproject.conversations.api.Reaction;
import org.sakaiproject.conversations.api.beans.CommentTransferBean;
import org.sakaiproject.conversations.api.beans.PostTransferBean;
import org.sakaiproject.conversations.api.beans.TopicTransferBean;
import org.sakaiproject.conversations.api.model.ConvStatus;
import org.sakaiproject.conversations.api.model.ConversationsComment;
import org.sakaiproject.conversations.api.model.ConversationsPost;
import org.sakaiproject.conversations.api.model.ConversationsTopic;
import org.sakaiproject.conversations.api.model.Settings;
import org.sakaiproject.conversations.api.model.Tag;

public interface ConversationsService {
    public static final String TOOL_ID = "sakai.conversations";
    public static final String REFERENCE_ROOT = "/conversations";
    public static final String SORT_NAME_ASCENDING = "nameAscending";
    public static final String SORT_NAME_DESCENDING = "nameDescending";
    public static final String SORT_TOPICS_CREATED_ASCENDING = "topicsCreatedAscending";
    public static final String SORT_TOPICS_CREATED_DESCENDING = "topicsCreatedDescending";
    public static final String SORT_TOPICS_VIEWED_ASCENDING = "topicsViewedAscending";
    public static final String SORT_TOPICS_VIEWED_DESCENDING = "topicsViewedDescending";
    public static final String SORT_POSTS_CREATED_ASCENDING = "postsCreatedAscending";
    public static final String SORT_POSTS_CREATED_DESCENDING = "postsCreatedDescending";
    public static final String SORT_REACTIONS_MADE_ASCENDING = "reactionsMadeAscending";
    public static final String SORT_REACTIONS_MADE_DESCENDING = "reactionsMadeDescending";
    public static final String PROP_THREADS_PAGE_SIZE = "conversations.threads.page.size";
    public static final String PROP_MAX_THREAD_DEPTH = "conversations.max.thread.depth";
    public static final String PROP_DISABLE_DISCUSSIONS = "conversations.disable.discussions";
    public static final String STATS_CACHE_NAME = "conversationsSortedStatsCache";
    public static final String POSTS_CACHE_NAME = "conversationsPostsCache";

    public TopicTransferBean getBlankTopic(String var1) throws ConversationsPermissionsException;

    public Optional<TopicTransferBean> getTopic(String var1) throws ConversationsPermissionsException;

    public boolean currentUserCanViewTopic(ConversationsTopic var1);

    public List<TopicTransferBean> getTopicsForSite(String var1) throws ConversationsPermissionsException;

    public Optional<String> getTopicPortalUrl(String var1);

    public TopicTransferBean saveTopic(TopicTransferBean var1, boolean var2) throws ConversationsPermissionsException;

    public void deleteTopic(String var1) throws ConversationsPermissionsException;

    public void pinTopic(String var1, boolean var2) throws ConversationsPermissionsException;

    public TopicTransferBean lockTopic(String var1, boolean var2, boolean var3) throws ConversationsPermissionsException;

    public ConversationsTopic hideTopic(String var1, boolean var2, boolean var3) throws ConversationsPermissionsException;

    public void bookmarkTopic(String var1, boolean var2) throws ConversationsPermissionsException;

    public Map<Reaction, Integer> saveTopicReactions(String var1, Map<Reaction, Boolean> var2) throws ConversationsPermissionsException;

    public Optional<PostTransferBean> getPost(String var1) throws ConversationsPermissionsException;

    public PostTransferBean savePost(PostTransferBean var1, boolean var2) throws ConversationsPermissionsException;

    public Optional<String> getPostPortalUrl(String var1, String var2);

    public int getNumberOfThreadPages(String var1, String var2) throws ConversationsPermissionsException;

    public Collection<PostTransferBean> getPostsByTopicId(String var1, String var2, Integer var3, PostSort var4, String var5) throws ConversationsPermissionsException;

    public void deletePost(String var1, String var2, String var3, boolean var4) throws ConversationsPermissionsException;

    public PostTransferBean upvotePost(String var1, String var2, String var3) throws ConversationsPermissionsException;

    public PostTransferBean unUpvotePost(String var1, String var2) throws ConversationsPermissionsException;

    public PostTransferBean lockPost(String var1, String var2, String var3, boolean var4) throws ConversationsPermissionsException;

    public PostTransferBean hidePost(String var1, String var2, String var3, boolean var4) throws ConversationsPermissionsException;

    public Map<Reaction, Integer> savePostReactions(String var1, String var2, Map<Reaction, Boolean> var3) throws ConversationsPermissionsException;

    public void markPostsViewed(Set<String> var1, String var2) throws ConversationsPermissionsException;

    public boolean currentUserCanViewPost(ConversationsPost var1);

    public boolean currentUserCanViewComment(ConversationsComment var1);

    public Optional<CommentTransferBean> getComment(String var1) throws ConversationsPermissionsException;

    public CommentTransferBean saveComment(CommentTransferBean var1) throws ConversationsPermissionsException;

    public void deleteComment(String var1, String var2) throws ConversationsPermissionsException;

    public Optional<String> getCommentPortalUrl(String var1);

    public List<Tag> createTags(List<Tag> var1) throws ConversationsPermissionsException;

    public Tag saveTag(Tag var1) throws ConversationsPermissionsException;

    public List<Tag> getTagsForSite(String var1) throws ConversationsPermissionsException;

    public void deleteTag(Long var1) throws ConversationsPermissionsException;

    public Settings getSettingsForSite(String var1) throws ConversationsPermissionsException;

    public Settings saveSettings(Settings var1) throws ConversationsPermissionsException;

    public ConvStatus getConvStatusForSiteAndUser(String var1, String var2) throws ConversationsPermissionsException;

    public void saveConvStatus(ConvStatus var1) throws ConversationsPermissionsException;

    public Map<String, Object> getSiteStats(String var1, Instant var2, Instant var3, int var4, String var5) throws ConversationsPermissionsException;
}

