/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_POSTS", indexes={@Index(name="conv_posts_topic_idx", columnList="TOPIC_ID"), @Index(name="conv_posts_topic_creator_idx", columnList="TOPIC_ID, CREATOR"), @Index(name="conv_posts_site_idx", columnList="SITE_ID"), @Index(name="conv_posts_parent_post_idx", columnList="PARENT_POST_ID"), @Index(name="conv_posts_parent_thread_idx", columnList="PARENT_THREAD_ID")})
public class ConversationsPost
implements PersistableEntity<String> {
    @Id
    @Column(name="POST_ID", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private String id;
    @Column(name="TOPIC_ID", length=36, nullable=false)
    private String topicId;
    @Column(name="PARENT_POST_ID", length=36)
    private String parentPostId;
    @Column(name="PARENT_THREAD_ID", length=36)
    private String parentThreadId;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @Lob
    @Column(name="MESSAGE", nullable=false)
    private String message;
    @Column(name="NUMBER_OF_COMMENTS")
    private Integer numberOfComments = 0;
    @Column(name="NUMBER_OF_THREAD_REPLIES")
    private Integer numberOfThreadReplies = 0;
    @Column(name="NUMBER_OF_THREAD_REACTIONS")
    private Integer numberOfThreadReactions = 0;
    @Column(name="DEPTH")
    private Integer depth = 1;
    @Column(name="HOW_ACTIVE")
    private Integer howActive = 0;
    @Column(name="DRAFT")
    private Boolean draft = Boolean.FALSE;
    @Column(name="HIDDEN")
    private Boolean hidden = Boolean.FALSE;
    @Column(name="LOCKED")
    private Boolean locked = Boolean.FALSE;
    @Column(name="UPVOTES")
    private Integer upvotes = 0;
    @Column(name="PRIVATE_POST")
    private Boolean privatePost = Boolean.FALSE;
    @Column(name="ANONYMOUS")
    private Boolean anonymous = Boolean.FALSE;
    @Embedded
    private Metadata metadata;

    public String getId() {
        return this.id;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getParentPostId() {
        return this.parentPostId;
    }

    public String getParentThreadId() {
        return this.parentThreadId;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getMessage() {
        return this.message;
    }

    public Integer getNumberOfComments() {
        return this.numberOfComments;
    }

    public Integer getNumberOfThreadReplies() {
        return this.numberOfThreadReplies;
    }

    public Integer getNumberOfThreadReactions() {
        return this.numberOfThreadReactions;
    }

    public Integer getDepth() {
        return this.depth;
    }

    public Integer getHowActive() {
        return this.howActive;
    }

    public Boolean getDraft() {
        return this.draft;
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Integer getUpvotes() {
        return this.upvotes;
    }

    public Boolean getPrivatePost() {
        return this.privatePost;
    }

    public Boolean getAnonymous() {
        return this.anonymous;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public void setParentPostId(String parentPostId) {
        this.parentPostId = parentPostId;
    }

    public void setParentThreadId(String parentThreadId) {
        this.parentThreadId = parentThreadId;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNumberOfComments(Integer numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    public void setNumberOfThreadReplies(Integer numberOfThreadReplies) {
        this.numberOfThreadReplies = numberOfThreadReplies;
    }

    public void setNumberOfThreadReactions(Integer numberOfThreadReactions) {
        this.numberOfThreadReactions = numberOfThreadReactions;
    }

    public void setDepth(Integer depth) {
        this.depth = depth;
    }

    public void setHowActive(Integer howActive) {
        this.howActive = howActive;
    }

    public void setDraft(Boolean draft) {
        this.draft = draft;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setUpvotes(Integer upvotes) {
        this.upvotes = upvotes;
    }

    public void setPrivatePost(Boolean privatePost) {
        this.privatePost = privatePost;
    }

    public void setAnonymous(Boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

