/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_TOPIC_STATUS", uniqueConstraints={@UniqueConstraint(name="UniqueTopicStatus", columnNames={"TOPIC_ID", "USER_ID"})}, indexes={@Index(name="conv_topic_status_topic_user_idx", columnList="TOPIC_ID, USER_ID")})
public class TopicStatus
implements PersistableEntity<Long> {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @Column(name="SITE_ID", nullable=false)
    private String siteId;
    @Column(name="TOPIC_ID", length=36, nullable=false)
    private String topicId;
    @Column(name="USER_ID", length=99, nullable=false)
    private String userId;
    @Column(name="BOOKMARKED")
    private Boolean bookmarked = Boolean.FALSE;
    @Column(name="UNREAD")
    private Integer unread = 0;
    @Column(name="POSTED")
    private Boolean posted = Boolean.FALSE;
    @Column(name="VIEWED")
    private Boolean viewed = Boolean.FALSE;

    public TopicStatus() {
    }

    public TopicStatus(String siteId, String topicId, String userId) {
        this.siteId = siteId;
        this.topicId = topicId;
        this.userId = userId;
    }

    public Long getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getBookmarked() {
        return this.bookmarked;
    }

    public Integer getUnread() {
        return this.unread;
    }

    public Boolean getPosted() {
        return this.posted;
    }

    public Boolean getViewed() {
        return this.viewed;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBookmarked(Boolean bookmarked) {
        this.bookmarked = bookmarked;
    }

    public void setUnread(Integer unread) {
        this.unread = unread;
    }

    public void setPosted(Boolean posted) {
        this.posted = posted;
    }

    public void setViewed(Boolean viewed) {
        this.viewed = viewed;
    }
}

