/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_POST_STATUS", indexes={@Index(name="conv_post_status_user_idx", columnList="USER_ID"), @Index(name="conv_post_status_post_idx", columnList="POST_ID"), @Index(name="conv_post_status_post_user_idx", columnList="POST_ID, USER_ID"), @Index(name="conv_post_status_topic_user_idx", columnList="TOPIC_ID, USER_ID")}, uniqueConstraints={@UniqueConstraint(name="UniquePostStatus", columnNames={"POST_ID", "USER_ID"})})
public class PostStatus
implements PersistableEntity<Long> {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @Column(name="TOPIC_ID", length=36, nullable=false)
    private String topicId;
    @Column(name="POST_ID", length=36, nullable=false)
    private String postId;
    @Column(name="USER_ID", length=99, nullable=false)
    private String userId;
    @Column(name="VIEWED_DATE")
    private Instant viewedDate;
    @Column(name="VIEWED")
    private Boolean viewed = Boolean.FALSE;
    @Column(name="UPVOTED")
    private Boolean upvoted = Boolean.FALSE;

    public PostStatus() {
    }

    public PostStatus(String topicId, String postId, String userId) {
        this.topicId = topicId;
        this.postId = postId;
        this.userId = userId;
    }

    public Long getId() {
        return this.id;
    }

    public String getTopicId() {
        return this.topicId;
    }

    public String getPostId() {
        return this.postId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Instant getViewedDate() {
        return this.viewedDate;
    }

    public Boolean getViewed() {
        return this.viewed;
    }

    public Boolean getUpvoted() {
        return this.upvoted;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTopicId(String topicId) {
        this.topicId = topicId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setViewedDate(Instant viewedDate) {
        this.viewedDate = viewedDate;
    }

    public void setViewed(Boolean viewed) {
        this.viewed = viewed;
    }

    public void setUpvoted(Boolean upvoted) {
        this.upvoted = upvoted;
    }
}

