/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api;

import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.conversations.api.model.ConversationsComment;
import org.sakaiproject.conversations.api.model.ConversationsPost;
import org.sakaiproject.conversations.api.model.ConversationsTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationsReferenceReckoner {
    private static final Logger log = LoggerFactory.getLogger(ConversationsReferenceReckoner.class);

    public static ConversationsReference referenceReckoner(ConversationsTopic topic, ConversationsPost post, ConversationsComment comment, String siteId, String type, String id, String reference) {
        if (StringUtils.startsWith((CharSequence)reference, (CharSequence)"/conversations")) {
            String[] parts = StringUtils.splitPreserveAllTokens((String)reference, (String)"/");
            if (siteId == null) {
                siteId = parts[2];
            }
            type = parts[3];
            if (id == null) {
                id = parts[4];
            }
        } else if (topic != null) {
            siteId = topic.getSiteId();
            type = "t";
            id = topic.getId();
        } else if (post != null) {
            siteId = post.getSiteId();
            type = "p";
            id = post.getId();
        } else if (comment != null) {
            siteId = comment.getSiteId();
            type = "c";
            id = comment.getId();
        }
        return new ConversationsReference(siteId == null ? "" : siteId, type, id == null ? "" : id);
    }

    public static ConversationsReferenceBuilder reckoner() {
        return new ConversationsReferenceBuilder();
    }

    public static class ConversationsReferenceBuilder {
        private ConversationsTopic topic;
        private ConversationsPost post;
        private ConversationsComment comment;
        private String siteId;
        private String type;
        private String id;
        private String reference;

        ConversationsReferenceBuilder() {
        }

        public ConversationsReferenceBuilder topic(ConversationsTopic topic) {
            this.topic = topic;
            return this;
        }

        public ConversationsReferenceBuilder post(ConversationsPost post) {
            this.post = post;
            return this;
        }

        public ConversationsReferenceBuilder comment(ConversationsComment comment) {
            this.comment = comment;
            return this;
        }

        public ConversationsReferenceBuilder siteId(String siteId) {
            this.siteId = siteId;
            return this;
        }

        public ConversationsReferenceBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ConversationsReferenceBuilder id(String id) {
            this.id = id;
            return this;
        }

        public ConversationsReferenceBuilder reference(String reference) {
            this.reference = reference;
            return this;
        }

        public ConversationsReference reckon() {
            return ConversationsReferenceReckoner.referenceReckoner(this.topic, this.post, this.comment, this.siteId, this.type, this.id, this.reference);
        }

        public String toString() {
            return "ConversationsReferenceReckoner.ConversationsReferenceBuilder(topic=" + this.topic + ", post=" + this.post + ", comment=" + this.comment + ", siteId=" + this.siteId + ", type=" + this.type + ", id=" + this.id + ", reference=" + this.reference + ")";
        }
    }

    public static final class ConversationsReference {
        private final String siteId;
        private final String type;
        private final String id;

        public String toString() {
            Object reference = "/conversations";
            switch (this.type) {
                case "p": {
                    reference = (String)reference + "/" + this.siteId + "/p/" + this.id;
                    break;
                }
                case "c": {
                    reference = (String)reference + "/" + this.siteId + "/c/" + this.id;
                    break;
                }
                default: {
                    reference = (String)reference + "/" + this.siteId + "/t/" + this.id;
                }
            }
            return reference;
        }

        public String getReference() {
            return this.toString();
        }

        public ConversationsReference(String siteId, String type, String id) {
            this.siteId = siteId;
            this.type = type;
            this.id = id;
        }

        public String getSiteId() {
            return this.siteId;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConversationsReference)) {
                return false;
            }
            ConversationsReference other = (ConversationsReference)o;
            String this$siteId = this.getSiteId();
            String other$siteId = other.getSiteId();
            if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $siteId = this.getSiteId();
            result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }
    }
}

