/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.beans;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sakaiproject.conversations.api.Reaction;
import org.sakaiproject.conversations.api.TopicType;
import org.sakaiproject.conversations.api.TopicVisibility;
import org.sakaiproject.conversations.api.model.ConversationsTopic;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.conversations.api.model.Tag;
import org.sakaiproject.entity.api.Entity;

public class TopicTransferBean
implements Entity {
    public String id;
    public String title;
    public String siteId;
    public String aboutReference;
    public String message;
    public long numberOfPosts;
    public long numberOfThreads;
    public long numberOfUnreadPosts;
    public String creator;
    public Instant created;
    public String formattedCreatedDate;
    public String modifier;
    public Instant modified;
    public String formattedModifiedDate;
    public boolean pinned;
    public boolean locked;
    public boolean hidden;
    public boolean mustPostBeforeViewing;
    public boolean hasPosted;
    public boolean resolved;
    public List<Tag> tags = new ArrayList<Tag>();
    public Map<Reaction, Boolean> myReactions = new HashMap<Reaction, Boolean>();
    public Map<Reaction, Integer> reactionTotals = new HashMap<Reaction, Integer>();
    public Set<String> groups = new HashSet<String>();
    public String type = TopicType.QUESTION.name();
    public String visibility = TopicVisibility.SITE.name();
    public Instant showDate;
    public Instant hideDate;
    public Instant lockDate;
    public Instant dueDate;
    public String dueDateCalendarEventId;
    public String showMessageScheduleId;
    public boolean pastDueDate;
    public String formattedDueDate;
    public boolean bookmarked;
    public boolean draft;
    public boolean anonymous;
    public boolean allowAnonymousPosts;
    public boolean hiddenByDate;
    public boolean lockedByDate;
    public String creatorDisplayName;
    public boolean canEdit;
    public boolean canDelete;
    public boolean canPost;
    public boolean canPin;
    public boolean canBookmark;
    public boolean canTag;
    public boolean canReact;
    public boolean canModerate;
    public boolean isMine;
    public String availability;
    public String url;
    public String portalUrl;
    public String reference;

    public static TopicTransferBean of(ConversationsTopic topic) {
        TopicTransferBean topicBean = new TopicTransferBean();
        topicBean.id = topic.getId();
        topicBean.title = topic.getTitle();
        topicBean.siteId = topic.getSiteId();
        topicBean.aboutReference = topic.getAboutReference();
        topicBean.message = topic.getMessage();
        Metadata metadata = topic.getMetadata();
        topicBean.creator = metadata.getCreator();
        topicBean.created = metadata.getCreated();
        topicBean.modifier = metadata.getModifier();
        topicBean.modified = metadata.getModified();
        topicBean.pinned = topic.getPinned();
        topicBean.locked = topic.getLocked();
        topicBean.mustPostBeforeViewing = topic.getMustPostBeforeViewing();
        topicBean.hidden = topic.getHidden();
        topicBean.resolved = topic.getResolved();
        topicBean.type = topic.getType().name();
        topicBean.visibility = topic.getVisibility().name();
        topicBean.showDate = topic.getShowDate();
        topicBean.hideDate = topic.getHideDate();
        topicBean.lockDate = topic.getLockDate();
        topicBean.dueDate = topic.getDueDate();
        topicBean.pastDueDate = topicBean.dueDate != null && topicBean.dueDate.isBefore(Instant.now());
        topicBean.dueDateCalendarEventId = topic.getDueDateCalendarEventId();
        topicBean.showMessageScheduleId = topic.getShowMessageScheduleId();
        topicBean.draft = topic.getDraft();
        topicBean.anonymous = topic.getAnonymous();
        topicBean.allowAnonymousPosts = topic.getAllowAnonymousPosts();
        topicBean.groups = topic.getGroups();
        Instant now = Instant.now();
        topicBean.hiddenByDate = topic.getHideDate() != null ? topic.getHideDate().isBefore(now) : false;
        topicBean.lockedByDate = topic.getLockDate() != null ? topic.getLockDate().isBefore(now) : false;
        return topicBean;
    }

    public ConversationsTopic asTopic() {
        ConversationsTopic topic = new ConversationsTopic();
        topic.setId(this.id);
        topic.setSiteId(this.siteId);
        topic.setTitle(this.title);
        topic.setAboutReference(this.aboutReference);
        topic.setMessage(this.message);
        topic.setResolved(this.resolved);
        Metadata metadata = new Metadata();
        metadata.setCreator(this.creator);
        metadata.setCreated(this.created);
        metadata.setModifier(this.modifier);
        metadata.setModified(this.modified);
        topic.setMetadata(metadata);
        topic.setTagIds(this.tags.stream().map(t -> t.getId()).collect(Collectors.toSet()));
        topic.setGroups(this.groups);
        topic.setPinned(this.pinned);
        topic.setLocked(this.locked);
        topic.setMustPostBeforeViewing(this.mustPostBeforeViewing);
        topic.setHidden(this.hidden);
        topic.setType(Enum.valueOf(TopicType.class, this.type));
        topic.setVisibility(Enum.valueOf(TopicVisibility.class, this.visibility));
        topic.setShowDate(this.showDate);
        topic.setHideDate(this.hideDate);
        topic.setLockDate(this.lockDate);
        topic.setDueDate(this.dueDate);
        topic.setDraft(this.draft);
        topic.setAnonymous(this.anonymous);
        topic.setAllowAnonymousPosts(this.allowAnonymousPosts);
        topic.setDueDateCalendarEventId(this.dueDateCalendarEventId);
        topic.setShowMessageScheduleId(this.showMessageScheduleId);
        return topic;
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getAboutReference() {
        return this.aboutReference;
    }

    public String getMessage() {
        return this.message;
    }

    public long getNumberOfPosts() {
        return this.numberOfPosts;
    }

    public long getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public long getNumberOfUnreadPosts() {
        return this.numberOfUnreadPosts;
    }

    public String getCreator() {
        return this.creator;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getFormattedCreatedDate() {
        return this.formattedCreatedDate;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Instant getModified() {
        return this.modified;
    }

    public String getFormattedModifiedDate() {
        return this.formattedModifiedDate;
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isMustPostBeforeViewing() {
        return this.mustPostBeforeViewing;
    }

    public boolean isHasPosted() {
        return this.hasPosted;
    }

    public boolean isResolved() {
        return this.resolved;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public Map<Reaction, Boolean> getMyReactions() {
        return this.myReactions;
    }

    public Map<Reaction, Integer> getReactionTotals() {
        return this.reactionTotals;
    }

    public Set<String> getGroups() {
        return this.groups;
    }

    public String getType() {
        return this.type;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public Instant getShowDate() {
        return this.showDate;
    }

    public Instant getHideDate() {
        return this.hideDate;
    }

    public Instant getLockDate() {
        return this.lockDate;
    }

    public Instant getDueDate() {
        return this.dueDate;
    }

    public String getDueDateCalendarEventId() {
        return this.dueDateCalendarEventId;
    }

    public String getShowMessageScheduleId() {
        return this.showMessageScheduleId;
    }

    public boolean isPastDueDate() {
        return this.pastDueDate;
    }

    public String getFormattedDueDate() {
        return this.formattedDueDate;
    }

    public boolean isBookmarked() {
        return this.bookmarked;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isAllowAnonymousPosts() {
        return this.allowAnonymousPosts;
    }

    public boolean isHiddenByDate() {
        return this.hiddenByDate;
    }

    public boolean isLockedByDate() {
        return this.lockedByDate;
    }

    public String getCreatorDisplayName() {
        return this.creatorDisplayName;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public boolean isCanDelete() {
        return this.canDelete;
    }

    public boolean isCanPost() {
        return this.canPost;
    }

    public boolean isCanPin() {
        return this.canPin;
    }

    public boolean isCanBookmark() {
        return this.canBookmark;
    }

    public boolean isCanTag() {
        return this.canTag;
    }

    public boolean isCanReact() {
        return this.canReact;
    }

    public boolean isCanModerate() {
        return this.canModerate;
    }

    public boolean isMine() {
        return this.isMine;
    }

    public String getAvailability() {
        return this.availability;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPortalUrl() {
        return this.portalUrl;
    }

    public String getReference() {
        return this.reference;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setAboutReference(String aboutReference) {
        this.aboutReference = aboutReference;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNumberOfPosts(long numberOfPosts) {
        this.numberOfPosts = numberOfPosts;
    }

    public void setNumberOfThreads(long numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public void setNumberOfUnreadPosts(long numberOfUnreadPosts) {
        this.numberOfUnreadPosts = numberOfUnreadPosts;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setFormattedCreatedDate(String formattedCreatedDate) {
        this.formattedCreatedDate = formattedCreatedDate;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    public void setFormattedModifiedDate(String formattedModifiedDate) {
        this.formattedModifiedDate = formattedModifiedDate;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setMustPostBeforeViewing(boolean mustPostBeforeViewing) {
        this.mustPostBeforeViewing = mustPostBeforeViewing;
    }

    public void setHasPosted(boolean hasPosted) {
        this.hasPosted = hasPosted;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public void setMyReactions(Map<Reaction, Boolean> myReactions) {
        this.myReactions = myReactions;
    }

    public void setReactionTotals(Map<Reaction, Integer> reactionTotals) {
        this.reactionTotals = reactionTotals;
    }

    public void setGroups(Set<String> groups) {
        this.groups = groups;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public void setShowDate(Instant showDate) {
        this.showDate = showDate;
    }

    public void setHideDate(Instant hideDate) {
        this.hideDate = hideDate;
    }

    public void setLockDate(Instant lockDate) {
        this.lockDate = lockDate;
    }

    public void setDueDate(Instant dueDate) {
        this.dueDate = dueDate;
    }

    public void setDueDateCalendarEventId(String dueDateCalendarEventId) {
        this.dueDateCalendarEventId = dueDateCalendarEventId;
    }

    public void setShowMessageScheduleId(String showMessageScheduleId) {
        this.showMessageScheduleId = showMessageScheduleId;
    }

    public void setPastDueDate(boolean pastDueDate) {
        this.pastDueDate = pastDueDate;
    }

    public void setFormattedDueDate(String formattedDueDate) {
        this.formattedDueDate = formattedDueDate;
    }

    public void setBookmarked(boolean bookmarked) {
        this.bookmarked = bookmarked;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setAllowAnonymousPosts(boolean allowAnonymousPosts) {
        this.allowAnonymousPosts = allowAnonymousPosts;
    }

    public void setHiddenByDate(boolean hiddenByDate) {
        this.hiddenByDate = hiddenByDate;
    }

    public void setLockedByDate(boolean lockedByDate) {
        this.lockedByDate = lockedByDate;
    }

    public void setCreatorDisplayName(String creatorDisplayName) {
        this.creatorDisplayName = creatorDisplayName;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public void setCanPost(boolean canPost) {
        this.canPost = canPost;
    }

    public void setCanPin(boolean canPin) {
        this.canPin = canPin;
    }

    public void setCanBookmark(boolean canBookmark) {
        this.canBookmark = canBookmark;
    }

    public void setCanTag(boolean canTag) {
        this.canTag = canTag;
    }

    public void setCanReact(boolean canReact) {
        this.canReact = canReact;
    }

    public void setCanModerate(boolean canModerate) {
        this.canModerate = canModerate;
    }

    public void setMine(boolean isMine) {
        this.isMine = isMine;
    }

    public void setAvailability(String availability) {
        this.availability = availability;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPortalUrl(String portalUrl) {
        this.portalUrl = portalUrl;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
}

