/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.beans;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.conversations.api.Reaction;
import org.sakaiproject.conversations.api.beans.CommentTransferBean;
import org.sakaiproject.conversations.api.model.ConversationsPost;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.entity.api.Entity;

public class PostTransferBean
implements Entity {
    public String id;
    public String message;
    public int numberOfComments;
    public int numberOfThreadReactions;
    public int howActive;
    public List<CommentTransferBean> comments = new ArrayList<CommentTransferBean>();
    public String creator;
    public Instant created;
    public String formattedCreatedDate;
    public String siteId;
    public String modifier;
    public Instant modified;
    public String formattedModifiedDate;
    public Map<Reaction, Boolean> myReactions = new HashMap<Reaction, Boolean>();
    public Map<Reaction, Integer> reactionTotals = new HashMap<Reaction, Integer>();
    public boolean locked;
    public boolean hidden;
    public boolean draft;
    public boolean anonymous;
    public boolean isMine;
    public boolean privatePost;
    public int upvotes;
    public int depth;
    public String topic;
    public String parentPost;
    public boolean parentIsPrivate;
    public String parentThread;
    public boolean isThread;
    public List<PostTransferBean> posts = new ArrayList<PostTransferBean>();
    public String creatorDisplayName;
    public String verifierDisplayName;
    public boolean viewed;
    public boolean upvoted;
    public boolean canView;
    public boolean canEdit;
    public boolean canDelete;
    public boolean canReply;
    public boolean canComment;
    public boolean canUpvote;
    public boolean canViewUpvotes;
    public boolean canReact;
    public boolean canModerate;
    public boolean isInstructor;
    public boolean late;
    public String url;
    public String portalUrl;
    public String reference;

    public void clear() {
        this.message = "";
        this.comments = Collections.emptyList();
        this.creator = "blank";
        this.creatorDisplayName = "";
        this.verifierDisplayName = "";
        this.formattedCreatedDate = "";
        this.canEdit = false;
        this.canDelete = false;
        this.canModerate = false;
        this.canReact = false;
        this.canReply = false;
    }

    public static PostTransferBean of(ConversationsPost post) {
        PostTransferBean postBean = new PostTransferBean();
        postBean.id = post.getId();
        postBean.message = post.getMessage();
        postBean.numberOfComments = post.getNumberOfComments();
        postBean.numberOfThreadReactions = post.getNumberOfThreadReactions();
        postBean.howActive = post.getHowActive();
        Metadata metadata = post.getMetadata();
        postBean.creator = metadata.getCreator();
        postBean.created = metadata.getCreated();
        postBean.modifier = metadata.getModifier();
        postBean.modified = metadata.getModified();
        postBean.hidden = post.getHidden();
        postBean.locked = post.getLocked();
        postBean.draft = post.getDraft();
        postBean.siteId = post.getSiteId();
        postBean.privatePost = post.getPrivatePost();
        postBean.upvotes = post.getUpvotes();
        postBean.depth = post.getDepth();
        postBean.topic = post.getTopicId();
        postBean.anonymous = post.getAnonymous();
        postBean.parentPost = post.getParentPostId();
        postBean.parentThread = post.getParentThreadId();
        postBean.isThread = StringUtils.isBlank((CharSequence)postBean.parentPost);
        return postBean;
    }

    public ConversationsPost asPost() {
        ConversationsPost post = new ConversationsPost();
        post.setId(this.id);
        post.setMessage(this.message);
        post.setNumberOfComments(this.numberOfComments);
        post.setNumberOfThreadReactions(this.numberOfThreadReactions);
        post.setHowActive(this.howActive);
        Metadata metadata = new Metadata();
        metadata.setCreator(this.creator);
        metadata.setCreated(this.created);
        metadata.setModifier(this.modifier);
        metadata.setModified(this.modified);
        post.setMetadata(metadata);
        post.setSiteId(this.siteId);
        post.setHidden(this.hidden);
        post.setLocked(this.locked);
        post.setDraft(this.draft);
        post.setUpvotes(this.upvotes);
        post.setDepth(this.depth);
        post.setPrivatePost(this.privatePost);
        post.setAnonymous(this.anonymous);
        post.setParentThreadId(this.parentThread);
        post.setParentPostId(this.parentPost);
        return post;
    }

    public String getId() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public int getNumberOfComments() {
        return this.numberOfComments;
    }

    public int getNumberOfThreadReactions() {
        return this.numberOfThreadReactions;
    }

    public int getHowActive() {
        return this.howActive;
    }

    public List<CommentTransferBean> getComments() {
        return this.comments;
    }

    public String getCreator() {
        return this.creator;
    }

    public Instant getCreated() {
        return this.created;
    }

    public String getFormattedCreatedDate() {
        return this.formattedCreatedDate;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Instant getModified() {
        return this.modified;
    }

    public String getFormattedModifiedDate() {
        return this.formattedModifiedDate;
    }

    public Map<Reaction, Boolean> getMyReactions() {
        return this.myReactions;
    }

    public Map<Reaction, Integer> getReactionTotals() {
        return this.reactionTotals;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public boolean isMine() {
        return this.isMine;
    }

    public boolean isPrivatePost() {
        return this.privatePost;
    }

    public int getUpvotes() {
        return this.upvotes;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getParentPost() {
        return this.parentPost;
    }

    public boolean isParentIsPrivate() {
        return this.parentIsPrivate;
    }

    public String getParentThread() {
        return this.parentThread;
    }

    public boolean isThread() {
        return this.isThread;
    }

    public List<PostTransferBean> getPosts() {
        return this.posts;
    }

    public String getCreatorDisplayName() {
        return this.creatorDisplayName;
    }

    public String getVerifierDisplayName() {
        return this.verifierDisplayName;
    }

    public boolean isViewed() {
        return this.viewed;
    }

    public boolean isUpvoted() {
        return this.upvoted;
    }

    public boolean isCanView() {
        return this.canView;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public boolean isCanDelete() {
        return this.canDelete;
    }

    public boolean isCanReply() {
        return this.canReply;
    }

    public boolean isCanComment() {
        return this.canComment;
    }

    public boolean isCanUpvote() {
        return this.canUpvote;
    }

    public boolean isCanViewUpvotes() {
        return this.canViewUpvotes;
    }

    public boolean isCanReact() {
        return this.canReact;
    }

    public boolean isCanModerate() {
        return this.canModerate;
    }

    public boolean isInstructor() {
        return this.isInstructor;
    }

    public boolean isLate() {
        return this.late;
    }

    public String getUrl() {
        return this.url;
    }

    public String getPortalUrl() {
        return this.portalUrl;
    }

    public String getReference() {
        return this.reference;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setNumberOfComments(int numberOfComments) {
        this.numberOfComments = numberOfComments;
    }

    public void setNumberOfThreadReactions(int numberOfThreadReactions) {
        this.numberOfThreadReactions = numberOfThreadReactions;
    }

    public void setHowActive(int howActive) {
        this.howActive = howActive;
    }

    public void setComments(List<CommentTransferBean> comments) {
        this.comments = comments;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setCreated(Instant created) {
        this.created = created;
    }

    public void setFormattedCreatedDate(String formattedCreatedDate) {
        this.formattedCreatedDate = formattedCreatedDate;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public void setModified(Instant modified) {
        this.modified = modified;
    }

    public void setFormattedModifiedDate(String formattedModifiedDate) {
        this.formattedModifiedDate = formattedModifiedDate;
    }

    public void setMyReactions(Map<Reaction, Boolean> myReactions) {
        this.myReactions = myReactions;
    }

    public void setReactionTotals(Map<Reaction, Integer> reactionTotals) {
        this.reactionTotals = reactionTotals;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public void setMine(boolean isMine) {
        this.isMine = isMine;
    }

    public void setPrivatePost(boolean privatePost) {
        this.privatePost = privatePost;
    }

    public void setUpvotes(int upvotes) {
        this.upvotes = upvotes;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setParentPost(String parentPost) {
        this.parentPost = parentPost;
    }

    public void setParentIsPrivate(boolean parentIsPrivate) {
        this.parentIsPrivate = parentIsPrivate;
    }

    public void setParentThread(String parentThread) {
        this.parentThread = parentThread;
    }

    public void setThread(boolean isThread) {
        this.isThread = isThread;
    }

    public void setPosts(List<PostTransferBean> posts) {
        this.posts = posts;
    }

    public void setCreatorDisplayName(String creatorDisplayName) {
        this.creatorDisplayName = creatorDisplayName;
    }

    public void setVerifierDisplayName(String verifierDisplayName) {
        this.verifierDisplayName = verifierDisplayName;
    }

    public void setViewed(boolean viewed) {
        this.viewed = viewed;
    }

    public void setUpvoted(boolean upvoted) {
        this.upvoted = upvoted;
    }

    public void setCanView(boolean canView) {
        this.canView = canView;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public void setCanReply(boolean canReply) {
        this.canReply = canReply;
    }

    public void setCanComment(boolean canComment) {
        this.canComment = canComment;
    }

    public void setCanUpvote(boolean canUpvote) {
        this.canUpvote = canUpvote;
    }

    public void setCanViewUpvotes(boolean canViewUpvotes) {
        this.canViewUpvotes = canViewUpvotes;
    }

    public void setCanReact(boolean canReact) {
        this.canReact = canReact;
    }

    public void setCanModerate(boolean canModerate) {
        this.canModerate = canModerate;
    }

    public void setInstructor(boolean isInstructor) {
        this.isInstructor = isInstructor;
    }

    public void setLate(boolean late) {
        this.late = late;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setPortalUrl(String portalUrl) {
        this.portalUrl = portalUrl;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }
}

