/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.conversations.api.Reaction;
import org.sakaiproject.conversations.api.model.ConversationsPost;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_POST_REACTIONS", uniqueConstraints={@UniqueConstraint(name="UniquePostReactions", columnNames={"POST_ID", "USER_ID", "REACTION"})}, indexes={@Index(name="conv_post_reactions_post_idx", columnList="POST_ID"), @Index(name="conv_post_reactions_post_user_idx", columnList="POST_ID, USER_ID")})
public class PostReaction
implements PersistableEntity<Long> {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="POST_ID")
    private ConversationsPost post;
    @Column(name="USER_ID", length=99, nullable=false)
    private String userId;
    @Column(name="REACTION", nullable=false)
    private Reaction reaction;
    @Column(name="REACTION_STATE")
    private Boolean state = Boolean.FALSE;

    public Long getId() {
        return this.id;
    }

    public ConversationsPost getPost() {
        return this.post;
    }

    public String getUserId() {
        return this.userId;
    }

    public Reaction getReaction() {
        return this.reaction;
    }

    public Boolean getState() {
        return this.state;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setPost(ConversationsPost post) {
        this.post = post;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setReaction(Reaction reaction) {
        this.reaction = reaction;
    }

    public void setState(Boolean state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostReaction)) {
            return false;
        }
        PostReaction other = (PostReaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConversationsPost this$post = this.getPost();
        ConversationsPost other$post = other.getPost();
        if (this$post == null ? other$post != null : !((Object)this$post).equals(other$post)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Reaction this$reaction = this.getReaction();
        Reaction other$reaction = other.getReaction();
        return !(this$reaction == null ? other$reaction != null : !((Object)((Object)this$reaction)).equals((Object)other$reaction));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostReaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversationsPost $post = this.getPost();
        result = result * 59 + ($post == null ? 43 : ((Object)$post).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Reaction $reaction = this.getReaction();
        result = result * 59 + ($reaction == null ? 43 : ((Object)((Object)$reaction)).hashCode());
        return result;
    }
}

