/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.conversations.api.model.ConversationsTopic;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_TOPIC_STATUS", uniqueConstraints={@UniqueConstraint(name="UniqueTopicStatus", columnNames={"TOPIC_ID", "USER_ID"})}, indexes={@Index(name="conv_topic_status_topic_user_idx", columnList="TOPIC_ID, USER_ID")})
public class TopicStatus
implements PersistableEntity<Long> {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @JoinColumn(name="TOPIC_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private ConversationsTopic topic;
    @Column(name="USER_ID", length=99, nullable=false)
    private String userId;
    @Column(name="BOOKMARKED")
    private Boolean bookmarked = Boolean.FALSE;
    @Column(name="UNREAD")
    private Integer unread = 0;
    @Column(name="POSTED")
    private Boolean posted = Boolean.FALSE;
    @Column(name="VIEWED")
    private Boolean viewed = Boolean.FALSE;

    public TopicStatus() {
    }

    public TopicStatus(ConversationsTopic topic, String userId) {
        this.topic = topic;
        this.userId = userId;
    }

    public Long getId() {
        return this.id;
    }

    public ConversationsTopic getTopic() {
        return this.topic;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getBookmarked() {
        return this.bookmarked;
    }

    public Integer getUnread() {
        return this.unread;
    }

    public Boolean getPosted() {
        return this.posted;
    }

    public Boolean getViewed() {
        return this.viewed;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTopic(ConversationsTopic topic) {
        this.topic = topic;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setBookmarked(Boolean bookmarked) {
        this.bookmarked = bookmarked;
    }

    public void setUnread(Integer unread) {
        this.unread = unread;
    }

    public void setPosted(Boolean posted) {
        this.posted = posted;
    }

    public void setViewed(Boolean viewed) {
        this.viewed = viewed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TopicStatus)) {
            return false;
        }
        TopicStatus other = (TopicStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConversationsTopic this$topic = this.getTopic();
        ConversationsTopic other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !((Object)this$topic).equals(other$topic)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TopicStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversationsTopic $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : ((Object)$topic).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }
}

