/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_STATUS", uniqueConstraints={@UniqueConstraint(name="UniqueConvStatus", columnNames={"SITE_ID", "USER_ID"})})
public class ConvStatus
implements PersistableEntity<Long> {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @Column(name="USER_ID", length=99, nullable=false)
    private String userId;
    @Column(name="GUIDELINES_AGREED")
    private Boolean guidelinesAgreed = Boolean.FALSE;

    public ConvStatus() {
    }

    public ConvStatus(String siteId, String userId) {
        this.siteId = siteId;
        this.userId = userId;
    }

    public Long getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Boolean getGuidelinesAgreed() {
        return this.guidelinesAgreed;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setGuidelinesAgreed(Boolean guidelinesAgreed) {
        this.guidelinesAgreed = guidelinesAgreed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConvStatus)) {
            return false;
        }
        ConvStatus other = (ConvStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$siteId = this.getSiteId();
        String other$siteId = other.getSiteId();
        if (this$siteId == null ? other$siteId != null : !this$siteId.equals(other$siteId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConvStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $siteId = this.getSiteId();
        result = result * 59 + ($siteId == null ? 43 : $siteId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }
}

