/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.hibernate.annotations.GenericGenerator;
import org.sakaiproject.conversations.api.model.ConversationsPost;
import org.sakaiproject.conversations.api.model.ConversationsTopic;
import org.sakaiproject.conversations.api.model.Metadata;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_COMMENTS", indexes={@Index(name="conv_comments_post_idx", columnList="POST_ID"), @Index(name="conv_comments_site_idx", columnList="SITE_ID"), @Index(name="conv_comments_topic_idx", columnList="TOPIC_ID")})
public class ConversationsComment
implements PersistableEntity<String> {
    @Id
    @Column(name="COMMENT_ID", length=36, nullable=false)
    @GeneratedValue(generator="uuid")
    @GenericGenerator(name="uuid", strategy="uuid2")
    private String id;
    @Column(name="SITE_ID", length=99, nullable=false)
    private String siteId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="POST_ID")
    private ConversationsPost post;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TOPIC_ID")
    private ConversationsTopic topic;
    @Column(name="MESSAGE", length=255, nullable=false)
    private String message;
    @Column(name="LOCKED")
    private Boolean locked = Boolean.FALSE;
    @Embedded
    private Metadata metadata;

    public String getId() {
        return this.id;
    }

    public String getSiteId() {
        return this.siteId;
    }

    public ConversationsPost getPost() {
        return this.post;
    }

    public ConversationsTopic getTopic() {
        return this.topic;
    }

    public String getMessage() {
        return this.message;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setSiteId(String siteId) {
        this.siteId = siteId;
    }

    public void setPost(ConversationsPost post) {
        this.post = post;
    }

    public void setTopic(ConversationsTopic topic) {
        this.topic = topic;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setMetadata(Metadata metadata) {
        this.metadata = metadata;
    }
}

