/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.api.model;

import java.time.Instant;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.sakaiproject.conversations.api.model.ConversationsPost;
import org.sakaiproject.conversations.api.model.ConversationsTopic;
import org.sakaiproject.springframework.data.PersistableEntity;

@Entity
@Table(name="CONV_POST_STATUS", indexes={@Index(name="conv_post_status_user_idx", columnList="USER_ID"), @Index(name="conv_post_status_post_idx", columnList="POST_ID"), @Index(name="conv_post_status_post_user_idx", columnList="POST_ID, USER_ID"), @Index(name="conv_post_status_topic_user_idx", columnList="TOPIC_ID, USER_ID")}, uniqueConstraints={@UniqueConstraint(name="UniquePostStatus", columnNames={"POST_ID", "USER_ID"})})
public class PostStatus
implements PersistableEntity<Long> {
    @Id
    @GeneratedValue
    @Column(name="ID")
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="TOPIC_ID")
    private ConversationsTopic topic;
    @JoinColumn(name="POST_ID")
    @ManyToOne(fetch=FetchType.LAZY)
    private ConversationsPost post;
    @Column(name="USER_ID", length=99, nullable=false)
    private String userId;
    @Column(name="VIEWED_DATE")
    private Instant viewedDate;
    @Column(name="VIEWED")
    private Boolean viewed = Boolean.FALSE;
    @Column(name="UPVOTED")
    private Boolean upvoted = Boolean.FALSE;

    public PostStatus() {
    }

    public PostStatus(ConversationsTopic topic, ConversationsPost post, String userId) {
        this.topic = topic;
        this.post = post;
        this.userId = userId;
    }

    public Long getId() {
        return this.id;
    }

    public ConversationsTopic getTopic() {
        return this.topic;
    }

    public ConversationsPost getPost() {
        return this.post;
    }

    public String getUserId() {
        return this.userId;
    }

    public Instant getViewedDate() {
        return this.viewedDate;
    }

    public Boolean getViewed() {
        return this.viewed;
    }

    public Boolean getUpvoted() {
        return this.upvoted;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTopic(ConversationsTopic topic) {
        this.topic = topic;
    }

    public void setPost(ConversationsPost post) {
        this.post = post;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setViewedDate(Instant viewedDate) {
        this.viewedDate = viewedDate;
    }

    public void setViewed(Boolean viewed) {
        this.viewed = viewed;
    }

    public void setUpvoted(Boolean upvoted) {
        this.upvoted = upvoted;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PostStatus)) {
            return false;
        }
        PostStatus other = (PostStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ConversationsPost this$post = this.getPost();
        ConversationsPost other$post = other.getPost();
        if (this$post == null ? other$post != null : !((Object)this$post).equals(other$post)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        return !(this$userId == null ? other$userId != null : !this$userId.equals(other$userId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PostStatus;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ConversationsPost $post = this.getPost();
        result = result * 59 + ($post == null ? 43 : ((Object)$post).hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        return result;
    }
}

