/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.conversations.tool;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.sakaiproject.conversations.tool.exception.MissingSessionException;
import org.sakaiproject.portal.util.PortalUtils;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;

@Controller
public class MainController {
    private static final Logger log = LoggerFactory.getLogger(MainController.class);
    @Resource
    private SessionManager sessionManager;
    @Resource
    private ToolManager toolManager;

    @GetMapping(value={"/", "/index"})
    public String pageIndex(Model model, HttpServletRequest request) {
        this.checkSakaiSession();
        this.loadModel(model, request);
        model.addAttribute("state", (Object)"STATE_NOTHING_SELECTED");
        return "bootstrap";
    }

    private void loadModel(Model model, HttpServletRequest request) {
        model.addAttribute("cdnQuery", (Object)PortalUtils.getCDNQuery());
        Placement placement = this.toolManager.getCurrentPlacement();
        model.addAttribute("siteId", (Object)placement.getContext());
        String baseUrl = "/portal/site/" + placement.getContext() + "/tool/" + this.toolManager.getCurrentPlacement().getId();
        model.addAttribute("baseUrl", (Object)baseUrl);
        model.addAttribute("sakaiHtmlHead", (Object)((String)request.getAttribute("sakai.html.head")));
    }

    private Session checkSakaiSession() {
        try {
            Session session = this.sessionManager.getCurrentSession();
            if (StringUtils.isBlank((CharSequence)session.getUserId())) {
                log.error("Sakai user session is invalid");
                throw new MissingSessionException();
            }
            return session;
        }
        catch (IllegalStateException e) {
            log.error("Could not retrieve the sakai session");
            throw new MissingSessionException(e.getCause());
        }
    }
}

