/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.Observable;
import java.util.Observer;
import org.sakaiproject.courier.api.CourierService;
import org.sakaiproject.courier.api.Delivery;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.util.DirectRefreshDelivery;

public abstract class ObservingCourier
implements org.sakaiproject.courier.api.ObservingCourier,
Observer {
    protected CourierService m_courierService = null;
    protected String m_location = null;
    protected String m_deliveryId = "";
    protected String m_elementId = "";
    protected boolean m_enabled = true;

    public ObservingCourier(String location, String elementId) {
        this.m_deliveryId = SessionManager.getCurrentSession().getId() + location;
        this.m_elementId = elementId;
        this.m_location = location;
        this.m_courierService = org.sakaiproject.courier.cover.CourierService.getInstance();
    }

    public String getDeliveryId() {
        return this.m_deliveryId;
    }

    public void setDeliveryId(String id) {
        this.m_deliveryId = id;
    }

    public String getElementId() {
        return this.m_elementId;
    }

    public void setElementId(String id) {
        this.m_elementId = id;
    }

    public boolean getEnabled() {
        return this.m_enabled;
    }

    public void enable() {
        this.m_enabled = true;
    }

    public void disable() {
        this.m_enabled = false;
    }

    public void justDelivered() {
        this.m_courierService.clear(this.getDeliveryId(), this.getElementId());
    }

    public boolean check(Object arg) {
        return true;
    }

    public String getLocation() {
        return this.m_location;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!this.getEnabled()) {
            return;
        }
        if (!this.check(arg)) {
            return;
        }
        this.m_courierService.deliver((Delivery)new DirectRefreshDelivery(this.getDeliveryId(), this.getElementId()));
    }
}

