/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.dav;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.XMLWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.alias.cover.AliasService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentCollection;
import org.sakaiproject.content.api.ContentCollectionEdit;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.dav.DavPrincipal;
import org.sakaiproject.dav.DavServlet;
import org.sakaiproject.dav.MD5Encoder;
import org.sakaiproject.dav.SakaidavStatus;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.UsageSession;
import org.sakaiproject.event.cover.UsageSessionService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdLengthException;
import org.sakaiproject.exception.IdUniquenessException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeBreakdown;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.user.api.Authentication;
import org.sakaiproject.user.api.AuthenticationException;
import org.sakaiproject.user.api.Evidence;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.AuthenticationManager;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.IdPwEvidence;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.StringUtil;
import org.sakaiproject.util.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class DavServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Log M_log;
    protected static ResourceLoader rb;
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_OPTIONS = "OPTIONS";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final String METHOD_GET = "GET";
    private static final String METHOD_PUT = "PUT";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_DELETE = "DELETE";
    private static final int INFINITY = 3;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected boolean readOnly = true;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    static final String FORM_VALUE_DELIMETER = "^";
    protected static final int STREAM_BUFFER_SIZE = 102400;
    protected static final int MAX_XML_STREAM_LENGTH = 4096;
    protected boolean m_siteAlias = true;
    private Hashtable<String, LockInfo> resourceLocks = new Hashtable();
    private Hashtable<String, Vector<String>> lockNullResources = new Hashtable();
    private Vector<LockInfo> collectionLocks = new Vector();
    private String secret = "catalina";
    private boolean doProtected = false;
    protected static MessageDigest md5Helper;
    private String[] ignorePatterns = null;
    private boolean useCookies = false;
    private String[] nonDavUserAgent = null;
    private ContentHostingService contentHostingService;
    protected static BitSet safeCharacters;
    protected static final char[] hexadecimal;

    protected boolean prohibited(String id) {
        if (id == null) {
            return false;
        }
        return id.startsWith("/attachment/") || id.equals("/attachment") || this.doProtected && id.toLowerCase().indexOf("/protected") >= 0 && !this.contentHostingService.allowAddCollection(this.adjustId(id));
    }

    protected String adjustId(String id) {
        String newId;
        String userId2;
        String[] parts;
        String[] prefix;
        if (!(!this.contentHostingService.isShortRefs() || (prefix = StringUtil.splitFirst((String)(id.length() > 1 ? id.substring(1) : ""), (String)"/")).length <= 0 || prefix[0].equals("group") || prefix[0].equals("user") || prefix[0].equals("group-user") || prefix[0].equals("public") || prefix[0].equals("private") || prefix[0].equals("attachment"))) {
            String newPrefix = null;
            newPrefix = prefix[0].startsWith("~") ? "/user/" + prefix[0].substring(1) : "/group/" + prefix[0];
            id = newPrefix + (prefix.length > 1 ? "/" + prefix[1] : (id.endsWith("/") ? "/" : ""));
        }
        if ((parts = StringUtil.split((String)id, (String)"/")).length >= 3) {
            if (parts[1].equals("user")) {
                try {
                    UserDirectoryService.getUser((String)parts[2]);
                }
                catch (UserNotDefinedException tryEid) {
                    try {
                        parts[2] = userId2 = UserDirectoryService.getUserId((String)parts[2]);
                        newId = StringUtil.unsplit((String[])parts, (String)"/");
                        if (id.endsWith("/")) {
                            newId = newId + "/";
                        }
                        id = newId;
                    }
                    catch (UserNotDefinedException userId2) {}
                }
            } else if (parts[1].equals("group")) {
                String context = parts[2];
                if (this.m_siteAlias && context != null && context.length() > 0 && !SiteService.siteExists((String)context)) {
                    try {
                        String target = AliasService.getTarget((String)context);
                        Reference targetRef = EntityManager.newReference((String)target);
                        boolean changed = false;
                        if (SiteService.APPLICATION_ID.equals(targetRef.getType())) {
                            context = targetRef.getId();
                            changed = true;
                        } else if ("sakai:mailarchive".equals(targetRef.getType())) {
                            context = targetRef.getContext();
                            changed = true;
                        }
                        if (changed) {
                            parts[2] = context;
                            String newId2 = StringUtil.unsplit((String[])parts, (String)"/");
                            if (id.endsWith("/")) {
                                newId2 = newId2 + "/";
                            }
                            id = newId2;
                        }
                    }
                    catch (IdUnusedException target) {
                        // empty catch block
                    }
                }
            }
        }
        if (parts.length >= 4 && parts[1].equals("group-user")) {
            try {
                UserDirectoryService.getUser((String)parts[3]);
            }
            catch (UserNotDefinedException tryEid) {
                try {
                    parts[3] = userId2 = UserDirectoryService.getUserId((String)parts[3]);
                    newId = StringUtil.unsplit((String[])parts, (String)"/");
                    if (id.endsWith("/")) {
                        newId = newId + "/";
                    }
                    id = newId;
                }
                catch (UserNotDefinedException userNotDefinedException) {
                    // empty catch block
                }
            }
        }
        return id;
    }

    private SimpleDateFormat creationDateFormat() {
        SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return creationDateFormat;
    }

    private SimpleDateFormat httpDateFormat() {
        SimpleDateFormat httpDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z", Locale.US);
        httpDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return httpDateFormat;
    }

    private SimpleDateFormat[] dateFormats() {
        SimpleDateFormat[] formats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.US), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.US)};
        return formats;
    }

    public void init() throws ServletException {
        this.contentHostingService = (ContentHostingService)ComponentManager.get((String)ContentHostingService.class.getName());
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("readonly");
            if (value != null) {
                this.readOnly = new Boolean(value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("secret");
            if (value != null) {
                this.secret = value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            value = this.getServletConfig().getInitParameter("doprotected");
            if (value != null) {
                this.doProtected = new Boolean(value);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.ignorePatterns = ServerConfigurationService.getStrings((String)"webdav.ignore");
        if (this.ignorePatterns != null) {
            String outVal = "";
            for (int i = 0; i < this.ignorePatterns.length; ++i) {
                if (outVal.length() > 0) {
                    outVal = outVal + " : ";
                }
                outVal = outVal + this.ignorePatterns[i];
            }
            M_log.info((Object)("ignore patterns:" + outVal));
        }
        try {
            md5Helper = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IllegalStateException();
        }
        this.useCookies = ServerConfigurationService.getBoolean((String)"webdav.cookies", (boolean)false);
        this.nonDavUserAgent = ServerConfigurationService.getStrings((String)"webdav.nonDavUserAgent");
        if (this.nonDavUserAgent == null) {
            this.nonDavUserAgent = new String[]{"Mozilla", "Opera", "BlackBerry"};
        }
    }

    public SakaidavServletInfo newInfo(HttpServletRequest req) {
        return new SakaidavServletInfo(this, req);
    }

    protected String getUserPropertyDisplayName(ResourceProperties props, String name) {
        String id = props.getProperty(name);
        if (id != null) {
            try {
                User u = UserDirectoryService.getUser((String)id);
                return u.getDisplayName();
            }
            catch (UserNotDefinedException e) {
                return id;
            }
        }
        return "unknown";
    }

    protected void showRequestInfo(HttpServletRequest req) {
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)"DefaultServlet Request Info");
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Encoding : " + req.getCharacterEncoding()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Length : " + req.getContentLength()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Type : " + req.getContentType()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)"Parameters");
        }
        Enumeration parameters = req.getParameterNames();
        while (parameters.hasMoreElements()) {
            String paramName = (String)parameters.nextElement();
            String[] values = req.getParameterValues(paramName);
            System.out.print(paramName + " : ");
            for (int i = 0; i < values.length; ++i) {
                System.out.print(values[i] + ", ");
            }
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Protocol : " + req.getProtocol()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Address : " + req.getRemoteAddr()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Host : " + req.getRemoteHost()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Scheme : " + req.getScheme()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Server Name : " + req.getServerName()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Server Port : " + req.getServerPort()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)"Attributes");
        }
        Enumeration attributes = req.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attributeName = (String)attributes.nextElement();
            System.out.print(attributeName + " : ");
            if (!M_log.isDebugEnabled()) continue;
            M_log.debug((Object)req.getAttribute(attributeName).toString());
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)"HTTP Header Info");
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Authentication Type : " + req.getAuthType()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("HTTP Method : " + req.getMethod()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Path Info : " + req.getPathInfo()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Path translated : " + req.getPathTranslated()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Query string : " + req.getQueryString()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Remote user : " + req.getRemoteUser()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Requested session id : " + req.getRequestedSessionId()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Request URI : " + req.getRequestURI()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Context path : " + req.getContextPath()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Servlet path : " + req.getServletPath()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("User principal : " + req.getUserPrincipal()));
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)"Headers : ");
        }
        Enumeration headers = req.getHeaderNames();
        while (headers.hasMoreElements()) {
            String headerName = (String)headers.nextElement();
            System.out.print(headerName + " : ");
            if (!M_log.isDebugEnabled()) continue;
            M_log.debug((Object)req.getHeader(headerName));
        }
    }

    protected String getRelativePath(HttpServletRequest request) {
        if (request.getAttribute("javax.servlet.include.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.include.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.include.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        if (request.getAttribute("javax.servlet.forward.request_uri") != null) {
            String result = (String)request.getAttribute("javax.servlet.forward.path_info");
            if (result == null) {
                result = (String)request.getAttribute("javax.servlet.forward.servlet_path");
            }
            if (result == null || result.equals("")) {
                result = "/";
            }
            return result;
        }
        String result = this.getRelativePathSAKAI(request);
        return this.normalize(result);
    }

    protected String normalize(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            normalized = normalized.replace('\\', '/');
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    protected String rewriteUrl(String path) {
        int maxBytesPerChar = 10;
        StringBuilder rewrittenPath = new StringBuilder(path.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)buf, "UTF8");
        }
        catch (Exception e) {
            e.printStackTrace();
            writer = new OutputStreamWriter(buf);
        }
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (safeCharacters.get(c)) {
                rewrittenPath.append(c);
                continue;
            }
            try {
                writer.write(c);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                byte toEncode = ba[j];
                rewrittenPath.append('%');
                int low = toEncode & 0xF;
                int high = (toEncode & 0xF0) >> 4;
                rewrittenPath.append(hexadecimal[high]);
                rewrittenPath.append(hexadecimal[low]);
            }
            buf.reset();
        }
        return rewrittenPath.toString();
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        DocumentBuilderFactory documentBuilderFactory = null;
        try {
            documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ServletException("Sakaidavservlet.jaxpfailed");
        }
        return documentBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        SakaidavServletInfo info;
        block9: {
            info = this.newInfo(req);
            Principal prin = req.getUserPrincipal();
            if (prin != null && prin instanceof DavPrincipal) {
                String eid = prin.getName();
                String pw = ((DavPrincipal)prin).getPassword();
                IdPwEvidence e = new IdPwEvidence(eid, pw);
                try {
                    if (eid.length() == 0 || pw.length() == 0) {
                        throw new AuthenticationException("missing required fields");
                    }
                    Authentication a = AuthenticationManager.authenticate((Evidence)e);
                    if (!(UsageSessionService.getSession() != null && !UsageSessionService.getSession().isClosed() && a.getEid().equals(UsageSessionService.getSession().getUserEid()) || UsageSessionService.login((Authentication)a, (HttpServletRequest)req, (String)UsageSessionService.EVENT_LOGIN_DAV))) {
                        res.addHeader("WWW-Authenticate", "Basic realm=\"DAV\"");
                        res.sendError(401);
                        return;
                    }
                    break block9;
                }
                catch (AuthenticationException ex) {
                    res.addHeader("WWW-Authenticate", "Basic realm=\"DAV\"");
                    res.sendError(401);
                    return;
                }
            }
            res.addHeader("WWW-Authenticate", "Basic realm=\"DAV\"");
            res.sendError(401);
            return;
        }
        if (this.useCookies) {
            req.setAttribute("sakai.set.cookie", (Object)true);
        }
        try {
            this.doDispatch(info, req, res);
        }
        finally {
            this.log(req, info);
        }
    }

    public void log(HttpServletRequest req, SakaidavServletInfo info) {
        M_log.debug((Object)("from:" + req.getRemoteAddr() + " path:" + req.getPathInfo() + " options: " + info.optionsString()));
    }

    protected void doDispatch(SakaidavServletInfo info, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String method = req.getMethod();
        if (M_log.isDebugEnabled()) {
            String path = this.getRelativePath(req);
            M_log.debug((Object)("SAKAIDAV doDispatch [" + method + "] " + path));
        }
        String remoteUser = req.getRemoteUser();
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("SAKAIDAV remoteuser = " + remoteUser));
        }
        if (remoteUser == null) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)"SAKAIDAV Requires Authorization");
            }
            resp.sendError(401);
            return;
        }
        if (method.equals("PROPFIND")) {
            this.doPropfind(req, resp);
        } else if (method.equals("PROPPATCH")) {
            this.doProppatch(req, resp);
        } else if (method.equals("MKCOL")) {
            this.doMkcol(req, resp);
        } else if (method.equals("COPY")) {
            this.doCopy(req, resp);
        } else if (method.equals("MOVE")) {
            this.doMove(req, resp);
        } else if (method.equals("LOCK")) {
            this.doLock(req, resp);
        } else if (method.equals("UNLOCK")) {
            this.doUnlock(req, resp);
        } else if (method.equals("GET")) {
            this.doGet(req, resp);
        } else if (method.equals("PUT")) {
            this.doPut(req, resp);
        } else if (method.equals("POST")) {
            this.doPost(req, resp);
        } else if (method.equals("HEAD")) {
            this.doHead(req, resp);
        } else if (method.equals("OPTIONS")) {
            this.doOptions(req, resp);
        } else if (method.equals("DELETE")) {
            this.doDelete(req, resp);
        } else {
            M_log.warn((Object)"SAKAIDAV:Request not supported");
            resp.sendError(501);
        }
    }

    protected boolean isFileNameAllowed(HttpServletRequest req) {
        if (this.ignorePatterns == null) {
            return true;
        }
        String sakaiPath = this.getRelativePathSAKAI(req);
        for (int i = 0; i < this.ignorePatterns.length; ++i) {
            if (sakaiPath.lastIndexOf(this.ignorePatterns[i]) <= 0) continue;
            return false;
        }
        return true;
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.processHead(request, response);
    }

    private boolean processHead(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String contentType;
        String path = this.getRelativePathSAKAI(request);
        if (path == null || this.prohibited(path) || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            response.sendError(404, path);
            return false;
        }
        DirContextSAKAI resources = this.getResourcesSAKAI();
        ResourceInfoSAKAI resourceInfo = new ResourceInfoSAKAI(this, path, resources);
        if (!resourceInfo.exists) {
            response.sendError(404, path);
            return false;
        }
        if (!resourceInfo.collection) {
            response.setDateHeader("Last-Modified", resourceInfo.date);
        }
        if ((contentType = this.getServletContext().getMimeType(ResourceInfoSAKAI.access$000((ResourceInfoSAKAI)resourceInfo))) != null) {
            response.setContentType(contentType);
        }
        long contentLength = resourceInfo.length;
        if (!resourceInfo.collection && contentLength >= 0L) {
            if (contentLength <= Integer.MAX_VALUE) {
                response.setContentLength((int)contentLength);
            } else {
                response.addHeader("Content-Length", Long.toString(contentLength));
            }
        }
        return true;
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePathSAKAI(req);
        resp.addHeader("DAV", "1,2");
        String methodsAllowed = null;
        DirContextSAKAI resources = this.getResourcesSAKAI();
        if (resources == null) {
            M_log.warn((Object)"SAKAIDAV doOptions ERROR Resources is null");
            resp.sendError(500);
            return;
        }
        ResourceInfoSAKAI resourceInfo = new ResourceInfoSAKAI(this, path, resources);
        boolean exists = true;
        try {
            resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (!exists) {
            methodsAllowed = "OPTIONS, MKCOL, PUT, LOCK, UNLOCK";
            resp.addHeader("Allow", methodsAllowed);
            return;
        }
        methodsAllowed = "OPTIONS, GET, HEAD, POST, DELETE, PROPFIND, COPY, MOVE, LOCK, UNLOCK";
        methodsAllowed = !resourceInfo.collection ? methodsAllowed + ", PUT" : methodsAllowed + ", MKCOL";
        resp.addHeader("Allow", methodsAllowed);
        resp.addHeader("MS-Author-Via", "DAV");
    }

    public DirContextSAKAI getResourcesSAKAI() {
        return new DirContextSAKAI(this);
    }

    public String fixDirPathSAKAI(String path) {
        String tmpPath = path;
        try {
            this.contentHostingService.getProperties(this.adjustId(tmpPath));
        }
        catch (IdUnusedException e) {
            if (!tmpPath.endsWith("/")) {
                String newPath = tmpPath + "/";
                try {
                    this.contentHostingService.getProperties(this.adjustId(newPath));
                    tmpPath = newPath;
                }
                catch (Exception exception) {}
            }
        }
        catch (PermissionException permissionException) {
            // empty catch block
        }
        return tmpPath;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePathSAKAI(req);
        this.doContent(path, req, resp);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String header = req.getHeader("User-Agent") != null ? req.getHeader("User-Agent") : "";
        String path = this.getRelativePathSAKAI(req);
        for (String agent : this.nonDavUserAgent) {
            if (!header.toUpperCase().contains(agent.toUpperCase())) continue;
            if (M_log.isInfoEnabled()) {
                M_log.info((Object)("Redirecting DAV access because this is a browser." + header));
            }
            resp.sendRedirect("/access/content" + this.adjustId(path));
            return;
        }
        this.doContent(path, req, resp);
    }

    protected int countSlashes(String s) {
        int count = 0;
        int loc = s.indexOf(47);
        while (loc >= 0) {
            ++count;
            ++loc;
            loc = s.indexOf(47, loc);
        }
        return count;
    }

    private void doDirectory(String id, HttpServletRequest req, HttpServletResponse res) {
        if (this.prohibited(id)) {
            return;
        }
        String uri = req.getRequestURI();
        PrintWriter out = null;
        try {
            ContentCollection x = this.contentHostingService.getCollection(this.adjustId(id));
            if (!uri.endsWith("/")) {
                try {
                    res.sendRedirect(uri + "/");
                    return;
                }
                catch (IOException ignore) {
                    return;
                }
            }
            List xl = x.getMembers();
            Collections.sort(xl);
            Iterator xi = xl.iterator();
            res.setContentType("text/html; charset=UTF-8");
            out = res.getWriter();
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
            out.println("<html><head>");
            String webappRoot = ServerConfigurationService.getServerUrl();
            out.println("<link href=\"" + webappRoot + "/css/default.css\" type=\"text/css\" rel=\"stylesheet\" media=\"screen\" />");
            out.println("<STYLE type=\"text/css\">");
            out.println("<!--");
            out.println("td {padding-right: .5em}");
            out.println("-->");
            out.println("</STYLE>");
            out.println("</head><body>");
            out.println("<div style=\"padding: 16px\">");
            out.println("<h2>" + rb.getString("contents_of") + id + "</h2>");
            out.println("<table>");
            int slashes = this.countSlashes(this.adjustId(id));
            if (slashes > 3) {
                out.println("<tr><td><a href=\"..\">" + rb.getString("up_one_level") + "</a></td><td><b>" + rb.getString("folder") + "</b>" + "</td><td>" + "</td><td>" + "</td><td>" + "</td></tr>");
            }
            while (xi.hasNext()) {
                String xs = (String)xi.next();
                String xss = xs.substring(this.adjustId(id).length());
                if (xss.endsWith("/")) {
                    xss = xss.substring(0, xss.length() - 1);
                    if (this.doProtected && xs.toLowerCase().indexOf("/protected") >= 0 && !this.contentHostingService.allowAddCollection(this.adjustId(xs))) continue;
                    out.println("<tr><td><a href=\"" + Validator.escapeUrl((String)xss) + "/\">" + Validator.escapeHtml((String)xss) + "</a></td><td><b>" + rb.getString("folder") + "</b>" + "</td><td>" + "</td><td>" + "</td><td>" + "</td></tr>");
                    continue;
                }
                try {
                    ContentResource nextres = this.contentHostingService.getResource(this.adjustId(xs));
                    ResourceProperties properties = nextres.getProperties();
                    long filesize = (nextres.getContentLength() - 1L) / 1024L + 1L;
                    String createdBy = this.getUserPropertyDisplayName(properties, "CHEF:creator");
                    Time modTime = properties.getTimeProperty("DAV:getlastmodified");
                    String modifiedTime = modTime.toStringLocalShortDate() + " " + modTime.toStringLocalShort();
                    String filetype = nextres.getContentType();
                    out.println("<tr><td><a href=\"" + Validator.escapeUrl((String)xss) + "\">" + Validator.escapeHtml((String)xss) + "</a></td><td>" + filesize + "</td><td>" + createdBy + "</td><td>" + filetype + "</td><td>" + modifiedTime + "</td></tr>");
                }
                catch (Throwable ignore) {
                    out.println("<tr><td><a href=\"" + Validator.escapeUrl((String)xss) + "\">" + Validator.escapeHtml((String)xss) + "</a></td><td>" + "</td><td>" + "</td><td>" + "</td><td>" + "</td></tr>");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (out != null) {
            out.println("</table></div></body></html>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doContent(String id, HttpServletRequest req, HttpServletResponse res) throws IOException {
        block53: {
            block52: {
                OutputStream out;
                InputStream contentStream;
                block47: {
                    block50: {
                        String string;
                        block51: {
                            long len;
                            block48: {
                                String string2;
                                block49: {
                                    if (this.prohibited(id)) {
                                        res.sendError(403);
                                        return rb.getString("permission_to_view");
                                    }
                                    boolean isCollection = false;
                                    try {
                                        ResourceProperties props = null;
                                        try {
                                            props = this.contentHostingService.getProperties(this.adjustId(id));
                                        }
                                        catch (IdUnusedException x) {
                                            if (!id.endsWith("/")) {
                                                String tempid = id + "/";
                                                props = this.contentHostingService.getProperties(this.adjustId(tempid));
                                                id = tempid;
                                            }
                                            res.sendError(404);
                                            return rb.getString("resource_not_exists");
                                        }
                                        isCollection = props.getBooleanProperty("CHEF:is-collection");
                                    }
                                    catch (PermissionException e) {
                                        res.sendError(403);
                                        return rb.getString("permission_to_view");
                                    }
                                    catch (IdUnusedException e) {
                                        res.sendError(404);
                                        return rb.getString("resource_not_exists");
                                    }
                                    catch (EntityPropertyNotDefinedException e) {
                                        res.sendError(404);
                                        return rb.getString("resource_not_exists");
                                    }
                                    catch (EntityPropertyTypeException e) {
                                        res.sendError(404);
                                        return rb.getString("resource_not_exists");
                                    }
                                    if (isCollection) break block52;
                                    if (M_log.isDebugEnabled()) {
                                        M_log.debug((Object)("SAKAIAccess doContent is resource " + id));
                                    }
                                    contentStream = null;
                                    out = null;
                                    ContentResource resource = this.contentHostingService.getResource(this.adjustId(id));
                                    len = resource.getContentLength();
                                    String contentType = resource.getContentType();
                                    if (contentType.equalsIgnoreCase("text/url")) {
                                        res.sendRedirect(new String(resource.getContent()));
                                        break block47;
                                    }
                                    contentStream = resource.streamContent();
                                    if (contentStream != null && len != 0L) break block48;
                                    string2 = rb.getString("empty_resource");
                                    if (contentStream == null) break block49;
                                    try {
                                        contentStream.close();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                                if (out != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                }
                                return string2;
                            }
                            if (len < 102400L) {
                                res.setBufferSize((int)len);
                            } else {
                                res.setBufferSize(102400);
                            }
                            if (this.processHead(req, res)) break block50;
                            string = rb.getString("error_setting_header_values");
                            if (contentStream == null) break block51;
                            try {
                                contentStream.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        return string;
                    }
                    try {
                        int lenRead;
                        out = res.getOutputStream();
                        byte[] chunk = new byte[102400];
                        while ((lenRead = contentStream.read(chunk)) != -1) {
                            out.write(chunk, 0, lenRead);
                        }
                    }
                    catch (Throwable e) {
                        try {
                            String string = e.toString();
                            return string;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (contentStream != null) {
                                try {
                                    contentStream.close();
                                }
                                catch (IOException iOException) {}
                            }
                            if (out != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable throwable) {}
                            }
                        }
                    }
                }
                if (contentStream != null) {
                    try {
                        contentStream.close();
                    }
                    catch (IOException resource) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Throwable resource) {}
                }
                break block53;
            }
            this.doDirectory(id, req, res);
        }
        return null;
    }

    public String getRelativePathSAKAI(HttpServletRequest req) {
        String path = req.getPathInfo();
        if (path == null) {
            path = "/";
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("getRelativePathSAKAI = " + path));
        }
        return path;
    }

    public String getResourceNameSAKAI(Entity mbr) {
        int lastSlash;
        String idx = mbr.getId();
        ResourceProperties props = mbr.getProperties();
        String resourceName = props.getProperty("DAV:displayname");
        if (idx.startsWith("/") && idx.endsWith("/") && idx.length() > 3) {
            lastSlash = idx.lastIndexOf("/", idx.length() - 2);
            if (lastSlash > 0 && lastSlash + 1 <= idx.length() - 2) {
                resourceName = idx.substring(lastSlash + 1, idx.length() - 1);
            }
        } else if (idx.startsWith("/") && !idx.endsWith("/") && idx.length() > 2 && (lastSlash = idx.lastIndexOf("/")) > -1) {
            resourceName = idx.substring(lastSlash + 1);
        }
        String[] parts = StringUtil.split((String)idx, (String)"/");
        if (parts.length == 4 && parts[1].equals("group-user")) {
            try {
                resourceName = UserDirectoryService.getUserEid((String)parts[3]);
            }
            catch (UserNotDefinedException tryId) {
                try {
                    UserDirectoryService.getUserByEid((String)parts[3]);
                }
                catch (UserNotDefinedException notId) {
                    M_log.warn((Object)("getResourceNameSAKAI could not find either id or eid: " + parts[3]));
                }
            }
        }
        return resourceName;
    }

    protected void doPropfind(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        boolean exists;
        DirContextSAKAI resources;
        int type;
        int depth;
        Vector<String> properties;
        String path;
        block48: {
            path = this.getRelativePathSAKAI(req);
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF") || this.prohibited(path)) {
                resp.sendError(403);
                return;
            }
            properties = null;
            depth = 3;
            type = 1;
            String depthStr = req.getHeader("Depth");
            if (depthStr == null) {
                depth = 3;
            } else if (depthStr.equals("0")) {
                depth = 0;
            } else if (depthStr.equals("1")) {
                depth = 1;
            } else if (depthStr.equals("infinity")) {
                depth = 3;
            }
            Node propNode = null;
            DocumentBuilder documentBuilder = this.getDocumentBuilder();
            int contentLength = req.getContentLength();
            if (contentLength > 4096) {
                resp.sendError(413);
                return;
            }
            if (contentLength > 0) {
                int lenRead;
                byte[] byteContent = new byte[contentLength];
                ServletInputStream inputStream = req.getInputStream();
                try {
                    int read;
                    for (lenRead = 0; lenRead < contentLength && (read = inputStream.read(byteContent, lenRead, contentLength - lenRead)) > 0; lenRead += read) {
                    }
                }
                catch (Exception read) {
                    // empty catch block
                }
                if (lenRead > 0) {
                    try {
                        ByteArrayInputStream is = new ByteArrayInputStream(byteContent, 0, lenRead);
                        Document document = documentBuilder.parse(new InputSource(is));
                        Element rootElement = document.getDocumentElement();
                        NodeList childList = rootElement.getChildNodes();
                        block18: for (int i = 0; i < childList.getLength(); ++i) {
                            Node currentNode = childList.item(i);
                            switch (currentNode.getNodeType()) {
                                case 3: {
                                    continue block18;
                                }
                                case 1: {
                                    if (currentNode.getNodeName().endsWith("prop")) {
                                        type = 0;
                                        propNode = currentNode;
                                    }
                                    if (currentNode.getNodeName().endsWith("propname")) {
                                        type = 2;
                                    }
                                    if (!currentNode.getNodeName().endsWith("allprop")) continue block18;
                                    type = 1;
                                }
                            }
                        }
                    }
                    catch (SAXParseException se) {
                        resp.sendError(400);
                        return;
                    }
                    catch (Exception e) {
                        M_log.warn((Object)"Exception parsing DAV request", (Throwable)e);
                    }
                }
            }
            if (type == 0) {
                properties = new Vector<String>();
                NodeList childList = propNode.getChildNodes();
                block19: for (int i = 0; i < childList.getLength(); ++i) {
                    Node currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block19;
                        }
                        case 1: {
                            String nodeName = currentNode.getNodeName();
                            String propertyName = null;
                            propertyName = nodeName.indexOf(58) != -1 ? nodeName.substring(nodeName.indexOf(58) + 1) : nodeName;
                            properties.addElement(propertyName);
                        }
                    }
                }
            }
            if ((resources = this.getResourcesSAKAI()) == null) {
                resp.sendError(500);
                return;
            }
            exists = true;
            try {
                resources.lookup(path);
            }
            catch (NamingException e) {
                String parentPath;
                Vector currentLockNullResources;
                exists = false;
                int slash = path.lastIndexOf(47);
                if (slash == -1 || (currentLockNullResources = (Vector)this.lockNullResources.get(parentPath = path.substring(0, slash))) == null) break block48;
                Enumeration lockNullResourcesList = currentLockNullResources.elements();
                while (lockNullResourcesList.hasMoreElements()) {
                    String lockNullPath = (String)lockNullResourcesList.nextElement();
                    if (!lockNullPath.equals(path)) continue;
                    resp.setStatus(207);
                    resp.setContentType("text/xml; charset=UTF-8");
                    XMLWriter generatedXML = new XMLWriter((Writer)resp.getWriter());
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", "multistatus" + this.generateNamespaceDeclarations(), 0);
                    this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                    generatedXML.writeElement("D", "multistatus", 1);
                    generatedXML.sendData();
                    return;
                }
            }
        }
        if (!exists) {
            resp.sendError(404, "/dav" + path);
            return;
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        XMLWriter generatedXML = new XMLWriter((Writer)resp.getWriter());
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", "multistatus" + this.generateNamespaceDeclarations(), 0);
        if (depth == 0) {
            this.parseProperties(req, resources, generatedXML, path, type, properties);
        } else {
            Stack<String> stack = new Stack<String>();
            stack.push(path);
            Stack<String> stackBelow = new Stack<String>();
            while (!stack.isEmpty() && depth >= 0) {
                String currentPath = (String)stack.pop();
                try {
                    resources.lookup(currentPath);
                }
                catch (NamingException e) {
                    continue;
                }
                this.parseProperties(req, resources, generatedXML, currentPath, type, properties);
                if (resources.isCollection && depth > 0) {
                    Vector currentLockNullResources;
                    Iterator it = resources.list(currentPath);
                    while (it.hasNext()) {
                        Entity mbr = (Entity)it.next();
                        String resourceName = this.getResourceNameSAKAI(mbr);
                        String newPath = currentPath;
                        if (!newPath.endsWith("/")) {
                            newPath = newPath + "/";
                        }
                        if ((newPath = newPath + resourceName).toLowerCase().indexOf("/protected") >= 0 && !this.contentHostingService.allowAddCollection(newPath)) continue;
                        stackBelow.push(newPath);
                    }
                    String lockPath = currentPath;
                    if (lockPath.endsWith("/")) {
                        lockPath = lockPath.substring(0, lockPath.length() - 1);
                    }
                    if ((currentLockNullResources = (Vector)this.lockNullResources.get(lockPath)) != null) {
                        Enumeration lockNullResourcesList = currentLockNullResources.elements();
                        while (lockNullResourcesList.hasMoreElements()) {
                            String lockNullPath = (String)lockNullResourcesList.nextElement();
                            this.parseLockNullProperties(req, generatedXML, lockNullPath, type, properties);
                        }
                    }
                }
                if (stack.isEmpty()) {
                    --depth;
                    stack = stackBelow;
                    stackBelow = new Stack();
                }
                generatedXML.sendData();
            }
        }
        generatedXML.writeElement("D", "multistatus", 1);
        generatedXML.sendData();
    }

    protected void doProppatch(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isLocked(req)) {
            resp.sendError(423);
        }
        DocumentBuilder documentBuilder = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            resp.sendError(420);
            return;
        }
        int contentLength = req.getContentLength();
        ArrayList<String> props = new ArrayList<String>();
        Hashtable<String, String> spaces = new Hashtable<String, String>();
        if (contentLength > 4096) {
            resp.sendError(413);
            return;
        }
        if (contentLength > 0) {
            int lenRead;
            byte[] byteContent = new byte[contentLength];
            ServletInputStream inputStream = req.getInputStream();
            try {
                int read;
                for (lenRead = 0; lenRead < contentLength && (read = inputStream.read(byteContent, lenRead, contentLength - lenRead)) > 0; lenRead += read) {
                }
            }
            catch (Exception read) {
                // empty catch block
            }
            if (lenRead > 0) {
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(byteContent, 0, lenRead);
                    Document document = documentBuilder.parse(new InputSource(is));
                    Element rootElement = document.getDocumentElement();
                    NodeList childList = rootElement.getElementsByTagNameNS("DAV:", "prop");
                    int nextChar = 1;
                    for (int i = 0; i < childList.getLength(); ++i) {
                        Node currentNode = childList.item(i);
                        NodeList names = currentNode.getChildNodes();
                        for (int j = 0; j < names.getLength(); ++j) {
                            String namespace = names.item(j).getNamespaceURI();
                            String prefix = (String)spaces.get(namespace);
                            if (prefix == null) {
                                prefix = "" + Character.toChars(68 + nextChar)[0];
                                spaces.put(namespace, prefix);
                            }
                            props.add(prefix + ":" + names.item(j).getLocalName());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write("<D:multistatus xmlns:D=\"DAV:\"");
        for (String namespace : spaces.keySet()) {
            ((Writer)writer).write(" xmlns:" + (String)spaces.get(namespace) + "=\"" + namespace + "\"");
        }
        ((Writer)writer).write("><D:response><D:href>" + HttpUtils.getRequestURL((HttpServletRequest)req) + "</D:href>");
        for (String pname : props) {
            ((Writer)writer).write("<D:propstat><D:prop><" + pname + "/></D:prop><D:status>HTTP/1.1 201 OK</D:status></D:propstat>");
        }
        ((Writer)writer).write("</D:response></D:multistatus>");
        ((Writer)writer).close();
    }

    protected String justName(String str) {
        try {
            int pos = str.lastIndexOf("/", str.length() - 2);
            String rv = str.substring(pos + 1);
            if (rv.endsWith("/")) {
                rv = rv.substring(0, rv.length() - 1);
            }
            return rv;
        }
        catch (Throwable t) {
            return str;
        }
    }

    private String isolateContainingId(String id) {
        return id.substring(0, id.lastIndexOf(47, id.length() - 2) + 1);
    }

    protected void doMkcol(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (req.getContentLength() > 0) {
            resp.sendError(415);
            return;
        }
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePathSAKAI(req);
        if (this.prohibited(path) || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        String name = this.justName(path);
        if (name.toUpperCase().startsWith("/WEB-INF") || name.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        String parentId = this.isolateContainingId(this.adjustId(path));
        try {
            this.contentHostingService.getCollection(parentId);
        }
        catch (IdUnusedException e1) {
            resp.sendError(409);
            return;
        }
        catch (TypeException e1) {
            resp.sendError(403);
            return;
        }
        catch (PermissionException e1) {
            resp.sendError(403);
            return;
        }
        String adjustedId = this.adjustId(path);
        try {
            this.contentHostingService.getProperties(adjustedId);
            resp.sendError(405);
            return;
        }
        catch (IdUnusedException idUnusedException) {
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return;
        }
        if (adjustedId.endsWith("/") && adjustedId.length() > 1) {
            try {
                String idToCheck = adjustedId.substring(0, adjustedId.length() - 1);
                this.contentHostingService.getProperties(idToCheck);
                resp.sendError(405);
                return;
            }
            catch (IdUnusedException idToCheck) {
            }
            catch (PermissionException e) {
                resp.sendError(403);
                return;
            }
        }
        try {
            ContentCollectionEdit edit = this.contentHostingService.addCollection(this.adjustId(path));
            ResourcePropertiesEdit resourceProperties = edit.getPropertiesEdit();
            resourceProperties.addProperty("DAV:displayname", name);
            this.contentHostingService.commitCollection(edit);
        }
        catch (IdUsedException edit) {
        }
        catch (IdInvalidException e) {
            M_log.warn((Object)("SAKAIDavServlet.doMkcol() IdInvalid:" + e.getMessage()));
            resp.sendError(403);
            return;
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return;
        }
        catch (InconsistentException e) {
            M_log.warn((Object)("SAKAIDavServlet.doMkcol() InconsistentException:" + e.getMessage()));
            resp.sendError(403);
            return;
        }
        resp.setStatus(201);
        this.lockNullResources.remove(path);
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        this.deleteResource(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.isFileNameAllowed(req)) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePathSAKAI(req);
        if (this.prohibited(path) || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        if (req.getHeader("Content-Range") != null) {
            resp.sendError(501);
        }
        String name = this.justName(path);
        if (path.length() > 254) {
            resp.sendError(403);
            return;
        }
        if (name.toUpperCase().startsWith("/WEB-INF") || name.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return;
        }
        String contentType = "";
        ServletInputStream inputStream = req.getInputStream();
        contentType = req.getContentType();
        if (contentType != null) {
            String fileContentType;
            UsageSession session = UsageSessionService.getSession();
            String agent = null;
            if (session != null) {
                agent = session.getUserAgent();
            }
            if (agent != null && agent.startsWith("Microsoft Office Core Storage Infrastructure") && (fileContentType = this.getServletContext().getMimeType(path)) != null) {
                contentType = fileContentType;
            }
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("  req.contentType() =" + contentType));
        }
        if (contentType == null) {
            contentType = this.getServletContext().getMimeType(path);
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("Lookup contentType =" + contentType));
            }
        }
        if (contentType == null) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)"Unable to determine contentType");
            }
            contentType = "";
        }
        try {
            ContentResourceEdit edit;
            boolean newfile = false;
            String resourcePath = this.adjustId(path);
            try {
                this.contentHostingService.getResource(resourcePath);
            }
            catch (IdUnusedException e) {
                newfile = true;
            }
            if (newfile) {
                edit = this.contentHostingService.addResource(resourcePath);
                ResourcePropertiesEdit p = edit.getPropertiesEdit();
                p.addProperty("DAV:displayname", name);
                User user = UserDirectoryService.getCurrentUser();
                TimeBreakdown timeBreakdown = TimeService.newTime().breakdownLocal();
                p.addProperty("CHEF:copyright", "copyright (c) " + timeBreakdown.getYear() + ", " + user.getDisplayName() + ". All Rights Reserved. ");
            } else {
                edit = this.contentHostingService.editResource(resourcePath);
                contentType = edit.getContentType();
            }
            edit.setContentType(contentType);
            edit.setContent((InputStream)inputStream);
            this.contentHostingService.commitResource(edit, 0);
        }
        catch (IdUsedException e) {
            M_log.warn((Object)("SAKAIDavServlet.doPut() IdUsedException:" + e.getMessage()));
            resp.sendError(409);
            return;
        }
        catch (IdInvalidException e) {
            M_log.warn((Object)("SAKAIDavServlet.doPut() IdInvalidException:" + e.getMessage()));
            resp.sendError(409);
            return;
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return;
        }
        catch (OverQuotaException e) {
            resp.sendError(403);
            return;
        }
        catch (InconsistentException e) {
            M_log.warn((Object)("SAKAIDavServlet.doPut() InconsistentException:" + e.getMessage()));
            resp.sendError(409);
            return;
        }
        catch (ServerOverloadException e) {
            M_log.warn((Object)("SAKAIDavServlet.doPut() ServerOverloadException:" + e.getMessage()));
            resp.setStatus(503);
            return;
        }
        catch (InUseException e) {
            resp.sendError(403);
            return;
        }
        catch (TypeException e) {
            M_log.warn((Object)("SAKAIDavServlet.doPut() TypeException:" + e.getMessage()));
            resp.sendError(409);
            return;
        }
        catch (IdUnusedException inconsistent) {
            M_log.error((Object)("SAKAIDavServlet.doPut() Inconsistently got IdUnusedException after checking resource exists: " + inconsistent.getMessage()));
            resp.sendError(403);
            return;
        }
        resp.setStatus(201);
        this.lockNullResources.remove(path);
    }

    protected void doCopy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        this.copyResource(req, resp, false);
    }

    protected void doMove(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        boolean success = this.copyResource(req, resp, true);
        if (success) {
            this.deleteResource(path, req, resp);
        }
    }

    protected void doLock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        LockInfo lock = new LockInfo(this);
        String depthStr = req.getHeader("Depth");
        lock.depth = depthStr == null ? 3 : (depthStr.equals("0") ? 0 : 3);
        int lockDuration = 3600;
        String lockDurationStr = req.getHeader("Timeout");
        if (lockDurationStr == null) {
            lockDuration = 3600;
        } else {
            if (lockDurationStr.startsWith("Second-")) {
                lockDuration = new Integer(lockDurationStr.substring(7));
            } else if (lockDurationStr.equalsIgnoreCase("infinity")) {
                lockDuration = 604800;
            } else {
                try {
                    lockDuration = new Integer(lockDurationStr);
                }
                catch (NumberFormatException e) {
                    lockDuration = 604800;
                }
            }
            if (lockDuration == 0) {
                lockDuration = 3600;
            }
            if (lockDuration > 604800) {
                lockDuration = 604800;
            }
        }
        lock.expiresAt = System.currentTimeMillis() + (long)(lockDuration * 1000);
        boolean lockRequestType = false;
        Node lockInfoNode = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            Document document = documentBuilder.parse(new InputSource((InputStream)req.getInputStream()));
            Element rootElement = document.getDocumentElement();
            lockInfoNode = rootElement;
        }
        catch (Exception e) {
            lockRequestType = true;
        }
        if (lockInfoNode != null) {
            Node currentNode;
            int i;
            NodeList childList = lockInfoNode.getChildNodes();
            StringWriter strWriter = null;
            DOMWriter domWriter = null;
            Node lockScopeNode = null;
            Node lockTypeNode = null;
            Node lockOwnerNode = null;
            block24: for (i = 0; i < childList.getLength(); ++i) {
                currentNode = childList.item(i);
                switch (currentNode.getNodeType()) {
                    case 3: {
                        continue block24;
                    }
                    case 1: {
                        String nodeName = currentNode.getNodeName();
                        if (nodeName.endsWith("lockscope")) {
                            lockScopeNode = currentNode;
                        }
                        if (nodeName.endsWith("locktype")) {
                            lockTypeNode = currentNode;
                        }
                        if (!nodeName.endsWith("owner")) continue block24;
                        lockOwnerNode = currentNode;
                    }
                }
            }
            if (lockScopeNode != null) {
                childList = lockScopeNode.getChildNodes();
                block25: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block25;
                        }
                        case 1: {
                            String tempScope = currentNode.getNodeName();
                            lock.scope = tempScope.indexOf(58) != -1 ? tempScope.substring(tempScope.indexOf(58) + 1) : tempScope;
                        }
                    }
                }
                if (lock.scope == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockTypeNode != null) {
                childList = lockTypeNode.getChildNodes();
                block26: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            continue block26;
                        }
                        case 1: {
                            String tempType = currentNode.getNodeName();
                            lock.type = tempType.indexOf(58) != -1 ? tempType.substring(tempType.indexOf(58) + 1) : tempType;
                        }
                    }
                }
                if (lock.type == null) {
                    resp.setStatus(400);
                }
            } else {
                resp.setStatus(400);
            }
            if (lockOwnerNode != null) {
                childList = lockOwnerNode.getChildNodes();
                block27: for (i = 0; i < childList.getLength(); ++i) {
                    currentNode = childList.item(i);
                    switch (currentNode.getNodeType()) {
                        case 3: {
                            lock.owner = lock.owner + currentNode.getNodeValue();
                            continue block27;
                        }
                        case 1: {
                            strWriter = new StringWriter();
                            domWriter = new DOMWriter((Writer)strWriter, true);
                            domWriter.print(currentNode);
                            lock.owner = lock.owner + strWriter.toString();
                        }
                    }
                }
                if (lock.owner == null) {
                    resp.setStatus(400);
                }
                lock.owner = lock.owner.replaceAll("<(/?)[^>]+:([hH][rR][eE][fF])>", "<$1$2>");
            } else {
                lock.owner = new String();
            }
        }
        String path = this.getRelativePath(req);
        String lockToken = null;
        lock.path = path;
        DirContextSAKAI resources = this.getResourcesSAKAI();
        if (resources == null) {
            resp.sendError(500);
            return;
        }
        boolean exists = true;
        Object object = null;
        try {
            object = resources.lookup(path);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (this.prohibited(path) || !(!exists ? this.contentHostingService.allowAddResource(this.adjustId(path)) : this.contentHostingService.allowUpdateResource(this.adjustId(path)))) {
            resp.sendError(403, path);
            return;
        }
        Enumeration<Object> locksList = null;
        if (!lockRequestType) {
            String lockTokenStr = req.getServletPath() + "-" + lock.type + "-" + lock.scope + "-" + req.getUserPrincipal() + "-" + lock.depth + "-" + lock.owner + "-" + lock.tokens + "-" + lock.expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            lockToken = MD5Encoder.encode((byte[])md5Helper.digest(lockTokenStr.getBytes()));
            if (exists && object instanceof DirContext && lock.depth == 3) {
                LockInfo currentLock;
                Vector<String> lockPaths = new Vector<String>();
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = (LockInfo)locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                locksList = this.resourceLocks.elements();
                while (locksList.hasMoreElements()) {
                    currentLock = (LockInfo)locksList.nextElement();
                    if (currentLock.hasExpired()) {
                        this.resourceLocks.remove(currentLock.path);
                        continue;
                    }
                    if (!currentLock.path.startsWith(lock.path) || !currentLock.isExclusive() && !lock.isExclusive()) continue;
                    lockPaths.addElement(currentLock.path);
                }
                if (!lockPaths.isEmpty()) {
                    Enumeration lockPathsList = lockPaths.elements();
                    resp.setStatus(409);
                    XMLWriter generatedXML = new XMLWriter();
                    generatedXML.writeXMLHeader();
                    generatedXML.writeElement("D", "multistatus" + this.generateNamespaceDeclarations(), 0);
                    while (lockPathsList.hasMoreElements()) {
                        generatedXML.writeElement("D", "response", 0);
                        generatedXML.writeElement("D", "href", 0);
                        generatedXML.writeText((String)lockPathsList.nextElement());
                        generatedXML.writeElement("D", "href", 1);
                        generatedXML.writeElement("D", "status", 0);
                        generatedXML.writeText("HTTP/1.1 423 " + SakaidavStatus.getStatusText((int)423));
                        generatedXML.writeElement("D", "status", 1);
                        generatedXML.writeElement("D", "response", 1);
                    }
                    generatedXML.writeElement("D", "multistatus", 1);
                    PrintWriter writer = resp.getWriter();
                    ((Writer)writer).write(generatedXML.toString());
                    ((Writer)writer).close();
                    return;
                }
                boolean addLock = true;
                locksList = this.collectionLocks.elements();
                while (locksList.hasMoreElements()) {
                    LockInfo currentLock2 = (LockInfo)locksList.nextElement();
                    if (!currentLock2.path.equals(lock.path)) continue;
                    if (currentLock2.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    if (lock.isExclusive()) {
                        resp.sendError(423);
                        return;
                    }
                    currentLock2.tokens.addElement(lockToken);
                    lock = currentLock2;
                    addLock = false;
                }
                if (addLock) {
                    lock.tokens.addElement(lockToken);
                    this.collectionLocks.addElement(lock);
                }
            } else {
                LockInfo presentLock = (LockInfo)this.resourceLocks.get(lock.path);
                if (presentLock != null) {
                    if (presentLock.isExclusive() || lock.isExclusive()) {
                        resp.sendError(412);
                        return;
                    }
                    presentLock.tokens.addElement(lockToken);
                    lock = presentLock;
                } else {
                    lock.tokens.addElement(lockToken);
                    this.resourceLocks.put(lock.path, lock);
                    exists = true;
                    try {
                        object = resources.lookup(path);
                    }
                    catch (NamingException e) {
                        exists = false;
                    }
                    if (!exists) {
                        int slash = lock.path.lastIndexOf(47);
                        String parentPath = lock.path.substring(0, slash);
                        Vector<String> lockNulls = (Vector<String>)this.lockNullResources.get(parentPath);
                        if (lockNulls == null) {
                            lockNulls = new Vector<String>();
                            this.lockNullResources.put(parentPath, lockNulls);
                        }
                        lockNulls.addElement(lock.path);
                    }
                }
            }
        }
        if (lockRequestType) {
            String ifHeader = req.getHeader("If");
            if (ifHeader == null) {
                ifHeader = "";
            }
            LockInfo toRenew = (LockInfo)this.resourceLocks.get(path);
            Enumeration tokenList = null;
            if (lock != null && toRenew != null && toRenew.tokens != null) {
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = (String)tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
            Enumeration collectionLocksList = this.collectionLocks.elements();
            while (collectionLocksList.hasMoreElements()) {
                toRenew = (LockInfo)collectionLocksList.nextElement();
                if (!path.equals(toRenew.path)) continue;
                tokenList = toRenew.tokens.elements();
                while (tokenList.hasMoreElements()) {
                    String token = (String)tokenList.nextElement();
                    if (ifHeader.indexOf(token) == -1) continue;
                    toRenew.expiresAt = lock.expiresAt;
                    lock = toRenew;
                }
            }
        }
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", "prop" + this.generateNamespaceDeclarations(), 0);
        generatedXML.writeElement("D", "lockdiscovery", 0);
        lock.toXML(generatedXML, true);
        generatedXML.writeElement("D", "lockdiscovery", 1);
        generatedXML.writeElement("D", "prop", 1);
        if (!lockRequestType) {
            resp.addHeader("Lock-Token", "opaquelocktoken:" + lockToken);
        }
        resp.setStatus(exists ? 200 : 201);
        resp.setContentType("text/xml; charset=UTF-8");
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    protected void doUnlock(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.readOnly) {
            resp.sendError(403);
            return;
        }
        if (this.isLocked(req)) {
            resp.sendError(423);
            return;
        }
        String path = this.getRelativePath(req);
        String lockTokenHeader = req.getHeader("Lock-Token");
        if (lockTokenHeader == null) {
            lockTokenHeader = "";
        }
        if (this.prohibited(path) || !this.contentHostingService.allowAddResource(this.adjustId(path)) && !this.contentHostingService.allowUpdateResource(this.adjustId(path))) {
            resp.sendError(403);
            return;
        }
        LockInfo lock = (LockInfo)this.resourceLocks.get(path);
        Enumeration tokenList = null;
        if (lock != null) {
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
            }
            if (lock.tokens.isEmpty()) {
                this.resourceLocks.remove(path);
                this.lockNullResources.remove(path);
            }
        }
        Enumeration collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = (LockInfo)collectionLocksList.nextElement();
            if (!path.equals(lock.path)) continue;
            tokenList = lock.tokens.elements();
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (lockTokenHeader.indexOf(token) == -1) continue;
                lock.tokens.removeElement(token);
                break;
            }
            if (!lock.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lock);
            this.lockNullResources.remove(path);
        }
        resp.setStatus(204);
    }

    private String generateNamespaceDeclarations() {
        return " xmlns:D=\"DAV:\"";
    }

    private boolean isLocked(HttpServletRequest req) {
        String lockTokenHeader;
        String path = this.getRelativePath(req);
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        return this.isLocked(path, ifHeader + lockTokenHeader);
    }

    private boolean isLocked(String path, String ifHeader) {
        LockInfo lock = (LockInfo)this.resourceLocks.get(path);
        Enumeration tokenList = null;
        if (lock != null && lock.hasExpired()) {
            this.resourceLocks.remove(path);
        } else if (lock != null) {
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
            }
            if (!tokenMatch) {
                return true;
            }
        }
        Enumeration collectionLocksList = this.collectionLocks.elements();
        while (collectionLocksList.hasMoreElements()) {
            lock = (LockInfo)collectionLocksList.nextElement();
            if (lock.hasExpired()) {
                this.collectionLocks.removeElement(lock);
                continue;
            }
            if (!path.startsWith(lock.path)) continue;
            tokenList = lock.tokens.elements();
            boolean tokenMatch = false;
            while (tokenList.hasMoreElements()) {
                String token = (String)tokenList.nextElement();
                if (ifHeader.indexOf(token) == -1) continue;
                tokenMatch = true;
            }
            if (tokenMatch) continue;
            return true;
        }
        return false;
    }

    private String getDestinationPath(HttpServletRequest req) {
        String servletPath;
        String pathInfo;
        String destinationPath = req.getHeader("Destination");
        if (destinationPath == null) {
            return null;
        }
        int protocolIndex = destinationPath.indexOf("://");
        if (protocolIndex >= 0) {
            int firstSeparator = destinationPath.indexOf("/", protocolIndex + 4);
            destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
        } else {
            int portIndex;
            String hostName = req.getServerName();
            if (hostName != null && destinationPath.startsWith(hostName)) {
                destinationPath = destinationPath.substring(hostName.length());
            }
            if ((portIndex = destinationPath.indexOf(":")) >= 0) {
                destinationPath = destinationPath.substring(portIndex);
            }
            if (destinationPath.startsWith(":")) {
                int firstSeparator = destinationPath.indexOf("/");
                destinationPath = firstSeparator < 0 ? "/" : destinationPath.substring(firstSeparator);
            }
        }
        String contextPath = req.getContextPath();
        if (contextPath != null && destinationPath.startsWith(contextPath)) {
            destinationPath = destinationPath.substring(contextPath.length());
        }
        if ((pathInfo = req.getPathInfo()) != null && (servletPath = req.getServletPath()) != null && destinationPath.startsWith(servletPath)) {
            destinationPath = destinationPath.substring(servletPath.length());
        }
        destinationPath = RequestUtil.URLDecode((String)this.normalize(destinationPath), (String)"UTF8");
        return destinationPath;
    }

    private ResourcePropertiesEdit duplicateResourceProperties(ResourceProperties properties, String id) {
        ResourcePropertiesEdit resourceProperties = this.contentHostingService.newResourceProperties();
        try {
            if (properties == null) {
                return resourceProperties;
            }
            Iterator propertyNames = properties.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                if (propertyName.equals("DAV:displayname")) continue;
                resourceProperties.addProperty(propertyName, properties.getProperty(propertyName));
            }
        }
        catch (Exception e) {
            return resourceProperties;
        }
        return resourceProperties;
    }

    private void copyCollection(String id, String new_id) throws IdUnusedException, PermissionException, TypeException, IdUnusedException, IdLengthException, IdUsedException, IdUniquenessException, IdInvalidException, InUseException, InconsistentException, OverQuotaException, ServerOverloadException {
        int i;
        if (!id.endsWith("/")) {
            id = id + "/";
        }
        if (!new_id.endsWith("/")) {
            new_id = new_id + "/";
        }
        ContentCollection thisCollection = this.contentHostingService.getCollection(id);
        List members = thisCollection.getMembers();
        ResourceProperties properties = thisCollection.getProperties();
        ResourcePropertiesEdit newProps = this.duplicateResourceProperties(properties, thisCollection.getId());
        String name = new_id;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        if ((i = name.lastIndexOf("/")) >= 0) {
            name = name.substring(i + 1);
        }
        newProps.addProperty("DAV:displayname", name);
        this.contentHostingService.addCollection(new_id, (ResourceProperties)newProps);
        for (String member_id : members) {
            if (this.doProtected && member_id.toLowerCase().indexOf("/protected") >= 0 && !this.contentHostingService.allowAddCollection(this.adjustId(member_id))) continue;
            this.contentHostingService.copyIntoFolder(member_id, new_id);
        }
    }

    private boolean copyResource(HttpServletRequest req, HttpServletResponse resp, boolean move) throws ServletException, IOException {
        DirContextSAKAI resources;
        String destinationPath = this.getDestinationPath(req);
        if (destinationPath == null) {
            resp.sendError(400);
            return false;
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Dest path :" + destinationPath));
        }
        if (destinationPath.toUpperCase().startsWith("/WEB-INF") || destinationPath.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        String path = this.getRelativePath(req);
        if (this.prohibited(path) || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        if (this.prohibited(destinationPath) || destinationPath.equals(path)) {
            resp.sendError(403);
            return false;
        }
        boolean overwrite = true;
        String overwriteHeader = req.getHeader("Overwrite");
        if (overwriteHeader != null) {
            overwrite = overwriteHeader.equalsIgnoreCase("T");
        }
        if ((resources = this.getResourcesSAKAI()) == null) {
            resp.sendError(500);
            return false;
        }
        boolean exists = true;
        try {
            resources.lookup(destinationPath);
        }
        catch (NamingException e) {
            exists = false;
        }
        if (overwrite) {
            if (exists) {
                if (!this.deleteResource(destinationPath, req, resp)) {
                    return false;
                }
                resp.setStatus(204);
            } else {
                resp.setStatus(201);
            }
        } else if (exists) {
            resp.sendError(412);
            return false;
        }
        String destParentId = this.isolateContainingId(this.adjustId(destinationPath));
        try {
            this.contentHostingService.getCollection(destParentId);
        }
        catch (IdUnusedException e1) {
            resp.sendError(409);
            return false;
        }
        catch (TypeException e1) {
            resp.sendError(403);
            return false;
        }
        catch (PermissionException e1) {
            resp.sendError(403);
            return false;
        }
        Hashtable errorList = new Hashtable();
        boolean result = this.copyResource(resources, errorList, path, destinationPath, move);
        if (!result || !errorList.isEmpty()) {
            this.sendReport(req, resp, errorList);
            return false;
        }
        try {
            String filename = null;
            filename = destinationPath.indexOf(47) >= 0 ? destinationPath.substring(destinationPath.lastIndexOf(47) + 1) : destinationPath;
            if (filename.length() == 0) {
                filename = "null";
            }
            ContentResourceEdit edit = this.contentHostingService.editResource(this.adjustId(this.fixDirPathSAKAI(destinationPath)));
            ResourcePropertiesEdit newProps = edit.getPropertiesEdit();
            newProps.addProperty("DAV:displayname", Validator.escapeResourceName((String)filename));
            this.contentHostingService.commitResource(edit, 0);
        }
        catch (Exception e) {
            M_log.info((Object)("copyResource unable to set new displayname " + e));
        }
        this.lockNullResources.remove(destinationPath);
        if (overwrite) {
            resp.setStatus(204);
        } else {
            resp.setStatus(201);
        }
        return true;
    }

    private boolean copyResource(DirContextSAKAI resources, Hashtable<String, Integer> errorList, String source, String dest, boolean move) {
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("Copy: " + source + " To: " + dest));
        }
        source = this.fixDirPathSAKAI(source);
        dest = this.fixDirPathSAKAI(dest);
        if (this.prohibited(source) || this.prohibited(dest)) {
            errorList.put(source, new Integer(403));
            return false;
        }
        source = this.adjustId(source);
        dest = this.adjustId(dest);
        try {
            boolean isCollection = this.contentHostingService.getProperties(source).getBooleanProperty("CHEF:is-collection");
            if (isCollection) {
                this.copyCollection(source, dest);
            } else {
                this.contentHostingService.copy(source, dest);
            }
        }
        catch (EntityPropertyNotDefinedException e) {
            errorList.put(source, new Integer(500));
            return false;
        }
        catch (EntityPropertyTypeException e) {
            errorList.put(source, new Integer(500));
            return false;
        }
        catch (IdUsedException e) {
            errorList.put(source, new Integer(500));
            return false;
        }
        catch (IdUniquenessException e) {
            errorList.put(source, new Integer(500));
            return false;
        }
        catch (IdLengthException e) {
            errorList.put(source, new Integer(403));
            return false;
        }
        catch (InconsistentException e) {
            errorList.put(source, new Integer(409));
            return false;
        }
        catch (PermissionException e) {
            errorList.put(source, new Integer(403));
            return false;
        }
        catch (InUseException e) {
            errorList.put(source, new Integer(409));
            return false;
        }
        catch (IdUnusedException e) {
            errorList.put(source, new Integer(404));
            return false;
        }
        catch (OverQuotaException e) {
            errorList.put(source, new Integer(403));
            return false;
        }
        catch (IdInvalidException e) {
            errorList.put(source, new Integer(403));
            return false;
        }
        catch (TypeException e) {
            errorList.put(source, new Integer(403));
            return false;
        }
        catch (ServerOverloadException e) {
            errorList.put(source, new Integer(500));
            return false;
        }
        errorList.clear();
        return true;
    }

    private boolean deleteResource(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String path = this.getRelativePathSAKAI(req);
        return this.deleteResource(path, req, resp);
    }

    private boolean deleteResource(String path, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String lockTokenHeader;
        if (this.prohibited(path) || path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            resp.sendError(403);
            return false;
        }
        String ifHeader = req.getHeader("If");
        if (ifHeader == null) {
            ifHeader = "";
        }
        if ((lockTokenHeader = req.getHeader("Lock-Token")) == null) {
            lockTokenHeader = "";
        }
        if (this.isLocked(path, ifHeader + lockTokenHeader)) {
            resp.sendError(423);
            return false;
        }
        path = this.fixDirPathSAKAI(path);
        boolean isCollection = false;
        try {
            isCollection = this.contentHostingService.getProperties(this.adjustId(path)).getBooleanProperty("CHEF:is-collection");
            if (isCollection) {
                this.contentHostingService.removeCollection(this.adjustId(path));
            } else {
                this.contentHostingService.removeResource(this.adjustId(path));
            }
        }
        catch (PermissionException e) {
            resp.sendError(403);
            return false;
        }
        catch (InUseException e) {
            return false;
        }
        catch (IdUnusedException e) {
            resp.sendError(404);
            return false;
        }
        catch (EntityPropertyNotDefinedException e) {
            M_log.warn((Object)("SAKAIDavServlet.deleteResource() - EntityPropertyNotDefinedException " + path));
            return false;
        }
        catch (EntityPropertyTypeException e) {
            M_log.warn((Object)("SAKAIDavServlet.deleteResource() - EntityPropertyTypeException " + path));
            return false;
        }
        catch (TypeException e) {
            M_log.warn((Object)("SAKAIDavServlet.deleteResource() - TypeException " + path));
            return false;
        }
        catch (ServerOverloadException e) {
            M_log.warn((Object)("SAKAIDavServlet.deleteResource() - ServerOverloadException " + path));
            return false;
        }
        return true;
    }

    private void sendReport(HttpServletRequest req, HttpServletResponse resp, Hashtable<String, Integer> errorList) throws ServletException, IOException {
        resp.setStatus(207);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        XMLWriter generatedXML = new XMLWriter();
        generatedXML.writeXMLHeader();
        generatedXML.writeElement("D", "multistatus" + this.generateNamespaceDeclarations(), 0);
        Enumeration<String> pathList = errorList.keys();
        while (pathList.hasMoreElements()) {
            String errorPath = pathList.nextElement();
            int errorCode = errorList.get(errorPath);
            generatedXML.writeElement("D", "response", 0);
            generatedXML.writeElement("D", "href", 0);
            String toAppend = errorPath.substring(relativePath.length());
            if (!toAppend.startsWith("/")) {
                toAppend = "/" + toAppend;
            }
            generatedXML.writeText(absoluteUri + toAppend);
            generatedXML.writeElement("D", "href", 1);
            generatedXML.writeElement("D", "status", 0);
            generatedXML.writeText("HTTP/1.1 " + errorCode + " " + SakaidavStatus.getStatusText((int)errorCode));
            generatedXML.writeElement("D", "status", 1);
            generatedXML.writeElement("D", "response", 1);
        }
        generatedXML.writeElement("D", "multistatus", 1);
        PrintWriter writer = resp.getWriter();
        ((Writer)writer).write(generatedXML.toString());
        ((Writer)writer).close();
    }

    private void parseProperties(HttpServletRequest req, DirContextSAKAI resources, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        ResourceInfoSAKAI resourceInfo = new ResourceInfoSAKAI(this, path, resources);
        generatedXML.writeElement("D", "response", 0);
        String status = new String("HTTP/1.1 200 " + SakaidavStatus.getStatusText((int)200));
        generatedXML.writeElement("D", "href", 0);
        String href = (String)req.getAttribute("javax.servlet.forward.servlet_path");
        if (href == null) {
            href = (String)req.getAttribute("javax.servlet.include.servlet_path");
        }
        if (href == null) {
            href = req.getContextPath();
        }
        href = href.endsWith("/") && path.startsWith("/") ? href + path.substring(1) : href + path;
        if (resourceInfo.collection && !href.endsWith("/")) {
            href = href + "/";
        }
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("parserProperties href=" + href));
        }
        generatedXML.writeText(this.rewriteUrl(href));
        generatedXML.writeElement("D", "href", 1);
        String resourceName = this.justName(path);
        switch (type) {
            case 1: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                generatedXML.writeElement("D", "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("D", "displayname", 1);
                generatedXML.writeProperty("D", "getcontentlanguage", Locale.getDefault().toString());
                if (!resourceInfo.collection) {
                    generatedXML.writeProperty("D", "getlastmodified", resourceInfo.httpDate);
                    generatedXML.writeProperty("D", "getcontentlength", String.valueOf(resourceInfo.length));
                    generatedXML.writeProperty("D", "getcontenttype", resourceInfo.MIMEType);
                    generatedXML.writeProperty("D", "getetag", resourceInfo.eTag);
                    generatedXML.writeElement("D", "resourcetype", 2);
                } else {
                    generatedXML.writeElement("D", "resourcetype", 0);
                    generatedXML.writeElement("D", "collection", 2);
                    generatedXML.writeElement("D", "resourcetype", 1);
                }
                generatedXML.writeProperty("D", "source", "");
                String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                generatedXML.writeElement("D", "displayname", 2);
                if (!resourceInfo.collection) {
                    generatedXML.writeElement("D", "getcontentlanguage", 2);
                    generatedXML.writeElement("D", "getcontentlength", 2);
                    generatedXML.writeElement("D", "getcontenttype", 2);
                    generatedXML.writeElement("D", "getetag", 2);
                    generatedXML.writeElement("D", "getlastmodified", 2);
                }
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "source", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement("D", "displayname", 0);
                        generatedXML.writeData(resourceInfo.displayName);
                        generatedXML.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getcontentlength", String.valueOf(resourceInfo.length));
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getcontenttype", this.getServletContext().getMimeType(ResourceInfoSAKAI.access$000((ResourceInfoSAKAI)resourceInfo)));
                        continue;
                    }
                    if (property.equals("getetag")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getetag", resourceInfo.eTag);
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        if (resourceInfo.collection) {
                            propertiesNotFound.addElement(property);
                            continue;
                        }
                        generatedXML.writeProperty("D", "getlastmodified", resourceInfo.httpDate);
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        if (resourceInfo.collection) {
                            generatedXML.writeElement("D", "resourcetype", 0);
                            generatedXML.writeElement("D", "collection", 2);
                            generatedXML.writeElement("D", "resourcetype", 1);
                            continue;
                        }
                        generatedXML.writeElement("D", "resourcetype", 2);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty("D", "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = new String("HTTP/1.1 404 " + SakaidavStatus.getStatusText((int)404));
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement("D", (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private void parseLockNullProperties(HttpServletRequest req, XMLWriter generatedXML, String path, int type, Vector<String> propertiesVector) {
        if (path.toUpperCase().startsWith("/WEB-INF") || path.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        LockInfo lock = (LockInfo)this.resourceLocks.get(path);
        if (lock == null) {
            return;
        }
        generatedXML.writeElement("D", "response", 0);
        String status = new String("HTTP/1.1 200 " + SakaidavStatus.getStatusText((int)200));
        generatedXML.writeElement("D", "href", 0);
        String absoluteUri = req.getRequestURI();
        String relativePath = this.getRelativePath(req);
        String toAppend = path.substring(relativePath.length());
        if (!toAppend.startsWith("/")) {
            toAppend = "/" + toAppend;
        }
        generatedXML.writeText(this.rewriteUrl(this.normalize(absoluteUri + toAppend)));
        generatedXML.writeElement("D", "href", 1);
        String resourceName = this.justName(path);
        switch (type) {
            case 1: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                generatedXML.writeElement("D", "displayname", 0);
                generatedXML.writeData(resourceName);
                generatedXML.writeElement("D", "displayname", 1);
                generatedXML.writeProperty("D", "getcontentlanguage", Locale.getDefault().toString());
                generatedXML.writeProperty("D", "getlastmodified", this.dateFormats()[0].format(lock.creationDate));
                generatedXML.writeProperty("D", "getcontentlength", String.valueOf(0));
                generatedXML.writeProperty("D", "getcontenttype", "");
                generatedXML.writeProperty("D", "getetag", "");
                generatedXML.writeElement("D", "resourcetype", 0);
                generatedXML.writeElement("D", "lock-null", 2);
                generatedXML.writeElement("D", "resourcetype", 1);
                generatedXML.writeProperty("D", "source", "");
                String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                generatedXML.writeElement("D", "supportedlock", 0);
                generatedXML.writeText(supportedLocks);
                generatedXML.writeElement("D", "supportedlock", 1);
                this.generateLockDiscovery(path, generatedXML);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 2: {
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                generatedXML.writeElement("D", "creationdate", 2);
                generatedXML.writeElement("D", "displayname", 2);
                generatedXML.writeElement("D", "getcontentlanguage", 2);
                generatedXML.writeElement("D", "getcontentlength", 2);
                generatedXML.writeElement("D", "getcontenttype", 2);
                generatedXML.writeElement("D", "getetag", 2);
                generatedXML.writeElement("D", "getlastmodified", 2);
                generatedXML.writeElement("D", "resourcetype", 2);
                generatedXML.writeElement("D", "source", 2);
                generatedXML.writeElement("D", "lockdiscovery", 2);
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                break;
            }
            case 0: {
                Vector<String> propertiesNotFound = new Vector<String>();
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                Enumeration<String> properties = propertiesVector.elements();
                while (properties.hasMoreElements()) {
                    String property = properties.nextElement();
                    if (property.equals("creationdate")) {
                        generatedXML.writeProperty("D", "creationdate", this.getISOCreationDate(lock.creationDate.getTime()));
                        continue;
                    }
                    if (property.equals("displayname")) {
                        generatedXML.writeElement("D", "displayname", 0);
                        generatedXML.writeData(resourceName);
                        generatedXML.writeElement("D", "displayname", 1);
                        continue;
                    }
                    if (property.equals("getcontentlanguage")) {
                        generatedXML.writeProperty("D", "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (property.equals("getcontentlength")) {
                        generatedXML.writeProperty("D", "getcontentlength", String.valueOf(0));
                        continue;
                    }
                    if (property.equals("getcontenttype")) {
                        generatedXML.writeProperty("D", "getcontenttype", "");
                        continue;
                    }
                    if (property.equals("getetag")) {
                        generatedXML.writeProperty("D", "getetag", "");
                        continue;
                    }
                    if (property.equals("getlastmodified")) {
                        generatedXML.writeProperty("D", "getlastmodified", this.dateFormats()[0].format(lock.creationDate));
                        continue;
                    }
                    if (property.equals("resourcetype")) {
                        generatedXML.writeElement("D", "resourcetype", 0);
                        generatedXML.writeElement("D", "lock-null", 2);
                        generatedXML.writeElement("D", "resourcetype", 1);
                        continue;
                    }
                    if (property.equals("source")) {
                        generatedXML.writeProperty("D", "source", "");
                        continue;
                    }
                    if (property.equals("supportedlock")) {
                        String supportedLocks = "<D:lockentry><D:lockscope><D:exclusive/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry><D:lockentry><D:lockscope><D:shared/></D:lockscope><D:locktype><D:write/></D:locktype></D:lockentry>";
                        generatedXML.writeElement("D", "supportedlock", 0);
                        generatedXML.writeText(supportedLocks);
                        generatedXML.writeElement("D", "supportedlock", 1);
                        continue;
                    }
                    if (property.equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(path, generatedXML)) continue;
                        propertiesNotFound.addElement(property);
                        continue;
                    }
                    propertiesNotFound.addElement(property);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
                Enumeration propertiesNotFoundList = propertiesNotFound.elements();
                if (!propertiesNotFoundList.hasMoreElements()) break;
                status = new String("HTTP/1.1 404 " + SakaidavStatus.getStatusText((int)404));
                generatedXML.writeElement("D", "propstat", 0);
                generatedXML.writeElement("D", "prop", 0);
                while (propertiesNotFoundList.hasMoreElements()) {
                    generatedXML.writeElement("D", (String)propertiesNotFoundList.nextElement(), 2);
                }
                generatedXML.writeElement("D", "prop", 1);
                generatedXML.writeElement("D", "status", 0);
                generatedXML.writeText(status);
                generatedXML.writeElement("D", "status", 1);
                generatedXML.writeElement("D", "propstat", 1);
            }
        }
        generatedXML.writeElement("D", "response", 1);
    }

    private boolean generateLockDiscovery(String path, XMLWriter generatedXML) {
        LockInfo resourceLock = (LockInfo)this.resourceLocks.get(path);
        Enumeration collectionLocksList = this.collectionLocks.elements();
        boolean wroteStart = false;
        if (resourceLock != null) {
            wroteStart = true;
            generatedXML.writeElement("D", "lockdiscovery", 0);
            resourceLock.toXML(generatedXML);
        }
        while (collectionLocksList.hasMoreElements()) {
            LockInfo currentLock = (LockInfo)collectionLocksList.nextElement();
            if (!path.startsWith(currentLock.path)) continue;
            if (!wroteStart) {
                wroteStart = true;
                generatedXML.writeElement("D", "lockdiscovery", 0);
            }
            currentLock.toXML(generatedXML);
        }
        if (!wroteStart) {
            return false;
        }
        generatedXML.writeElement("D", "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long creationDate) {
        StringBuilder creationDateValue = new StringBuilder(this.creationDateFormat().format(new Date(creationDate)));
        return creationDateValue.toString();
    }

    private String getHttpDate(long dateMS) {
        return this.httpDateFormat().format(new Date(dateMS));
    }

    static /* synthetic */ Log access$100() {
        return M_log;
    }

    static /* synthetic */ ContentHostingService access$200(DavServlet x0) {
        return x0.contentHostingService;
    }

    static /* synthetic */ String access$300(DavServlet x0, long x1) {
        return x0.getHttpDate(x1);
    }

    static /* synthetic */ SimpleDateFormat[] access$400(DavServlet x0) {
        return x0.dateFormats();
    }

    static {
        int i;
        M_log = LogFactory.getLog(DavServlet.class);
        rb = new ResourceLoader("org.sakaiproject.tool.dav.bundle.Messages");
        hexadecimal = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        safeCharacters = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            safeCharacters.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            safeCharacters.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            safeCharacters.set(i);
        }
        safeCharacters.set(45);
        safeCharacters.set(95);
        safeCharacters.set(46);
        safeCharacters.set(42);
        safeCharacters.set(47);
    }
}

