/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.user.api.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SiteSearchResult
implements Serializable {
    private SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
    private SimpleDateFormat formatWithTime = new SimpleDateFormat("MM/dd/yyyy h:mm a");
    private SiteSerialized site;
    private List<UserSerialized> instructors = new ArrayList<UserSerialized>();
    private String[] access;
    private String shoppingPeriodAuth;
    private Date shoppingPeriodStartDate;
    private Date shoppingPeriodEndDate;
    private String[] restrictedTools;
    private Date modified;
    private String modifiedBy;
    private String modifiedBySortName;

    public SiteSearchResult(Site site, List<User> instructors, String termProp) {
        this.site = new SiteSerialized(site, termProp);
        this.instructors = new ArrayList<UserSerialized>();
        for (User user : instructors) {
            this.instructors.add(new UserSerialized(user));
        }
    }

    private SiteSerialized getSite() {
        return this.site;
    }

    public List<UserSerialized> getInstructors() {
        return this.instructors;
    }

    public void setInstructors(List<UserSerialized> instructors) {
        this.instructors = instructors;
    }

    public void addInstructor(User user) {
        this.instructors.add(new UserSerialized(user));
    }

    public String getInstructorsString() {
        String instructors = "";
        for (UserSerialized user : this.getInstructors()) {
            if (!"".equals(instructors)) {
                instructors = instructors + "; ";
            }
            instructors = instructors + user.getSortName();
        }
        return instructors;
    }

    public String[] getAccess() {
        return this.access;
    }

    public void setAccess(String[] access) {
        this.access = access;
    }

    public String getAccessString() {
        return this.getAccess() != null && this.getAccess().length == 2 ? this.getAccess()[0] + ":" + this.getAccess()[1] : "";
    }

    public String getShoppingPeriodAuth() {
        return this.shoppingPeriodAuth;
    }

    public void setShoppingPeriodAuth(String shoppingPeriodAuth) {
        this.shoppingPeriodAuth = shoppingPeriodAuth;
    }

    public Date getShoppingPeriodStartDate() {
        return this.shoppingPeriodStartDate;
    }

    public void setShoppingPeriodStartDate(Date shoppingPeriodStartDate) {
        this.shoppingPeriodStartDate = shoppingPeriodStartDate;
    }

    public Date getShoppingPeriodEndDate() {
        return this.shoppingPeriodEndDate;
    }

    public void setShoppingPeriodEndDate(Date shoppingPeriodEndDate) {
        this.shoppingPeriodEndDate = shoppingPeriodEndDate;
    }

    public String getShoppingPeriodStartDateStr() {
        if (this.getShoppingPeriodStartDate() == null) {
            return "";
        }
        return this.format.format(this.getShoppingPeriodStartDate());
    }

    public String getShoppingPeriodEndDateStr() {
        if (this.getShoppingPeriodEndDate() == null) {
            return "";
        }
        return this.format.format(this.getShoppingPeriodEndDate());
    }

    public String getSiteTerm() {
        String prop = this.getSite().getTerm();
        return prop == null ? "" : prop.toString();
    }

    public String[] getRestrictedTools() {
        return this.restrictedTools;
    }

    public void setRestrictedTools(String[] restrictedTools) {
        this.restrictedTools = restrictedTools;
    }

    public String getToolsString(Map<String, String> toolsMap) {
        String restrictedToolsStr = "";
        if (this.getRestrictedTools() != null) {
            for (String tool : this.getRestrictedTools()) {
                String toolName;
                if (!"".equals(this.restrictedTools)) {
                    restrictedToolsStr = restrictedToolsStr + ", ";
                }
                if (toolsMap.containsKey(toolName = tool)) {
                    toolName = toolsMap.get(toolName);
                }
                restrictedToolsStr = restrictedToolsStr + toolName;
            }
        }
        return restrictedToolsStr;
    }

    public String getSiteUrl() {
        return this.getSite().getUrl();
    }

    public String getSiteTitle() {
        return this.getSite().getTitle();
    }

    public String getSiteId() {
        return this.getSite().getId();
    }

    public String getSiteReference() {
        return this.getSite().getReference();
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getModifiedBySortName() {
        return this.modifiedBySortName;
    }

    public void setModifiedBySortName(String modifiedBySortName) {
        this.modifiedBySortName = modifiedBySortName;
    }

    public String getModifiedStr() {
        if (this.getModified() == null) {
            return "";
        }
        return this.formatWithTime.format(this.getModified());
    }

    public class SiteSerialized
    implements Serializable {
        private String url;
        private String id;
        private String title;
        private String term;
        private String reference;

        public SiteSerialized(Site site, String termProp) {
            this.id = site.getId();
            this.url = site.getUrl();
            this.title = site.getTitle();
            Object prop = site.getProperties().get(termProp);
            this.term = "";
            if (prop != null) {
                this.term = prop.toString();
            }
            this.reference = site.getReference();
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getTerm() {
            return this.term;
        }

        public void setTerm(String term) {
            this.term = term;
        }

        public String getReference() {
            return this.reference;
        }

        public void setReference(String reference) {
            this.reference = reference;
        }
    }

    public class UserSerialized
    implements Serializable {
        private String userId;
        private String displayName;
        private String sortName;

        public UserSerialized(User user) {
            this.userId = user.getId();
            this.displayName = user.getDisplayName();
            this.sortName = user.getSortName();
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getSortName() {
            return this.sortName;
        }

        public void setSortName(String sortName) {
            this.sortName = sortName;
        }
    }
}

