/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sakaiproject.delegatedaccess.model.HierarchyNodeSerialized;
import org.sakaiproject.delegatedaccess.model.ListOptionSerialized;
import org.sakaiproject.delegatedaccess.model.SelectOption;

public class NodeModel
implements Serializable {
    private String nodeId;
    private HierarchyNodeSerialized node;
    private boolean directAccessOrig = false;
    private boolean directAccess = false;
    private boolean accessAdmin = false;
    private boolean accessAdminOrig = false;
    private String realm = "";
    private String role = "";
    private String realmOrig = "";
    private String roleOrig = "";
    private NodeModel parentNode;
    private List<ListOptionSerialized> restrictedTools;
    private List<ListOptionSerialized> restrictedToolsOrig;
    private Date shoppingPeriodStartDate = new Date();
    private Date shoppingPeriodStartDateOrig = new Date();
    private Date shoppingPeriodEndDate = new Date();
    private Date shoppingPeriodEndDateOrig = new Date();
    private String shoppingPeriodAuthOrig;
    private boolean addedDirectChildrenFlag = false;
    private boolean shoppingPeriodAdmin = false;
    private boolean shoppingPeriodAdminOrig = false;
    private String siteInstructors;
    private SelectOption shoppingPeriodAuthOption;
    private SelectOption roleOption;
    private Date shoppingAdminModified = null;
    private String shoppingAdminModifiedBy = null;
    private Date modified = null;
    private String modifiedBy = null;
    private boolean editable = true;
    private boolean shoppingPeriodRevokeInstructorEditable = false;
    private boolean shoppingPeriodRevokeInstructorEditableOrig = false;

    public void setOriginals() {
        this.directAccessOrig = this.directAccess;
        this.accessAdminOrig = this.accessAdmin;
        this.shoppingPeriodAdminOrig = this.shoppingPeriodAdmin;
        this.realmOrig = this.realm;
        this.roleOrig = this.role;
        this.restrictedToolsOrig = this.copyListOptions(this.restrictedTools);
        this.shoppingPeriodStartDateOrig = this.shoppingPeriodStartDate;
        this.shoppingPeriodEndDateOrig = this.shoppingPeriodEndDate;
        this.shoppingPeriodAuthOrig = this.getShoppingPeriodAuth();
        this.shoppingPeriodRevokeInstructorEditableOrig = this.shoppingPeriodRevokeInstructorEditable;
    }

    public NodeModel(String nodeId, HierarchyNodeSerialized node, boolean directAccess, String realm, String role, NodeModel parentNode, List<ListOptionSerialized> restrictedTools, Date shoppingPeriodStartDate, Date shoppingPeriodEndDate, String shoppingPeriodAuth, boolean addedDirectChildrenFlag, boolean shoppingPeriodAdmin, String modifiedBy, Date modified, Date shoppingAdminModified, String shoppingAdminModifiedBy, boolean accessAdmin, boolean shoppingPeriodRevokeInstructorEditable) {
        this.nodeId = nodeId;
        this.node = node;
        this.directAccessOrig = directAccess;
        this.directAccess = directAccess;
        this.realm = realm;
        this.role = role;
        this.realmOrig = realm;
        this.roleOrig = role;
        this.parentNode = parentNode;
        this.restrictedTools = restrictedTools;
        this.restrictedToolsOrig = this.copyListOptions(restrictedTools);
        this.setShoppingPeriodAuth(shoppingPeriodAuth);
        this.shoppingPeriodAuthOrig = shoppingPeriodAuth;
        this.shoppingPeriodEndDate = shoppingPeriodEndDate;
        this.shoppingPeriodEndDateOrig = shoppingPeriodEndDate;
        this.shoppingPeriodStartDate = shoppingPeriodStartDate;
        this.shoppingPeriodStartDateOrig = shoppingPeriodStartDate;
        this.addedDirectChildrenFlag = addedDirectChildrenFlag;
        this.shoppingPeriodAdmin = shoppingPeriodAdmin;
        this.shoppingPeriodAdminOrig = shoppingPeriodAdmin;
        this.modifiedBy = modifiedBy;
        this.modified = modified;
        this.shoppingAdminModified = shoppingAdminModified;
        this.shoppingAdminModifiedBy = shoppingAdminModifiedBy;
        this.accessAdmin = accessAdmin;
        this.accessAdminOrig = accessAdmin;
        this.shoppingPeriodRevokeInstructorEditable = shoppingPeriodRevokeInstructorEditable;
        this.shoppingPeriodRevokeInstructorEditableOrig = shoppingPeriodRevokeInstructorEditable;
    }

    private List<ListOptionSerialized> copyListOptions(List<ListOptionSerialized> tools) {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : tools) {
            returnList.add(new ListOptionSerialized(tool.getId(), tool.getName(), tool.isSelected()));
        }
        return returnList;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public HierarchyNodeSerialized getNode() {
        return this.node;
    }

    public void setNode(HierarchyNodeSerialized node) {
        this.node = node;
    }

    public boolean isDirectAccessOrig() {
        return this.directAccessOrig;
    }

    public void setDirectAccessOrig(boolean directAccess) {
        this.directAccessOrig = directAccess;
    }

    public String toString() {
        return this.node.description;
    }

    public boolean isDirectAccess() {
        return this.directAccess;
    }

    public void setDirectAccess(boolean directAccess) {
        this.directAccess = directAccess;
    }

    public boolean isModified() {
        if (this.directAccessOrig != this.directAccess) {
            return true;
        }
        if (this.shoppingPeriodAdmin != this.shoppingPeriodAdminOrig) {
            return true;
        }
        if (this.accessAdmin != this.accessAdminOrig) {
            return true;
        }
        if (this.shoppingPeriodRevokeInstructorEditable != this.shoppingPeriodRevokeInstructorEditableOrig) {
            return true;
        }
        if (this.directAccess) {
            return this.isModified(this.getShoppingPeriodAuth(), this.shoppingPeriodAuthOrig, this.shoppingPeriodStartDate, this.shoppingPeriodStartDateOrig, this.shoppingPeriodEndDate, this.shoppingPeriodEndDateOrig, this.realm, this.realmOrig, this.role, this.roleOrig, this.convertListToArray(this.getSelectedRestrictedTools()), this.convertListToArray(this.getSelectedRestrictedToolsOrig()));
        }
        return false;
    }

    public boolean isModified(String shoppingAuthOld, String shoppingAuthNew, Date shoppingStartDateOld, Date shoppingStartDateNew, Date shoppingEndDateOld, Date shoppingEndDateNew, String realmOld, String realmNew, String roleOld, String roleNew, String[] toolsOld, String[] toolsNew) {
        if (realmOld != null && realmNew != null ? !realmOld.equals(realmNew) : !(realmOld != null && realmNew != null || realmOld == null && realmNew == null)) {
            return true;
        }
        if (shoppingStartDateOld != null && shoppingStartDateNew != null ? !shoppingStartDateOld.equals(shoppingStartDateNew) : !(shoppingStartDateOld != null && shoppingStartDateNew != null || shoppingStartDateOld == null && shoppingStartDateNew == null)) {
            return true;
        }
        if (shoppingEndDateOld != null && shoppingEndDateNew != null ? !shoppingEndDateOld.equals(shoppingEndDateNew) : !(shoppingEndDateOld != null && shoppingEndDateNew != null || shoppingEndDateOld == null && shoppingEndDateNew == null)) {
            return true;
        }
        if (roleOld != null && roleNew != null ? !roleOld.equals(roleNew) : !(roleOld != null && roleNew != null || roleOld == null && roleNew == null)) {
            return true;
        }
        if (shoppingAuthOld != null && shoppingAuthNew != null ? !shoppingAuthOld.equals(shoppingAuthNew) : !(shoppingAuthOld != null && shoppingAuthNew != null || shoppingAuthOld == null && shoppingAuthNew == null)) {
            return true;
        }
        if (toolsOld != null && toolsNew != null) {
            if (toolsOld.length != toolsNew.length) {
                return true;
            }
            for (int i = 0; i < toolsOld.length; ++i) {
                boolean found = false;
                for (int j = 0; j < toolsNew.length; ++j) {
                    if (!toolsOld[i].equals(toolsNew[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return true;
            }
        } else if (!(toolsOld != null && toolsNew != null || toolsOld == null && toolsNew == null)) {
            return true;
        }
        return false;
    }

    private boolean isRestrictedToolsModified() {
        for (ListOptionSerialized origTool : this.restrictedToolsOrig) {
            for (ListOptionSerialized tool : this.restrictedTools) {
                if (!tool.getId().equals(origTool.getId()) || tool.isSelected() == origTool.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String[] getNodeAccessRealmRole() {
        String[] myAccessRealmRole = new String[]{this.getRealm(), this.getRole()};
        if (!this.isDirectAccess()) {
            myAccessRealmRole = this.getInheritedAccessRealmRole();
        }
        if (myAccessRealmRole == null || "".equals(myAccessRealmRole[0]) || "".equals(myAccessRealmRole[1])) {
            return new String[]{"", ""};
        }
        return myAccessRealmRole;
    }

    public String getNodeShoppingPeriodAuth() {
        if (this.isDirectAccess()) {
            return this.getShoppingPeriodAuth();
        }
        return this.getInheritedShoppingPeriodAuth();
    }

    public Date getNodeShoppingPeriodStartDate() {
        if (this.isDirectAccess()) {
            return this.getShoppingPeriodStartDate();
        }
        return this.getInheritedShoppingPeriodStartDate();
    }

    public Date getNodeShoppingPeriodEndDate() {
        if (this.isDirectAccess()) {
            return this.getShoppingPeriodEndDate();
        }
        return this.getInheritedShoppingPeriodEndDate();
    }

    public boolean getNodeAccess() {
        if (this.isDirectAccess()) {
            return true;
        }
        return this.getInheritedNodeAccess();
    }

    public boolean getInheritedNodeAccess() {
        return this.getInheritedNodeAccessHelper(this.parentNode);
    }

    public boolean getInheritedNodeAccessHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isDirectAccess()) {
            return true;
        }
        return this.getInheritedNodeAccessHelper(parent.getParentNode());
    }

    public String[] getInheritedAccessRealmRole() {
        return this.getInheritedAccessRealmRoleHelper(this.parentNode);
    }

    private String[] getInheritedAccessRealmRoleHelper(NodeModel parent) {
        if (parent == null) {
            return new String[]{"", ""};
        }
        if (parent.isDirectAccess()) {
            return new String[]{parent.getRealm(), parent.getRole()};
        }
        return this.getInheritedAccessRealmRoleHelper(parent.getParentNode());
    }

    public Date getInheritedShoppingPeriodEndDate() {
        return this.getInheritedShoppingPeriodEndDateHelper(this.parentNode);
    }

    private Date getInheritedShoppingPeriodEndDateHelper(NodeModel parent) {
        if (parent == null) {
            return null;
        }
        if (parent.isDirectAccess()) {
            return parent.getShoppingPeriodEndDate();
        }
        return this.getInheritedShoppingPeriodEndDateHelper(parent.getParentNode());
    }

    public Date getInheritedShoppingPeriodStartDate() {
        return this.getInheritedShoppingPeriodStartDateHelper(this.parentNode);
    }

    private Date getInheritedShoppingPeriodStartDateHelper(NodeModel parent) {
        if (parent == null) {
            return null;
        }
        if (parent.isDirectAccess()) {
            return parent.getShoppingPeriodStartDate();
        }
        return this.getInheritedShoppingPeriodStartDateHelper(parent.getParentNode());
    }

    public String getInheritedShoppingPeriodAuth() {
        return this.getInheritedShoppingPeriodAuthHelper(this.parentNode);
    }

    private String getInheritedShoppingPeriodAuthHelper(NodeModel parent) {
        if (parent == null) {
            return "";
        }
        if (parent.isDirectAccess()) {
            return parent.getShoppingPeriodAuth();
        }
        return this.getInheritedShoppingPeriodAuthHelper(parent.getParentNode());
    }

    public NodeModel getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(NodeModel parentNode) {
        this.parentNode = parentNode;
    }

    public List<ListOptionSerialized> getRestrictedTools() {
        return this.restrictedTools;
    }

    public void setRestrictedTools(List<ListOptionSerialized> restrictedTools) {
        this.restrictedTools = restrictedTools;
    }

    public String[] getNodeRestrictedTools() {
        List<ListOptionSerialized> myRestrictedTools = this.getSelectedRestrictedTools();
        if (!this.isDirectAccess()) {
            myRestrictedTools = this.getInheritedRestrictedTools();
        }
        if (myRestrictedTools == null || myRestrictedTools.size() == 0) {
            return new String[0];
        }
        return this.convertListToArray(myRestrictedTools);
    }

    private String[] convertListToArray(List<ListOptionSerialized> list) {
        String[] restrictedToolsArray = new String[list.size()];
        int i = 0;
        for (ListOptionSerialized tool : list) {
            restrictedToolsArray[i] = tool.getId();
            ++i;
        }
        return restrictedToolsArray;
    }

    public List<ListOptionSerialized> getInheritedRestrictedTools() {
        return this.getInheritedRestrictedToolsHelper(this.parentNode);
    }

    private List<ListOptionSerialized> getInheritedRestrictedToolsHelper(NodeModel parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        if (parent.isDirectAccess()) {
            return parent.getSelectedRestrictedTools();
        }
        return this.getInheritedRestrictedToolsHelper(parent.getParentNode());
    }

    public List<ListOptionSerialized> getSelectedRestrictedTools() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : this.restrictedTools) {
            if (!tool.isSelected()) continue;
            returnList.add(tool);
        }
        return returnList;
    }

    public List<ListOptionSerialized> getSelectedRestrictedToolsOrig() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : this.restrictedToolsOrig) {
            if (!tool.isSelected()) continue;
            returnList.add(tool);
        }
        return returnList;
    }

    public boolean hasAnyRestrictedToolsSelected() {
        for (ListOptionSerialized tool : this.restrictedTools) {
            if (!tool.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setToolRestricted(String toolId, boolean restricted) {
        for (ListOptionSerialized tool : this.restrictedTools) {
            if (!tool.getId().equals(toolId)) continue;
            tool.setSelected(restricted);
            break;
        }
    }

    public Date getShoppingPeriodStartDate() {
        return this.shoppingPeriodStartDate;
    }

    public void setShoppingPeriodStartDate(Date shoppingPeriodStartDate) {
        this.shoppingPeriodStartDate = shoppingPeriodStartDate;
    }

    public Date getShoppingPeriodEndDate() {
        return this.shoppingPeriodEndDate;
    }

    public void setShoppingPeriodEndDate(Date shoppingPeriodEndDate) {
        this.shoppingPeriodEndDate = shoppingPeriodEndDate;
    }

    public String getShoppingPeriodAuth() {
        String shoppingPeriodAuth = null;
        if (this.shoppingPeriodAuthOption != null) {
            shoppingPeriodAuth = this.shoppingPeriodAuthOption.getValue();
        }
        return shoppingPeriodAuth;
    }

    public void setShoppingPeriodAuth(String shoppingPeriodAuth) {
        if (this.shoppingPeriodAuthOption == null) {
            this.shoppingPeriodAuthOption = new SelectOption("", shoppingPeriodAuth);
        } else {
            this.shoppingPeriodAuthOption.setValue(shoppingPeriodAuth);
            this.shoppingPeriodAuthOption.setLabel("");
        }
    }

    public boolean isAddedDirectChildrenFlag() {
        return this.addedDirectChildrenFlag;
    }

    public void setAddedDirectChildrenFlag(boolean addedDirectChildrenFlag) {
        this.addedDirectChildrenFlag = addedDirectChildrenFlag;
    }

    public boolean isShoppingPeriodAdmin() {
        return this.shoppingPeriodAdmin;
    }

    public boolean isShoppingPeriodAdminOrig() {
        return this.shoppingPeriodAdminOrig;
    }

    public void setShoppingPeriodAdmin(boolean shoppingPeriodAdmin) {
        this.shoppingPeriodAdmin = shoppingPeriodAdmin;
    }

    public boolean getNodeShoppingPeriodAdmin() {
        if (this.isShoppingPeriodAdmin()) {
            return true;
        }
        return this.getInheritedShoppingPeriodAdmin();
    }

    public boolean getInheritedShoppingPeriodAdmin() {
        return this.getInheritedShoppingPeriodAdminHelper(this.parentNode);
    }

    private boolean getInheritedShoppingPeriodAdminHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isShoppingPeriodAdmin()) {
            return true;
        }
        return this.getInheritedShoppingPeriodAdminHelper(parent.getParentNode());
    }

    public String getSiteInstructors() {
        return this.siteInstructors;
    }

    public void setSiteInstructors(String siteInstructors) {
        this.siteInstructors = siteInstructors;
    }

    public void setShoppingPeriodAuthOption(SelectOption shoppingPeriodAuthOption) {
        this.shoppingPeriodAuthOption = shoppingPeriodAuthOption;
    }

    public SelectOption getShoppingPeriodAuthOption() {
        return this.shoppingPeriodAuthOption;
    }

    public SelectOption getRoleOption() {
        return this.roleOption;
    }

    public void setRoleOption(SelectOption roleOption) {
        this.roleOption = roleOption;
    }

    public Date getShoppingAdminModified() {
        return this.shoppingAdminModified;
    }

    public void setShoppingAdminModified(Date shoppingAdminModified) {
        this.shoppingAdminModified = shoppingAdminModified;
    }

    public String getShoppingAdminModifiedBy() {
        return this.shoppingAdminModifiedBy;
    }

    public void setShoppingAdminModifiedBy(String shoppingAdminModifiedBy) {
        this.shoppingAdminModifiedBy = shoppingAdminModifiedBy;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public boolean isAccessAdmin() {
        return this.accessAdmin;
    }

    public void setAccessAdmin(boolean accessAdmin) {
        this.accessAdmin = accessAdmin;
    }

    public boolean isAccessAdminOrig() {
        return this.accessAdminOrig;
    }

    public void setAccessAdminOrig(boolean accessAdminOrig) {
        this.accessAdminOrig = accessAdminOrig;
    }

    public boolean getNodeAccessAdmin() {
        if (this.isAccessAdmin()) {
            return true;
        }
        return this.getInheritedAccessAdmin();
    }

    public boolean getInheritedAccessAdmin() {
        return this.getInheritedAccessAdminHelper(this.parentNode);
    }

    public boolean getInheritedAccessAdminHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isAccessAdmin()) {
            return true;
        }
        return this.getInheritedAccessAdminHelper(parent.getParentNode());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isNodeEditable() {
        if (this.isEditable()) {
            return true;
        }
        return this.getInheritedEditable();
    }

    private boolean getInheritedEditable() {
        return this.getInheritedEditableHelper(this.parentNode);
    }

    private boolean getInheritedEditableHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isEditable()) {
            return true;
        }
        return this.getInheritedEditableHelper(parent.getParentNode());
    }

    public boolean isShoppingPeriodRevokeInstructorEditable() {
        return this.shoppingPeriodRevokeInstructorEditable;
    }

    public void setShoppingPeriodRevokeInstructorEditable(boolean shoppingPeriodRevokeInstructorEditable) {
        this.shoppingPeriodRevokeInstructorEditable = shoppingPeriodRevokeInstructorEditable;
    }

    public boolean isShoppingPeriodRevokeInstructorEditableOrig() {
        return this.shoppingPeriodRevokeInstructorEditableOrig;
    }

    public void setShoppingPeriodRevokeInstructorEditableOrig(boolean shoppingPeriodRevokeInstructorEditableOrig) {
        this.shoppingPeriodRevokeInstructorEditableOrig = shoppingPeriodRevokeInstructorEditableOrig;
    }

    public boolean getNodeShoppingPeriodRevokeInstructorEditable() {
        if (this.isShoppingPeriodRevokeInstructorEditable()) {
            return true;
        }
        return this.getInheritedShoppingPeriodRevokeInstructorEditable();
    }

    public boolean getInheritedShoppingPeriodRevokeInstructorEditable() {
        return this.getInheritedShoppingPeriodRevokeInstructorEditableHelper(this.parentNode);
    }

    public boolean getInheritedShoppingPeriodRevokeInstructorEditableHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isShoppingPeriodRevokeInstructorEditable()) {
            return true;
        }
        return this.getInheritedShoppingPeriodRevokeInstructorEditableHelper(parent.getParentNode());
    }
}

