/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.model;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.sakaiproject.delegatedaccess.model.SiteSerialized;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.user.api.User;

public class SiteSearchResult
implements Serializable {
    private SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
    private SimpleDateFormat formatWithTime = new SimpleDateFormat("MM/dd/yyyy h:mm a");
    private SiteSerialized site;
    private List<UserSerialized> instructors = new ArrayList<UserSerialized>();
    private String[] access;
    private Date shoppingPeriodStartDate;
    private Date shoppingPeriodEndDate;
    private String[] restrictedAuthTools;
    private String[] restrictedPublicTools;
    private Date modified;
    private String modifiedBy;
    private String modifiedBySortName;
    private boolean hasInstructor = true;
    private String providers = "";

    public SiteSearchResult(Site site, List<User> instructors, String termProp) {
        this.site = new SiteSerialized(site, termProp);
        this.instructors = new ArrayList<UserSerialized>();
        for (User user : instructors) {
            this.instructors.add(new UserSerialized(user));
        }
    }

    public SiteSearchResult(SiteSerialized site, List<User> instructors, String termProp) {
        this.site = site;
        this.instructors = new ArrayList<UserSerialized>();
        for (User user : instructors) {
            this.instructors.add(new UserSerialized(user));
        }
    }

    public SiteSerialized getSite() {
        return this.site;
    }

    public List<UserSerialized> getInstructors() {
        return this.instructors;
    }

    public void setInstructors(List<UserSerialized> instructors) {
        this.instructors = instructors;
    }

    public void addInstructor(User user) {
        this.instructors.add(new UserSerialized(user));
    }

    public String getInstructorsString() {
        Object instructors = "";
        for (UserSerialized user : this.getInstructors()) {
            if (!"".equals(instructors)) {
                instructors = (String)instructors + "; ";
            }
            instructors = (String)instructors + user.getSortName();
        }
        return instructors;
    }

    public String[] getAccess() {
        return this.access;
    }

    public void setAccess(String[] access) {
        this.access = access;
    }

    public String getAccessString() {
        return this.getAccess() != null && this.getAccess().length == 2 ? this.getAccess()[0] + ":" + this.getAccess()[1] : "";
    }

    public String getAccessRoleString() {
        return this.getAccess() != null && this.getAccess().length == 2 ? this.getAccess()[1] : "";
    }

    public Date getShoppingPeriodStartDate() {
        return this.shoppingPeriodStartDate;
    }

    public void setShoppingPeriodStartDate(Date shoppingPeriodStartDate) {
        this.shoppingPeriodStartDate = shoppingPeriodStartDate;
    }

    public Date getShoppingPeriodEndDate() {
        return this.shoppingPeriodEndDate;
    }

    public void setShoppingPeriodEndDate(Date shoppingPeriodEndDate) {
        this.shoppingPeriodEndDate = shoppingPeriodEndDate;
    }

    public String getShoppingPeriodStartDateStr() {
        if (this.getShoppingPeriodStartDate() == null) {
            return "";
        }
        return this.format.format(this.getShoppingPeriodStartDate());
    }

    public String getShoppingPeriodEndDateStr() {
        if (this.getShoppingPeriodEndDate() == null) {
            return "";
        }
        return this.format.format(this.getShoppingPeriodEndDate());
    }

    public String getSiteTerm() {
        String prop = this.getSite().getTerm();
        return prop == null ? "" : prop.toString();
    }

    public String[] getRestrictedAuthTools() {
        return this.restrictedAuthTools;
    }

    public void setRestrictedAuthTools(String[] restrictedTools) {
        this.restrictedAuthTools = restrictedTools;
    }

    public String getAuthToolsString(Map<String, String> toolsMap) {
        Object restrictedToolsStr = "";
        if (this.getRestrictedAuthTools() != null) {
            for (String tool : this.getRestrictedAuthTools()) {
                String toolName;
                if (!"".equals(restrictedToolsStr)) {
                    restrictedToolsStr = (String)restrictedToolsStr + ", ";
                }
                if (toolsMap.containsKey(toolName = tool)) {
                    toolName = toolsMap.get(toolName);
                }
                restrictedToolsStr = (String)restrictedToolsStr + toolName;
            }
        }
        return restrictedToolsStr;
    }

    public String[] getRestrictedPublicTools() {
        return this.restrictedPublicTools;
    }

    public void setRestrictedPublicTools(String[] restrictedTools) {
        this.restrictedPublicTools = restrictedTools;
    }

    public String getPublicToolsString(Map<String, String> toolsMap) {
        Object restrictedToolsStr = "";
        if (this.getRestrictedPublicTools() != null) {
            for (String tool : this.getRestrictedPublicTools()) {
                String toolName;
                if (!"".equals(restrictedToolsStr)) {
                    restrictedToolsStr = (String)restrictedToolsStr + ", ";
                }
                if (toolsMap.containsKey(toolName = tool)) {
                    toolName = toolsMap.get(toolName);
                }
                restrictedToolsStr = (String)restrictedToolsStr + toolName;
            }
        }
        return restrictedToolsStr;
    }

    public String getSiteUrl() {
        return this.getSite().getUrl();
    }

    public String getSiteTitle() {
        return this.getSite().getTitle();
    }

    public String getSiteId() {
        return this.getSite().getId();
    }

    public String getSiteReference() {
        return this.getSite().getReference();
    }

    public boolean isSitePublished() {
        return this.getSite().isPublished();
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public String getModifiedBySortName() {
        return this.modifiedBySortName;
    }

    public void setModifiedBySortName(String modifiedBySortName) {
        this.modifiedBySortName = modifiedBySortName;
    }

    public String getModifiedStr() {
        if (this.getModified() == null) {
            return "";
        }
        return this.formatWithTime.format(this.getModified());
    }

    public void setHasInstructor(boolean hasInstructor) {
        this.hasInstructor = hasInstructor;
    }

    public boolean isHasInstructor() {
        return this.hasInstructor;
    }

    public String getProviders() {
        return this.providers;
    }

    public void setProviders(String providers) {
        if (providers == null) {
            providers = "";
        }
        this.providers = providers;
    }

    public class UserSerialized
    implements Serializable {
        private String userId;
        private String displayName;
        private String sortName;

        public UserSerialized(User user) {
            this.userId = user.getId();
            this.displayName = user.getDisplayName();
            this.sortName = user.getSortName();
        }

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public String getSortName() {
            return this.sortName;
        }

        public void setSortName(String sortName) {
            this.sortName = sortName;
        }
    }
}

