/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.sakaiproject.delegatedaccess.model.HierarchyNodeSerialized;
import org.sakaiproject.delegatedaccess.model.ListOptionSerialized;
import org.sakaiproject.delegatedaccess.model.SelectOption;

public class NodeModel
implements Serializable {
    private String nodeId;
    private HierarchyNodeSerialized node;
    private boolean directAccessOrig = false;
    private boolean directAccess = false;
    private boolean accessAdmin = false;
    private boolean accessAdminOrig = false;
    private String realm = "";
    private String role = "";
    private String realmOrig = "";
    private String roleOrig = "";
    private NodeModel parentNode;
    private List<ListOptionSerialized> restrictedAuthTools;
    private List<ListOptionSerialized> restrictedAuthToolsOrig;
    private List<ListOptionSerialized> restrictedPublicTools;
    private List<ListOptionSerialized> restrictedPublicToolsOrig;
    private Date shoppingPeriodStartDate = new Date();
    private Date shoppingPeriodStartDateOrig = new Date();
    private Date shoppingPeriodEndDate = new Date();
    private Date shoppingPeriodEndDateOrig = new Date();
    private boolean addedDirectChildrenFlag = false;
    private boolean shoppingPeriodAdmin = false;
    private boolean shoppingPeriodAdminOrig = false;
    private String siteInstructors;
    private SelectOption roleOption;
    private Date shoppingAdminModified = null;
    private String shoppingAdminModifiedBy = null;
    private Date modified = null;
    private String modifiedBy = null;
    private boolean editable = true;
    private boolean shoppingPeriodRevokeInstructorEditable = false;
    private boolean shoppingPeriodRevokeInstructorEditableOrig = false;
    private boolean shoppingPeriodRevokeInstructorPublicOpt = false;
    private boolean shoppingPeriodRevokeInstructorPublicOptOrig = false;
    private String[] subAdminSiteAccess = null;
    private boolean isActive = true;

    public void setOriginals() {
        this.directAccessOrig = this.directAccess;
        this.accessAdminOrig = this.accessAdmin;
        this.shoppingPeriodAdminOrig = this.shoppingPeriodAdmin;
        this.realmOrig = this.realm;
        this.roleOrig = this.role;
        this.restrictedAuthToolsOrig = this.copyListOptions(this.restrictedAuthTools);
        this.restrictedPublicToolsOrig = this.copyListOptions(this.restrictedPublicTools);
        this.shoppingPeriodStartDateOrig = this.shoppingPeriodStartDate;
        this.shoppingPeriodEndDateOrig = this.shoppingPeriodEndDate;
        this.shoppingPeriodRevokeInstructorEditableOrig = this.shoppingPeriodRevokeInstructorEditable;
        this.shoppingPeriodRevokeInstructorPublicOptOrig = this.shoppingPeriodRevokeInstructorPublicOpt;
    }

    public NodeModel(String nodeId, HierarchyNodeSerialized node, boolean directAccess, String realm, String role, NodeModel parentNode, List<ListOptionSerialized> restrictedAuthTools, List<ListOptionSerialized> restrictedPublicTools, Date shoppingPeriodStartDate, Date shoppingPeriodEndDate, boolean addedDirectChildrenFlag, boolean shoppingPeriodAdmin, String modifiedBy, Date modified, Date shoppingAdminModified, String shoppingAdminModifiedBy, boolean accessAdmin, boolean shoppingPeriodRevokeInstructorEditable, boolean shoppingPeriodRevokeInstructorPublicOpt) {
        this.nodeId = nodeId;
        this.node = node;
        this.directAccessOrig = directAccess;
        this.directAccess = directAccess;
        this.realm = realm;
        this.role = role;
        this.realmOrig = realm;
        this.roleOrig = role;
        this.parentNode = parentNode;
        this.restrictedAuthTools = restrictedAuthTools;
        this.restrictedAuthToolsOrig = this.copyListOptions(restrictedAuthTools);
        this.restrictedPublicTools = restrictedPublicTools;
        this.restrictedPublicToolsOrig = this.copyListOptions(restrictedPublicTools);
        this.shoppingPeriodEndDate = shoppingPeriodEndDate;
        this.shoppingPeriodEndDateOrig = shoppingPeriodEndDate;
        this.shoppingPeriodStartDate = shoppingPeriodStartDate;
        this.shoppingPeriodStartDateOrig = shoppingPeriodStartDate;
        this.addedDirectChildrenFlag = addedDirectChildrenFlag;
        this.shoppingPeriodAdmin = shoppingPeriodAdmin;
        this.shoppingPeriodAdminOrig = shoppingPeriodAdmin;
        this.modifiedBy = modifiedBy;
        this.modified = modified;
        this.shoppingAdminModified = shoppingAdminModified;
        this.shoppingAdminModifiedBy = shoppingAdminModifiedBy;
        this.accessAdmin = accessAdmin;
        this.accessAdminOrig = accessAdmin;
        this.shoppingPeriodRevokeInstructorEditable = shoppingPeriodRevokeInstructorEditable;
        this.shoppingPeriodRevokeInstructorEditableOrig = shoppingPeriodRevokeInstructorEditable;
        this.shoppingPeriodRevokeInstructorPublicOpt = shoppingPeriodRevokeInstructorPublicOpt;
        this.shoppingPeriodRevokeInstructorPublicOptOrig = shoppingPeriodRevokeInstructorPublicOpt;
    }

    private List<ListOptionSerialized> copyListOptions(List<ListOptionSerialized> tools) {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : tools) {
            returnList.add(new ListOptionSerialized(tool.getId(), tool.getName(), tool.isSelected()));
        }
        return returnList;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    public HierarchyNodeSerialized getNode() {
        return this.node;
    }

    public void setNode(HierarchyNodeSerialized node) {
        this.node = node;
    }

    public boolean isDirectAccessOrig() {
        return this.directAccessOrig;
    }

    public void setDirectAccessOrig(boolean directAccess) {
        this.directAccessOrig = directAccess;
    }

    public String toString() {
        return this.node.description;
    }

    public boolean isDirectAccess() {
        return this.directAccess;
    }

    public void setDirectAccess(boolean directAccess) {
        this.directAccess = directAccess;
    }

    public boolean isModified() {
        if (this.directAccessOrig != this.directAccess) {
            return true;
        }
        if (this.shoppingPeriodAdmin != this.shoppingPeriodAdminOrig) {
            return true;
        }
        if (this.accessAdmin != this.accessAdminOrig) {
            return true;
        }
        if (this.directAccess) {
            return this.isModified(this.shoppingPeriodStartDate, this.shoppingPeriodStartDateOrig, this.shoppingPeriodEndDate, this.shoppingPeriodEndDateOrig, this.realm, this.realmOrig, this.role, this.roleOrig, this.convertListToArray(this.getSelectedRestrictedAuthTools()), this.convertListToArray(this.getSelectedRestrictedAuthToolsOrig()), this.convertListToArray(this.getSelectedRestrictedPublicTools()), this.convertListToArray(this.getSelectedRestrictedPublicToolsOrig()), this.shoppingPeriodRevokeInstructorEditable, this.shoppingPeriodRevokeInstructorEditableOrig, this.shoppingPeriodRevokeInstructorPublicOpt, this.shoppingPeriodRevokeInstructorPublicOptOrig);
        }
        return false;
    }

    public boolean isModified(Date shoppingStartDateOld, Date shoppingStartDateNew, Date shoppingEndDateOld, Date shoppingEndDateNew, String realmOld, String realmNew, String roleOld, String roleNew, String[] authToolsOld, String[] authToolsNew, String[] publicToolsOld, String[] publicToolsNew, boolean shoppingPeriodRevokeInstructorEditable, boolean shoppingPeriodRevokeInstructorEditableOrig, boolean shoppingPeriodRevokeInstructorPublicOpt, boolean shoppingPeriodRevokeInstructorPublicOptOrig) {
        int j;
        boolean found;
        int i;
        if (realmOld != null && realmNew != null ? !realmOld.equals(realmNew) : !(realmOld != null && realmNew != null || realmOld == null && realmNew == null)) {
            return true;
        }
        if (shoppingStartDateOld != null && shoppingStartDateNew != null ? !shoppingStartDateOld.equals(shoppingStartDateNew) : !(shoppingStartDateOld != null && shoppingStartDateNew != null || shoppingStartDateOld == null && shoppingStartDateNew == null)) {
            return true;
        }
        if (shoppingEndDateOld != null && shoppingEndDateNew != null ? !shoppingEndDateOld.equals(shoppingEndDateNew) : !(shoppingEndDateOld != null && shoppingEndDateNew != null || shoppingEndDateOld == null && shoppingEndDateNew == null)) {
            return true;
        }
        if (roleOld != null && roleNew != null ? !roleOld.equals(roleNew) : !(roleOld != null && roleNew != null || roleOld == null && roleNew == null)) {
            return true;
        }
        if (authToolsOld != null && authToolsNew != null) {
            if (authToolsOld.length != authToolsNew.length) {
                return true;
            }
            for (i = 0; i < authToolsOld.length; ++i) {
                found = false;
                for (j = 0; j < authToolsNew.length; ++j) {
                    if (!authToolsOld[i].equals(authToolsNew[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return true;
            }
        } else if (!(authToolsOld != null && authToolsNew != null || authToolsOld == null && authToolsNew == null)) {
            return true;
        }
        if (publicToolsOld != null && publicToolsNew != null) {
            if (publicToolsOld.length != publicToolsNew.length) {
                return true;
            }
            for (i = 0; i < publicToolsOld.length; ++i) {
                found = false;
                for (j = 0; j < publicToolsNew.length; ++j) {
                    if (!publicToolsOld[i].equals(publicToolsNew[j])) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return true;
            }
        } else if (!(publicToolsOld != null && publicToolsNew != null || publicToolsOld == null && publicToolsNew == null)) {
            return true;
        }
        return shoppingPeriodRevokeInstructorEditable != shoppingPeriodRevokeInstructorEditableOrig || shoppingPeriodRevokeInstructorPublicOpt != shoppingPeriodRevokeInstructorPublicOptOrig;
    }

    private boolean isRestrictedAuthToolsModified() {
        for (ListOptionSerialized origTool : this.restrictedAuthToolsOrig) {
            for (ListOptionSerialized tool : this.restrictedAuthTools) {
                if (!tool.getId().equals(origTool.getId()) || tool.isSelected() == origTool.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isRestrictedPublicToolsModified() {
        for (ListOptionSerialized origTool : this.restrictedPublicToolsOrig) {
            for (ListOptionSerialized tool : this.restrictedPublicTools) {
                if (!tool.getId().equals(origTool.getId()) || tool.isSelected() == origTool.isSelected()) continue;
                return true;
            }
        }
        return false;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String[] getNodeAccessRealmRole() {
        String[] myAccessRealmRole = new String[]{this.getRealm(), this.getRole()};
        if (!this.isDirectAccess()) {
            myAccessRealmRole = this.getInheritedAccessRealmRole();
        }
        if (myAccessRealmRole == null || "".equals(myAccessRealmRole[0]) || "".equals(myAccessRealmRole[1])) {
            return new String[]{"", ""};
        }
        return myAccessRealmRole;
    }

    public Date getNodeShoppingPeriodStartDate() {
        if (this.isDirectAccess()) {
            return this.getShoppingPeriodStartDate();
        }
        return this.getInheritedShoppingPeriodStartDate();
    }

    public Date getNodeShoppingPeriodEndDate() {
        if (this.isDirectAccess()) {
            return this.getShoppingPeriodEndDate();
        }
        return this.getInheritedShoppingPeriodEndDate();
    }

    public boolean getNodeAccess() {
        if (this.isDirectAccess()) {
            return true;
        }
        return this.getInheritedNodeAccess();
    }

    public boolean getInheritedNodeAccess() {
        return this.getInheritedNodeAccessHelper(this.parentNode);
    }

    public boolean getInheritedNodeAccessHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isDirectAccess()) {
            return true;
        }
        return this.getInheritedNodeAccessHelper(parent.getParentNode());
    }

    public String[] getInheritedAccessRealmRole() {
        return this.getInheritedAccessRealmRoleHelper(this.parentNode);
    }

    private String[] getInheritedAccessRealmRoleHelper(NodeModel parent) {
        if (parent == null) {
            return new String[]{"", ""};
        }
        if (parent.isDirectAccess()) {
            return new String[]{parent.getRealm(), parent.getRole()};
        }
        return this.getInheritedAccessRealmRoleHelper(parent.getParentNode());
    }

    public Date getInheritedShoppingPeriodEndDate() {
        return this.getInheritedShoppingPeriodEndDateHelper(this.parentNode);
    }

    private Date getInheritedShoppingPeriodEndDateHelper(NodeModel parent) {
        if (parent == null) {
            return null;
        }
        if (parent.isDirectAccess()) {
            return parent.getShoppingPeriodEndDate();
        }
        return this.getInheritedShoppingPeriodEndDateHelper(parent.getParentNode());
    }

    public Date getInheritedShoppingPeriodStartDate() {
        return this.getInheritedShoppingPeriodStartDateHelper(this.parentNode);
    }

    private Date getInheritedShoppingPeriodStartDateHelper(NodeModel parent) {
        if (parent == null) {
            return null;
        }
        if (parent.isDirectAccess()) {
            return parent.getShoppingPeriodStartDate();
        }
        return this.getInheritedShoppingPeriodStartDateHelper(parent.getParentNode());
    }

    public NodeModel getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(NodeModel parentNode) {
        this.parentNode = parentNode;
    }

    public List<ListOptionSerialized> getRestrictedAuthTools() {
        return this.restrictedAuthTools;
    }

    public void setRestrictedAuthTools(List<ListOptionSerialized> restrictedAuthTools) {
        this.restrictedAuthTools = restrictedAuthTools;
    }

    public String[] getNodeRestrictedAuthTools() {
        List<ListOptionSerialized> myRestrictedTools = this.getSelectedRestrictedAuthTools();
        if (!this.isDirectAccess()) {
            myRestrictedTools = this.getInheritedRestrictedAuthTools();
        }
        if (myRestrictedTools == null || myRestrictedTools.size() == 0) {
            return new String[0];
        }
        return this.convertListToArray(myRestrictedTools);
    }

    public String[] convertListToArray(List<ListOptionSerialized> list) {
        String[] restrictedToolsArray = new String[list.size()];
        int i = 0;
        for (ListOptionSerialized tool : list) {
            restrictedToolsArray[i] = tool.getId();
            ++i;
        }
        return restrictedToolsArray;
    }

    public List<ListOptionSerialized> getInheritedRestrictedAuthTools() {
        return this.getInheritedRestrictedAuthToolsHelper(this.parentNode);
    }

    private List<ListOptionSerialized> getInheritedRestrictedAuthToolsHelper(NodeModel parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        if (parent.isDirectAccess()) {
            return parent.getSelectedRestrictedAuthTools();
        }
        return this.getInheritedRestrictedAuthToolsHelper(parent.getParentNode());
    }

    public List<ListOptionSerialized> getSelectedRestrictedAuthTools() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : this.restrictedAuthTools) {
            if (!tool.isSelected()) continue;
            returnList.add(tool);
        }
        return returnList;
    }

    public List<ListOptionSerialized> getSelectedRestrictedAuthToolsOrig() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : this.restrictedAuthToolsOrig) {
            if (!tool.isSelected()) continue;
            returnList.add(tool);
        }
        return returnList;
    }

    public boolean hasAnyRestrictedAuthToolsSelected() {
        for (ListOptionSerialized tool : this.restrictedAuthTools) {
            if (!tool.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setAuthToolRestricted(String toolId, boolean restricted) {
        for (ListOptionSerialized tool : this.restrictedAuthTools) {
            if (!tool.getId().equals(toolId)) continue;
            tool.setSelected(restricted);
            break;
        }
    }

    public boolean isAuthToolRestricted(String toolId) {
        for (ListOptionSerialized tool : this.restrictedAuthTools) {
            if (!tool.getId().equals(toolId)) continue;
            return tool.isSelected();
        }
        return false;
    }

    public List<ListOptionSerialized> getRestrictedPublicTools() {
        return this.restrictedPublicTools;
    }

    public void setRestrictedPublicTools(List<ListOptionSerialized> restrictedPublicTools) {
        this.restrictedPublicTools = restrictedPublicTools;
    }

    public String[] getNodeRestrictedPublicTools() {
        List<ListOptionSerialized> myRestrictedTools = this.getSelectedRestrictedPublicTools();
        if (!this.isDirectAccess()) {
            myRestrictedTools = this.getInheritedRestrictedPublicTools();
        }
        if (myRestrictedTools == null || myRestrictedTools.size() == 0) {
            return new String[0];
        }
        return this.convertListToArray(myRestrictedTools);
    }

    public List<ListOptionSerialized> getInheritedRestrictedPublicTools() {
        return this.getInheritedRestrictedPublicToolsHelper(this.parentNode);
    }

    private List<ListOptionSerialized> getInheritedRestrictedPublicToolsHelper(NodeModel parent) {
        if (parent == null) {
            return Collections.emptyList();
        }
        if (parent.isDirectAccess()) {
            return parent.getSelectedRestrictedPublicTools();
        }
        return this.getInheritedRestrictedPublicToolsHelper(parent.getParentNode());
    }

    public List<ListOptionSerialized> getSelectedRestrictedPublicTools() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : this.restrictedPublicTools) {
            if (!tool.isSelected()) continue;
            returnList.add(tool);
        }
        return returnList;
    }

    public List<ListOptionSerialized> getSelectedRestrictedPublicToolsOrig() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized tool : this.restrictedPublicToolsOrig) {
            if (!tool.isSelected()) continue;
            returnList.add(tool);
        }
        return returnList;
    }

    public boolean hasAnyRestrictedPublicToolsSelected() {
        for (ListOptionSerialized tool : this.restrictedPublicTools) {
            if (!tool.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void setPublicToolRestricted(String toolId, boolean restricted) {
        for (ListOptionSerialized tool : this.restrictedPublicTools) {
            if (!tool.getId().equals(toolId)) continue;
            tool.setSelected(restricted);
            break;
        }
    }

    public boolean isPublicToolRestricted(String toolId) {
        for (ListOptionSerialized tool : this.restrictedPublicTools) {
            if (!tool.getId().equals(toolId)) continue;
            return tool.isSelected();
        }
        return false;
    }

    public Date getShoppingPeriodStartDate() {
        return this.shoppingPeriodStartDate;
    }

    public void setShoppingPeriodStartDate(Date shoppingPeriodStartDate) {
        this.shoppingPeriodStartDate = shoppingPeriodStartDate;
    }

    public Date getShoppingPeriodEndDate() {
        return this.shoppingPeriodEndDate;
    }

    public void setShoppingPeriodEndDate(Date shoppingPeriodEndDate) {
        this.shoppingPeriodEndDate = shoppingPeriodEndDate;
    }

    public boolean isAddedDirectChildrenFlag() {
        return this.addedDirectChildrenFlag;
    }

    public void setAddedDirectChildrenFlag(boolean addedDirectChildrenFlag) {
        this.addedDirectChildrenFlag = addedDirectChildrenFlag;
    }

    public boolean isShoppingPeriodAdmin() {
        return this.shoppingPeriodAdmin;
    }

    public boolean isShoppingPeriodAdminOrig() {
        return this.shoppingPeriodAdminOrig;
    }

    public void setShoppingPeriodAdmin(boolean shoppingPeriodAdmin) {
        this.shoppingPeriodAdmin = shoppingPeriodAdmin;
    }

    public boolean getNodeShoppingPeriodAdmin() {
        if (this.isShoppingPeriodAdmin()) {
            return true;
        }
        return this.getInheritedShoppingPeriodAdmin();
    }

    public boolean getInheritedShoppingPeriodAdmin() {
        return this.getInheritedShoppingPeriodAdminHelper(this.parentNode);
    }

    private boolean getInheritedShoppingPeriodAdminHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isShoppingPeriodAdmin()) {
            return true;
        }
        return this.getInheritedShoppingPeriodAdminHelper(parent.getParentNode());
    }

    public String getSiteInstructors() {
        return this.siteInstructors;
    }

    public void setSiteInstructors(String siteInstructors) {
        this.siteInstructors = siteInstructors;
    }

    public SelectOption getRoleOption() {
        return this.roleOption;
    }

    public void setRoleOption(SelectOption roleOption) {
        this.roleOption = roleOption;
    }

    public Date getShoppingAdminModified() {
        return this.shoppingAdminModified;
    }

    public void setShoppingAdminModified(Date shoppingAdminModified) {
        this.shoppingAdminModified = shoppingAdminModified;
    }

    public String getShoppingAdminModifiedBy() {
        return this.shoppingAdminModifiedBy;
    }

    public void setShoppingAdminModifiedBy(String shoppingAdminModifiedBy) {
        this.shoppingAdminModifiedBy = shoppingAdminModifiedBy;
    }

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date modified) {
        this.modified = modified;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public boolean isAccessAdmin() {
        return this.accessAdmin;
    }

    public void setAccessAdmin(boolean accessAdmin) {
        this.accessAdmin = accessAdmin;
    }

    public boolean isAccessAdminOrig() {
        return this.accessAdminOrig;
    }

    public void setAccessAdminOrig(boolean accessAdminOrig) {
        this.accessAdminOrig = accessAdminOrig;
    }

    public boolean getNodeAccessAdmin() {
        if (this.isAccessAdmin()) {
            return true;
        }
        return this.getInheritedAccessAdmin();
    }

    public boolean getInheritedAccessAdmin() {
        return this.getInheritedAccessAdminHelper(this.parentNode);
    }

    public boolean getInheritedAccessAdminHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isAccessAdmin()) {
            return true;
        }
        return this.getInheritedAccessAdminHelper(parent.getParentNode());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isNodeEditable() {
        if (this.isEditable()) {
            return true;
        }
        return this.getInheritedEditable();
    }

    private boolean getInheritedEditable() {
        return this.getInheritedEditableHelper(this.parentNode);
    }

    private boolean getInheritedEditableHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isEditable()) {
            return true;
        }
        return this.getInheritedEditableHelper(parent.getParentNode());
    }

    public boolean isShoppingPeriodRevokeInstructorEditable() {
        return this.shoppingPeriodRevokeInstructorEditable;
    }

    public void setShoppingPeriodRevokeInstructorEditable(boolean shoppingPeriodRevokeInstructorEditable) {
        this.shoppingPeriodRevokeInstructorEditable = shoppingPeriodRevokeInstructorEditable;
    }

    public boolean isShoppingPeriodRevokeInstructorEditableOrig() {
        return this.shoppingPeriodRevokeInstructorEditableOrig;
    }

    public void setShoppingPeriodRevokeInstructorEditableOrig(boolean shoppingPeriodRevokeInstructorEditableOrig) {
        this.shoppingPeriodRevokeInstructorEditableOrig = shoppingPeriodRevokeInstructorEditableOrig;
    }

    public boolean getNodeShoppingPeriodRevokeInstructorEditable() {
        if (this.isDirectAccess()) {
            return this.isShoppingPeriodRevokeInstructorEditable();
        }
        return this.getInheritedShoppingPeriodRevokeInstructorEditable();
    }

    public boolean getInheritedShoppingPeriodRevokeInstructorEditable() {
        return this.getInheritedShoppingPeriodRevokeInstructorEditableHelper(this.parentNode);
    }

    public boolean getInheritedShoppingPeriodRevokeInstructorEditableHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isDirectAccess()) {
            return parent.isShoppingPeriodRevokeInstructorEditable();
        }
        return this.getInheritedShoppingPeriodRevokeInstructorEditableHelper(parent.getParentNode());
    }

    public boolean isShoppingPeriodRevokeInstructorPublicOpt() {
        return this.shoppingPeriodRevokeInstructorPublicOpt;
    }

    public void setShoppingPeriodRevokeInstructorPublicOpt(boolean shoppingPeriodRevokeInstructorPublicOpt) {
        this.shoppingPeriodRevokeInstructorPublicOpt = shoppingPeriodRevokeInstructorPublicOpt;
    }

    public boolean isShoppingPeriodRevokeInstructorPublicOptOrig() {
        return this.shoppingPeriodRevokeInstructorPublicOptOrig;
    }

    public void setShoppingPeriodRevokeInstructorPublicOptOrig(boolean shoppingPeriodRevokeInstructorPublicOptOrig) {
        this.shoppingPeriodRevokeInstructorPublicOptOrig = shoppingPeriodRevokeInstructorPublicOptOrig;
    }

    public boolean getNodeShoppingPeriodRevokeInstructorPublicOpt() {
        if (this.isDirectAccess()) {
            return this.isShoppingPeriodRevokeInstructorPublicOpt();
        }
        return this.getInheritedShoppingPeriodRevokeInstructorPublicOpt();
    }

    public boolean getInheritedShoppingPeriodRevokeInstructorPublicOpt() {
        return this.getInheritedShoppingPeriodRevokeInstructorPublicOptHelper(this.parentNode);
    }

    public boolean getInheritedShoppingPeriodRevokeInstructorPublicOptHelper(NodeModel parent) {
        if (parent == null) {
            return false;
        }
        if (parent.isDirectAccess()) {
            return parent.isShoppingPeriodRevokeInstructorPublicOpt();
        }
        return this.getInheritedShoppingPeriodRevokeInstructorPublicOptHelper(parent.getParentNode());
    }

    public String[] getSubAdminSiteAccess() {
        return this.subAdminSiteAccess;
    }

    public void setSubAdminSiteAccess(String[] subAdminSiteAccess) {
        this.subAdminSiteAccess = subAdminSiteAccess;
    }

    public String[] getInheritedSubAdminSiteAccess() {
        return this.getInheritedSubAdminSiteAccessHelper(this.parentNode);
    }

    public String[] getInheritedSubAdminSiteAccessHelper(NodeModel parent) {
        if (parent == null) {
            return null;
        }
        if (parent.getSubAdminSiteAccess() != null) {
            return parent.subAdminSiteAccess;
        }
        return this.getInheritedSubAdminSiteAccessHelper(parent.getParentNode());
    }

    public String[] getNodeSubAdminSiteAccess() {
        if (this.getSubAdminSiteAccess() != null) {
            return this.getSubAdminSiteAccess();
        }
        return this.getInheritedSubAdminSiteAccess();
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isSiteNode() {
        return this.node != null && this.node.title != null && this.node.title.startsWith("/site/");
    }
}

