/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.dao.impl;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatedAccessDaoImpl
extends JdbcDaoSupport
implements DelegatedAccessDao {
    private static final Logger log = Logger.getLogger(DelegatedAccessDaoImpl.class);
    private PropertiesConfiguration statements;

    public void init() {
        log.info((Object)"init()");
        String vendor = ServerConfigurationService.getInstance().getString("vendor@org.sakaiproject.db.api.SqlService", null);
        this.initStatements(vendor);
    }

    private void initStatements(String vendor) {
        URL url = this.getClass().getClassLoader().getResource(vendor + ".properties");
        try {
            this.statements = new PropertiesConfiguration();
            this.statements.setReloadingStrategy((ReloadingStrategy)new InvariantReloadingStrategy());
            this.statements.setThrowExceptionOnMissing(true);
            this.statements.setDelimiterParsingDisabled(true);
            this.statements.load(url);
        }
        catch (ConfigurationException e) {
            log.error((Object)(((Object)((Object)e)).getClass() + ": " + e.getMessage()));
            return;
        }
    }

    private String getStatement(String key) {
        try {
            return this.statements.getString(key);
        }
        catch (NoSuchElementException e) {
            log.error((Object)("Statement: '" + key + "' could not be found in: " + this.statements.getFileName()));
            return null;
        }
    }

    @Override
    public List<String> getDistinctSiteTerms(String termField) {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.distinctTerms"), (Object[])new String[]{termField}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString(1);
                }
            });
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getSiteProperty(String propertyName, String siteId) {
        try {
            return (String)this.getJdbcTemplate().queryForObject(this.getStatement("select.siteProperty"), new Object[]{propertyName, siteId}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("VALUE");
                }
            });
        }
        catch (DataAccessException ex) {
            return null;
        }
    }

    @Override
    public List<String> getNodesBySiteRef(String siteRef, String hierarchyId) {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.hierarchyNode"), new Object[]{siteRef, hierarchyId}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("ID");
                }
            });
        }
        catch (DataAccessException ex) {
            return null;
        }
    }

    @Override
    public List<String> getEmptyNonSiteNodes(String hierarchyId) {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.emptyNodes"), new Object[]{hierarchyId}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("ID");
                }
            });
        }
        catch (DataAccessException ex) {
            return null;
        }
    }

    @Override
    public void addSiteProperty(String siteId, String propertyName, String propertyValue) {
        try {
            this.getJdbcTemplate().update(this.getStatement("insert.siteProperty"), new Object[]{siteId, propertyName, propertyValue});
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()));
        }
    }

    @Override
    public void updateSiteProperty(String siteId, String propertyName, String propertyValue) {
        try {
            this.getJdbcTemplate().update(this.getStatement("update.siteProperty"), new Object[]{propertyValue, propertyName, siteId});
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()));
        }
    }

    @Override
    public void removeSiteProperty(String siteId, String propertyName) {
        try {
            this.getJdbcTemplate().update(this.getStatement("delete.siteProperty"), new Object[]{propertyName, siteId});
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()));
        }
    }
}

