/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.jobs;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.delegatedaccess.util.DelegatedAccessConstants;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.hierarchy.HierarchyService;
import org.sakaiproject.hierarchy.model.HierarchyNode;
import org.sakaiproject.site.api.Site;

public class DelegatedAccessSiteHierarchyJob
implements Job {
    private static final Logger log = Logger.getLogger(DelegatedAccessSiteHierarchyJob.class);
    private HierarchyService hierarchyService;
    private SakaiProxy sakaiProxy;
    private DelegatedAccessDao dao;
    private ProjectLogic projectLogic;
    private static boolean semaphore = false;

    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        if (semaphore) {
            log.warn((Object)"Stopping job since this job is already running");
            return;
        }
        semaphore = true;
        try {
            boolean orderByModifiedDate;
            log.info((Object)"DelegatedAccessSiteHierarchyJob started");
            long startTime = System.currentTimeMillis();
            HierarchyNode rootNode = this.hierarchyService.getRootNode("delegatedAccessHierarchyId");
            Date hierarchyJobLastRunDate = null;
            if (rootNode == null) {
                rootNode = this.hierarchyService.createHierarchy("delegatedAccessHierarchyId");
                String rootTitle = this.sakaiProxy.getRootName();
                this.hierarchyService.saveNodeMetaData(rootNode.id, rootTitle, rootTitle, null);
                log.info((Object)"Created the root node for the delegated access hierarchy: delegatedAccessHierarchyId");
            } else {
                hierarchyJobLastRunDate = this.projectLogic.getHierarchyJobLastRunDate(rootNode.id);
            }
            String[] hierarchy = this.sakaiProxy.getServerConfigurationStrings("delegatedaccess.hierarchy.site.properties");
            if (hierarchy == null || hierarchy.length == 0) {
                hierarchy = DelegatedAccessConstants.DEFAULT_HIERARCHY;
            }
            int page = 1;
            int pageFirstRecord = 1;
            int pageLastRecord = 10000;
            boolean hasMoreSites = true;
            int processedSites = 0;
            String errors = "";
            HashMap<String, String> propsMap = null;
            boolean bl = orderByModifiedDate = hierarchyJobLastRunDate != null;
            if (!orderByModifiedDate) {
                propsMap = new HashMap<String, String>();
                for (String prop : hierarchy) {
                    propsMap.put(prop, "");
                }
            }
            while (hasMoreSites) {
                List sites = this.sakaiProxy.getAllSitesByPages(propsMap, pageFirstRecord, pageLastRecord, orderByModifiedDate);
                log.info((Object)("DelegatedAccessSiteHierarchyJob: Processing site results: " + pageFirstRecord + " to " + pageLastRecord));
                for (Site site : sites) {
                    if (orderByModifiedDate && hierarchyJobLastRunDate.after(site.getModifiedDate())) {
                        hasMoreSites = false;
                        break;
                    }
                    try {
                        List<String> nodeIds;
                        String hiearchyProperty;
                        String siteProperty;
                        HierarchyNode siteParentNode = rootNode;
                        ResourceProperties props = site.getProperties();
                        String[] arr$ = hierarchy;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$ && (siteProperty = props.getProperty(hiearchyProperty = arr$[i$])) != null && !"".equals(siteProperty); ++i$) {
                            siteParentNode = this.checkAndAddNode(siteParentNode, siteProperty, siteProperty, null);
                        }
                        if (!rootNode.id.equals(siteParentNode.id)) {
                            this.checkAndAddNode(siteParentNode, site.getReference(), site.getTitle(), props.getProperty(this.sakaiProxy.getTermField()));
                        } else if (orderByModifiedDate && (nodeIds = this.dao.getNodesBySiteRef(site.getReference(), "delegatedAccessHierarchyId")) != null) {
                            for (String nodeId : nodeIds) {
                                this.projectLogic.removeNode(this.hierarchyService.getNodeById(nodeId));
                            }
                        }
                        ++processedSites;
                    }
                    catch (Exception e) {
                        log.error((Object)e);
                        if ("".equals(errors)) {
                            errors = errors + "The following sites had errors: \n\n";
                        }
                        errors = errors + site.getId() + ": " + e.getMessage();
                    }
                }
                pageFirstRecord = 10000 * page + 1;
                pageLastRecord = 10000 * ++page;
                if (!sites.isEmpty()) continue;
                hasMoreSites = false;
            }
            this.projectLogic.deleteEmptyNonSiteNodes("delegatedAccessHierarchyId");
            if (!"".equals(errors)) {
                log.warn((Object)errors);
                this.sakaiProxy.sendEmail("DelegatedAccessShoppingPeriodJob error", errors);
            } else {
                this.projectLogic.saveHierarchyJobLastRunDate(new Date(), rootNode.id);
            }
            this.projectLogic.clearNodeCache();
            log.info((Object)("DelegatedAccessSiteHierarchyJob finished in " + (System.currentTimeMillis() - startTime) + " ms and processed " + processedSites + " sites."));
        }
        catch (Exception e) {
            log.error((Object)e);
            this.sakaiProxy.sendEmail("Error occurred in DelegatedAccessSiteHierarchyJob", e.getMessage());
        }
        finally {
            semaphore = false;
        }
    }

    private HierarchyNode checkAndAddNode(HierarchyNode parentNode, String title, String description, String term) {
        HierarchyNode node = null;
        if (title != null && !"".equals(title)) {
            List<String> nodeIds = this.dao.getNodesBySiteRef(title, "delegatedAccessHierarchyId");
            boolean hasChild = false;
            String childNodeId = "";
            if (nodeIds != null && nodeIds.size() > 0) {
                for (String id : nodeIds) {
                    if (parentNode.directChildNodeIds.contains(id)) {
                        hasChild = true;
                        childNodeId = id;
                        continue;
                    }
                    if (!title.startsWith("/site/")) continue;
                    this.projectLogic.removeNode(this.hierarchyService.getNodeById(id));
                }
            }
            if (!hasChild) {
                HierarchyNode newNode = this.hierarchyService.addNode("delegatedAccessHierarchyId", parentNode.id);
                this.hierarchyService.saveNodeMetaData(newNode.id, title, description, term);
                this.hierarchyService.addChildRelation(parentNode.id, newNode.id);
                node = newNode;
                parentNode.directChildNodeIds.add(node.id);
            } else {
                node = this.hierarchyService.getNodeById(childNodeId);
                if (!node.description.equals(description) || !node.title.equals(title)) {
                    node = this.hierarchyService.saveNodeMetaData(node.id, title, description, term);
                }
            }
        }
        return node;
    }

    public HierarchyService getHierarchyService() {
        return this.hierarchyService;
    }

    public void setHierarchyService(HierarchyService hierarchyService) {
        this.hierarchyService = hierarchyService;
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public DelegatedAccessDao getDao() {
        return this.dao;
    }

    public void setDao(DelegatedAccessDao dao) {
        this.dao = dao;
    }

    public ProjectLogic getProjectLogic() {
        return this.projectLogic;
    }

    public void setProjectLogic(ProjectLogic projectLogic) {
        this.projectLogic = projectLogic;
    }
}

