/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.logic;

import java.util.Observable;
import java.util.Observer;
import org.apache.log4j.Logger;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;

public class DelegatedAccessObserver
implements Observer {
    private ProjectLogic projectLogic;
    private EventTrackingService eventTrackingService;
    private static final Logger log = Logger.getLogger(DelegatedAccessObserver.class);

    public void init() {
        log.info((Object)"init()");
        this.eventTrackingService.addObserver((Observer)this);
    }

    public void update(Observable arg0, Object arg) {
        if (!(arg instanceof Event)) {
            return;
        }
        Event event = (Event)arg;
        if ("user.login".equals(event.getEvent()) || "user.login.container".equals(event.getEvent())) {
            this.projectLogic.initializeDelegatedAccessSession();
        } else if ("site.del".equals(event.getEvent())) {
            boolean deleted = false;
            for (String nodeId : this.projectLogic.getNodesBySiteRef(event.getResource(), "delegatedAccessHierarchyId")) {
                this.projectLogic.removeNode(nodeId);
                deleted = true;
            }
            if (deleted) {
                this.projectLogic.clearNodeCache();
            }
        } else if ("dac.checkaccess".equals(event.getEvent())) {
            this.projectLogic.getCurrentUsersAccessToSite(event.getResource());
        }
    }

    public ProjectLogic getProjectLogic() {
        return this.projectLogic;
    }

    public void setProjectLogic(ProjectLogic projectLogic) {
        this.projectLogic = projectLogic;
    }

    public EventTrackingService getEventTrackingService() {
        return this.eventTrackingService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }
}

