/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.logic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.log4j.Logger;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.delegatedaccess.model.HierarchyNodeSerialized;
import org.sakaiproject.delegatedaccess.model.ListOptionSerialized;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.delegatedaccess.model.SearchResult;
import org.sakaiproject.delegatedaccess.model.SiteSearchResult;
import org.sakaiproject.delegatedaccess.util.DelegatedAccessConstants;
import org.sakaiproject.delegatedaccess.util.DelegatedAccessMutableTreeNode;
import org.sakaiproject.hierarchy.HierarchyService;
import org.sakaiproject.hierarchy.model.HierarchyNode;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.user.api.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLogicImpl
implements ProjectLogic {
    private static final Logger log = Logger.getLogger(ProjectLogicImpl.class);
    private SakaiProxy sakaiProxy;
    private HierarchyService hierarchyService;
    private DelegatedAccessDao dao;
    private Cache nodeCache;
    private Cache restrictedToolsCache;
    private List<String> accessNodes = new ArrayList<String>();
    private List<String> shoppingPeriodAdminNodes = new ArrayList<String>();
    private List<String> accessAdminNodes = new ArrayList<String>();

    public void init() {
        log.info((Object)"init");
    }

    public HierarchyNodeSerialized getNode(String id) {
        return new HierarchyNodeSerialized(this.hierarchyService.getNodeById(id));
    }

    public void updateNodePermissionsForUser(NodeModel nodeModel, String userId) {
        this.removeAllUserPermissions(nodeModel.getNodeId(), userId);
        this.saveAccessAdmin(nodeModel.isAccessAdmin(), nodeModel.getNodeId(), userId);
        this.saveShoppingPeriodAdmin(nodeModel.isShoppingPeriodAdmin(), nodeModel.getNodeId(), userId);
        if (nodeModel.isDirectAccess()) {
            this.hierarchyService.assignUserNodePerm(userId, nodeModel.getNodeId(), "site.visit", false);
            this.saveRealmAndRoleAccess(userId, nodeModel.getRealm(), nodeModel.getRole(), nodeModel.getNodeId());
            ArrayList<String> restrictedTools = new ArrayList<String>();
            for (ListOptionSerialized tool : nodeModel.getRestrictedTools()) {
                if (!tool.isSelected()) continue;
                restrictedTools.add(tool.getId());
            }
            if (!restrictedTools.isEmpty()) {
                this.saveRestrictedToolsForUser(userId, nodeModel.getNodeId(), restrictedTools);
            }
            ArrayList<String> terms = new ArrayList<String>();
            for (ListOptionSerialized term : nodeModel.getTerms()) {
                if (!term.isSelected()) continue;
                terms.add(term.getId());
            }
            if (!terms.isEmpty()) {
                this.saveTermsForUser(userId, nodeModel.getNodeId(), terms);
            }
            if ("120dv0f43cv90sdf0asv9".equals(userId)) {
                this.saveShoppingPeriodAuth(nodeModel.getShoppingPeriodAuth(), nodeModel.getNodeId());
                this.saveShoppingPeriodStartDate(nodeModel.getShoppingPeriodStartDate(), nodeModel.getNodeId());
                this.saveShoppingPeriodEndDate(nodeModel.getShoppingPeriodEndDate(), nodeModel.getNodeId());
            }
        }
        if (nodeModel.isDirectAccess() || nodeModel.isShoppingPeriodAdmin() || nodeModel.isAccessAdmin()) {
            this.saveModifiedData(userId, nodeModel.getNodeId());
            this.sakaiProxy.postEvent("dac.nodeperms.modified", "/user/" + userId + "/node/" + nodeModel.getNodeId() + "/realm/" + nodeModel.getRealm() + "/role/" + nodeModel.getRole(), true);
        }
        if (nodeModel.isDirectAccess() != nodeModel.isDirectAccessOrig()) {
            if (nodeModel.isDirectAccess()) {
                this.sakaiProxy.postEvent("dac.nodeperms.add", "/user/" + userId + "/node/" + nodeModel.getNodeId() + "/realm/" + nodeModel.getRealm() + "/role/" + nodeModel.getRole(), true);
            } else {
                this.sakaiProxy.postEvent("dac.nodeperms.delete", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            }
        }
        if (!"120dv0f43cv90sdf0asv9".equals(userId) && nodeModel.isShoppingPeriodAdmin() != nodeModel.isShoppingPeriodAdminOrig()) {
            this.saveShoppingPeriodAdminModifiedData(userId, nodeModel.getNodeId());
            if (nodeModel.isShoppingPeriodAdmin()) {
                this.sakaiProxy.postEvent("dac.shoppingAdmin.add", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            } else {
                this.sakaiProxy.postEvent("dac.shoppingAdmin.delete", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            }
        } else if (!"120dv0f43cv90sdf0asv9".equals(userId) && nodeModel.getShoppingAdminModified() != null) {
            this.hierarchyService.assignUserNodePerm(userId, nodeModel.getNodeId(), "shoppingAdminModified:" + nodeModel.getShoppingAdminModified().getTime(), false);
            this.hierarchyService.assignUserNodePerm(userId, nodeModel.getNodeId(), "shoppingAdminModifiedBy:" + nodeModel.getShoppingAdminModifiedBy(), false);
        }
        if (nodeModel.isAccessAdmin() != nodeModel.isAccessAdminOrig()) {
            if (nodeModel.isAccessAdmin()) {
                this.sakaiProxy.postEvent("dac.accessAdmin.add", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            } else {
                this.sakaiProxy.postEvent("dac.accessAdmin.delete", "/user/" + userId + "/node/" + nodeModel.getNodeId(), true);
            }
        }
    }

    private void saveShoppingPeriodAdmin(boolean admin, String nodeId, String userId) {
        if (admin && !"120dv0f43cv90sdf0asv9".equals(userId)) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "shoppingAdmin", false);
        }
    }

    private void saveAccessAdmin(boolean accessAdmin, String nodeId, String userId) {
        if (accessAdmin && !"120dv0f43cv90sdf0asv9".equals(userId)) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "accessAdmin", false);
        }
    }

    private void saveShoppingPeriodAdminModifiedData(String userId, String nodeId) {
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "shoppingAdminModified:" + new Date().getTime(), false);
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "shoppingAdminModifiedBy:" + this.sakaiProxy.getCurrentUserId(), false);
    }

    private void saveModifiedData(String userId, String nodeId) {
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "modified:" + new Date().getTime(), false);
        this.hierarchyService.assignUserNodePerm(userId, nodeId, "modifiedBy:" + this.sakaiProxy.getCurrentUserId(), false);
    }

    private void saveShoppingPeriodAuth(String auth, String nodeId) {
        if (auth != null && !"".equals(auth) && !"null".equals(auth)) {
            this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", nodeId, "shoppingAuth:" + auth, false);
        }
    }

    private void saveShoppingPeriodStartDate(Date startDate, String nodeId) {
        if (startDate != null) {
            this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", nodeId, "shoppingStartDate:" + startDate.getTime(), false);
        }
    }

    private void saveShoppingPeriodEndDate(Date endDate, String nodeId) {
        if (endDate != null) {
            this.hierarchyService.assignUserNodePerm("120dv0f43cv90sdf0asv9", nodeId, "shoppingEndDate:" + endDate.getTime(), false);
        }
    }

    public void saveHierarchyJobLastRunDate(Date runDate, String nodeId) {
        if (runDate != null) {
            this.clearHierarchyJobLastRunDate(nodeId);
            this.hierarchyService.assignUserNodePerm("777dv0f43bd90sdf012uf", nodeId, "siteHierarchyJobLastRunDate:" + runDate.getTime(), false);
        }
    }

    private void clearHierarchyJobLastRunDate(String nodeId) {
        for (String perm : this.hierarchyService.getPermsForUserNodes("777dv0f43bd90sdf012uf", new String[]{nodeId})) {
            if (!perm.startsWith("siteHierarchyJobLastRunDate:")) continue;
            this.hierarchyService.removeUserNodePerm("777dv0f43bd90sdf012uf", nodeId, perm, false);
        }
    }

    public Date getHierarchyJobLastRunDate(String nodeId) {
        Date returnDate = null;
        for (String perm : this.hierarchyService.getPermsForUserNodes("777dv0f43bd90sdf012uf", new String[]{nodeId})) {
            if (!perm.startsWith("siteHierarchyJobLastRunDate:")) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring("siteHierarchyJobLastRunDate:".length())));
            }
            catch (Exception e) {}
        }
        return returnDate;
    }

    private void removeAllUserPermissions(String nodeId, String userId) {
        for (String perm : this.getPermsForUserNodes(userId, nodeId)) {
            this.hierarchyService.removeUserNodePerm(userId, nodeId, perm, false);
        }
    }

    public Set<HierarchyNodeSerialized> getAllNodesForUser(String userId) {
        Set<HierarchyNodeSerialized> accessNodes = this.getAccessNodesForUser(userId);
        Set<HierarchyNodeSerialized> adminNodes = this.getShoppingPeriodAdminNodesForUser(userId);
        Set<HierarchyNodeSerialized> accessAdminNodes = this.getAccessAdminNodesForUser(userId);
        accessNodes.addAll(adminNodes);
        accessNodes.addAll(accessAdminNodes);
        return accessNodes;
    }

    public Set<HierarchyNodeSerialized> getAccessNodesForUser(String userId) {
        this.accessNodes = new ArrayList<String>();
        Set<HierarchyNodeSerialized> directAccessNodes = this.convertToSerializedNodeSet(this.hierarchyService.getNodesForUserPerm(userId, "site.visit"));
        for (HierarchyNodeSerialized node : directAccessNodes) {
            this.accessNodes.add(node.id);
        }
        return directAccessNodes;
    }

    public Set<HierarchyNodeSerialized> getShoppingPeriodAdminNodesForUser(String userId) {
        this.shoppingPeriodAdminNodes = new ArrayList<String>();
        Set<HierarchyNodeSerialized> adminNodes = this.convertToSerializedNodeSet(this.hierarchyService.getNodesForUserPerm(userId, "shoppingAdmin"));
        for (HierarchyNodeSerialized node : adminNodes) {
            this.shoppingPeriodAdminNodes.add(node.id);
        }
        return adminNodes;
    }

    public Set<HierarchyNodeSerialized> getAccessAdminNodesForUser(String userId) {
        this.accessAdminNodes = new ArrayList<String>();
        Set<HierarchyNodeSerialized> adminNodes = this.convertToSerializedNodeSet(this.hierarchyService.getNodesForUserPerm(userId, "accessAdmin"));
        for (HierarchyNodeSerialized node : adminNodes) {
            this.accessAdminNodes.add(node.id);
        }
        return adminNodes;
    }

    private Set<HierarchyNodeSerialized> convertToSerializedNodeSet(Set<HierarchyNode> nodeSet) {
        HashSet<HierarchyNodeSerialized> nodesForUserSerialized = new HashSet<HierarchyNodeSerialized>();
        if (nodeSet != null) {
            for (HierarchyNode node : nodeSet) {
                nodesForUserSerialized.add(new HierarchyNodeSerialized(node));
            }
        }
        return nodesForUserSerialized;
    }

    public void initializeDelegatedAccessSession() {
        String userId = this.sakaiProxy.getCurrentUserId();
        if (userId != null && !"".equals(userId)) {
            Session session = this.sakaiProxy.getCurrentSession();
            Set<HierarchyNodeSerialized> accessNodes = this.getAccessNodesForUser(userId);
            if (accessNodes != null && accessNodes.size() > 0) {
                session.setAttribute("delegatedaccess.accessmapflag", (Object)true);
                Element el = this.restrictedToolsCache.get((Serializable)((Object)userId));
                if (el != null) {
                    session.setAttribute("delegatedaccess.deniedToolsMap", el.getObjectValue());
                }
            }
        }
    }

    private List<NodeModel> getSiteNodes(DefaultMutableTreeNode treeNode) {
        ArrayList<NodeModel> returnList = new ArrayList<NodeModel>();
        if (treeNode != null) {
            if (((NodeModel)treeNode.getUserObject()).getNode().title.startsWith("/site/")) {
                returnList.add((NodeModel)treeNode.getUserObject());
            }
            for (int i = 0; i < treeNode.getChildCount(); ++i) {
                returnList.addAll(this.getSiteNodes((DefaultMutableTreeNode)treeNode.getChildAt(i)));
            }
        }
        return returnList;
    }

    private HierarchyNodeSerialized getRootNode() {
        return new HierarchyNodeSerialized(this.hierarchyService.getRootNode("delegatedAccessHierarchyId"));
    }

    public List<SearchResult> searchUsers(String search) {
        List searchResult = this.sakaiProxy.searchUsers(search);
        ArrayList<SearchResult> returnList = new ArrayList<SearchResult>();
        for (User user : searchResult) {
            returnList.add(this.getSearchResult(user));
        }
        return returnList;
    }

    private SearchResult getSearchResult(User user) {
        if (user != null) {
            return new SearchResult(user);
        }
        return null;
    }

    private void saveRealmAndRoleAccess(String userId, String realmId, String role, String nodeId) {
        if (!(realmId == null || role == null || "".equals(realmId) || "".equals(role) || "null".equals(realmId) || "null".equals(role))) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "realm:" + realmId, false);
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "role:" + role, false);
        }
    }

    private Set<String> getPermsForUserNodes(String userId, String nodeId) {
        return this.hierarchyService.getPermsForUserNodes(userId, new String[]{nodeId});
    }

    private String[] getAccessRealmRole(Set<String> perms) {
        String realmId = "";
        String roleId = "";
        for (String perm : perms) {
            if (perm.startsWith("realm:")) {
                realmId = perm.substring("realm:".length());
                continue;
            }
            if (!perm.startsWith("role:")) continue;
            roleId = perm.substring("role:".length());
        }
        return new String[]{realmId, roleId};
    }

    public List<ListOptionSerialized> getRestrictedToolSerializedList(Set<String> perms) {
        return this.getRestrictedToolSerializedList(perms, this.getEntireToolsList());
    }

    public List<ListOptionSerialized> getRestrictedToolSerializedList(Set<String> perms, List<ListOptionSerialized> blankList) {
        List<String> restrictedTools = this.getRestrictedToolsForUser(perms);
        for (ListOptionSerialized tool : blankList) {
            if (!restrictedTools.contains(tool.getId())) continue;
            tool.setSelected(true);
        }
        return blankList;
    }

    public List<ListOptionSerialized> getEntireToolsList() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (Tool tool : this.sakaiProxy.getAllTools()) {
            returnList.add(new ListOptionSerialized(tool.getId(), tool.getTitle() + " (" + tool.getId() + ")", false));
        }
        String[] homeTools = this.sakaiProxy.getHomeTools();
        if (homeTools != null && homeTools.length > 0) {
            returnList.add(new ListOptionSerialized("Home", "Home", false));
        }
        Collections.sort(returnList, new Comparator<ListOptionSerialized>(){

            @Override
            public int compare(ListOptionSerialized arg0, ListOptionSerialized arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return returnList;
    }

    private List<String> getRestrictedToolsForUser(Set<String> userPerms) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String userPerm : userPerms) {
            if (!userPerm.startsWith("denyTool:")) continue;
            returnList.add(userPerm.substring("denyTool:".length()));
        }
        return returnList;
    }

    private void saveRestrictedToolsForUser(String userId, String nodeId, List<String> toolIds) {
        for (String newTool : toolIds) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "denyTool:" + newTool, false);
        }
    }

    public List<ListOptionSerialized> getTermSerializedList(Set<String> perms) {
        return this.getTermSerializedList(perms, this.getEntireTermsList());
    }

    public List<ListOptionSerialized> getTermSerializedList(Set<String> perms, List<ListOptionSerialized> blankList) {
        List<String> terms = this.getTermsForUser(perms);
        for (ListOptionSerialized term : blankList) {
            if (!terms.contains(term.getId())) continue;
            term.setSelected(true);
        }
        return blankList;
    }

    public List<ListOptionSerialized> getEntireTermsList() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (String[] term : this.sakaiProxy.getTerms()) {
            returnList.add(new ListOptionSerialized(term[0], term[1], false));
        }
        return returnList;
    }

    private List<String> getTermsForUser(Set<String> userPerms) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (String userPerm : userPerms) {
            if (!userPerm.startsWith("term:")) continue;
            returnList.add(userPerm.substring("term:".length()));
        }
        return returnList;
    }

    private void saveTermsForUser(String userId, String nodeId, List<String> termIds) {
        for (String newTerm : termIds) {
            this.hierarchyService.assignUserNodePerm(userId, nodeId, "term:" + newTerm, false);
        }
    }

    public List<SiteSearchResult> searchUserSites(String search, Map<String, String> advancedOptions, boolean shoppingPeriod, boolean activeShoppingData) {
        ArrayList<SiteSearchResult> returnList = new ArrayList<SiteSearchResult>();
        if (search == null) {
            search = "";
        }
        Collection<SiteSearchResult> siteSubset = null;
        HashMap<String, String> userSortNameCache = new HashMap<String, String>();
        if (!"".equals(search) || advancedOptions != null && advancedOptions.size() > 0) {
            siteSubset = this.searchSites(search, advancedOptions);
            ArrayList<String> siteRefs = new ArrayList<String>();
            for (SiteSearchResult siteResult : siteSubset) {
                siteRefs.add(siteResult.getSiteReference());
            }
            Map<String, AccessNode> accessList = this.grantAccessToSites(siteRefs, shoppingPeriod, activeShoppingData);
            for (SiteSearchResult siteResult : siteSubset) {
                AccessNode access = accessList.get(siteResult.getSiteReference());
                if (access == null) continue;
                siteResult.setAccess(access.getAccess());
                siteResult.setShoppingPeriodAuth(access.getAuth());
                siteResult.setShoppingPeriodStartDate(access.getStartDate());
                siteResult.setShoppingPeriodEndDate(access.getEndDate());
                siteResult.setRestrictedTools(access.getDeniedTools());
                siteResult.setModified(access.getModified());
                siteResult.setModifiedBy(access.getModifiedBy());
                if (!userSortNameCache.containsKey(access.getModifiedBy())) {
                    User user = this.sakaiProxy.getUser(access.getModifiedBy());
                    String sortName = "";
                    if (user != null) {
                        sortName = user.getSortName();
                    }
                    userSortNameCache.put(access.getModifiedBy(), sortName);
                }
                siteResult.setModifiedBySortName((String)userSortNameCache.get(access.getModifiedBy()));
                returnList.add(siteResult);
            }
        }
        return returnList;
    }

    public Collection<SiteSearchResult> searchSites(String search, Map<String, String> advancedOptions) {
        if ("".equals(search)) {
            search = null;
        }
        HashMap<String, SiteSearchResult> sites = new HashMap<String, SiteSearchResult>();
        Site searchByIdSite = this.sakaiProxy.getSiteById(search);
        String termField = this.sakaiProxy.getTermField();
        String[] hierarchy = this.sakaiProxy.getServerConfigurationStrings("delegatedaccess.hierarchy.site.properties");
        if (hierarchy == null || hierarchy.length == 0) {
            hierarchy = DelegatedAccessConstants.DEFAULT_HIERARCHY;
        }
        HashMap<String, String> propsMap = new HashMap<String, String>();
        for (String prop : hierarchy) {
            propsMap.put(prop, "");
        }
        if (advancedOptions != null && advancedOptions.containsKey("termField") && advancedOptions.get("termField") != null && !"".equals(advancedOptions.get("termField").trim())) {
            propsMap.put(termField, advancedOptions.get("termField"));
            if (searchByIdSite == null || searchByIdSite.getProperties() == null || searchByIdSite.getProperties().getProperty(termField) == null || !searchByIdSite.getProperties().getProperty(termField).toLowerCase().contains(advancedOptions.get("termField"))) {
                searchByIdSite = null;
            }
        }
        if (advancedOptions != null && advancedOptions.containsKey("instructorField") && advancedOptions.get("instructorField") != null && !"".equals(advancedOptions.get("instructorField").trim())) {
            List searchUsers = this.sakaiProxy.searchUsers(advancedOptions.get("instructorField"));
            boolean foundSearchByIdMember = searchByIdSite == null;
            for (User user : searchUsers) {
                if (!foundSearchByIdMember && searchByIdSite.getMember(user.getId()) != null) {
                    foundSearchByIdMember = true;
                }
                for (Site site : this.getUserUpdatePermissionMembership(user.getId(), search, propsMap)) {
                    if (sites.containsKey(site.getId())) {
                        ((SiteSearchResult)sites.get(site.getId())).addInstructor(user);
                        continue;
                    }
                    ArrayList<User> usersList = new ArrayList<User>();
                    usersList.add(user);
                    sites.put(site.getId(), new SiteSearchResult(site, usersList, termField));
                }
            }
            if (!foundSearchByIdMember && searchByIdSite != null) {
                searchByIdSite = null;
            }
        } else {
            for (Site site : this.sakaiProxy.getSites(SiteService.SelectionType.NON_USER, search, propsMap)) {
                sites.put(site.getId(), new SiteSearchResult(site, new ArrayList(), termField));
            }
        }
        if (searchByIdSite != null && !sites.containsKey(searchByIdSite.getId())) {
            sites.put(searchByIdSite.getId(), new SiteSearchResult(searchByIdSite, new ArrayList(), termField));
        }
        return sites.values();
    }

    private List<Site> getUserUpdatePermissionMembership(String userId, String search, Map<String, String> propsMap) {
        String currentUserId = this.sakaiProxy.getCurrentUserId();
        Session sakaiSession = this.sakaiProxy.getCurrentSession();
        sakaiSession.setUserId(userId);
        sakaiSession.setUserEid(userId);
        List siteList = this.sakaiProxy.getSites(SiteService.SelectionType.UPDATE, search, propsMap);
        sakaiSession.setUserId(currentUserId);
        sakaiSession.setUserEid(currentUserId);
        return siteList;
    }

    private String[] convertToArray(List<String> list) {
        String[] returnArray = new String[]{};
        if (!list.isEmpty()) {
            returnArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                returnArray[i] = list.get(i);
            }
        }
        return returnArray;
    }

    public TreeModel createEntireTreeModelForUser(String userId, boolean addDirectChildren, boolean cascade) {
        ArrayList<String> accessAdminNodeIds = null;
        if (!this.sakaiProxy.isSuperUser()) {
            Set<HierarchyNodeSerialized> currentUserAdminNodes = this.getAccessAdminNodesForUser(this.sakaiProxy.getCurrentUserId());
            accessAdminNodeIds = new ArrayList<String>();
            if (currentUserAdminNodes != null) {
                for (HierarchyNodeSerialized node : currentUserAdminNodes) {
                    accessAdminNodeIds.add(node.id);
                }
            }
        }
        Set<HierarchyNodeSerialized> userNodes = this.getAllNodesForUser(userId);
        List<List> l1 = this.getTreeListForUser(userId, addDirectChildren, cascade, userNodes);
        if (l1 != null) {
            HierarchyNode shoppingRoot = this.hierarchyService.getRootNode("shoppingPeriodHierarchyId");
            String shoppingPeriodRootId = "-1";
            if (shoppingRoot != null) {
                shoppingPeriodRootId = shoppingRoot.id;
            }
            Iterator<List> iterator = l1.iterator();
            while (iterator.hasNext()) {
                List list = iterator.next();
                if (!shoppingPeriodRootId.equals(((HierarchyNodeSerialized)list.get((int)0)).id)) continue;
                iterator.remove();
            }
        }
        this.orderTreeModel(l1);
        return this.convertToTreeModel(l1, userId, this.getEntireToolsList(), this.getEntireTermsList(), addDirectChildren, accessAdminNodeIds);
    }

    public TreeModel createAccessTreeModelForUser(String userId, boolean addDirectChildren, boolean cascade) {
        this.accessNodes = new ArrayList<String>();
        this.shoppingPeriodAdminNodes = new ArrayList<String>();
        this.accessAdminNodes = new ArrayList<String>();
        List<List> l1 = this.getTreeListForUser(userId, addDirectChildren, cascade, this.getAccessNodesForUser(userId));
        this.orderTreeModel(l1);
        return this.trimTreeForTerms(this.convertToTreeModel(l1, userId, this.getEntireToolsList(), this.getEntireTermsList(), addDirectChildren, null));
    }

    public TreeModel getTreeModelForShoppingPeriod(boolean includePerms) {
        String userId = "";
        if (includePerms) {
            userId = "120dv0f43cv90sdf0asv9";
        }
        HashSet<HierarchyNodeSerialized> rootSet = new HashSet<HierarchyNodeSerialized>();
        rootSet.add(new HierarchyNodeSerialized(this.hierarchyService.getRootNode("shoppingPeriodHierarchyId")));
        List<List> l1 = this.getTreeListForUser(userId, false, true, rootSet);
        this.orderTreeModel(l1);
        return this.convertToTreeModel(l1, userId, this.getEntireToolsList(), this.getEntireTermsList(), false, null);
    }

    private TreeModel trimTreeForTerms(TreeModel treeModel) {
        HashMap<DefaultMutableTreeNode, List<DefaultMutableTreeNode>> removeMap = new HashMap<DefaultMutableTreeNode, List<DefaultMutableTreeNode>>();
        if (treeModel != null && treeModel.getRoot() != null) {
            this.trimTreeForTermsHelper((DefaultMutableTreeNode)treeModel.getRoot(), null, removeMap);
        }
        for (Map.Entry entry : removeMap.entrySet()) {
            DefaultMutableTreeNode removeParent = (DefaultMutableTreeNode)entry.getKey();
            for (DefaultMutableTreeNode removeNode : (List)entry.getValue()) {
                removeParent.remove(removeNode);
            }
        }
        return treeModel;
    }

    private void trimTreeForTermsHelper(DefaultMutableTreeNode node, DefaultMutableTreeNode parent, Map<DefaultMutableTreeNode, List<DefaultMutableTreeNode>> removeMap) {
        if (node != null) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.trimTreeForTermsHelper((DefaultMutableTreeNode)node.getChildAt(i), node, removeMap);
            }
            NodeModel nodeModel = (NodeModel)node.getUserObject();
            if (nodeModel.getNode().title.startsWith("/site/")) {
                String term = nodeModel.getNode().permKey;
                if (!this.checkTerm(nodeModel.getNodeTerms(), term) && parent != null) {
                    if (removeMap.containsKey(parent)) {
                        removeMap.get(parent).add(node);
                    } else {
                        ArrayList<DefaultMutableTreeNode> list = new ArrayList<DefaultMutableTreeNode>();
                        list.add(node);
                        removeMap.put(parent, list);
                    }
                }
            }
        }
    }

    private boolean checkTerm(String[] terms, String siteTerm) {
        boolean returnVal = true;
        if (terms != null && terms.length > 0) {
            returnVal = false;
            if (siteTerm != null && !"".equals(siteTerm)) {
                for (String term : terms) {
                    if (!term.equals(siteTerm)) continue;
                    returnVal = true;
                    break;
                }
            }
        }
        return returnVal;
    }

    public TreeModel getEntireTreePlusUserPerms(String userId) {
        this.getAllNodesForUser(userId);
        HashSet<HierarchyNodeSerialized> rootSet = new HashSet<HierarchyNodeSerialized>();
        rootSet.add(this.getRootNode());
        List<List> l1 = this.getTreeListForUser(userId, false, true, rootSet);
        this.orderTreeModel(l1);
        return this.convertToTreeModel(l1, userId, this.getEntireToolsList(), this.getEntireTermsList(), false, null);
    }

    public TreeModel createTreeModelForShoppingPeriod(String userId) {
        List<List> l1 = this.getTreeListForUser("120dv0f43cv90sdf0asv9", false, false, this.getShoppingPeriodAdminNodesForUser(userId));
        this.orderTreeModel(l1);
        return this.convertToTreeModel(l1, "120dv0f43cv90sdf0asv9", this.getEntireToolsList(), this.getEntireTermsList(), false, null);
    }

    private TreeModel convertToTreeModel(List<List> map, String userId, List<ListOptionSerialized> blankRestrictedTools, List<ListOptionSerialized> blankTerms, boolean addDirectChildren, List<String> accessAdminNodeIds) {
        DefaultTreeModel model = null;
        if (!map.isEmpty() && map.size() == 1) {
            DefaultMutableTreeNode rootNode = this.add(null, map, userId, blankRestrictedTools, blankTerms, addDirectChildren, accessAdminNodeIds);
            model = new DefaultTreeModel(rootNode);
        }
        return model;
    }

    private Date getShoppingStartDate(Set<String> perms) {
        Date returnDate = null;
        for (String perm : perms) {
            if (!perm.startsWith("shoppingStartDate:")) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring("shoppingStartDate:".length())));
            }
            catch (Exception e) {}
        }
        return returnDate;
    }

    private Date getShoppingEndDate(Set<String> perms) {
        Date returnDate = null;
        for (String perm : perms) {
            if (!perm.startsWith("shoppingEndDate:")) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring("shoppingEndDate:".length())));
            }
            catch (Exception e) {}
        }
        return returnDate;
    }

    private Date getPermDate(Set<String> perms, String permName) {
        Date returnDate = null;
        for (String perm : perms) {
            if (!perm.startsWith(permName)) continue;
            try {
                returnDate = new Date(Long.parseLong(perm.substring(permName.length())));
            }
            catch (Exception e) {}
        }
        return returnDate;
    }

    private String getShoppingPeriodAuth(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("shoppingAuth:")) continue;
            return perm.substring("shoppingAuth:".length());
        }
        return "";
    }

    private String getShoppingAdminModifiedBy(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("shoppingAdminModifiedBy:")) continue;
            return perm.substring("shoppingAdminModifiedBy:".length());
        }
        return null;
    }

    private String getModifiedBy(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("modifiedBy:")) continue;
            return perm.substring("modifiedBy:".length());
        }
        return null;
    }

    private boolean isShoppingPeriodAdmin(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.startsWith("shoppingAdmin")) continue;
            return true;
        }
        return false;
    }

    private boolean getIsDirectAccess(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.equals("site.visit")) continue;
            return true;
        }
        return false;
    }

    private boolean getIsAccessAdmin(Set<String> perms) {
        for (String perm : perms) {
            if (!perm.equals("accessAdmin")) continue;
            return true;
        }
        return false;
    }

    private List<ListOptionSerialized> copyListOptions(List<ListOptionSerialized> options) {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        for (ListOptionSerialized option : options) {
            returnList.add(new ListOptionSerialized(option.getId(), option.getName(), option.isSelected()));
        }
        return returnList;
    }

    private DefaultMutableTreeNode add(DefaultMutableTreeNode parent, List<List> sub, String userId, List<ListOptionSerialized> blankRestrictedTools, List<ListOptionSerialized> blankTerms, boolean addDirectChildren, List<String> accessAdminNodeIds) {
        DelegatedAccessMutableTreeNode root = null;
        for (List nodeList : sub) {
            HierarchyNodeSerialized node = (HierarchyNodeSerialized)nodeList.get(0);
            List children = (List)nodeList.get(1);
            String realm = "";
            String role = "";
            boolean directAccess = false;
            Date startDate = null;
            Date endDate = null;
            String shoppingPeriodAuth = "";
            Date shoppingAdminModified = null;
            String shoppingAdminModifiedBy = null;
            Date modified = null;
            String modifiedBy = null;
            List<ListOptionSerialized> restrictedTools = this.copyListOptions(blankRestrictedTools);
            List<ListOptionSerialized> terms = this.copyListOptions(blankTerms);
            boolean accessAdmin = this.accessAdminNodes.contains(node.id);
            boolean shoppingPeriodAdmin = this.shoppingPeriodAdminNodes.contains(node.id);
            if ("120dv0f43cv90sdf0asv9".equals(userId) || this.accessNodes.contains(node.id) || this.shoppingPeriodAdminNodes.contains(node.id)) {
                Set<String> perms = this.getPermsForUserNodes(userId, node.id);
                String[] realmRole = this.getAccessRealmRole(perms);
                realm = realmRole[0];
                role = realmRole[1];
                startDate = this.getShoppingStartDate(perms);
                endDate = this.getShoppingEndDate(perms);
                shoppingPeriodAuth = this.getShoppingPeriodAuth(perms);
                restrictedTools = this.getRestrictedToolSerializedList(perms, restrictedTools);
                terms = this.getTermSerializedList(perms, terms);
                directAccess = this.getIsDirectAccess(perms);
                shoppingAdminModified = this.getPermDate(perms, "shoppingAdminModified:");
                shoppingAdminModifiedBy = this.getShoppingAdminModifiedBy(perms);
                modified = this.getPermDate(perms, "modified:");
                modifiedBy = this.getModifiedBy(perms);
            }
            NodeModel parentNodeModel = null;
            if (parent != null) {
                parentNodeModel = (NodeModel)parent.getUserObject();
            }
            DelegatedAccessMutableTreeNode child = new DelegatedAccessMutableTreeNode();
            NodeModel childNodeModel = new NodeModel(node.id, node, directAccess, realm, role, parentNodeModel, restrictedTools, startDate, endDate, shoppingPeriodAuth, addDirectChildren && !children.isEmpty(), shoppingPeriodAdmin, terms, modifiedBy, modified, shoppingAdminModified, shoppingAdminModifiedBy, accessAdmin);
            if (accessAdminNodeIds != null) {
                childNodeModel.setEditable(false);
                boolean found = false;
                for (String nodeId : accessAdminNodeIds) {
                    if (!nodeId.equals(node.id)) continue;
                    found = true;
                    break;
                }
                if (found) {
                    childNodeModel.setEditable(true);
                }
            }
            child.setUserObject(childNodeModel);
            if (parent == null) {
                root = child;
            } else {
                parent.add((MutableTreeNode)child);
            }
            if (children.isEmpty()) continue;
            this.add((DefaultMutableTreeNode)child, children, userId, blankRestrictedTools, blankTerms, addDirectChildren, accessAdminNodeIds);
        }
        return root;
    }

    private void orderTreeModel(List<List> hierarchy) {
        if (hierarchy != null) {
            for (List nodeList : hierarchy) {
                this.orderTreeModel((List)nodeList.get(1));
            }
            Collections.sort(hierarchy, new NodeListComparator());
        }
    }

    private List<String> getOrderedParentsList(HierarchyNodeSerialized node) {
        String directParentId = null;
        if (node.directParentNodeIds != null && node.directParentNodeIds.size() > 0) {
            directParentId = node.directParentNodeIds.toArray(new String[node.directParentNodeIds.size()])[0];
            return this.getOrderedParentsListHelper(this.getCachedNode(directParentId));
        }
        return new ArrayList<String>();
    }

    private List<String> getOrderedParentsListHelper(HierarchyNodeSerialized node) {
        if (node.directParentNodeIds == null || node.directParentNodeIds.size() == 0) {
            ArrayList<String> returnList = new ArrayList<String>();
            returnList.add(node.id);
            return returnList;
        }
        List<String> parents = this.getOrderedParentsListHelper(this.getCachedNode(node.directParentNodeIds.toArray(new String[node.directParentNodeIds.size()])[0]));
        parents.add(node.id);
        return parents;
    }

    private List<List> getTreeListForUser(String userId, boolean addDirectChildren, boolean cascade, Set<HierarchyNodeSerialized> nodes) {
        HierarchyNodeSerialized root;
        ArrayList<List> l1 = new ArrayList<List>();
        List<List> currentLevel = l1;
        for (HierarchyNodeSerialized node : nodes) {
            for (String parentId : this.getOrderedParentsList(node)) {
                HierarchyNodeSerialized parentNode = this.getCachedNode(parentId);
                if (!this.hasNode(parentNode, currentLevel)) {
                    ArrayList<Object> newNode = new ArrayList<Object>();
                    newNode.add(parentNode);
                    newNode.add(new ArrayList());
                    currentLevel.add(newNode);
                }
                currentLevel = this.getChildrenForNode(parentNode.id, currentLevel);
                if (!addDirectChildren) continue;
                for (List nodeList : this.getDirectChildren(parentNode)) {
                    if (this.hasNode((HierarchyNodeSerialized)nodeList.get(0), currentLevel)) continue;
                    currentLevel.add(nodeList);
                }
            }
            if (!this.hasNode(node, currentLevel)) {
                ArrayList<Object> child = new ArrayList<Object>();
                child.add(node);
                child.add(new ArrayList());
                currentLevel.add(child);
            }
            if (cascade) {
                this.getCascadingChildren(node, this.getChildrenForNode(node.id, currentLevel));
            }
            currentLevel = l1;
        }
        if (l1.isEmpty() && addDirectChildren && (root = this.getRootNode()) != null && root.id != null && !"".equals(root.id)) {
            ArrayList<Object> child = new ArrayList<Object>();
            child.add(root);
            child.add(this.getDirectChildren(root));
            l1.add(child);
        }
        return l1;
    }

    private HierarchyNodeSerialized getCachedNode(String id) {
        Element el = this.nodeCache.get((Serializable)((Object)id));
        HierarchyNodeSerialized node = null;
        if (el == null) {
            node = this.getNode(id);
            try {
                this.nodeCache.put(new Element((Serializable)((Object)id), (Serializable)node));
            }
            catch (Exception e) {
                log.error((Object)("getCachedNode: " + id), (Throwable)e);
            }
        } else if (el.getObjectValue() instanceof HierarchyNodeSerialized) {
            node = (HierarchyNodeSerialized)el.getObjectValue();
        }
        return node;
    }

    private List<List> getChildrenForNode(String id, List<List> level) {
        for (List nodeList : level) {
            HierarchyNodeSerialized n = (HierarchyNodeSerialized)nodeList.get(0);
            if (!n.id.equals(id)) continue;
            return (List)nodeList.get(1);
        }
        return null;
    }

    private List<List> getDirectChildren(HierarchyNodeSerialized parent) {
        ArrayList<List> returnList = new ArrayList<List>();
        if (parent != null) {
            Set parentChildren = parent.directChildNodeIds;
            for (String childId : parentChildren) {
                ArrayList<Object> child = new ArrayList<Object>();
                child.add(this.getCachedNode(childId));
                child.add(new ArrayList());
                returnList.add(child);
            }
        }
        return returnList;
    }

    private List<List> getCascadingChildren(HierarchyNodeSerialized parent, List<List> children) {
        Set parentChildren = parent.directChildNodeIds;
        for (String childId : parentChildren) {
            HierarchyNodeSerialized childNode = this.getCachedNode(childId);
            List<List> childMap = this.getChildrenForNode(childNode.id, children);
            if (childMap == null) {
                childMap = new ArrayList<List>();
            }
            childMap = this.getCascadingChildren(childNode, childMap);
            if (this.hasNode(childNode, children)) continue;
            ArrayList<Object> childList = new ArrayList<Object>();
            childList.add(childNode);
            childList.add(childMap);
            children.add(childList);
        }
        return children;
    }

    private boolean hasNode(HierarchyNodeSerialized node, List<List> level) {
        for (List nodeList : level) {
            HierarchyNodeSerialized n = (HierarchyNodeSerialized)nodeList.get(0);
            if (!n.id.equals(node.id)) continue;
            return true;
        }
        return false;
    }

    public boolean addChildrenNodes(Object node, String userId, List<ListOptionSerialized> blankRestrictedTools, List<ListOptionSerialized> blankTerms, boolean onlyAccessNodes, List<String> accessAdminNodes) {
        boolean anyAdded = false;
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)node;
        NodeModel nodeModel = (NodeModel)((DefaultMutableTreeNode)node).getUserObject();
        if (nodeModel.getNode() != null) {
            List<List> childrenNodes = this.getDirectChildren(nodeModel.getNode());
            Collections.sort(childrenNodes, new NodeListComparator());
            for (List childList : childrenNodes) {
                if (accessAdminNodes != null && !((NodeModel)parentNode.getUserObject()).isNodeEditable() && !accessAdminNodes.contains(((HierarchyNodeSerialized)childList.get((int)0)).id)) continue;
                boolean newlyAdded = this.addChildNodeToTree((HierarchyNodeSerialized)childList.get(0), parentNode, userId, blankRestrictedTools, blankTerms, onlyAccessNodes);
                anyAdded = anyAdded || newlyAdded;
            }
        }
        return anyAdded;
    }

    private boolean addChildNodeToTree(HierarchyNodeSerialized childNode, DefaultMutableTreeNode parentNode, String userId, List<ListOptionSerialized> blankRestrictedTools, List<ListOptionSerialized> blankTerms, boolean onlyAccessNodes) {
        boolean added = false;
        if (!this.doesChildExist(childNode.id, parentNode)) {
            String realm = "";
            String role = "";
            boolean selected = false;
            Date startDate = null;
            Date endDate = null;
            String shoppingPeriodAuth = "";
            List<ListOptionSerialized> restrictedTools = this.copyListOptions(blankRestrictedTools);
            List<ListOptionSerialized> terms = this.copyListOptions(blankTerms);
            boolean shoppingPeriodAdmin = false;
            boolean directAccess = false;
            Date shoppingAdminModified = null;
            String shoppingAdminModifiedBy = null;
            Date modified = null;
            String modifiedBy = null;
            boolean accessAdmin = false;
            DelegatedAccessMutableTreeNode child = new DelegatedAccessMutableTreeNode();
            if ("120dv0f43cv90sdf0asv9".equals(userId)) {
                Set<String> perms = this.getPermsForUserNodes(userId, childNode.id);
                String[] realmRole = this.getAccessRealmRole(perms);
                realm = realmRole[0];
                role = realmRole[1];
                startDate = this.getShoppingStartDate(perms);
                endDate = this.getShoppingEndDate(perms);
                shoppingPeriodAuth = this.getShoppingPeriodAuth(perms);
                restrictedTools = this.getRestrictedToolSerializedList(perms, restrictedTools);
                terms = this.getTermSerializedList(perms, terms);
                directAccess = this.getIsDirectAccess(perms);
                shoppingAdminModified = this.getPermDate(perms, "shoppingAdminModified:");
                shoppingAdminModifiedBy = this.getShoppingAdminModifiedBy(perms);
                modified = this.getPermDate(perms, "modified:");
                modifiedBy = this.getModifiedBy(perms);
                accessAdmin = this.getIsAccessAdmin(perms);
            }
            NodeModel node = new NodeModel(childNode.id, childNode, directAccess, realm, role, (NodeModel)parentNode.getUserObject(), restrictedTools, startDate, endDate, shoppingPeriodAuth, false, shoppingPeriodAdmin, terms, modifiedBy, modified, shoppingAdminModified, shoppingAdminModifiedBy, accessAdmin);
            child.setUserObject(node);
            if (!onlyAccessNodes || node.getNodeAccess()) {
                parentNode.add((MutableTreeNode)child);
                added = true;
            }
        }
        return added;
    }

    private boolean doesChildExist(String childNodeId, DefaultMutableTreeNode parentNode) {
        boolean exists = false;
        for (int i = 0; i < parentNode.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parentNode.getChildAt(i);
            if (!childNodeId.equals(((NodeModel)child.getUserObject()).getNodeId())) continue;
            exists = true;
            break;
        }
        return exists;
    }

    public NodeModel getNodeModel(String nodeId, String userId) {
        HierarchyNodeSerialized node = this.getNode(nodeId);
        NodeModel parentNodeModel = null;
        if (node.directParentNodeIds != null && node.directParentNodeIds.size() > 0) {
            parentNodeModel = this.getNodeModel((String)node.directParentNodeIds.toArray()[node.directParentNodeIds.size() - 1], userId);
        }
        Set nodePerms = this.hierarchyService.getPermsForUserNodes(userId, new String[]{nodeId});
        Set<String> perms = this.getPermsForUserNodes(userId, node.id);
        String[] realmRole = this.getAccessRealmRole(perms);
        String realm = realmRole[0];
        String role = realmRole[1];
        Date startDate = this.getShoppingStartDate(perms);
        Date endDate = this.getShoppingEndDate(perms);
        String shoppingPeriodAuth = this.getShoppingPeriodAuth(perms);
        List<ListOptionSerialized> restrictedTools = this.getRestrictedToolSerializedList(perms, this.getEntireToolsList());
        List<ListOptionSerialized> terms = this.getTermSerializedList(perms, this.getEntireToolsList());
        boolean direct = this.getIsDirectAccess(perms);
        boolean shoppingPeriodAdmin = this.isShoppingPeriodAdmin(perms);
        boolean accessAdmin = this.getIsAccessAdmin(perms);
        Date shoppingAdminModified = this.getPermDate(perms, "shoppingAdminModified:");
        String shoppingAdminModifiedBy = this.getShoppingAdminModifiedBy(perms);
        Date modified = this.getPermDate(perms, "modified:");
        String modifiedBy = this.getModifiedBy(perms);
        NodeModel nodeModel = new NodeModel(node.id, node, this.getIsDirectAccess(nodePerms), realm, role, parentNodeModel, restrictedTools, startDate, endDate, shoppingPeriodAuth, false, shoppingPeriodAdmin, terms, modifiedBy, modified, shoppingAdminModified, shoppingAdminModifiedBy, accessAdmin);
        return nodeModel;
    }

    public void assignUserNodePerm(String userId, String nodeId, String perm, boolean cascade) {
        this.hierarchyService.assignUserNodePerm(userId, nodeId, perm, false);
    }

    public void removeNode(String nodeId) {
        this.removeNode(this.hierarchyService.getNodeById(nodeId));
    }

    public void removeNode(HierarchyNode node) {
        if (node != null) {
            if (node.childNodeIds != null && !node.childNodeIds.isEmpty()) {
                for (String childId : node.childNodeIds) {
                    this.removeNode(this.hierarchyService.getNodeById(childId));
                }
            }
            this.hierarchyService.removeNode(node.id);
            Set userIds = this.hierarchyService.getUserIdsForNodesPerm(new String[]{node.id}, "site.visit");
            for (String userId : userIds) {
                this.removeAllUserPermissions(node.id, userId);
            }
            this.hierarchyService.setNodeDisabled(node.id, Boolean.valueOf(true));
        }
    }

    public void deleteEmptyNonSiteNodes(String hierarchyId) {
        List<String> emptyNodes = this.dao.getEmptyNonSiteNodes(hierarchyId);
        for (int loopProtection = 1; emptyNodes != null && emptyNodes.size() > 0 && loopProtection < 1000000; ++loopProtection) {
            for (String id : emptyNodes) {
                this.removeNode(this.hierarchyService.getNodeById(id));
            }
            emptyNodes = this.dao.getEmptyNonSiteNodes(hierarchyId);
        }
    }

    public Map<String, String> getRealmRoleDisplay(boolean shopping) {
        if (shopping) {
            return this.convertRealmRoleToSingleList(this.sakaiProxy.getShoppingRealmOptions());
        }
        return this.convertRealmRoleToSingleList(this.sakaiProxy.getDelegatedAccessRealmOptions());
    }

    private Map<String, String> convertRealmRoleToSingleList(Map<String, List<String>> realmMap) {
        ArrayList<String> allRoles = new ArrayList<String>();
        for (Map.Entry<String, List<String>> entry : realmMap.entrySet()) {
            for (String role : entry.getValue()) {
                allRoles.add(role);
            }
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : realmMap.entrySet()) {
            String realm = entry.getKey();
            Iterator<String> i$ = entry.getValue().iterator();
            while (i$.hasNext()) {
                String role;
                String roleTitle = role = i$.next();
                if (this.countNumOfOccurances(allRoles, role) > 1) {
                    roleTitle = roleTitle + " (" + realm + ")";
                }
                returnMap.put(realm + ":" + role, roleTitle);
            }
        }
        return returnMap;
    }

    private int countNumOfOccurances(List<String> list, String str) {
        int i = 0;
        for (String check : list) {
            if (!check.equals(str)) continue;
            ++i;
        }
        return i;
    }

    public List<ListOptionSerialized> getAuthorizationOptions() {
        ArrayList<ListOptionSerialized> returnList = new ArrayList<ListOptionSerialized>();
        returnList.add(new ListOptionSerialized(".auth", "Logged In", false));
        returnList.add(new ListOptionSerialized(".anon", "Public", false));
        return returnList;
    }

    public boolean hasShoppingPeriodAdminNodes(String userId) {
        if (userId == null || "".equals(userId)) {
            return false;
        }
        Set shoppingAdminNodes = this.hierarchyService.getNodesForUserPerm(userId, "shoppingAdmin");
        return shoppingAdminNodes != null && shoppingAdminNodes.size() > 0;
    }

    public boolean hasDelegatedAccessNodes(String userId) {
        if (userId == null || "".equals(userId)) {
            return false;
        }
        Set delegatedAccessNodes = this.hierarchyService.getNodesForUserPerm(userId, "site.visit");
        return delegatedAccessNodes != null && delegatedAccessNodes.size() > 0;
    }

    public boolean hasAccessAdminNodes(String userId) {
        if (userId == null || "".equals(userId)) {
            return false;
        }
        Set accessAdminNodes = this.hierarchyService.getNodesForUserPerm(userId, "accessAdmin");
        return accessAdminNodes != null && accessAdminNodes.size() > 0;
    }

    public Map<String, List<String>> getNodesBySiteRef(String[] siteRefs, String hierarchyId) {
        return this.dao.getNodesBySiteRef(siteRefs, hierarchyId);
    }

    public void clearNodeCache() {
        this.nodeCache.removeAll();
    }

    public String[] getCurrentUsersAccessToSite(String siteRef) {
        if (this.sakaiProxy.getCurrentSession().getAttribute("delegatedaccess.accessmap") != null && ((Map)this.sakaiProxy.getCurrentSession().getAttribute("delegatedaccess.accessmap")).containsKey(siteRef)) {
            return (String[])((Map)this.sakaiProxy.getCurrentSession().getAttribute("delegatedaccess.accessmap")).get(siteRef);
        }
        ArrayList<String> siteRefs = new ArrayList<String>();
        siteRefs.add(siteRef);
        Map<String, AccessNode> accessNodes = this.grantAccessToSites(siteRefs, false, false);
        if (accessNodes != null && accessNodes.containsKey(siteRef)) {
            return accessNodes.get(siteRef).getAccess();
        }
        return null;
    }

    private Map<String, AccessNode> grantAccessToSites(List<String> siteRefs, boolean shoppingPeriod, boolean activeShoppingData) {
        Map<String, List<String>> siteRefToNodeMap;
        Object sessionaccessMap;
        Object sessionDeniedToolsMap;
        HashMap<String, AccessNode> returnNodes = new HashMap<String, AccessNode>();
        Session session = this.sakaiProxy.getCurrentSession();
        Map<String, String[]> deniedToolsMap = new HashMap();
        if (!shoppingPeriod && (sessionDeniedToolsMap = session.getAttribute("delegatedaccess.deniedToolsMap")) != null) {
            deniedToolsMap = (Map)sessionDeniedToolsMap;
        }
        Map<String, Object> accessMap = new HashMap();
        if (!shoppingPeriod && (sessionaccessMap = session.getAttribute("delegatedaccess.accessmap")) != null) {
            accessMap = (Map)sessionaccessMap;
        }
        Iterator<String> iterator = siteRefs.iterator();
        while (iterator.hasNext()) {
            String siteRef = iterator.next();
            if (!shoppingPeriod && accessMap.containsKey(siteRef) && accessMap.get(siteRef) == null) {
                returnNodes.put(siteRef, null);
                iterator.remove();
                continue;
            }
            deniedToolsMap.put(siteRef, null);
            accessMap.put(siteRef, null);
        }
        String userId = this.sakaiProxy.getCurrentUserId();
        String hierarchyId = "delegatedAccessHierarchyId";
        if (shoppingPeriod) {
            userId = "120dv0f43cv90sdf0asv9";
            if (activeShoppingData) {
                hierarchyId = "shoppingPeriodHierarchyId";
            }
        }
        Object dAMapFlag = null;
        if (!shoppingPeriod) {
            dAMapFlag = session.getAttribute("delegatedaccess.accessmapflag");
        }
        if ((dAMapFlag != null || shoppingPeriod) && (siteRefToNodeMap = this.getNodesBySiteRef(siteRefs.toArray(new String[siteRefs.size()]), hierarchyId)) != null) {
            HashSet<String> nodeIds = new HashSet<String>();
            for (List<String> nodeIdsList : siteRefToNodeMap.values()) {
                nodeIds.addAll(nodeIdsList);
            }
            Map siteNodes = this.hierarchyService.getNodesByIds(nodeIds.toArray(new String[nodeIds.size()]));
            Map usersNodesAndPerms = this.hierarchyService.getNodesAndPermsForUser(new String[]{userId});
            Map userNodesAndPerms = (Map)usersNodesAndPerms.get(userId);
            if (userNodesAndPerms != null) {
                block4: for (String siteRef : siteRefs) {
                    if (siteRefToNodeMap == null || !siteRefToNodeMap.containsKey(siteRef) || siteRefToNodeMap.get(siteRef) == null || siteRefToNodeMap.get(siteRef).size() <= 0) continue;
                    String nodeId = siteRefToNodeMap.get(siteRef).get(0);
                    while (nodeId != null && !"".equals(nodeId)) {
                        Set perms = (Set)userNodesAndPerms.get(nodeId);
                        if (perms != null && this.getIsDirectAccess(perms)) {
                            if (!shoppingPeriod && this.sakaiProxy.isUserMember(userId, siteRef)) {
                                returnNodes.put(siteRef, null);
                            } else {
                                String siteId;
                                if (shoppingPeriod && activeShoppingData && !this.isShoppingAvailable(perms, siteId = siteRef.substring(6))) continue block4;
                                String[] access = this.getAccessRealmRole(perms);
                                if (access == null || access.length != 2 || access[0] == null || access[1] == null || "".equals(access[0]) || "".equals(access[1]) || "null".equals(access[0]) || "null".equals(access[1])) {
                                    access = new String[]{"", ""};
                                }
                                accessMap.put(siteRef, access);
                                List<String> deniedTools = this.getRestrictedToolsForUser(perms);
                                String[] deniedToolsArr = deniedTools.toArray(new String[deniedTools.size()]);
                                if (deniedToolsArr != null) {
                                    deniedToolsMap.put(siteRef, deniedToolsArr);
                                } else {
                                    deniedToolsMap.put(siteRef, new String[0]);
                                }
                                String shoppingAuth = this.getShoppingPeriodAuth(perms);
                                Date startDate = this.getShoppingStartDate(perms);
                                Date endDate = this.getShoppingEndDate(perms);
                                Date modified = this.getPermDate(perms, "modified:");
                                String modifiedBy = this.getModifiedBy(perms);
                                AccessNode returnNode = new AccessNode(siteRef, access, deniedToolsArr, shoppingAuth, startDate, endDate, modified, modifiedBy);
                                returnNodes.put(siteRef, returnNode);
                            }
                            nodeId = null;
                            continue block4;
                        }
                        Set parentIds = null;
                        parentIds = siteNodes != null && siteNodes.containsKey(nodeId) ? ((HierarchyNode)siteNodes.get((Object)nodeId)).directParentNodeIds : this.getCachedNode((String)nodeId).directParentNodeIds;
                        nodeId = null;
                        if (parentIds == null || parentIds.size() != 1) continue;
                        Iterator i$ = parentIds.iterator();
                        while (i$.hasNext()) {
                            String id;
                            nodeId = id = (String)i$.next();
                        }
                    }
                }
            }
        }
        if (!shoppingPeriod) {
            session.setAttribute("delegatedaccess.deniedToolsMap", deniedToolsMap);
            session.setAttribute("delegatedaccess.accessmap", accessMap);
            try {
                this.restrictedToolsCache.put(new Element((Object)userId, deniedToolsMap));
            }
            catch (Exception e) {
                log.error((Object)("grantAccessToSite: " + userId), (Throwable)e);
            }
        }
        return returnNodes;
    }

    private boolean isShoppingAvailable(Set<String> perms, String siteId) {
        Date startDate = this.getShoppingStartDate(perms);
        Date endDate = this.getShoppingEndDate(perms);
        String[] nodeAccessRealmRole = this.getAccessRealmRole(perms);
        String auth = this.getShoppingPeriodAuth(perms);
        List<String> termsArr = this.getTermsForUser(perms);
        String siteTerm = null;
        String[] terms = null;
        if (terms != null) {
            terms = termsArr.toArray(new String[termsArr.size()]);
            siteTerm = this.dao.getSiteProperty(this.sakaiProxy.getTermField(), siteId);
        }
        return this.isShoppingPeriodOpenForSite(startDate, endDate, nodeAccessRealmRole, auth, terms, siteId);
    }

    public boolean isShoppingPeriodOpenForSite(Date startDate, Date endDate, String[] nodeAccessRealmRole, String auth, String[] terms, String siteTerm) {
        Date now = new Date();
        boolean isOpen = false;
        if (startDate != null && endDate != null) {
            isOpen = startDate.before(now) && endDate.after(now);
        } else if (startDate != null) {
            isOpen = startDate.before(now);
        } else if (endDate != null) {
            isOpen = endDate.after(now);
        }
        isOpen = nodeAccessRealmRole != null && nodeAccessRealmRole.length == 2 && !"".equals(nodeAccessRealmRole[0]) && !"".equals(nodeAccessRealmRole[1]) && !"null".equals(nodeAccessRealmRole[0]) && !"null".equals(nodeAccessRealmRole[1]) ? isOpen : false;
        if (auth == null || "".equals(auth)) {
            isOpen = false;
        } else if (".anon".equals(auth) || ".auth".equals(auth)) {
            boolean bl = isOpen = isOpen;
        }
        if (!this.checkTerm(terms, siteTerm)) {
            isOpen = false;
        }
        return isOpen;
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }

    public HierarchyService getHierarchyService() {
        return this.hierarchyService;
    }

    public void setHierarchyService(HierarchyService hierarchyService) {
        this.hierarchyService = hierarchyService;
    }

    public DelegatedAccessDao getDao() {
        return this.dao;
    }

    public void setDao(DelegatedAccessDao dao) {
        this.dao = dao;
    }

    public Cache getNodeCache() {
        return this.nodeCache;
    }

    public void setNodeCache(Cache nodeCache) {
        this.nodeCache = nodeCache;
    }

    public Cache getRestrictedToolsCache() {
        return this.restrictedToolsCache;
    }

    public void setRestrictedToolsCache(Cache restrictedToolsCache) {
        this.restrictedToolsCache = restrictedToolsCache;
    }

    private class AccessNode {
        private String siteRef;
        private String[] access;
        private String[] deniedTools;
        private String auth;
        private Date startDate;
        private Date endDate;
        private Date modified;
        private String modifiedBy;

        public AccessNode(String siteRef, String[] access, String[] deniedTools, String auth, Date startDate, Date endDate, Date modified, String modifiedBy) {
            this.siteRef = siteRef;
            this.access = access;
            this.deniedTools = deniedTools;
            this.setAuth(auth);
            this.setStartDate(startDate);
            this.setEndDate(endDate);
            this.setModified(modified);
            this.setModifiedBy(modifiedBy);
        }

        public void setSiteRef(String siteRef) {
            this.siteRef = siteRef;
        }

        public String getSiteRef() {
            return this.siteRef;
        }

        public void setAccess(String[] access) {
            this.access = access;
        }

        public String[] getAccess() {
            return this.access;
        }

        public void setDeniedTools(String[] deniedTools) {
            this.deniedTools = deniedTools;
        }

        public String[] getDeniedTools() {
            return this.deniedTools;
        }

        public void setAuth(String auth) {
            this.auth = auth;
        }

        public String getAuth() {
            return this.auth;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public Date getModified() {
            return this.modified;
        }

        public void setModified(Date modified) {
            this.modified = modified;
        }

        public String getModifiedBy() {
            return this.modifiedBy;
        }

        public void setModifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeListComparator
    implements Comparator<List> {
        private NodeListComparator() {
        }

        @Override
        public int compare(List o1, List o2) {
            return ((HierarchyNodeSerialized)o1.get((int)0)).title.compareToIgnoreCase(((HierarchyNodeSerialized)o2.get((int)0)).title);
        }
    }
}

