/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.dao.impl;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.reloading.InvariantReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.apache.log4j.Logger;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.delegatedaccess.dao.DelegatedAccessDao;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class DelegatedAccessDaoImpl
extends JdbcDaoSupport
implements DelegatedAccessDao {
    private static final Logger log = Logger.getLogger(DelegatedAccessDaoImpl.class);
    private PropertiesConfiguration statements;
    private static int ORACLE_IN_CLAUSE_SIZE_LIMIT = 1000;
    private boolean oracle = false;

    public void init() {
        log.info((Object)"init()");
        String vendor = ServerConfigurationService.getInstance().getString("vendor@org.sakaiproject.db.api.SqlService", null);
        this.initStatements(vendor);
        if (vendor != null && "oracle".equals(vendor)) {
            this.oracle = true;
        }
    }

    private void initStatements(String vendor) {
        URL url = this.getClass().getClassLoader().getResource(vendor + ".properties");
        try {
            this.statements = new PropertiesConfiguration();
            this.statements.setReloadingStrategy((ReloadingStrategy)new InvariantReloadingStrategy());
            this.statements.setThrowExceptionOnMissing(true);
            this.statements.setDelimiterParsingDisabled(true);
            this.statements.load(url);
        }
        catch (ConfigurationException e) {
            log.error((Object)(((Object)((Object)e)).getClass() + ": " + e.getMessage()), (Throwable)e);
            return;
        }
    }

    private String getStatement(String key) {
        try {
            return this.statements.getString(key);
        }
        catch (NoSuchElementException e) {
            log.error((Object)("Statement: '" + key + "' could not be found in: " + this.statements.getFileName()), (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getDistinctSiteTerms(String termField) {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.distinctTerms"), (Object[])new String[]{termField}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString(1);
                }
            });
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public String getSiteProperty(String propertyName, String siteId) {
        try {
            return (String)this.getJdbcTemplate().queryForObject(this.getStatement("select.siteProperty"), new Object[]{propertyName, siteId}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("VALUE");
                }
            });
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public Map<String, List<String>> getNodesBySiteRef(String[] siteRefs, String hierarchyId) {
        try {
            int subArraySize;
            HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
            if (siteRefs == null || siteRefs.length == 0) {
                return returnMap;
            }
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > siteRefs.length) {
                    subArraySize = siteRefs.length - subArrayIndex;
                }
                String[] subSiteRefs = Arrays.copyOfRange(siteRefs, subArrayIndex, subArrayIndex + subArraySize);
                String query = this.getStatement("select.hierarchyNode");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "?";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query = query.replace("(?)", inParams);
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(hierarchyId);
                parameters.addAll(Arrays.asList(subSiteRefs));
                List results = this.getJdbcTemplate().query(query, parameters.toArray(), new RowMapper(){

                    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                        return new String[]{resultSet.getString("title"), resultSet.getString("ID")};
                    }
                });
                if (results == null) continue;
                for (String[] result : results) {
                    if (result == null || result.length != 2) continue;
                    if (!returnMap.containsKey(result[0])) {
                        returnMap.put(result[0], new ArrayList());
                    }
                    ((List)returnMap.get(result[0])).add(result[1]);
                }
            } while ((subArrayIndex += subArraySize) < siteRefs.length);
            return returnMap;
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<String> getEmptyNonSiteNodes(String hierarchyId) {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.emptyNodes"), new Object[]{hierarchyId}, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("ID");
                }
            });
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void updateSiteProperty(String[] siteIds, String propertyName, String propertyValue) {
        try {
            if (siteIds == null || siteIds.length == 0) {
                return;
            }
            String query = this.getStatement("update.siteProperty");
            if (this.oracle) {
                String values = "";
                for (String siteId : siteIds) {
                    if (!"".equals(values)) {
                        values = values + " union ";
                    }
                    values = values + "select '" + siteId + "' SITE_ID, '" + propertyName + "' NAME, '" + propertyValue + "' VALUE from dual";
                }
                query = query.replace("?", values);
            } else {
                String values = "";
                for (String siteId : siteIds) {
                    if (!"".equals(values)) {
                        values = values + ",";
                    }
                    values = values + "('" + siteId + "', '" + propertyName + "','" + propertyValue + "')";
                }
                query = query + values;
            }
            this.getJdbcTemplate().update(query);
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void removeSiteProperty(String[] siteIds, String propertyName) {
        try {
            int subArraySize;
            if (siteIds == null || siteIds.length == 0) {
                return;
            }
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > siteIds.length) {
                    subArraySize = siteIds.length - subArrayIndex;
                }
                String[] subSiteRefs = Arrays.copyOfRange(siteIds, subArrayIndex, subArrayIndex + subArraySize);
                String query1 = this.getStatement("delete.siteProperty");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "?";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query1 = query1.replace("(?)", inParams);
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(propertyName);
                parameters.addAll(Arrays.asList(subSiteRefs));
                this.getJdbcTemplate().update(query1, parameters.toArray());
            } while ((subArrayIndex += subArraySize) < siteIds.length);
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public List<Object[]> searchSites(String titleSearch, Map<String, String> propsMap, String[] instructorIds, String insturctorType, boolean publishedOnly) {
        try {
            boolean noInstructors;
            if (titleSearch == null) {
                titleSearch = "";
            }
            titleSearch = "%" + titleSearch + "%";
            Object[] params = new Object[]{titleSearch};
            String query = "";
            boolean bl = noInstructors = instructorIds == null || instructorIds.length == 0;
            if (noInstructors) {
                query = this.getStatement("select.siteSearch");
            } else {
                query = "member".equals(insturctorType) ? this.getStatement("select.siteSearchMembers") : this.getStatement("select.siteSearchInstructors");
                String inParams = "(";
                for (int i = 0; i < instructorIds.length && i < ORACLE_IN_CLAUSE_SIZE_LIMIT; ++i) {
                    inParams = inParams + "'" + instructorIds[i].replace("'", "''") + "'";
                    if (i >= instructorIds.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query = query.replace("(:userIds)", inParams);
            }
            if (propsMap != null && propsMap.size() > 0) {
                params = new Object[1 + propsMap.size() * 2];
                params[0] = titleSearch;
                int i = 1;
                for (Map.Entry<String, String> entry : propsMap.entrySet()) {
                    query = query + " " + this.getStatement("select.siteSearchPropWhere");
                    params[i] = entry.getKey();
                    params[++i] = entry.getValue();
                    ++i;
                }
            }
            if (publishedOnly) {
                query = query + " " + this.getStatement("select.siteSearchPublishedOnly");
            }
            return this.getJdbcTemplate().query(query, params, new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    if (noInstructors) {
                        return new Object[]{resultSet.getString("SITE_ID"), resultSet.getString("TITLE"), resultSet.getBoolean("PUBLISHED")};
                    }
                    return new Object[]{resultSet.getString("SITE_ID"), resultSet.getString("TITLE"), resultSet.getBoolean("PUBLISHED"), resultSet.getString("USER_ID")};
                }
            });
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return new ArrayList<Object[]>();
        }
    }

    @Override
    public Map<String, Map<String, String>> searchSitesForProp(String[] props, String[] siteIds) {
        try {
            int subArraySize;
            HashMap<String, Map<String, String>> returnMap = new HashMap<String, Map<String, String>>();
            if (props == null || props.length == 0 || siteIds == null || siteIds.length == 0) {
                return returnMap;
            }
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > siteIds.length) {
                    subArraySize = siteIds.length - subArrayIndex;
                }
                String[] subSiteRefs = Arrays.copyOfRange(siteIds, subArrayIndex, subArrayIndex + subArraySize);
                String query = this.getStatement("select.sitesProp");
                String propInParams = "(";
                for (int i = 0; i < props.length; ++i) {
                    propInParams = propInParams + "'" + props[i].replace("'", "''") + "'";
                    if (i >= props.length - 1) continue;
                    propInParams = propInParams + ",";
                }
                propInParams = propInParams + ")";
                query = query.replace("(:props)", propInParams);
                propInParams = propInParams + ")";
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "'" + subSiteRefs[i].replace("'", "''") + "'";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query = query.replace("(:siteIds)", inParams);
                List results = this.getJdbcTemplate().query(query, new RowMapper(){

                    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                        return new String[]{resultSet.getString("SITE_ID"), resultSet.getString("NAME"), resultSet.getString("VALUE")};
                    }
                });
                if (results == null) continue;
                for (String[] result : results) {
                    Map<String, String> propMap = new HashMap<String, String>();
                    if (returnMap.containsKey(result[0])) {
                        propMap = (Map)returnMap.get(result[0]);
                    }
                    propMap.put(result[1], result[2]);
                    returnMap.put(result[0], propMap);
                }
            } while ((subArrayIndex += subArraySize) < siteIds.length);
            return returnMap;
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void cleanupOrphanedPermissions() {
        try {
            this.getJdbcTemplate().update(this.getStatement("delete.orphaned.permissions"));
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public Map<String, Set<String>> getNodesAndPermsForUser(String userId, String[] nodeIds) {
        try {
            int subArraySize;
            HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>();
            if (nodeIds == null || nodeIds.length == 0) {
                return returnMap;
            }
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > nodeIds.length) {
                    subArraySize = nodeIds.length - subArrayIndex;
                }
                String[] subSiteRefs = Arrays.copyOfRange(nodeIds, subArrayIndex, subArrayIndex + subArraySize);
                String query = this.getStatement("select.nodes.and.perms.for.user");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "?";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query = query.replace("(?)", inParams);
                ArrayList<String> parameters = new ArrayList<String>();
                parameters.add(userId);
                parameters.addAll(Arrays.asList(subSiteRefs));
                List results = this.getJdbcTemplate().query(query, parameters.toArray(), new RowMapper(){

                    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                        return new String[]{resultSet.getString("NODEID"), resultSet.getString("PERMISSION")};
                    }
                });
                if (results == null) continue;
                for (String[] result : results) {
                    if (result == null || result.length != 2) continue;
                    if (!returnMap.containsKey(result[0])) {
                        returnMap.put(result[0], new HashSet());
                    }
                    ((Set)returnMap.get(result[0])).add(result[1]);
                }
            } while ((subArrayIndex += subArraySize) < nodeIds.length);
            return returnMap;
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<String> findActiveSites(String[] siteIds) {
        ArrayList<String> returnList = new ArrayList<String>();
        if (siteIds == null || siteIds.length == 0) {
            return returnList;
        }
        try {
            int subArraySize;
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > siteIds.length) {
                    subArraySize = siteIds.length - subArrayIndex;
                }
                Object[] subSiteRefs = Arrays.copyOfRange(siteIds, subArrayIndex, subArrayIndex + subArraySize);
                String query = this.getStatement("select.activeSites");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "?";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query = query.replace("(?)", inParams);
                List results = this.getJdbcTemplate().query(query, subSiteRefs, new RowMapper(){

                    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                        return resultSet.getString("SITE_ID");
                    }
                });
                if (results == null) continue;
                returnList.addAll(results);
            } while ((subArrayIndex += subArraySize) < siteIds.length);
            return returnList;
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public void removeAnonAndAuthRoles(String[] siteRefs) {
        try {
            int subArraySize;
            if (siteRefs == null || siteRefs.length == 0) {
                return;
            }
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > siteRefs.length) {
                    subArraySize = siteRefs.length - subArrayIndex;
                }
                Object[] subSiteRefs = Arrays.copyOfRange(siteRefs, subArrayIndex, subArrayIndex + subArraySize);
                String query1 = this.getStatement("delete.anon.auth.roles");
                String query2 = this.getStatement("delete.anon.auth.permissions");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "?";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query1 = query1.replace("(?)", inParams);
                query2 = query2.replace("(?)", inParams);
                this.getJdbcTemplate().update(query1, subSiteRefs);
                this.getJdbcTemplate().update(query2, subSiteRefs);
            } while ((subArrayIndex += subArraySize) < siteRefs.length);
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public void copyRole(String fromRealm, String fromRole, String[] toRealm, String toRole) {
        if (toRealm == null || toRealm.length == 0) {
            return;
        }
        try {
            int subArraySize;
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > toRealm.length) {
                    subArraySize = toRealm.length - subArrayIndex;
                }
                String[] subSiteRefs = Arrays.copyOfRange(toRealm, subArrayIndex, subArrayIndex + subArraySize);
                String query1 = this.getStatement("insert.copyrole");
                String query2 = this.getStatement("insert.copyroledesc");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "?";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query1 = query1.replace("(?)", inParams);
                query2 = query2.replace("(?)", inParams);
                ArrayList<String> parameters1 = new ArrayList<String>();
                parameters1.addAll(Arrays.asList(subSiteRefs));
                parameters1.add(fromRealm);
                parameters1.add(fromRole);
                parameters1.add(toRole);
                ArrayList<String> parameters2 = new ArrayList<String>();
                parameters2.addAll(Arrays.asList(subSiteRefs));
                parameters2.add(toRole);
                this.getJdbcTemplate().update(query1, parameters1.toArray());
                this.getJdbcTemplate().update(query2, parameters2.toArray());
            } while ((subArrayIndex += subArraySize) < toRealm.length);
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
        }
    }

    @Override
    public List<String> getDelegatedAccessUsers() {
        try {
            return this.getJdbcTemplate().query(this.getStatement("select.delegatedaccess.user"), new RowMapper(){

                public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                    return resultSet.getString("userId");
                }
            });
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public List<String> getSitesWithDelegatedAccessTool(String[] siteIds) {
        try {
            int subArraySize;
            ArrayList<String> returnList = new ArrayList<String>();
            if (siteIds == null || siteIds.length == 0) {
                return returnList;
            }
            int subArrayIndex = 0;
            do {
                if (subArrayIndex + (subArraySize = ORACLE_IN_CLAUSE_SIZE_LIMIT) > siteIds.length) {
                    subArraySize = siteIds.length - subArrayIndex;
                }
                Object[] subSiteRefs = Arrays.copyOfRange(siteIds, subArrayIndex, subArrayIndex + subArraySize);
                String query = this.getStatement("select.delegatedaccess.user.hasworkspacetool");
                String inParams = "(";
                for (int i = 0; i < subSiteRefs.length; ++i) {
                    inParams = inParams + "?";
                    if (i >= subSiteRefs.length - 1) continue;
                    inParams = inParams + ",";
                }
                inParams = inParams + ")";
                query = query.replace("(?)", inParams);
                List results = this.getJdbcTemplate().query(query, subSiteRefs, new RowMapper(){

                    public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                        return resultSet.getString("SITE_ID");
                    }
                });
                if (results == null) continue;
                returnList.addAll(results);
            } while ((subArrayIndex += subArraySize) < siteIds.length);
            return returnList;
        }
        catch (DataAccessException ex) {
            log.error((Object)("Error executing query: " + ((Object)((Object)ex)).getClass() + ":" + ex.getMessage()), (Throwable)ex);
            return null;
        }
    }

    @Override
    public Map<String, Set<String>> getHierarchySearchOptions(Map<String, String> hierarchySearchMap) {
        int i;
        HashMap<String, Set<String>> returnMap = new HashMap<String, Set<String>>();
        if (hierarchySearchMap == null || hierarchySearchMap.size() == 0) {
            return returnMap;
        }
        final int mapSize = hierarchySearchMap.size();
        String query = "select ";
        for (i = 0; i < mapSize; ++i) {
            query = this.oracle ? query + "ssp" + i + ".NAME, dbms_lob.substr(ssp" + i + ".VALUE), " : query + "ssp" + i + ".NAME, ssp" + i + ".VALUE, ";
        }
        query = query.substring(0, query.length() - 2) + " ";
        i = 0;
        String whereClause = "";
        for (Map.Entry<String, String> entry : hierarchySearchMap.entrySet()) {
            if (i == 0) {
                query = query + "from SAKAI_SITE_PROPERTY ssp0 ";
                whereClause = "where ssp0.NAME = '" + entry.getKey() + "'";
                if (entry.getValue() != null && !"".equals(entry.getValue().trim())) {
                    whereClause = this.oracle ? whereClause + " and dbms_lob.substr(ssp0.VALUE) = '" + entry.getValue().trim() + "'" : whereClause + " and ssp0.VALUE = '" + entry.getValue().trim() + "'";
                }
            } else {
                query = query + "right join SAKAI_SITE_PROPERTY ssp" + i + " on ssp0.SITE_ID = ssp" + i + ".SITE_ID and ssp" + i + ".NAME = '" + entry.getKey() + "' ";
                if (entry.getValue() != null && !"".equals(entry.getValue().trim())) {
                    query = this.oracle ? query + "and dbms_lob.substr(ssp" + i + ".VALUE) = '" + entry.getValue().trim() + "' " : query + "and ssp" + i + ".VALUE = '" + entry.getValue().trim() + "' ";
                }
            }
            ++i;
        }
        query = query + whereClause + " Group By ";
        for (i = 0; i < mapSize; ++i) {
            query = query + "ssp" + i + ".NAME, ";
            query = this.oracle ? query + "dbms_lob.substr(ssp" + i + ".VALUE), " : query + "ssp" + i + ".VALUE, ";
        }
        query = query.substring(0, query.length() - 2);
        List results = this.getJdbcTemplate().query(query, new Object[0], new RowMapper(){

            public Object mapRow(ResultSet resultSet, int i) throws SQLException {
                ArrayList<String> results = new ArrayList<String>();
                for (i = 0; i < mapSize * 2; ++i) {
                    results.add(resultSet.getString(i + 1));
                }
                return results;
            }
        });
        if (results != null) {
            for (List result : results) {
                if (result.size() != mapSize * 2) continue;
                for (i = 0; i < mapSize; ++i) {
                    String key = (String)result.get(i * 2);
                    String value = (String)result.get(i * 2 + 1);
                    Set<String> values = new HashSet<String>();
                    if (returnMap.containsKey(key)) {
                        values = (Set)returnMap.get(key);
                    }
                    values.add(value);
                    returnMap.put(key, values);
                }
            }
        }
        return returnMap;
    }
}

