/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.delegatedaccess.jobs;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.StatefulJob;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationCommand;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.delegatedaccess.logic.ProjectLogic;
import org.sakaiproject.delegatedaccess.logic.SakaiProxy;
import org.sakaiproject.delegatedaccess.model.NodeModel;
import org.sakaiproject.delegatedaccess.util.DelegatedAccessMutableTreeNode;

public class DelegatedAccessShoppingPeriodJob
implements StatefulJob,
ScheduledInvocationCommand {
    private static final Logger log = Logger.getLogger(DelegatedAccessShoppingPeriodJob.class);
    private ProjectLogic projectLogic;
    private SakaiProxy sakaiProxy;

    public void init() {
    }

    public void execute(JobExecutionContext arg0) throws JobExecutionException {
        this.execute("");
    }

    public void execute(String nodeId) {
        if (nodeId != null) {
            nodeId = nodeId.trim();
        }
        try {
            HashMap errors = new HashMap();
            log.info((Object)("DelegatedAccessShoppingPeriodJob started.  NodeId: " + nodeId));
            long startTime = System.currentTimeMillis();
            SecurityAdvisor advisor = this.sakaiProxy.addSiteUpdateSecurityAdvisor();
            Object treeNode = null;
            if (nodeId == null || "".equals(nodeId)) {
                TreeModel treeModel = this.projectLogic.getEntireTreePlusUserPerms("120dv0f43cv90sdf0asv9");
                if (treeModel != null && treeModel.getRoot() != null) {
                    treeNode = (DefaultMutableTreeNode)treeModel.getRoot();
                }
            } else {
                NodeModel nodeModel = this.projectLogic.getNodeModel(nodeId, "120dv0f43cv90sdf0asv9");
                treeNode = new DelegatedAccessMutableTreeNode();
                ((DefaultMutableTreeNode)treeNode).setUserObject(nodeModel);
            }
            if (treeNode != null) {
                this.projectLogic.updateShoppingPeriodSettings((DefaultMutableTreeNode)treeNode);
                this.sakaiProxy.popSecurityAdvisor(advisor);
                log.info((Object)("DelegatedAccessShoppingPeriodJob finished in " + (System.currentTimeMillis() - startTime) + " ms"));
                if (errors.size() > 0) {
                    String warning = "The following sites had errors: \n\n";
                    for (Map.Entry entry : errors.entrySet()) {
                        warning = warning + entry.getKey() + ": " + entry.getValue() + "\n";
                    }
                    log.warn((Object)warning);
                    this.sakaiProxy.sendEmail("DelegatedAccessShoppingPeriodJob error", warning);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            this.sakaiProxy.sendEmail("DelegatedAccessShoppingPeriodJob error", sw.toString());
        }
    }

    public ProjectLogic getProjectLogic() {
        return this.projectLogic;
    }

    public void setProjectLogic(ProjectLogic projectLogic) {
        this.projectLogic = projectLogic;
    }

    public SakaiProxy getSakaiProxy() {
        return this.sakaiProxy;
    }

    public void setSakaiProxy(SakaiProxy sakaiProxy) {
        this.sakaiProxy = sakaiProxy;
    }
}

